(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    152856,       3571]*)
(*NotebookOutlinePosition[    153527,       3594]*)
(*  CellTagsIndexPosition[    153483,       3590]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(Poisson\ Process\ \((Gillespie\ Algorithm)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(<< Statistics`DiscreteDistributions`\), "\n", 
    \(Clear[a, p]\), "\n", 
    \(\(a = 4;\)\), "\n", 
    \(For[k = 1, 
      k \[LessEqual] 
        5, {mu = 0.1 + \((k - 1)\); \[IndentingNewLine]p = 
          Exp[\(-t\)]; \[IndentingNewLine]poissondist = 
          PoissonDistribution[mu]; \[IndentingNewLine]pdf = 
          PDF[poissondist, x]; \[IndentingNewLine]plotpdf[k] = 
          Plot[pdf, {x, 0, 10}, 
            TextStyle \[Rule] {FontFamily \[Rule] "\<Times\>", 
                FontSize \[Rule] 20}, 
            DisplayFunction \[Rule] 
              Identity];}; \[IndentingNewLine]\(k++\)]\), "\n", 
    \(\(plotall = Table[plotpdf[i], {i, 1, 5}];\)\), "\n", 
    \(\(Show[plotall, DisplayFunction \[Rule] $DisplayFunction, 
        PlotRange \[Rule] All];\)\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.0147151 0.650508 [
[.21429 .00222 -7 -22 ]
[.21429 .00222 7 0 ]
[.40476 .00222 -7 -22 ]
[.40476 .00222 7 0 ]
[.59524 .00222 -7 -22 ]
[.59524 .00222 7 0 ]
[.78571 .00222 -7 -22 ]
[.78571 .00222 7 0 ]
[.97619 .00222 -12 -22 ]
[.97619 .00222 12 0 ]
[.01131 .14482 -29 -11 ]
[.01131 .14482 0 11 ]
[.01131 .27492 -29 -11 ]
[.01131 .27492 0 11 ]
[.01131 .40502 -29 -11 ]
[.01131 .40502 0 11 ]
[.01131 .53512 -29 -11 ]
[.01131 .53512 0 11 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
gsave
.21429 .00222 -68 -26 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 20.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 20.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.40476 .01472 m
.40476 .02097 L
s
gsave
.40476 .00222 -68 -26 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 20.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 20.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
1.000 setlinewidth
grestore
.59524 .01472 m
.59524 .02097 L
s
gsave
.59524 .00222 -68 -26 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 20.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 20.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(6) show
1.000 setlinewidth
grestore
.78571 .01472 m
.78571 .02097 L
s
gsave
.78571 .00222 -68 -26 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 20.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 20.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(8) show
1.000 setlinewidth
grestore
.97619 .01472 m
.97619 .02097 L
s
gsave
.97619 .00222 -73 -26 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 20.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 20.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
1.000 setlinewidth
grestore
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .14482 m
.03006 .14482 L
s
gsave
.01131 .14482 -90 -15 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 20.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 20.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
1.000 setlinewidth
grestore
.02381 .27492 m
.03006 .27492 L
s
gsave
.01131 .27492 -90 -15 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 20.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 20.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
1.000 setlinewidth
grestore
.02381 .40502 m
.03006 .40502 L
s
gsave
.01131 .40502 -90 -15 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 20.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 20.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
1.000 setlinewidth
grestore
.02381 .53512 m
.03006 .53512 L
s
gsave
.01131 .53512 -90 -15 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 20.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 20.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
1.000 setlinewidth
grestore
.125 Mabswid
.02381 .04724 m
.02756 .04724 L
s
.02381 .07977 m
.02756 .07977 L
s
.02381 .11229 m
.02756 .11229 L
s
.02381 .17734 m
.02756 .17734 L
s
.02381 .20987 m
.02756 .20987 L
s
.02381 .24239 m
.02756 .24239 L
s
.02381 .30744 m
.02756 .30744 L
s
.02381 .33997 m
.02756 .33997 L
s
.02381 .37249 m
.02756 .37249 L
s
.02381 .43755 m
.02756 .43755 L
s
.02381 .47007 m
.02756 .47007 L
s
.02381 .5026 m
.02756 .5026 L
s
.02381 .56765 m
.02756 .56765 L
s
.02381 .60017 m
.02756 .60017 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
.5 Mabswid
.02381 .60332 m
.04262 .42125 L
.06244 .27548 L
.07286 .21749 L
.08255 .17355 L
.09388 .13282 L
.10458 .10308 L
.11437 .08195 L
.125 .0643 L
.13466 .05206 L
.14357 .0433 L
.15324 .036 L
.1623 .03078 L
.17223 .02645 L
.18292 .02304 L
.19303 .0207 L
.20406 .01887 L
.21448 .01764 L
.22415 .01682 L
.23472 .01618 L
.24467 .01575 L
.25361 .01547 L
.26328 .01525 L
.27278 .01509 L
.28322 .01497 L
.28847 .01493 L
.29411 .01489 L
.30428 .01483 L
.30957 .01481 L
.31445 .0148 L
.31971 .01478 L
.32552 .01477 L
.33528 .01475 L
.34062 .01475 L
.34564 .01474 L
.35547 .01473 L
.36042 .01473 L
.36582 .01473 L
.37046 .01472 L
.37541 .01472 L
.38433 .01472 L
.38966 .01472 L
.39457 .01472 L
.39986 .01472 L
.40568 .01472 L
.41546 .01472 L
.42082 .01472 L
.42583 .01472 L
.43081 .01472 L
.43623 .01472 L
Mistroke
.44102 .01472 L
.44611 .01472 L
.45116 .01472 L
.45573 .01472 L
.46465 .01472 L
.46954 .01472 L
.4747 .01472 L
.48394 .01472 L
.48908 .01472 L
.49387 .01472 L
.4991 .01472 L
.50477 .01472 L
.51022 .01472 L
.51525 .01472 L
.51996 .01472 L
.52516 .01472 L
.53417 .01472 L
.53911 .01472 L
.54373 .01472 L
.55359 .01472 L
.55854 .01472 L
.56395 .01472 L
.5686 .01472 L
.57355 .01472 L
.58247 .01472 L
.58782 .01472 L
.59274 .01472 L
.59804 .01472 L
.60386 .01472 L
.61366 .01472 L
.61901 .01472 L
.62402 .01472 L
.62902 .01472 L
.63445 .01472 L
.63925 .01472 L
.64435 .01472 L
.64892 .01472 L
.65398 .01472 L
.6629 .01472 L
.6678 .01472 L
.67297 .01472 L
.68222 .01472 L
.68737 .01472 L
.69217 .01472 L
.6974 .01472 L
.70307 .01472 L
.70853 .01472 L
.71357 .01472 L
.7183 .01472 L
.7235 .01472 L
Mistroke
.73252 .01472 L
.73746 .01472 L
.74208 .01472 L
.74705 .01472 L
.75247 .01472 L
.75725 .01472 L
.76234 .01472 L
.76738 .01472 L
.77195 .01472 L
.78087 .01472 L
.78575 .01472 L
.79091 .01472 L
.80013 .01472 L
.80527 .01472 L
.81006 .01472 L
.81532 .01472 L
.82096 .01472 L
.82625 .01472 L
.83114 .01472 L
.83651 .01472 L
.84221 .01472 L
.84715 .01472 L
.85178 .01472 L
.85683 .01472 L
.86234 .01472 L
.86744 .01472 L
.87218 .01472 L
.87761 .01472 L
.88254 .01472 L
.89149 .01472 L
.89641 .01472 L
.90105 .01472 L
.90608 .01472 L
.91078 .01472 L
.91568 .01472 L
.92108 .01472 L
.92998 .01472 L
.93497 .01472 L
.93953 .01472 L
.94394 .01472 L
.94864 .01472 L
.95708 .01472 L
.96225 .01472 L
.96711 .01472 L
.97619 .01472 L
Mfstroke
.02381 .23125 m
.03279 .24381 L
.04262 .25485 L
.04758 .25934 L
.05288 .26333 L
.05785 .26633 L
.06244 .26847 L
.06508 .26943 L
.06788 .27025 L
.07069 .27085 L
.07229 .2711 L
.073 .27119 L
.07379 .27128 L
.0745 .27134 L
.07517 .27138 L
.07648 .27144 L
.07768 .27146 L
.07895 .27144 L
.07967 .2714 L
.08045 .27136 L
.08119 .2713 L
.08186 .27123 L
.08314 .27108 L
.08451 .27087 L
.08691 .2704 L
.08916 .26984 L
.09427 .26816 L
.09966 .26579 L
.10458 .26314 L
.12366 .24898 L
.14443 .22831 L
.18521 .18017 L
.22447 .13435 L
.26222 .09712 L
.2832 .08019 L
.30243 .06705 L
.34111 .04691 L
.36004 .0397 L
.38074 .03344 L
.40035 .02881 L
.4213 .02502 L
.44265 .02212 L
.4628 .02009 L
.48281 .01859 L
.50126 .01756 L
.52003 .01678 L
.54067 .01615 L
.56011 .01573 L
.58101 .01541 L
.59114 .01529 L
Mistroke
.60218 .01518 L
.61273 .0151 L
.62228 .01503 L
.64199 .01493 L
.65281 .01489 L
.66298 .01486 L
.67277 .01483 L
.6831 .01481 L
.70158 .01478 L
.71109 .01477 L
.72126 .01476 L
.73961 .01475 L
.74981 .01474 L
.76089 .01473 L
.77046 .01473 L
.78102 .01473 L
.80083 .01472 L
.81168 .01472 L
.82186 .01472 L
.83171 .01472 L
.84208 .01472 L
.86059 .01472 L
.87017 .01472 L
.88038 .01472 L
.89876 .01472 L
.90902 .01472 L
.92014 .01472 L
.92975 .01472 L
.94031 .01472 L
.95775 .01472 L
.96728 .01472 L
.97619 .01472 L
Mfstroke
.02381 .09437 m
.06244 .13607 L
.08255 .15529 L
.10458 .17286 L
.11448 .17933 L
.12507 .18519 L
.13499 .18964 L
.14415 .19285 L
.14901 .1942 L
.15437 .19541 L
.15975 .19632 L
.1627 .1967 L
.16546 .19698 L
.1667 .19708 L
.16805 .19717 L
.16925 .19723 L
.17052 .19729 L
.17178 .19733 L
.17293 .19735 L
.17408 .19736 L
.17516 .19735 L
.17643 .19734 L
.17707 .19732 L
.17777 .1973 L
.17901 .19725 L
.18017 .1972 L
.18279 .19702 L
.1856 .19677 L
.19088 .1961 L
.19577 .19526 L
.20684 .19265 L
.21659 .18957 L
.22696 .1856 L
.26471 .16625 L
.30491 .14073 L
.3436 .11522 L
.38474 .09014 L
.42436 .06962 L
.46247 .05379 L
.50303 .041 L
.54208 .03212 L
.56342 .02844 L
.58358 .0256 L
.62204 .02158 L
.64192 .02007 L
.66296 .0188 L
.68276 .01787 L
.70085 .01719 L
.7203 .01661 L
.74119 .01613 L
Mistroke
.76021 .0158 L
.78095 .01552 L
.80066 .01531 L
.82165 .01515 L
.8431 .01503 L
.86328 .01495 L
.8834 .01488 L
.90188 .01484 L
.92075 .01481 L
.94142 .01478 L
.95821 .01476 L
.97619 .01475 L
Mfstroke
.02381 .04402 m
.06244 .067 L
.10458 .09566 L
.14415 .12191 L
.18221 .14293 L
.20178 .15125 L
.22272 .15793 L
.23293 .16032 L
.23832 .16134 L
.24402 .16225 L
.24901 .16289 L
.25449 .16344 L
.2569 .16363 L
.25949 .16379 L
.26193 .16392 L
.26416 .164 L
.26545 .16404 L
.26666 .16406 L
.26775 .16408 L
.26893 .16409 L
.27021 .1641 L
.27086 .1641 L
.27157 .16409 L
.27283 .16408 L
.27401 .16406 L
.27519 .16403 L
.27631 .164 L
.27842 .16392 L
.28068 .16381 L
.28315 .16366 L
.28837 .16324 L
.29391 .16265 L
.30387 .16123 L
.31324 .15948 L
.32334 .15719 L
.34162 .15207 L
.38276 .13694 L
.42239 .11953 L
.46049 .10204 L
.50106 .08419 L
.5401 .06875 L
.5816 .05482 L
.62158 .04397 L
.66005 .03579 L
.70096 .02922 L
.74037 .0246 L
.77826 .02142 L
.7977 .02017 L
.8186 .01906 L
.83834 .0182 L
Mistroke
.85987 .01744 L
.89963 .01643 L
.91934 .01606 L
.94033 .01576 L
.97619 .01538 L
Mfstroke
.02381 .0255 m
.06244 .03626 L
.10458 .05246 L
.14415 .07086 L
.18221 .08981 L
.22272 .10918 L
.26171 .12506 L
.28158 .13157 L
.30316 .1372 L
.31323 .13927 L
.32392 .14108 L
.33304 .14229 L
.34309 .14328 L
.34828 .14365 L
.35084 .1438 L
.35322 .14391 L
.35555 .14401 L
.35765 .14407 L
.36 .14413 L
.36128 .14415 L
.36249 .14417 L
.36371 .14418 L
.36439 .14418 L
.36503 .14419 L
.36633 .14419 L
.36706 .14418 L
.36772 .14418 L
.3689 .14417 L
.37019 .14415 L
.3714 .14413 L
.37252 .14411 L
.37502 .14404 L
.37778 .14394 L
.38337 .14365 L
.38829 .14332 L
.39347 .14289 L
.40272 .1419 L
.42358 .13875 L
.44332 .13472 L
.46168 .13017 L
.50073 .11856 L
.54223 .10446 L
.58221 .09037 L
.62068 .07725 L
.66159 .06445 L
.701 .05365 L
.73888 .04484 L
.77922 .03715 L
.81805 .03127 L
.85933 .02646 L
Mistroke
.89909 .02299 L
.93733 .02052 L
.97619 .0187 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{808.688, 499.812},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000<X0001lb000`400?l00000o`00003ooooooooo
oooooooooooo:oooool00?ooooooooooooooooooob_ooooo003oooooooooooooooooool[ooooo`00
oooooooooooooooooooo:oooool00?ooooooooooooooooooob_ooooo003oooooooooooooooooool[
ooooo`00oooooooooooooooooooo:oooool00;_ooooo2?l000000ooMgMgoooooooooo`2?ooooo`;o
0000SOooool01_nj^[[o8B4Qo`000?l0003oEEEEonk^kXkooooo00KoZJVYob4Q8Ol0003o0000ob4Q
8OnYZJV8ooooo`Ko00001?ooool01OnYZJWo410@o`000?l@413oQhN701?ooooo002kooooo`03olc<
c?l0003o000000Go000000?oQhN7ooooooooool0Soooool2o`0008cooooo00GoV9RHo`000?n7QhOo
ooooomgMg@02ob4Q8Hgooooo00SoV9RHo`000?lQ8B7ogMgMonk^k_mEEEGo0000oiRHV8Sooooo00?o
^[Zjo`000?l000001Oooool01onHV9So0000ohN7Qooooooo^[Zjo`000?n7QhL04_ooool00;cooooo
00?oc<c<oa0@4?o<c<`00oooool00on7QhOo8B4Qooooo`2@ooooo`;o0000Roooool00ooMgMgo0000
oeEEE@03ooooo`03ojVYZOl0003oMgMg08cooooo00?o410@o`000?o<c<`00_ooool00oo^k^ko0000
oa0@4029ooooo`;o00001?ooool00ooMgMgo0000oeEEE@03ooooo`03ofIVI_l0003ok^k^017ooooo
002mooooo`03oiRHV?l0003ok^k^00?ooooo00?o^[Zjooooooooool0ROooool:o`0008Wooooo00?o
EEEEo`000?nYZJT01?ooool00ol0003o8B4Qooooo`2;ooooo`;o00000oooool00oo^k^ko0000o`00
0029ooooo`;o00001?ooool00on7QhOo0000ojVYZ@03ooooo`03okZj^_l0003oQhN7017ooooo002n
ooooo`03ohN7QolQ8B7ok^k^08kooooo00?oA4A4ojVYZOooool00oooool2o`0008_ooooo00?o410@
o`000?o^k^h01?ooool2o`0008cooooo00?o<S8bo`000?o^k^h00_ooool00omEEEGo0000ob4Q8@29
ooooo`;o00001?ooool00olb<S;o0000omgMg@03ooooo`03omgMgOl0003o<S8b017ooooo002ooooo
o`;oEEEES_ooool00oo^k^ko410@onk^kP03ooooo`;o0000Roooool2o`0000Cooooo00?ogMgMo`00
0?l00000S?ooool01Oo<c<co0000ohN7QoooooooEEEE00;o000000?oZJVYooooooooool0Qoooool2
o`0000Cooooo0_l00005ooooo`03o`000?l@413ooooo013ooooo002oooooo`03onk^k_l@413oQhN7
08kooooo00?oZJVYoc8b<_ooool00_ooool2o`0008_ooooo0_l000001oo^k^kooooooooooooooooo
MgMgo`000?m4A4@0SOooool00ooMgMgo<S8bob4Q8@02o`000003oiRHV?oooooooooo08Sooooo0_l0
0004ooooo`;o00001Oooool2o`00017ooooo0030ooooo`03oiRHV?l0003ogMgM08kooooo00CoEEEE
ohN7Qooooooooooo0_l0002;ooooo`06ob4Q8Ol0003oEEEEonk^k_ooooooZJVY0_l000000oo<c<co
ooooooooo`2;ooooo`05onk^k_m4A4Co0000o`000?o<c<`0Roooool2o`0000Cooooo0_l00005oooo
o`;o00004Oooool00<3ooooo00?ok^k^o`000?mEEED0S_ooool01?o^k^ko8B4QomgMgOooool2o`00
08_ooooo00CoIVIVo`000?n7QhOo<S8b0_l000000om4A4Coc<c<ooooo`2<ooooo`07onk^k_lQ8B7o
0000odA4A?nYZJWo8B4QojVYZ@2:ooooo`;o00001?ooool2o`0000Gooooo0_l0000Aooooo`00^ooo
ool00omgMgOok^k^ooooo`03ooooo`;o0000Soooool00onj^[[o<S8booooo`02o`0008_ooooo00?o
gMgMo`000?mEEED0T_ooool00omEEEGo0000oeEEE@02ooooo`03oiRHV?l0003oV9RH08Wooooo0_l0
0004ooooo`03oc8b<_l0003oc<c<00?ooooo00?oc<c<o`000?lb<S804Oooool00;_ooooo00?o<S8b
ogMgMoooool00_ooool00onj^[[o0000o`00002@ooooo`04ofIVI_n7QhOo0000o`0008cooooo00?o
MgMgo`000?nj^[X0TOooool2o`000004omgMgOooooooooooooooo`;o0000ROooool2o`0000Cooooo
00?oQhN7o`000?nYZJT00oooool00onYZJWo0000ohN7Q`0Aooooo`00^oooool02?nHV9So0000oiRH
V?oooooogMgMob4Q8Ol0003o410@T?ooool01?o^k^ko8B4Qo`000?l0002=ooooo`03oeEEEOl0003o
c<c<093ooooo0_l000001?o^k^koooooooooooo^k^h2o`0008Wooooo0_l00004ooooo`03omgMgOl0
003oEEEE00?ooooo00?oEEEEo`000?o^k^h04Oooool00;cooooo00?o8B4Qo`000?l000000ol00000
0onYZJWoooooooooo`2?ooooo`03okZj^_l0003o000008kooooo00CoQhN7oa0@4?n7QhOok^k^S_oo
ool00onHV9So0000oeEEE@02onk^kP03oeEEEOl0003oMgMg08Oooooo00Co8B4QofIVI_l0003o0000
1Oooool01omgMgOo0000oiRHV?ooooooV9RHo`000?nHV9P04_ooool002gooooo00?o0000oooooooo
ool0S?ooool01_o^k^koMgMgo`000?l0003o8B4QojVYZI?ooooo00?oIVIVo`000?ooool0S_ooool0
1Oo^k^koQhN7oc8b<_lb<S;o^[Zj08gooooo00Ko^[ZjodA4A?l0003o0000oa0@4?nHV9R8ooooo`04
omgMgOnHV9SoEEEEo`0000Kooooo00GoQhN7oa0@4?l0003o410@oiRHV00Cooooo`00;Oooool00ol0
003oooooooooo`3ooooooooooooon_ooool002gooooo00?o0000ooooooooool0oooooooooooooo[o
oooo000]ooooo`03o`000?oooooooooo0?ooooooooooooojooooo`00;Oooool00ol0003ooooooooo
o`3ooooooooooooon_ooool002gooooo00?o0000ooooooooool0oooooooooooooo[ooooo000]oooo
o`03o`000?oooooooooo0?ooooooooooooojooooo`00;Oooool00ol0003oooooooooo`3ooooooooo
oooon_ooool002gooooo00?o0000ooooooooool0oooooooooooooo[ooooo000]ooooo`03o`000?oo
oooooooo0?ooooooooooooojooooo`00;Oooool00ol0003oooooooooo`3ooooooooooooon_ooool0
01[oooooool0003oo`000?oo00002ol00006ooooo`00;Oooool00ol0003oooooooooo`0Rooooo`03
o`000?oooooooooo02;ooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`0Rooooo`03
o`000?oooooooooo00Wooooo<?l0000>ooooo`03o`000?oooooooooo02;ooooo00?o0000oooooooo
ool08_ooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo027ooooo00?o0000oooooooo
ool05OoooomKo`00027ooooo00?o0000ooooooooool07?oooom_o`0000Gooooo00?o0000oooooooo
ool05?ooooldo`0001Wooooo000]ooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool0
8_ooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo02;ooooo00Co0000oooooooooooo
oooo2?l0000Iooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool08_ooool00ol0003o
ooooooooo`0Rooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool08Oooool00ol0003o
ooooooooo`06ooooo`oo00003Oooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo02;o
oooo00?o0000ooooooooool08_oooolOo`0000Kooooo00?o0000ooooooooool08_ooool00ol0003o
ooooooooo`0Rooooo`03o`000?oooooooooo00Wooooo;ol0000>ooooo`03o`000?oooooooooo02;o
oooo00?o0000ooooooooool05oooool002gooooo00?o0000ooooooooool08_ooool00ol0003ooooo
ooooo`0Rooooo`03o`000?oooooooooo027ooooo00?o0000ooooooooool07_ooool8o`00027ooooo
00?o0000ooooooooool08_ooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo02;ooooo
00?o0000ooooooooool08_ooool00ol0003oooooooooo`0@oooooa[o00007?ooool00ol0003ooooo
ooooo`0Rooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool05Oooool>o`0002Cooooo
00?o0000ooooooooool08_ooool00ol0003oooooooooo`0Noooooa3o00006?ooool00ol0003ooooo
ooooo`0Rooooo`03o`000?oooooooooo01_ooooo2?l0000Iooooo`00;Oooool00ol0003ooooooooo
o`24ooooo`So00001?ooool00ol0003oooooooooo`2Aooooo`03o`000?oooooooooo02kooooo1ol0
001Kooooo`03o`000?oooooooooo02[ooooo4?l0001Gooooo`03o`000?oooooooooo00kooooo4?l0
001Looooo`oo00001oooool00ol0003oooooooooo`0Gooooo`00;Oooool00ol0003oooooooooo`1n
ooooo`Ko00003?ooool00ol0003oooooooooo`2Aooooo`03o`000?oooooooooo02;ooooo3?l0001R
ooooo`03o`000?oooooooooo01[ooooo4?l0001Wooooo`03o`000?oooooo000000ko0000GOooool?
o`0001Kooooo00?o0000ooooooooool05oooool002gooooo00?o0000ooooooooool0N_ooool4o`00
0;oooooo3?l0001nooooo`go0000J_ooool?o`0005gooooo3ol0000oooooo`00;Oooool00ol0003o
ooooooooo`1fooooo`Co0000^oooool8o`00083ooooo2_l0001Xooooo`oo0000GOooool?o`0004ko
oooo000]ooooo`03o`000?oooooooooo07;ooooo1?l0002hooooo`Oo0000O_ooool:o`0006Oooooo
2ol0001Mooooo`oo0000GOooool002gooooo0ol0001_ooooo`?o0000]_ooool6o`0007cooooo2Ol0
001Yooooo`So0000G?ooool<o`0006cooooo000]ooooo`03o`000?oooooooooo00Co0000JOooool2
o`000;Cooooo1Ol0001kooooo`Oo0000Joooool7o`0005cooooo2?l0001hooooo`00;Oooool00ol0
003oooooooooo`04ooooo`?o0000I?ooool2o`000;7ooooo1Ol0001iooooo`Oo0000J_ooool8o`00
05_ooooo2?l00020ooooo`00;Oooool00ol0003oooooooooo`07ooooo`Co0000G_ooool2o`000:oo
oooo1?l0001hooooo`Ko0000J_ooool7o`0005_ooooo2?l00028ooooo`00;Oooool00ol0003ooooo
ooooo`0;ooooo`Co0000F?ooool2o`000:kooooo0ol0001gooooo`Go0000JOooool7o`0005_ooooo
1ol0002@ooooo`00;Oooool00ol0003oooooooooo`0?ooooo`Co0000D_ooool2o`000:cooooo1?l0
001eooooo`Go0000J?ooool6o`0005cooooo1_l0002Gooooo`00;Oooool00ol0003oooooooooo`0C
ooooo`?o0000C_ooool00ol0003oooooooooo`2Xooooo`Co0000MOooool4o`0006Oooooo1_l0001L
ooooo`Ko0000WOooool002gooooo00?o0000ooooooooool05_ooool4o`0004Sooooo0_l0002Xoooo
o`?o0000M?ooool5o`0006Cooooo1ol0001Looooo`Ko0000Xoooool002gooooo00?o0000oooooooo
ool06_ooool3o`0004?ooooo0_l0002Wooooo`?o0000Loooool4o`0006Cooooo1Ol0001Mooooo`Ko
0000ZOooool002gooooo00?o0000ooooooooool07Oooool3o`0003oooooo00?o0000ooooooooool0
Y?ooool3o`0007;ooooo1?l0001Sooooo`Go0000G?ooool6o`000:oooooo000]ooooo`03o`000?oo
oooooooo023ooooo0_l0000kooooo`;o0000Y?ooool3o`00073ooooo1Ol0001Rooooo`Go0000G?oo
ool5o`000;Gooooo000]ooooo`03o`000?oooooooooo02;ooooo0ol0000fooooo`;o0000Xoooool3
o`0006oooooo1?l0001Rooooo`Go0000G?ooool5o`000;[ooooo000]ooooo`03o`000?oooooooooo
02Gooooo0_l0000cooooo`03o`000?oooooooooo0:3ooooo0ol0001^ooooo`Co0000HOooool5o`00
05_ooooo1_l0002oooooo`00;Oooool00ol0003oooooooooo`0Wooooo`?o0000;oooool00ol0003o
ooooooooo`2Nooooo`?o0000K_ooool3o`00063ooooo1Ol0001Kooooo`Go0000aOooool002gooooo
0_l0000[ooooo`;o0000;Oooool00ol0003oooooooooo`2Kooooo`?o0000K_ooool3o`0005oooooo
1?l0001Kooooo`Go0000b_ooool002gooooo00Co0000ooooool0003o0000:oooool2o`0002[ooooo
00?o0000ooooooooool0VOooool3o`0006kooooo0ol0001Nooooo`Co0000F_ooool5o`000<oooooo
000]ooooo`05o`000?ooooooooooooooool00000;?ooool3o`0002Kooooo00?o0000ooooooooool0
Uoooool3o`0006kooooo0ol0001Mooooo`Co0000F_ooool4o`000=Cooooo000]ooooo`Co000000?o
ooooo`000?l00000;Oooool2o`0002?ooooo00?o0000ooooooooool0U_ooool2o`0006gooooo1?l0
001Looooo`Co0000F_ooool4o`000=Sooooo000]ooooo`03o`000?oooooooooo00Cooooo0_l0000]
ooooo`?o00007oooool00ol0003oooooooooo`2Eooooo`;o0000K?ooool3o`0005gooooo0ol0001I
ooooo`Go0000g?ooool002gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0]oooo
o`;o00007?ooool00ol0003oooooooooo`2Dooooo`;o0000Joooool3o`0005cooooo1?l0001Hoooo
o`Co0000hOooool002gooooo00?o0000ooooooooool01oooool2o`0002oooooo0ol0000Hooooo`03
o`000?oooooooooo09Cooooo00?o0000ooooooooool0J?ooool3o`0005_ooooo1?l0001Hooooo`Co
0000iOooool002gooooo00?o0000ooooooooool02Oooool2o`00033ooooo0_l0000Fooooo`03o`00
0?oooooooooo09;ooooo0_l0001Xooooo`?o0000F_ooool4o`0005Sooooo1?l0003Yooooo`00;Ooo
ool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo02oooooo0_l0000Cooooo`03o`000?oo
oooooooo097ooooo0_l0001Wooooo`?o0000F_ooool3o`0005Sooooo1?l0003]ooooo`00;Oooool0
0ol0003oooooooooo`0<ooooo`;o0000<Oooool3o`0000oooooo00?o0000ooooooooool0T?ooool2
o`0006Kooooo0ol0001Jooooo`?o0000Eoooool4o`000?7ooooo000]ooooo`03o`000?oooooooooo
00kooooo0_l0000booooo`;o00003?ooool00ol0003oooooooooo`2?ooooo`;o0000I_ooool2o`00
05[ooooo0ol0001Gooooo`?o0000mOooool002gooooo00?o0000ooooooooool04?ooool00ol0003o
ooooooooo`0aooooo`;o00002Oooool00ol0003oooooooooo`2>ooooo`;o0000I_ooool2o`0005Wo
oooo0ol0001Fooooo`Co0000n?ooool002gooooo00?o0000ooooooooool04Oooool2o`0003?ooooo
0_l00007ooooo`03o`000?oooooooooo08cooooo0_l0001Uooooo`?o0000F?ooool3o`0005Gooooo
1?l0003looooo`00;Oooool00ol0003oooooooooo`0Cooooo`;o0000<oooool2o`0000Cooooo00?o
0000ooooooooool0Roooool2o`0006Gooooo0_l0001Hooooo`?o0000E?ooool4o`000?oooooo0Ooo
ool002gooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`0booooo`Co0000SOooool0
0ol0003oooooooooo`1Rooooo`?o0000Eoooool3o`0005Cooooo0ol0003oooooo`Gooooo000]oooo
o`03o`000?oooooooooo01Kooooo0_l0000dooooo`?o0000R_ooool2o`0006?ooooo0_l0001Goooo
o`?o0000Doooool4o`000?oooooo2?ooool002gooooo00?o0000ooooooooool06?ooool2o`00037o
oooo00Co0000oooooooooooooooo0_l00026ooooo`;o0000H_ooool3o`0005Kooooo0ol0001Boooo
o`Co0000ooooool<ooooo`00;Oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo02ko
oooo00?o0000ooooooooool00oooool2o`0008;ooooo0_l0001Rooooo`;o0000E_ooool3o`0005;o
oooo0ol0003ooooooa3ooooo000]ooooo`03o`000?oooooooooo01_ooooo0_l0000]ooooo`03o`00
0?oooooooooo00Kooooo0_l0001nooooo`;o0000H_ooool2o`0005Gooooo0ol0001Booooo`?o0000
oooooolCooooo`00;Oooool00ol0003oooooooooo`0Mooooo`03o`000?oooooooooo02Wooooo00?o
0000ooooooooool02Oooool3o`0007[ooooo00?o0000ooooooooool0Goooool3o`0005Gooooo0_l0
001Booooo`?o0000oooooolFooooo`00;Oooool00ol0003oooooooooo`0Nooooo`;o0000:Oooool0
0ol0003oooooooooo`0<ooooo`;o0000M_ooool2o`00063ooooo0_l0001Eooooo`?o0000DOooool3
o`000?oooooo6Oooool002gooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`0Uoooo
o`03o`000?oooooooooo00oooooo0_l0001cooooo`03o`000?oooooooooo05kooooo0_l0001Eoooo
o`;o0000D?ooool4o`000?oooooo7?ooool002gooooo00?o0000ooooooooool08Oooool2o`0002Go
oooo00?o0000ooooooooool04Oooool2o`00073ooooo00?o0000ooooooooool0GOooool2o`0005Co
oooo0ol0001?ooooo`?o0000oooooolPooooo`00;Oooool00ol0003oooooooooo`0Sooooo`03o`00
0?oooooooooo027ooooo00?o0000ooooooooool05?ooool2o`0006cooooo0_l0001Nooooo`;o0000
Doooool3o`0004oooooo0ol0003oooooob?ooooo000]ooooo`03o`000?oooooooooo02Cooooo00?o
0000ooooooooool07oooool00ol0003oooooooooo`0Gooooo`;o0000JOooool00ol0003ooooooooo
o`1Looooo`;o0000Doooool2o`0004oooooo0ol0003oooooobKooooo000]ooooo`03o`000?oooooo
oooo02Gooooo0_l0000Oooooo`03o`000?oooooooooo01Wooooo0_l0001Uooooo`;o0000GOooool2
o`0005;ooooo0ol0001>ooooo`?o0000oooooolYooooo`00;Oooool00ol0003oooooooooo`0Woooo
o`03o`000?oooooooooo01_ooooo00?o0000ooooooooool07?ooool2o`0006;ooooo00?o0000oooo
ooooool0Foooool2o`0005;ooooo0_l0001>ooooo`?o0000ooooool/ooooo`00;Oooool00ol0003o
ooooooooo`0Xooooo`;o00006oooool00ol0003oooooooooo`0Nooooo`;o0000Goooool00ol0003o
ooooooooo`1Jooooo`;o0000DOooool3o`0004gooooo0ol0003ooooooboooooo000]ooooo`Co0000
:Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo027ooooo0_l0001Kooooo`;o0000
G?ooool00ol0003oooooooooo`1>ooooo`?o0000COooool3o`000?oooooo<_ooool002gooooo00?o
0000ooooooooool0:oooool2o`0001Kooooo00?o0000ooooooooool09?ooool00ol0003ooooooooo
o`1Gooooo`03o`000?oooooooooo05[ooooo0_l0001?ooooo`;o0000COooool3o`000?oooooo=Ooo
ool002gooooo00?o0000ooooooooool0;Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooo
oooo02Gooooo0_l0001Fooooo`03o`000?oooooooooo05Wooooo0_l0001>ooooo`?o0000C?ooool3
o`000?oooooo>?ooool002gooooo00?o0000ooooooooool0;_ooool2o`0001;ooooo00?o0000oooo
ooooool0:?ooool2o`0005;ooooo0_l0001Jooooo`;o0000C_ooool2o`0004cooooo0ol0003ooooo
oc_ooooo000]ooooo`03o`000?oooooooooo033ooooo00?o0000ooooooooool03oooool00ol0003o
ooooooooo`0Zooooo`;o0000Coooool00ol0003oooooooooo`1Hooooo`;o0000C_ooool2o`0004_o
oooo0ol0003oooooockooooo000]ooooo`03o`000?oooooooooo037ooooo0_l0000>ooooo`03o`00
0?oooooooooo02gooooo0_l0001<ooooo`03o`000?oooooooooo05Oooooo0_l0001=ooooo`?o0000
B_ooool3o`000?oooooo@Oooool002gooooo00?o0000ooooooooool0<oooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo02oooooo0_l00018ooooo`;o0000F?ooool2o`0004gooooo0_l0
001:ooooo`?o0000oooooom4ooooo`00;Oooool00ol0003oooooooooo`0dooooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool0<_ooool2o`0004Gooooo00?o0000ooooooooool0E_ooool2
o`0004gooooo0_l00019ooooo`?o0000oooooom7ooooo`00;Oooool00ol0003oooooooooo`0eoooo
o`;o00002Oooool00ol0003oooooooooo`0dooooo`;o0000@_ooool00ol0003oooooooooo`1Eoooo
o`;o0000COooool2o`0004Sooooo0ol0003ooooood[ooooo000]ooooo`03o`000?oooooooooo03Oo
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0gooooo`;o0000?oooool00ol0003o
ooooooooo`1Dooooo`;o0000COooool2o`0004Oooooo0ol0003oooooodgooooo000]ooooo`03o`00
0?oooooooooo03Sooooo0_l00005ooooo`03o`000?oooooooooo03Wooooo0_l0000kooooo`;o0000
E_ooool00ol0003oooooooooo`1:ooooo`?o0000A_ooool3o`000?ooooooD?ooool002gooooo00?o
0000ooooooooool0>_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo03_ooooo0_l0
000hooooo`03o`000?oooooooooo05Cooooo0_l0001;ooooo`;o0000A_ooool3o`000?ooooooDooo
ool002gooooo00?o0000ooooooooool0>oooool2o`000003ooooool0003ooooo03oooooo0ol0000d
ooooo`03o`000?oooooooooo05?ooooo0_l0001;ooooo`;o0000AOooool3o`000?ooooooE_ooool0
02gooooo0_l0000nooooo`;o0000@oooool2o`00037ooooo00?o0000ooooooooool0Doooool00ol0
003oooooooooo`19ooooo`;o0000A?ooool3o`000?ooooooFOooool002gooooo00?o0000ooooool0
0000?Oooool3o`0004Cooooo0_l0000^ooooo`03o`000?oooooooooo05;ooooo0_l0001:ooooo`;o
0000A?ooool2o`000?ooooooG?ooool002gooooo00Co0000oooooooooooo0000??ooool01?l0003o
ooooooooool00015ooooo`;o0000:oooool00ol0003oooooooooo`1Aooooo`;o0000BOooool3o`00
04?ooooo0ol0003ooooooekooooo000]ooooo`05o`000?ooooooooooooooool00000>_ooool00ol0
003oooooooooo`02ooooo`;o0000AOooool2o`0002Sooooo00?o0000ooooooooool0DOooool00ol0
003oooooooooo`17ooooo`;o0000@oooool3o`000?ooooooHOooool002gooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`0gooooo`03o`000?oooooooooo00Cooooo0_l00015ooooo`;o
00009Oooool00ol0003oooooooooo`1@ooooo`;o0000B?ooool2o`0004;ooooo0ol0003oooooofCo
oooo000]ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0=Oooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo04Cooooo0_l0000Rooooo`03o`000?oooooooooo04oooooo
0_l00018ooooo`;o0000@Oooool3o`000?ooooooIoooool002gooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`0dooooo`03o`000?oooooooooo00Sooooo0_l00016ooooo`?o00007_oo
ool00ol0003oooooooooo`1?ooooo`03o`000?oooooooooo04Kooooo0_l00011ooooo`;o0000oooo
oomZooooo`00;Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo03;ooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`16ooooo`;o00006oooool00ol0003oooooooooo`1>
ooooo`;o0000A_ooool3o`00043ooooo0ol0003oooooofcooooo000]ooooo`03o`000?oooooooooo
00Kooooo00?o0000ooooooooool0<Oooool00ol0003oooooooooo`0<ooooo`;o0000B?ooool2o`00
01Sooooo00?o0000ooooooooool0COooool2o`0004Kooooo0_l00010ooooo`?o0000oooooom_oooo
o`00;Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo033ooooo00?o0000oooooooo
ool03_ooool00ol0003oooooooooo`17ooooo`;o00005Oooool00ol0003oooooooooo`1=ooooo`03
o`000?oooooooooo04Cooooo0_l0000oooooo`?o0000oooooombooooo`00;Oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo02kooooo00?o0000ooooooooool04?ooool2o`0004Wooooo
0_l0000Booooo`03o`000?oooooooooo04cooooo0_l00015ooooo`;o0000?_ooool3o`000?oooooo
MOooool002gooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0]ooooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool0B?ooool3o`0000kooooo00?o0000ooooooooool0Booo
ool2o`0004Gooooo0_l0000mooooo`?o0000oooooomhooooo`00;Oooool4o`0000Wooooo00?o0000
ooooooooool0;?ooool00ol0003oooooooooo`0Cooooo`;o0000Boooool2o`0000_ooooo00?o0000
ooooooooool0Boooool00ol0003oooooooooo`13ooooo`;o0000??ooool3o`000?ooooooNoooool0
02gooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Zooooo`03o`000?oooooooooo
01Kooooo00?o0000ooooooooool0B_ooool3o`0000Oooooo00?o0000ooooooooool0B_ooool2o`00
04Cooooo0_l0000kooooo`?o0000oooooomnooooo`00;Oooool00ol0003oooooooooo`0<ooooo`03
o`000?oooooooooo02Wooooo00?o0000ooooooooool05oooool2o`0004gooooo0_l00004ooooo`03
o`000?oooooooooo04Wooooo0_l00013ooooo`?o0000>_ooool3o`000?ooooooPOooool002gooooo
00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo01Wooooo
0_l0001=ooooo`Co0000Boooool00ol0003oooooooooo`11ooooo`;o0000>_ooool3o`000?oooooo
Q?ooool002gooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0Wooooo`03o`000?oo
oooooooo01cooooo00?o0000ooooooooool0C?ooool3o`0004Sooooo0_l00012ooooo`;o0000>Ooo
ool3o`000?ooooooQoooool002gooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0V
ooooo`03o`000?oooooooooo01gooooo0_l0001;ooooo`04o`000?ooooooooooooooo`?o0000A?oo
ool00ol0003oooooooooo`10ooooo`;o0000>?ooool3o`000?ooooooR_ooool002gooooo00?o0000
ooooooooool03oooool00ol0003oooooooooo`0Uooooo`03o`000?oooooooooo01oooooo00?o0000
ooooooooool0Aoooool00ol0003oooooooooo`05ooooo`;o0000@?ooool2o`00047ooooo0_l0000g
ooooo`?o0000oooooon=ooooo`00;Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo
02?ooooo00?o0000ooooooooool08Oooool2o`0004Kooooo00?o0000ooooooooool02?ooool3o`00
03cooooo00?o0000ooooooooool0?oooool2o`0003Kooooo0ol0003ooooooi3ooooo000]ooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`0Sooooo`;o
0000@oooool00ol0003oooooooooo`0<ooooo`;o0000>?ooool2o`0003oooooo0ol0000dooooo`Co
0000oooooonCooooo`00;Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo027ooooo
00?o0000ooooooooool09Oooool00ol0003oooooooooo`0oooooo`03o`000?oooooooooo00oooooo
0ol0000dooooo`03o`000?oooooooooo03gooooo0_l0000dooooo`?o0000oooooonGooooo`00;Ooo
ool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool09ooo
ool2o`0003kooooo00?o0000ooooooooool04oooool3o`0002oooooo0_l0000nooooo`;o0000<ooo
ool3o`000?ooooooV_ooool002gooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0N
ooooo`03o`000?oooooooooo02Wooooo0_l0000kooooo`03o`000?oooooooooo01Oooooo0ol0000[
ooooo`03o`000?oooooooooo03_ooooo0ol0000aooooo`Co0000oooooonMooooo`00;Oooool00ol0
003oooooooooo`0Eooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool0:oooool00ol0
003oooooooooo`0gooooo`03o`000?oooooooooo01_ooooo0ol0000Vooooo`;o0000??ooool2o`00
037ooooo0ol0003ooooooj7ooooo000]ooooo`03o`000?oooooooooo01Kooooo00?o0000oooooooo
ool06oooool00ol0003oooooooooo`0]ooooo`;o0000=_ooool00ol0003oooooooooo`0Oooooo`?o
00008_ooool00ol0003oooooooooo`0jooooo`;o0000<?ooool3o`000?ooooooY?ooool002gooooo
00?o0000ooooooooool05oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo02oooooo
0_l0000cooooo`03o`000?oooooooooo02?ooooo0ol0000Mooooo`;o0000>_ooool3o`0002kooooo
1?l0003oooooojOooooo000]ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool06Ooo
ool00ol0003oooooooooo`0aooooo`;o0000<?ooool00ol0003oooooooooo`0Wooooo`?o00006Ooo
ool00ol0003oooooooooo`0hooooo`;o0000;?ooool5o`000?ooooooZoooool002gooooo00?o0000
ooooooooool06Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo03Cooooo00?o0000
ooooooooool0;?ooool00ol0003oooooooooo`0[ooooo`Co00004oooool2o`0003Wooooo0_l0000Y
ooooo`Go0000oooooon`ooooo`00;Oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo
01Kooooo00?o0000ooooooooool0=Oooool2o`0002_ooooo00?o0000ooooooooool0<?ooool5o`00
00gooooo00?o0000ooooooooool0=_ooool3o`0002Kooooo1Ol0003ooooookGooooo000]ooooo`03
o`000?oooooooooo01_ooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`0gooooo`;o
0000:Oooool00ol0003oooooooooo`0eooooo`Co00001oooool2o`0003Oooooo0_l0000Tooooo`Go
0000oooooonjooooo`00;Oooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo01?ooooo
00?o0000ooooooooool0>_ooool00ol0003oooooooooo`0Uooooo`03o`000?oooooooooo03[ooooo
1?l00002ooooo`03o`000?oooooooooo03Gooooo0_l0000Qooooo`Go0000oooooonoooooo`00;Ooo
ool00ol0003oooooooooo`0Mooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0>ooo
ool2o`0002Cooooo00?o0000ooooooooool0?oooool4o`0003?ooooo0ol0000Mooooo`Ko0000oooo
ooo4ooooo`002_ooool01OnYZJWo410@o`000?l@413oQhN700Cooooo0_lQ8B42ooooo`So000000?o
gMgMooooooooool02oooool00ol0003oooooooooo`0Nooooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool0?Oooool2o`00027ooooo00?o0000ooooooooool0?oooool00ol0003ooooooooo
o`02ooooo`Ko0000:_ooool3o`0001_ooooo1Ol0003ooooool[ooooo0009ooooo`07oiRHV?l0003o
QhN7oooooonj^[[o0000ohN7Q`03ooooo`;o8B4Q0_ooool00oo<c<co0000o`000005o`000003ohN7
Qooooooooooo00_ooooo00?o0000ooooooooool07oooool00ol0003oooooooooo`0?ooooo`03o`00
0?oooooooooo043ooooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`0nooooo`;o0000
2oooool8o`00023ooooo0_l0000Iooooo`Go0000ooooooo?ooooo`002?ooool00ooMgMgo0000oeEE
E@03ooooo`03ofIVI_l0003ok^k^00Oooooo00?oc<c<oa0@4?o<c<`00oooool00on7QhOo8B4Qoooo
o`0<ooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool03_ooool00ol0003ooooooooo
o`11ooooo`;o00007?ooool00ol0003oooooooooo`0nooooo`03o`000?oooooooooo01?ooooo1ol0
000Fooooo`?o00005Oooool6o`000?ooooooe?ooool000Sooooo00?oQhN7o`000?nYZJT00oooool0
0onj^[[o0000ohN7Q`08ooooo`03oiRHV?l0003ok^k^00?ooooo00?o^[Zjooooooooool02oooool0
0ol0003oooooooooo`0Qooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0@oooool2
o`0001Wooooo00?o0000ooooooooool0?Oooool2o`0001gooooo3_l00005ooooo`?o00001OoooolC
o`000?oooooof_ooool000Sooooo00?o<S8bo`000?oMgMd00oooool00ooMgMgo0000oc8b<P09oooo
o`03ohN7QolQ8B7ok^k^013ooooo1_l0000Oooooo`03o`000?oooooooooo00cooooo00?o0000oooo
ooooool0AOooool3o`0001Kooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`0[oooo
o`go0000ooooooo]ooooo`002?ooool2o`0000Gooooo00?o0000oa0@4?ooool02Oooool2oeEEEA3o
oooo00?o0000ooooooooool08oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo04Wo
oooo0ol0000Booooo`03o`000?oooooooooo03_ooooo0_l0000^ooooo`?o0000ooooooogooooo`00
2?ooool2o`0000Gooooo0_l0000:ooooo`03onk^k_l@413oQhN700oooooo00?o0000ooooooooool0
9?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo04cooooo0_l0000?ooooo`03o`00
0?oooooooooo03[ooooo0_l0000]ooooo`?o0000ooooooojooooo`002?ooool2o`0000Gooooo0_l0
000;ooooo`03oiRHV?l0003ogMgM00kooooo00?o0000ooooooooool09Oooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo04kooooo0ol0000;ooooo`03o`000?oooooooooo03[ooooo00?o
0000ooooooooool0:oooool2o`000?oooooooOooool000Sooooo0_l00005ooooo`;o00002oooool0
0oo^k^ko0000oeEEE@0>ooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool01_ooool0
0ol0003oooooooooo`1Booooo`?o00001oooool00ol0003oooooooooo`0iooooo`;o0000:oooool3
o`000?ooooooooooool000Sooooo00?o<S8bo`000?o<c<`00oooool00oo<c<co0000oc8b<P06oooo
o`03ogMgMoo^k^kooooo00?ooooo0_l0000>ooooo`03o`000?oooooooooo02Oooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`1Eooooo`?o00000oooool00ol0003oooooooooo`0ioooo
o`03o`000?oooooooooo02Sooooo0ol0003ooooooooooooo0oooool000Sooooo00?oQhN7o`000?nY
ZJT00oooool00onYZJWo0000ohN7Q`06ooooo`03oc8b<_mgMgOooooo00;ooooo00?o^[Zjo`000?l0
00003_ooool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool0F?ooool3o`0003[ooooo0_l0000Xooooo`?o0000ooooooooooooo`Kooooo0008ooooo`03omgM
gOl0003oEEEE00?ooooo00?oEEEEo`000?o^k^h01_ooool02?nHV9So0000oiRHV?oooooogMgMob4Q
8Ol0003o410@3_ooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool0Foooool4o`0003Kooooo00?o0000ooooooooool09Oooool3o`000?ooooooooooool9
ooooo`002Oooool01omgMgOo0000oiRHV?ooooooV9RHo`000?nHV9P02?ooool00olQ8B7o0000o`00
0003o`000003ojVYZOoooooooooo00cooooo00?o0000ooooooooool0:_ooool2o`0000;ooooo00?o
0000ooooooooool0F_ooool00ol0003oooooooooo`02ooooo`?o0000<Oooool2o`0002Cooooo1?l0
003ooooooooooooo3?ooool000[ooooo00GoQhN7oa0@4?l0003o410@oiRHV009ooooo`06onk^k_mg
MgOo0000o`000?lQ8B7oZJVY3oooool00ol0003oooooooooo`0/ooooo`03o`000?oooooo000005_o
oooo00?o0000ooooooooool01_ooool3o`0002gooooo00?o0000ooooooooool08Oooool3o`000?oo
ooooooooool@ooooo`00;Oooool00ol0003oooooooooo`0]ooooo`;o0000F_ooool00ol0003ooooo
ooooo`0:ooooo`Co00009oooool2o`0001kooooo1_l0003ooooooooooooo4oooool002gooooo00?o
0000ooooooooool0;Oooool2o`0005Wooooo00?o0000ooooooooool03oooool4o`0002;ooooo00?o
0000ooooooooool06?ooool6o`000?oooooooooooolIooooo`00;Oooool00ol0003oooooooooo`0]
ooooo`03o`000?oooooo000005Oooooo00?o0000ooooooooool05?ooool4o`0001cooooo0_l0000H
ooooo`?o0000oooooooooooooaoooooo000]ooooo`03o`000?oooooooooo02gooooo00?o0000oooo
ooooool00_l0001Dooooo`03o`000?oooooooooo01Wooooo1?l0000Fooooo`;o00005?ooool6o`00
0?oooooooooooolRooooo`00;Oooool00ol0003oooooooooo`0/ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`0Mooooo`So00003Oooool00ol0003o
ooooooooo`0:ooooo`[o0000ooooooooooooobSooooo000]ooooo`03o`000?oooooooooo02cooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`1?ooooo`03o`000?oooooooooo02Kooooo
6_l0003ooooooooooooo<_ooool002gooooo00?o0000ooooooooool0;?ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0<Oooool00ol0003ooooooooo
o`3ooooooooooooo?oooool002gooooo00?o0000ooooooooool0;?ooool00ol0003oooooooooo`06
ooooo`;o0000C?ooool00ol0003oooooooooo`0`ooooo`;o0000oooooooooooood;ooooo000]oooo
o`03o`000?oooooooooo02_ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`18oooo
o`03o`000?oooooooooo02oooooo0_l0003oooooooooooooA?ooool002gooooo00?o0000oooooooo
ool0:oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo04Kooooo00?o0000oooooooo
ool0;_ooool2o`000?oooooooooooom6ooooo`00;Oooool00ol0003oooooooooo`0[ooooo`03o`00
0?oooooooooo00_ooooo00?o0000ooooooooool0A?ooool00ol0003oooooooooo`0]ooooo`;o0000
ooooooooooooodSooooo000]ooooo`03o`000?oooooooooo02[ooooo00?o0000ooooooooool03Ooo
ool00ol0003oooooooooo`13ooooo`03o`000?oooooooooo02_ooooo0_l0003oooooooooooooB_oo
ool002gooooo00?o0000ooooooooool0:_ooool00ol0003oooooooooo`0>ooooo`;o0000@_ooool0
0ol0003oooooooooo`0Zooooo`;o0000ooooooooooooodcooooo000]ooooo`03o`000?oooooooooo
02[ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0nooooo`03o`000?oooooooooo
02Wooooo0_l0003oooooooooooooC_ooool002gooooo00?o0000ooooooooool0:_ooool00ol0003o
ooooooooo`0Aooooo`;o0000?Oooool00ol0003oooooooooo`0Xooooo`;o0000oooooooooooooe3o
oooo000]ooooo`Co0000:?ooool00ol0003oooooooooo`0Dooooo`;o0000>_ooool00ol0003ooooo
ooooo`0Xooooo`03o`000?oooooooooo0?oooooooooooom@ooooo`00;Oooool00ol0003ooooooooo
o`0Yooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool0=_ooool00ol0003ooooooooo
o`0Wooooo`;o0000oooooooooooooe?ooooo000]ooooo`03o`000?oooooooooo02Wooooo00?o0000
ooooooooool05oooool2o`0003Gooooo00?o0000ooooooooool09_ooool2o`000?oooooooooooomE
ooooo`00;Oooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo01Wooooo0_l0000coooo
o`03o`000?oooooooooo02Cooooo0_l0003oooooooooooooEoooool002gooooo00?o0000oooooooo
ool0:Oooool00ol0003oooooooooo`0Kooooo`;o0000<?ooool00ol0003oooooooooo`0Sooooo`;o
0000oooooooooooooeWooooo000]ooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool0
7_ooool2o`0002gooooo00?o0000ooooooooool08_ooool2o`000?oooooooooooomKooooo`00;Ooo
ool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo023ooooo0_l0000Zooooo`03o`000?oo
oooooooo027ooooo0_l0003oooooooooooooGOooool002gooooo00?o0000ooooooooool0:?ooool0
0ol0003oooooooooo`0Rooooo`;o00009oooool00ol0003oooooooooo`0Pooooo`;o0000oooooooo
oooooeoooooo000]ooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool09?ooool2o`00
02Cooooo00?o0000ooooooooool07_ooool3o`000?oooooooooooomQooooo`00;Oooool00ol0003o
ooooooooo`0Xooooo`03o`000?oooooooooo02Kooooo0_l0000Rooooo`03o`000?oooooooooo01_o
oooo0ol0003oooooooooooooI?ooool002gooooo00?o0000ooooooooool09oooool00ol0003ooooo
ooooo`0Yooooo`?o00007_ooool00ol0003oooooooooo`0Iooooo`?o0000ooooooooooooofOooooo
000]ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool0;?ooool3o`0001[ooooo00?o
0000ooooooooool05_ooool4o`000?oooooooooooomZooooo`00;Oooool00ol0003oooooooooo`0W
ooooo`03o`000?oooooooooo02oooooo1?l0000Eooooo`03o`000?oooooooooo01?ooooo1?l0003o
ooooooooooooK_ooool002gooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0coooo
o`Co00004?ooool00ol0003oooooooooo`0@ooooo`Co0000ooooooooooooog;ooooo000]ooooo`03
o`000?oooooooooo02Oooooo00?o0000ooooooooool0=oooool4o`0000_ooooo00?o0000oooooooo
ool03Oooool4o`000?oooooooooooomfooooo`00;Oooool00ol0003oooooooooo`0Vooooo`03o`00
0?oooooooooo03cooooo1_l00004ooooo`03o`000?oooooooooo00Oooooo1ol0003ooooooooooooo
N_ooool002gooooo00?o0000ooooooooool09_ooool00ol0003oooooooooo`12ooooo`ko0000oooo
oooooooooh7ooooo000]ooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool0AOooool0
0ol0003oooooooooo`3oooooooooooooROooool002gooooo00?o0000ooooooooool09_ooool00ol0
003oooooooooo`14ooooo`03o`000?oooooooooo0?oooooooooooon:ooooo`00;Oooool00ol0003o
ooooooooo`0Vooooo`03o`000?oooooooooo04?ooooo00?o0000ooooooooool0oooooooooooooh_o
oooo000]ooooo`03o`000?oooooooooo02Gooooo00?o0000ooooooooool0@oooool00ol0003ooooo
ooooo`3oooooooooooooS?ooool002gooooo00?o0000ooooooooool09Oooool00ol0003ooooooooo
o`12ooooo`03o`000?oooooooooo0?oooooooooooon=ooooo`00;Oooool00ol0003oooooooooo`0U
ooooo`03o`000?oooooooooo04;ooooo00?o0000ooooooooool0ooooooooooooohgooooo000]oooo
o`03o`000?oooooooooo02Gooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`3ooooo
ooooooooS_ooool002gooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`10ooooo`03
o`000?oooooooooo0?oooooooooooon?ooooo`00;Oooool4o`0002?ooooo00?o0000ooooooooool0
@?ooool00ol0003oooooooooo`3oooooooooooooT?ooool002gooooo00?o0000ooooooooool09?oo
ool00ol0003oooooooooo`0oooooo`03o`000?oooooooooo0?oooooooooooonAooooo`00;Oooool0
0ol0003oooooooooo`0Tooooo`03o`000?oooooooooo03kooooo00?o0000ooooooooool0oooooooo
oooooi;ooooo000]ooooo`03o`000?oooooooooo02Cooooo00?o0000ooooooooool0?_ooool00ol0
003oooooooooo`3oooooooooooooT_ooool002gooooo00?o0000ooooooooool09?ooool00ol0003o
ooooooooo`0mooooo`03o`000?oooooooooo0?oooooooooooonCooooo`00;Oooool00ol0003ooooo
ooooo`0Sooooo`03o`000?oooooooooo03gooooo00?o0000ooooooooool0oooooooooooooiCooooo
000]ooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool0??ooool00ol0003ooooooooo
o`3oooooooooooooUOooool002gooooo00?o0000ooooooooool08oooool00ol0003oooooooooo`0k
ooooo`03o`000?oooooooooo0?oooooooooooonFooooo`00;Oooool00ol0003oooooooooo`0Soooo
o`03o`000?oooooooooo03[ooooo00?o0000ooooooooool0oooooooooooooiOooooo000]ooooo`03
o`000?oooooooooo02?ooooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`3ooooooooo
ooooV?ooool002gooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`0jooooo`03o`00
0?oooooooooo0?oooooooooooonHooooo`00;Oooool00ol0003oooooooooo`0Rooooo`03o`000?oo
oooooooo03Wooooo00?o0000ooooooooool0oooooooooooooiWooooo000]ooooo`03o`000?oooooo
oooo02;ooooo00?o0000ooooooooool0>?ooool00ol0003oooooooooo`3oooooooooooooV_ooool0
02gooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`0gooooo`03o`000?oooooooooo
0?oooooooooooonKooooo`00;Oooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo03Ko
oooo00?o0000ooooooooool0oooooooooooooicooooo000]ooooo`03o`000?oooooooooo027ooooo
00?o0000ooooooooool0=_ooool00ol0003oooooooooo`3oooooooooooooWOooool002gooooo00?o
0000ooooooooool08Oooool00ol0003oooooooooo`0eooooo`03o`000?oooooooooo0?oooooooooo
oonNooooo`00;Oooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo03Cooooo00?o0000
ooooooooool0oooooooooooooioooooo000]ooooo`03o`000?oooooooooo027ooooo00?o0000oooo
ooooool0<oooool00ol0003oooooooooo`3oooooooooooooX?ooool002gooooo0_l0000Rooooo`03
o`000?oooooooooo03;ooooo00?o0000ooooooooool0oooooooooooooj7ooooo000]ooooo`03o`00
0?oooooo0000027ooooo00?o0000ooooooooool0<Oooool00ol0003oooooooooo`3ooooooooooooo
X_ooool002gooooo00?o0000ooooool000008?ooool00ol0003oooooooooo`0aooooo`03o`000?oo
oooooooo0?oooooooooooonSooooo`00;Oooool01?l0003oooooooooool0000Oooooo`03o`000?oo
oooooooo033ooooo00?o0000ooooooooool0ooooooooooooojCooooo000]ooooo`05o`000?oooooo
ooooooooool000007_ooool00ol0003oooooooooo`0_ooooo`03o`000?oooooooooo0?oooooooooo
oonUooooo`00;Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo01_ooooo00?o0000
ooooooooool0;_ooool00ol0003oooooooooo`3oooooooooooooY_ooool002gooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo02gooooo00?o0000oooo
ooooool0ooooooooooooojOooooo000]ooooo`Co00000_ooool00ol0003oooooooooo`0Jooooo`03
o`000?oooooooooo02cooooo00?o0000ooooooooool0ooooooooooooojSooooo000]ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0/ooooo`03o`00
0?oooooooooo0?oooooooooooonYooooo`00;Oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo01Sooooo00?o0000ooooooooool0:oooool00ol0003oooooooooo`3oooooooooooooZ_oo
ool002gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooo
oooo02[ooooo00?o0000ooooooooool0oooooooooooooj_ooooo000]ooooo`03o`000?oooooooooo
00Kooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo
0?oooooooooooon/ooooo`00;Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo01Go
oooo00?o0000ooooooooool09oooool2o`000?oooooooooooon_ooooo`00;Oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool09oooool00ol0003ooooo
ooooo`3ooooooooooooo[oooool002gooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool0oooooooooooook3ooooo000]
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0T
ooooo`;o0000oooooooooooook?ooooo000]ooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool04?ooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo0?ooooooooooooncoooo
o`00;Oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00oooooo00?o0000oooooooo
ool08Oooool2o`000?oooooooooooonfooooo`00;Oooool00ol0003oooooooooo`0=ooooo`03o`00
0?oooooooooo00kooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`3ooooooooooooo
]_ooool002gooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo023ooooo00?o0000ooooooooool0oooooooooooookOooooo000]ooooo`03o`000?oooooo
oooo00oooooo0_l0000<ooooo`03o`000?oooooooooo01kooooo0_l0003ooooooooooooo^_ooool0
02gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
01gooooo00?o0000ooooooooool0oooooooooooook[ooooo000]ooooo`03o`000?oooooooooo01;o
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo0?oo
oooooooooonkooooo`00;Oooool00ol0003oooooooooo`0Cooooo`;o00002?ooool00ol0003ooooo
ooooo`0Jooooo`;o0000oooooooooooookkooooo000]ooooo`03o`000?oooooooooo01Gooooo0_l0
0006ooooo`03o`000?oooooooooo01Sooooo0_l0003ooooooooooooo`?ooool002gooooo00?o0000
ooooooooool05oooool2o`0000?ooooo00?o0000ooooooooool05oooool2o`000?ooooooooooooo2
ooooo`00;Oooool00ol0003oooooooooo`0Iooooo`;o000000?oooooo`000?ooool05_ooool2o`00
0?ooooooooooooo4ooooo`00;Oooool00ol0003oooooooooo`0Kooooo`;o00005?ooool3o`000?oo
ooooooooooo6ooooo`002_ooool01OnYZJWo410@o`000?l@413oQhN700Cooooo0_lQ8B48ooooo`;o
00003_ooool00ol0003oooooooooo`0Looooo`Go00003?ooool4o`000?ooooooooooooo9ooooo`00
2Oooool01onHV9So0000ohN7Qooooooo^[Zjo`000?n7QhL00oooool2ob4Q8@Sooooo0_l0000>oooo
o`03o`000?oooooooooo01cooooo00?o0000ooooooooool00_ooool<o`000?ooooooooooooo=oooo
o`002?ooool00ooMgMgo0000oeEEE@03ooooo`03ofIVI_l0003ok^k^00cooooo0_l0000>ooooo`03
o`000?oooooooooo01_ooooo00?o0000ooooooooool0ooooooooooooomcooooo0008ooooo`03ohN7
Qol0003oZJVY00?ooooo00?o^[Zjo`000?n7QhL01_ooool:o`0000cooooo00?o0000ooooooooool0
6oooool00ol0003oooooooooo`3ooooooooooooog?ooool000Sooooo00?o<S8bo`000?oMgMd00ooo
ool00ooMgMgo0000oc8b<P06ooooo`03odA4A?nYZJWooooo00?ooooo0_l0000>ooooo`Ko00006?oo
ool00ol0003oooooooooo`3ooooooooooooog?ooool000Sooooo0_l00005ooooo`03o`000?l@413o
oooo00Gooooo00?ok^k^oa0@4?o^k^h00oooool2o`0000kooooo00?o0000ooooooooool06oooool0
0ol0003oooooooooo`3ooooooooooooog?ooool000Sooooo0_l00005ooooo`;o00001oooool00onY
ZJWo<S8booooo`02ooooo`;o00003_ooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo
0?oooooooooooooLooooo`002?ooool2o`0000Gooooo0_l00008ooooo`04oeEEEOn7QhOooooooooo
o`;o00003_ooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo0?oooooooooooooLoooo
o`002?ooool2o`0000Gooooo0_l00008ooooo`04onk^k_lQ8B7ogMgMooooo`;o00003_ooool00ol0
003oooooooooo`0Kooooo`03o`000?oooooooooo0?oooooooooooooLooooo`002?ooool00olb<S;o
0000olc<c003ooooo`03olc<c?l0003o<S8b00Wooooo00?o^[Zjoc8b<_ooool00_l0000>ooooo`03
o`000?oooooooooo01[ooooo00?o0000ooooooooool0ooooooooooooomgooooo0008ooooo`03ohN7
Qol0003oZJVY00?ooooo00?oZJVYo`000?n7QhL02_ooool01?mVIVKoQhN7o`000?l0000>ooooo`03
o`000?oooooooooo01[ooooo00?o0000ooooooooool0ooooooooooooomgooooo0008ooooo`03omgM
gOl0003oEEEE00?ooooo00?oEEEEo`000?o^k^h02_ooool01?o^k^ko8B4Qo`000?l0000>ooooo`03
o`000?oooooooooo01[ooooo00?o0000ooooooooool0ooooooooooooomgooooo0009ooooo`07ogMg
Mol0003oV9RHoooooonHV9So0000oiRHV00<ooooo`03okZj^_l0003o000000kooooo00?o0000oooo
ooooool06_ooool00ol0003oooooooooo`3ooooooooooooogOooool000[ooooo00GoQhN7oa0@4?l0
003o410@oiRHV00>ooooo`03ofIVI_l0003ooooo00gooooo00?o0000ooooooooool06_ooool00ol0
003oooooooooo`3ooooooooooooogOooool002gooooo00?o0000ooooooooool06_ooool00ol0003o
ooooooooo`3ooooooooooooogOooool002gooooo00?o0000ooooooooool06_ooool00ol0003ooooo
ooooo`3ooooooooooooogOooool002gooooo00?o0000ooooooooool06Oooool00ol0003ooooooooo
o`3ooooooooooooog_ooool002gooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`3o
oooooooooooog_ooool002gooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`3ooooo
oooooooog_ooool002gooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`3ooooooooo
oooog_ooool002gooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`3ooooooooooooo
g_ooool002gooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`3ooooooooooooog_oo
ool002gooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`3ooooooooooooog_ooool0
02gooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`3ooooooooooooogoooool002go
oooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`3ooooooooooooogoooool002gooooo
00?o0000ooooooooool06?ooool00ol0003oooooooooo`3ooooooooooooogoooool002gooooo00?o
0000ooooooooool06?ooool00ol0003oooooooooo`3ooooooooooooogoooool002gooooo00?o0000
ooooooooool06?ooool00ol0003oooooooooo`3ooooooooooooogoooool002gooooo00?o0000oooo
ooooool06?ooool00ol0003oooooooooo`3ooooooooooooogoooool002gooooo1?l0000Gooooo`03
o`000?oooooooooo0?oooooooooooooOooooo`00;Oooool00ol0003oooooooooo`0Gooooo`03o`00
0?oooooooooo0?oooooooooooooPooooo`00;Oooool00ol0003oooooooooo`0Gooooo`03o`000?oo
oooooooo0?oooooooooooooPooooo`00;Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooo
oooo0?oooooooooooooPooooo`00;Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo
0?oooooooooooooPooooo`00;Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo0?oo
oooooooooooPooooo`00;Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo0?oooooo
oooooooPooooo`00;Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo0?oooooooooo
oooPooooo`00;Oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo0?oooooooooooooQ
ooooo`00;Oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo0?oooooooooooooQoooo
o`00;Oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo0?oooooooooooooQooooo`00
;Oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo0?oooooooooooooQooooo`00;Ooo
ool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo0?oooooooooooooQooooo`00;Oooool0
0ol0003oooooooooo`0Fooooo`03o`000?oooooooooo0?oooooooooooooQooooo`00;Oooool00ol0
003oooooooooo`0Fooooo`03o`000?oooooooooo0?oooooooooooooQooooo`00;Oooool00ol0003o
ooooooooo`0Eooooo`03o`000?oooooooooo0?oooooooooooooRooooo`00;Oooool00ol0003ooooo
ooooo`0Eooooo`03o`000?oooooooooo0?oooooooooooooRooooo`00;Oooool00ol0003ooooooooo
o`0Eooooo`03o`000?oooooooooo0?oooooooooooooRooooo`00;Oooool00ol0003oooooooooo`0E
ooooo`03o`000?oooooooooo0?oooooooooooooRooooo`00;Oooool00ol0003oooooooooo`0Eoooo
o`03o`000?oooooooooo0?oooooooooooooRooooo`00;Oooool00ol0003oooooooooo`0Eooooo`03
o`000?oooooooooo0?oooooooooooooRooooo`00;Oooool00ol0003oooooooooo`0Eooooo`03o`00
0?oooooooooo0?oooooooooooooRooooo`00;Oooool00ol0003oooooooooo`0Dooooo`03o`000?oo
oooooooo0?oooooooooooooSooooo`00;Oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooo
oooo0?oooooooooooooSooooo`00;Oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo
0?oooooooooooooSooooo`00;Oooool4o`0001?ooooo00?o0000ooooooooool0ooooooooooooon?o
oooo000]ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0ooooooooooooon?ooooo
000]ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0ooooooooooooon?ooooo000]
ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0ooooooooooooon?ooooo000]oooo
o`03o`000?oooooooooo01?ooooo00?o0000ooooooooool0ooooooooooooonCooooo000]ooooo`03
o`000?oooooooooo01?ooooo00?o0000ooooooooool0ooooooooooooonCooooo000]ooooo`03o`00
0?oooooooooo01?ooooo00?o0000ooooooooool0ooooooooooooonCooooo000]ooooo`03o`000?oo
oooooooo01?ooooo00?o0000ooooooooool0ooooooooooooonCooooo000]ooooo`03o`000?oooooo
oooo01?ooooo00?o0000ooooooooool0ooooooooooooonCooooo000]ooooo`03o`000?oooooooooo
01?ooooo00?o0000ooooooooool0ooooooooooooonCooooo000]ooooo`03o`000?oooooooooo01?o
oooo00?o0000ooooooooool0ooooooooooooonCooooo000]ooooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool0ooooooooooooonGooooo000]ooooo`03o`000?oooooooooo01;ooooo00?o
0000ooooooooool0ooooooooooooonGooooo000]ooooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool0ooooooooooooonGooooo000]ooooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool0ooooooooooooonGooooo000]ooooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool0ooooooooooooonGooooo000]ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0
ooooooooooooonGooooo000]ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0oooo
ooooooooonGooooo000]ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0oooooooo
ooooonKooooo000]ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0oooooooooooo
onKooooo000]ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0ooooooooooooonKo
oooo000]ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0ooooooooooooonKooooo
000]ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0ooooooooooooonKooooo000]
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0ooooooooooooonKooooo000]oooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool0ooooooooooooonKooooo000]ooooo`Co
00003oooool00ol0003oooooooooo`3oooooooooooooioooool002gooooo00?o0000ooooooooool0
4?ooool00ol0003oooooooooo`3oooooooooooooioooool002gooooo00?o0000ooooooooool04?oo
ool00ol0003oooooooooo`3oooooooooooooioooool002gooooo00?o0000ooooooooool04?ooool0
0ol0003oooooooooo`3oooooooooooooioooool002gooooo00?o0000ooooooooool04?ooool00ol0
003oooooooooo`3oooooooooooooioooool002gooooo00?o0000ooooooooool04?ooool00ol0003o
ooooooooo`3oooooooooooooioooool002gooooo00?o0000ooooooooool04?ooool00ol0003ooooo
ooooo`3oooooooooooooioooool002gooooo00?o0000ooooooooool03oooool00ol0003ooooooooo
o`3oooooooooooooj?ooool002gooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`3o
ooooooooooooj?ooool002gooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`3ooooo
ooooooooj?ooool002gooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`3ooooooooo
ooooj?ooool002gooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`3ooooooooooooo
j?ooool002gooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`3oooooooooooooj?oo
ool002gooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`3oooooooooooooj?ooool0
02gooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`3ooooooooooooojOooool002go
oooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`3ooooooooooooojOooool002gooooo
00?o0000ooooooooool03_ooool00ol0003oooooooooo`3ooooooooooooojOooool002gooooo00?o
0000ooooooooool03_ooool00ol0003oooooooooo`3ooooooooooooojOooool002gooooo00?o0000
ooooooooool03_ooool00ol0003oooooooooo`3ooooooooooooojOooool002gooooo00?o0000oooo
ooooool03_ooool00ol0003oooooooooo`3ooooooooooooojOooool002gooooo00?o0000oooooooo
ool03_ooool00ol0003oooooooooo`3ooooooooooooojOooool002gooooo00?o0000ooooooooool0
3Oooool00ol0003oooooooooo`3oooooooooooooj_ooool000[ooooo00GoZJVYoa0@4?l0003o410@
ohN7Q`04ooooo`;o8B4Q1?ooool01_nj^[[o8B4Qo`000?l0003oEEEEonk^kPkooooo00?o0000oooo
ooooool03Oooool00ol0003oooooooooo`3oooooooooooooj_ooool000Wooooo00OoV9RHo`000?n7
QhOooooookZj^_l0003oQhN700?ooooo0_lQ8B43ooooo`05oiRHV?l0003oQhN7oooooooMgMd00_lQ
8B4>ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0ooooooooooooon[ooooo0008
ooooo`03omgMgOl0003oEEEE00?ooooo00?oIVIVo`000?o^k^h01_ooool00ooMgMgo0000oeEEE@03
ooooo`03ojVYZOl0003oMgMg00gooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`3o
ooooooooooooj_ooool000Sooooo00?oQhN7o`000?nYZJT00oooool00onj^[[o0000ohN7Q`06oooo
o`03oeEEEOl0003oZJVY00Cooooo00?o0000ob4Q8Oooool03?ooool00ol0003oooooooooo`0=oooo
o`03o`000?oooooooooo0?oooooooooooooZooooo`002?ooool00olb<S;o0000omgMg@03ooooo`03
omgMgOl0003o<S8b00Kooooo00?o410@o`000?o^k^h01?ooool2o`0000gooooo1_l0000:ooooo`03
o`000?oooooooooo0?oooooooooooooZooooo`002?ooool2o`0000Gooooo00?o0000oa0@4?ooool0
1Oooool2o`0000Cooooo00?ogMgMo`000?l000003Oooool00ol0003oooooooooo`0=ooooo`03o`00
0?oooooooooo0?oooooooooooooZooooo`002?ooool2o`0000Gooooo0_l00006ooooo`;o000000Oo
k^k^ooooooooooooooooogMgMol0003oA4A400gooooo00?o0000ooooooooool03?ooool00ol0003o
ooooooooo`3ooooooooooooojoooool000Sooooo0_l00005ooooo`;o00001_ooool01_lQ8B7o0000
oeEEEOo^k^koooooojVYZ@;o000000?oc<c<ooooooooool02oooool00ol0003oooooooooo`0<oooo
o`03o`000?oooooooooo0?ooooooooooooo[ooooo`002?ooool2o`0000Gooooo0_l00006ooooo`04
ofIVI_l0003oQhN7oc8b<P;o000000?oA4A4olc<c?ooool03Oooool00ol0003oooooooooo`0<oooo
o`03o`000?oooooooooo0?ooooooooooooo[ooooo`002?ooool00olb<S;o0000olc<c003ooooo`03
olc<c?l0003o<S8b00Kooooo00?ogMgMo`000?mEEED04oooool00ol0003oooooooooo`0<ooooo`03
o`000?oooooooooo0?ooooooooooooo[ooooo`002?ooool00on7QhOo0000ojVYZ@03ooooo`03ojVY
ZOl0003oQhN700Oooooo00?oMgMgo`000?nj^[X04_ooool00ol0003oooooooooo`0<ooooo`03o`00
0?oooooooooo0?ooooooooooooo[ooooo`002?ooool00ooMgMgo0000oeEEE@03ooooo`03oeEEEOl0
003ok^k^00Sooooo00?oEEEEo`000?o<c<`04Oooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo0?ooooooooooooo[ooooo`002Oooool01omgMgOo0000oiRHV?ooooooV9RHo`000?nHV9P0
2_ooool01?n7QhOo410@ohN7Qoo^k^h?ooooo`03o`000?oooooooooo00cooooo00?o0000oooooooo
ool0ooooooooooooon_ooooo000:ooooo`05ohN7Qol@413o0000oa0@4?nHV9P03?ooool01Oo^k^ko
QhN7oc8b<_lb<S;o^[Zj00gooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`3ooooo
ooooooook?ooool002gooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`3ooooooooo
ooook?ooool002gooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`3ooooooooooooo
k?ooool002gooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`3oooooooooooook?oo
ool002gooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`3oooooooooooook?ooool0
02gooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`3oooooooooooook?ooool002go
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`3oooooooooooook?ooool002gooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`3oooooooooooook?ooool002gooooo00?o
0000ooooooooool02oooool00ol0003oooooooooo`3oooooooooooook?ooool002gooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`3oooooooooooookOooool002gooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`3oooooooooooookOooool002gooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`3oooooooooooookOooool002gooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`3oooooooooooookOooool002gooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`3oooooooooooookOooool002gooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`3oooooooooooookOooool002gooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`3oooooooooooookOooool002gooooo1?l00009ooooo`03o`000?oooooooooo0?oo
ooooooooooo]ooooo`00;Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo0?oooooo
ooooooo]ooooo`00;Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo0?oooooooooo
ooo]ooooo`00;Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo0?ooooooooooooo^
ooooo`00;Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo0?ooooooooooooo^oooo
o`00;Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo0?ooooooooooooo^ooooo`00
;Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo0?ooooooooooooo^ooooo`00;Ooo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo0?ooooooooooooo^ooooo`00;Oooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo0?ooooooooooooo^ooooo`00;Oooool00ol0
003oooooooooo`09ooooo`03o`000?oooooooooo0?ooooooooooooo^ooooo`00;Oooool00ol0003o
ooooooooo`09ooooo`03o`000?oooooooooo0?ooooooooooooo^ooooo`00;Oooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo0?ooooooooooooo^ooooo`00;Oooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo0?ooooooooooooo^ooooo`00;Oooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo0?ooooooooooooo_ooooo`00;Oooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo0?ooooooooooooo_ooooo`00;Oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo0?ooooooooooooo_ooooo`00;Oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo0?ooooooooooooo_ooooo`00;Oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo0?ooooooooooooo_ooooo`00;Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo0?ooooooooooooo_ooooo`00;Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
0?ooooooooooooo_ooooo`00;Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo0?oo
ooooooooooo_ooooo`00;Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo0?oooooo
ooooooo_ooooo`00;Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo0?oooooooooo
ooo_ooooo`00;Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo0?ooooooooooooo`
ooooo`00;Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo0?ooooooooooooo`oooo
o`00;Oooool4o`0000Kooooo00?o0000ooooooooool0oooooooooooooo3ooooo000]ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool0oooooooooooooo3ooooo000]ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool0oooooooooooooo3ooooo000]ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool0oooooooooooooo3ooooo000]ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool0oooooooooooooo3ooooo000]ooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool0oooooooooooooo3ooooo000]ooooo`03o`000?oooooooooo00Oooooo
00?o0000ooooooooool0oooooooooooooo3ooooo000]ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool0oooooooooooooo3ooooo000]ooooo`03o`000?oooooooooo00Kooooo00?o0000
ooooooooool0oooooooooooooo7ooooo000]ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool0oooooooooooooo7ooooo000]ooooo`03o`000?oooooooooo00Kooooo00?o0000oooooooo
ool0oooooooooooooo7ooooo000]ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0
oooooooooooooo7ooooo000]ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0oooo
oooooooooo7ooooo000]ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0oooooooo
oooooo7ooooo000]ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0oooooooooooo
oo7ooooo000]ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0oooooooooooooo7o
oooo000]ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0oooooooooooooo7ooooo
000]ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0oooooooooooooo7ooooo000]
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0oooooooooooooo;ooooo000]oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0oooooooooooooo;ooooo000]ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool0oooooooooooooo;ooooo000]ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool0oooooooooooooo;ooooo000]ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool0oooooooooooooo;ooooo000]ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool0oooooooooooooo;ooooo000]ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool0oooooooooooooo;ooooo000]ooooo`Co00001?ooool00ol0003o
ooooooooo`3oooooooooooool_ooool002gooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`3oooooooooooool_ooool002gooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`3oooooooooooool_ooool002gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3o
ooooooooooooloooool002gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3ooooo
ooooooooloooool002gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3ooooooooo
ooooloooool002gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3ooooooooooooo
loooool002gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3ooooooooooooolooo
ool002gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3oooooooooooooloooool0
02gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3oooooooooooooloooool002go
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3oooooooooooooloooool002gooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`3oooooooooooooloooool002gooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`3oooooooooooooloooool002gooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`3oooooooooooooloooool002gooooo00?o0000oooo
ooooool00oooool00ol0003oooooooooo`3ooooooooooooom?ooool002gooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`3ooooooooooooom?ooool002gooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`3ooooooooooooom?ooool002gooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`3ooooooooooooom?ooool002gooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`3ooooooooooooom?ooool002gooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`3ooooooooooooom?ooool002gooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`3ooooooooooooom?ooool000[ooooo00GoZJVYoa0@4?l0003o410@ohN7Q`04ooooo`;o
8B4Q1?ooool01_nYZJWo8B4Qo`000?l0003o8B4QojVYZ@kooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`3ooooooooooooom?ooool000Wooooo00OoV9RHo`000?n7QhOooooookZj^_l0
003oQhN700?ooooo0_lQ8B43ooooo`08oiRHV?l0003o8B4QomgMgOo^k^koEEEEo`000?nHV9P=oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0ooooooooooooooCooooo0008ooooo`03
omgMgOl0003oEEEE00?ooooo00?oIVIVo`000?o^k^h01oooool00ol@413o0000olc<c002ooooo`03
onk^k_l0003o410@00gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`3ooooooooo
oooom?ooool000Sooooo00?oQhN7o`000?nYZJT00oooool00onj^[[o0000ohN7Q`07ooooo`;o0000
0oooool00oo^k^ko0000o`00000=ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
ooooooooooooooGooooo0008ooooo`03oc8b<_l0003ogMgM00?ooooo00?ogMgMo`000?lb<S801ooo
ool00olb<S;o0000onk^kP02ooooo`03oeEEEOl0003o8B4Q00gooooo1_l0003ooooooooooooomooo
ool000Sooooo0_l00005ooooo`03o`000?l@413ooooo00Kooooo00Goc<c<o`000?n7QhOooooooeEE
E@02o`000003ojVYZOoooooooooo00_ooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`3ooooooooooooomOooool000Sooooo0_l00005ooooo`;o00002?ooool00ooMgMgo<S8bob4Q8@02
o`000003oiRHV?oooooooooo00cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`3o
oooooooooooomOooool000Sooooo0_l00005ooooo`;o00002?ooool01Oo^k^koA4A4o`000?l0003o
c<c<00oooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`3ooooooooooooomOooool0
00Sooooo0_l00005ooooo`;o00001oooool01oo^k^ko8B4Qo`000?m4A4CoZJVYob4Q8OnYZJT03_oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?oooooooooooooeooooo`002?ooool0
0olb<S;o0000olc<c003ooooo`03olc<c?l0003o<S8b00Oooooo00?oEEEEo`000?mEEED00_ooool0
0onHV9So0000oiRHV00=ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0oooooooo
ooooooGooooo0008ooooo`03ohN7Qol0003oZJVY00?ooooo00?oZJVYo`000?n7QhL01oooool2o`00
0004omgMgOooooooooooooooo`;o00003Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo0?oooooooooooooeooooo`002?ooool00ooMgMgo0000oeEEE@03ooooo`03oeEEEOl0003ok^k^
00Oooooo0_l000001?o^k^koooooooooooo^k^h2o`0000gooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`3ooooooooooooomOooool000Wooooo00OoMgMgo`000?nHV9SooooooiRHV?l0
003oV9RH00Sooooo00?oV9RHo`000?mEEED00_o^k^h00omEEEGo0000ogMgM`0=ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool0ooooooooooooooGooooo000:ooooo`05ohN7Qol@413o
0000oa0@4?nHV9P02_ooool01_nj^[[oA4A4o`000?l0003o410@oiRHV0kooooo00Go0000oooooooo
ooooooooo`00003ooooooooooooon?ooool002gooooo00Go0000ooooooooooooooooo`00003ooooo
oooooooon?ooool002gooooo00Go0000ooooooooooooooooo`00003ooooooooooooon?ooool002go
oooo00Go0000ooooooooooooooooo`00003ooooooooooooon?ooool002gooooo00Go0000oooooooo
ooooooooo`00003ooooooooooooon?ooool002gooooo00Go0000ooooooooooooooooo`00003ooooo
oooooooon?ooool002gooooo00Go0000ooooooooooooooooo`00003ooooooooooooon?ooool002go
oooo00Go0000ooooooooooooooooo`00003ooooooooooooon?ooool002gooooo00Go0000oooooooo
ooooooooo`00003ooooooooooooon?ooool002gooooo00Go0000ooooooooooooooooo`00003ooooo
oooooooon?ooool002gooooo00Co0000oooooooooooo0000ooooooooooooooWooooo000]ooooo`04
o`000?ooooooooooo`000?oooooooooooooiooooo`00;Oooool01?l0003oooooooooool0003ooooo
oooooooonOooool002gooooo00Co0000oooooooooooo0000ooooooooooooooWooooo000]ooooo`04
o`000?ooooooooooo`000?oooooooooooooiooooo`00;Oooool01?l0003oooooooooool0003ooooo
oooooooonOooool002gooooo1?l0003ooooooooooooonOooool002gooooo00Co0000oooooooooooo
0000ooooooooooooooWooooo000]ooooo`04o`000?ooooooooooo`000?oooooooooooooiooooo`00
;Oooool01?l0003oooooooooool0003ooooooooooooonOooool002gooooo00?o0000ooooool00000
oooooooooooooo[ooooo000]ooooo`03o`000?oooooo00000?ooooooooooooojooooo`00;Oooool0
0ol0003oooooo`00003ooooooooooooon_ooool002gooooo00?o0000ooooool00000oooooooooooo
oo[ooooo000]ooooo`03o`000?oooooo00000?ooooooooooooojooooo`00;Oooool00ol0003ooooo
o`00003ooooooooooooon_ooool002gooooo00?o0000ooooool00000oooooooooooooo[ooooo000]
ooooo`03o`000?oooooo00000?ooooooooooooojooooo`00;Oooool00ol0003oooooo`00003ooooo
oooooooon_ooool002gooooo00?o0000ooooool00000oooooooooooooo[ooooo000]ooooo`;o0000
oooooooooooooo_ooooo000]ooooo`;o0000oooooooooooooo_ooooo000]ooooo`;o0000oooooooo
oooooo_ooooo000]ooooo`;o0000oooooooooooooo_ooooo000]ooooo`;o0000oooooooooooooo_o
oooo000]ooooo`;o0000oooooooooooooo_ooooo000]ooooo`;o0000oooooooooooooo_ooooo000]
ooooo`;o0000oooooooooooooo_ooooo000]ooooo`;o0000oooooooooooooo_ooooo000]ooooo`;o
0000oooooooooooooo_ooooo000]ooooo`03o`000?oooooooooo0?ooooooooooooojooooo`00;Ooo
ool00ol0003oooooooooo`3ooooooooooooon_ooool002gooooo1?l0003ooooooooooooonOooool0
02gooooo00?o0000ooooooooool0oooooooooooooo[ooooo000]ooooo`03o`000?oooooooooo0?oo
ooooooooooojooooo`00;Oooool00ol0003oooooooooo`3ooooooooooooon_ooool002gooooo00?o
0000ooooooooool0oooooooooooooo[ooooo000]ooooo`03o`000?oooooooooo0?oooooooooooooj
ooooo`00;Oooool00ol0003oooooooooo`3ooooooooooooon_ooool002gooooo00?o0000oooooooo
ool0oooooooooooooo[ooooo000]ooooo`03o`000?oooooooooo0?ooooooooooooojooooo`00;Ooo
ool00ol0003oooooooooo`3ooooooooooooon_ooool002gooooo00?o0000ooooooooool0oooooooo
oooooo[ooooo000]ooooo`03o`000?oooooooooo0?ooooooooooooojooooo`00;Oooool00ol0003o
ooooooooo`3ooooooooooooon_ooool002gooooo00?o0000ooooooooool0oooooooooooooo[ooooo
0000\
\>"],
  ImageRangeCache->{{{0, 807.688}, {498.812, 0}} -> {-0.613795, -0.062892, \
0.013561, 0.00198541}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{\(a = 0;\), "\n", \(n = 100;\), "\n", \(trial = 
        3;\), "\n", \(numbers = Table[{i}, {i, 1, n - a}];\), "\n", 
    RowBox[{"For", "[", 
      RowBox[{\(k = 1\), 
        StyleBox[",",
          "MR"], " ", 
        RowBox[{"k", " ", 
          StyleBox["<=",
            "MR"], " ", "trial"}], ",", " ", "\n", "  ", 
        RowBox[{
          RowBox[{"{", 
            
            RowBox[{\(t = 0\), ";", "\n", 
              "  ", \(data = 
                Table[{{t = t - Log[Random[]], i}, {t, i + 1}}, {i, a + 1, 
                    n}]\), ";", "\n", 
              "  ", \(dataflat = FlattenAt[data, numbers]\), ";", "\n", 
              "  ", \(firsttime = Part[Part[dataflat, 1], 1]\), ";", "\n", 
              "  ", \(datafull = 
                Prepend[Prepend[dataflat, {firsttime, a}], {0, a}]\), ";", 
              "\n", "  ", 
              RowBox[{
                RowBox[{"experiment", 
                  StyleBox["[",
                    "Subsubsection"], 
                  StyleBox["k",
                    "Subsubsection"], 
                  StyleBox["]",
                    "Subsubsection"]}], 
                "=", \(ListPlot[datafull, PlotJoined \[Rule] True, 
                  PlotRange \[Rule] {0, n}, DisplayFunction \[Rule] Identity, 
                  TextStyle \[Rule] {FontFamily \[Rule] "\<Times\>", 
                      FontSize \[Rule] 20}]\)}]}], "}"}], ";", 
          "\[IndentingNewLine]", \(k++\)}]}], 
      "]"}], "\n", \(allplots = 
        Table[experiment[k], {k, 1, trial}];\), "\n", \(deterministic = 
        Plot[x, {x, 0, n}, 
          TextStyle \[Rule] {FontFamily \[Rule] "\<Times\>", 
              FontSize \[Rule] 20}, 
          PlotStyle \[Rule] {{Thickness[0.01], RGBColor[0, 1, 0]}}, 
          DisplayFunction \[Rule] Identity];\), "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{"Show", "[", 
        RowBox[{"allplots", ",", "deterministic", ",", 
          StyleBox[\(DisplayFunction \[Rule] $DisplayFunction\),
            FontFamily->"Courier New"]}], 
        StyleBox["]",
          FontFamily->"Courier New"]}], 
      StyleBox[";",
        FontFamily->"Courier New"]}]}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00952381 0 0.00618034 [
[.21429 -0.0125 -12 -22 ]
[.21429 -0.0125 12 0 ]
[.40476 -0.0125 -12 -22 ]
[.40476 -0.0125 12 0 ]
[.59524 -0.0125 -12 -22 ]
[.59524 -0.0125 12 0 ]
[.78571 -0.0125 -12 -22 ]
[.78571 -0.0125 12 0 ]
[.97619 -0.0125 -17 -22 ]
[.97619 -0.0125 17 0 ]
[.01131 .12361 -24 -11 ]
[.01131 .12361 0 11 ]
[.01131 .24721 -24 -11 ]
[.01131 .24721 0 11 ]
[.01131 .37082 -24 -11 ]
[.01131 .37082 0 11 ]
[.01131 .49443 -24 -11 ]
[.01131 .49443 0 11 ]
[.01131 .61803 -34 -11 ]
[.01131 .61803 0 11 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 0 m
.21429 .00625 L
s
gsave
.21429 -0.0125 -73 -26 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 20.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 20.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(20) show
1.000 setlinewidth
grestore
.40476 0 m
.40476 .00625 L
s
gsave
.40476 -0.0125 -73 -26 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 20.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 20.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(40) show
1.000 setlinewidth
grestore
.59524 0 m
.59524 .00625 L
s
gsave
.59524 -0.0125 -73 -26 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 20.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 20.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(60) show
1.000 setlinewidth
grestore
.78571 0 m
.78571 .00625 L
s
gsave
.78571 -0.0125 -73 -26 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 20.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 20.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(80) show
1.000 setlinewidth
grestore
.97619 0 m
.97619 .00625 L
s
gsave
.97619 -0.0125 -78 -26 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 20.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 20.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(100) show
1.000 setlinewidth
grestore
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.5 0 m
.5 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .12361 m
.03006 .12361 L
s
gsave
.01131 .12361 -85 -15 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 20.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 20.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(20) show
1.000 setlinewidth
grestore
.02381 .24721 m
.03006 .24721 L
s
gsave
.01131 .24721 -85 -15 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 20.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 20.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(40) show
1.000 setlinewidth
grestore
.02381 .37082 m
.03006 .37082 L
s
gsave
.01131 .37082 -85 -15 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 20.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 20.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(60) show
1.000 setlinewidth
grestore
.02381 .49443 m
.03006 .49443 L
s
gsave
.01131 .49443 -85 -15 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 20.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 20.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(80) show
1.000 setlinewidth
grestore
.02381 .61803 m
.03006 .61803 L
s
gsave
.01131 .61803 -95 -15 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 20.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 20.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(100) show
1.000 setlinewidth
grestore
.125 Mabswid
.02381 .0309 m
.02756 .0309 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .09271 m
.02756 .09271 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .58713 m
.02756 .58713 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 0 m
.04987 0 L
.04987 .00618 L
.04987 .01236 L
.06184 .01236 L
.06184 .01854 L
.06975 .01854 L
.06975 .02472 L
.08113 .02472 L
.08113 .0309 L
.08909 .0309 L
.08909 .03708 L
.09666 .03708 L
.09666 .04326 L
.09758 .04326 L
.09758 .04944 L
.101 .04944 L
.101 .05562 L
.11058 .05562 L
.11058 .0618 L
.113 .0618 L
.113 .06798 L
.11625 .06798 L
.11625 .07416 L
.11876 .07416 L
.11876 .08034 L
.12576 .08034 L
.12576 .08652 L
.12753 .08652 L
.12753 .09271 L
.13215 .09271 L
.13215 .09889 L
.14411 .09889 L
.14411 .10507 L
.1443 .10507 L
.1443 .11125 L
.14519 .11125 L
.14519 .11743 L
.15771 .11743 L
.15771 .12361 L
.15822 .12361 L
.15822 .12979 L
.16122 .12979 L
.16122 .13597 L
.16221 .13597 L
.16221 .14215 L
.17188 .14215 L
.17188 .14833 L
.18749 .14833 L
.18749 .15451 L
Mistroke
.19137 .15451 L
.19137 .16069 L
.19597 .16069 L
.19597 .16687 L
.1967 .16687 L
.1967 .17305 L
.1978 .17305 L
.1978 .17923 L
.21171 .17923 L
.21171 .18541 L
.22888 .18541 L
.22888 .19159 L
.26677 .19159 L
.26677 .19777 L
.28245 .19777 L
.28245 .20395 L
.28381 .20395 L
.28381 .21013 L
.29281 .21013 L
.29281 .21631 L
.30403 .21631 L
.30403 .22249 L
.31219 .22249 L
.31219 .22867 L
.32123 .22867 L
.32123 .23485 L
.32677 .23485 L
.32677 .24103 L
.33028 .24103 L
.33028 .24721 L
.349 .24721 L
.349 .25339 L
.35757 .25339 L
.35757 .25957 L
.36171 .25957 L
.36171 .26575 L
.3699 .26575 L
.3699 .27193 L
.38559 .27193 L
.38559 .27812 L
.38932 .27812 L
.38932 .2843 L
.3921 .2843 L
.3921 .29048 L
.41873 .29048 L
.41873 .29666 L
.41875 .29666 L
.41875 .30284 L
.46207 .30284 L
.46207 .30902 L
Mistroke
.48152 .30902 L
.48152 .3152 L
.50061 .3152 L
.50061 .32138 L
.5219 .32138 L
.5219 .32756 L
.52428 .32756 L
.52428 .33374 L
.52462 .33374 L
.52462 .33992 L
.54514 .33992 L
.54514 .3461 L
.54599 .3461 L
.54599 .35228 L
.54687 .35228 L
.54687 .35846 L
.55212 .35846 L
.55212 .36464 L
.55415 .36464 L
.55415 .37082 L
.56095 .37082 L
.56095 .377 L
.56709 .377 L
.56709 .38318 L
.60567 .38318 L
.60567 .38936 L
.62614 .38936 L
.62614 .39554 L
.63615 .39554 L
.63615 .40172 L
.65648 .40172 L
.65648 .4079 L
.66595 .4079 L
.66595 .41408 L
.66944 .41408 L
.66944 .42026 L
.68708 .42026 L
.68708 .42644 L
.69486 .42644 L
.69486 .43262 L
.69935 .43262 L
.69935 .4388 L
.70372 .4388 L
.70372 .44498 L
.72127 .44498 L
.72127 .45116 L
.72927 .45116 L
.72927 .45735 L
.73599 .45735 L
.73599 .46353 L
Mistroke
.74264 .46353 L
.74264 .46971 L
.7709 .46971 L
.7709 .47589 L
.77496 .47589 L
.77496 .48207 L
.78102 .48207 L
.78102 .48825 L
.7902 .48825 L
.7902 .49443 L
.80911 .49443 L
.80911 .50061 L
.81197 .50061 L
.81197 .50679 L
.81243 .50679 L
.81243 .51297 L
.81772 .51297 L
.81772 .51915 L
.82186 .51915 L
.82186 .52533 L
.83646 .52533 L
.83646 .53151 L
.83709 .53151 L
.83709 .53769 L
.84456 .53769 L
.84456 .54387 L
.85607 .54387 L
.85607 .55005 L
.87823 .55005 L
.87823 .55623 L
.88366 .55623 L
.88366 .56241 L
.88623 .56241 L
.88623 .56859 L
.90485 .56859 L
.90485 .57477 L
.90887 .57477 L
.90887 .58095 L
.90944 .58095 L
.90944 .58713 L
.92881 .58713 L
.92881 .59331 L
.92897 .59331 L
.92897 .59949 L
.94321 .59949 L
.94321 .60567 L
.95086 .60567 L
.95086 .61185 L
.95521 .61185 L
.95521 .61803 L
Mistroke
.95588 .61803 L
Mfstroke
.95588 .61803 m
.95588 .61803 L
s
.02381 0 m
.02914 0 L
.02914 .00618 L
.02914 .01236 L
.02994 .01236 L
.02994 .01854 L
.04309 .01854 L
.04309 .02472 L
.04528 .02472 L
.04528 .0309 L
.04705 .0309 L
.04705 .03708 L
.04738 .03708 L
.04738 .04326 L
.05107 .04326 L
.05107 .04944 L
.06936 .04944 L
.06936 .05562 L
.074 .05562 L
.074 .0618 L
.10716 .0618 L
.10716 .06798 L
.12151 .06798 L
.12151 .07416 L
.12308 .07416 L
.12308 .08034 L
.12937 .08034 L
.12937 .08652 L
.13665 .08652 L
.13665 .09271 L
.14408 .09271 L
.14408 .09889 L
.14739 .09889 L
.14739 .10507 L
.14881 .10507 L
.14881 .11125 L
.15498 .11125 L
.15498 .11743 L
.16561 .11743 L
.16561 .12361 L
.1687 .12361 L
.1687 .12979 L
.17299 .12979 L
.17299 .13597 L
.1976 .13597 L
.1976 .14215 L
.20108 .14215 L
.20108 .14833 L
.2033 .14833 L
.2033 .15451 L
Mistroke
.22926 .15451 L
.22926 .16069 L
.24693 .16069 L
.24693 .16687 L
.25469 .16687 L
.25469 .17305 L
.25471 .17305 L
.25471 .17923 L
.2685 .17923 L
.2685 .18541 L
.2843 .18541 L
.2843 .19159 L
.28686 .19159 L
.28686 .19777 L
.2884 .19777 L
.2884 .20395 L
.29295 .20395 L
.29295 .21013 L
.31043 .21013 L
.31043 .21631 L
.31625 .21631 L
.31625 .22249 L
.37245 .22249 L
.37245 .22867 L
.39403 .22867 L
.39403 .23485 L
.3975 .23485 L
.3975 .24103 L
.42104 .24103 L
.42104 .24721 L
.43263 .24721 L
.43263 .25339 L
.44612 .25339 L
.44612 .25957 L
.46295 .25957 L
.46295 .26575 L
.4656 .26575 L
.4656 .27193 L
.47091 .27193 L
.47091 .27812 L
.47569 .27812 L
.47569 .2843 L
.49807 .2843 L
.49807 .29048 L
.52442 .29048 L
.52442 .29666 L
.52678 .29666 L
.52678 .30284 L
.53265 .30284 L
.53265 .30902 L
Mistroke
.53325 .30902 L
.53325 .3152 L
.5378 .3152 L
.5378 .32138 L
.54012 .32138 L
.54012 .32756 L
.55143 .32756 L
.55143 .33374 L
.55418 .33374 L
.55418 .33992 L
.55567 .33992 L
.55567 .3461 L
.55633 .3461 L
.55633 .35228 L
.55994 .35228 L
.55994 .35846 L
.56498 .35846 L
.56498 .36464 L
.57604 .36464 L
.57604 .37082 L
.57674 .37082 L
.57674 .377 L
.58191 .377 L
.58191 .38318 L
.58297 .38318 L
.58297 .38936 L
.59702 .38936 L
.59702 .39554 L
.60137 .39554 L
.60137 .40172 L
.61169 .40172 L
.61169 .4079 L
.61477 .4079 L
.61477 .41408 L
.62193 .41408 L
.62193 .42026 L
.64858 .42026 L
.64858 .42644 L
.65154 .42644 L
.65154 .43262 L
.65596 .43262 L
.65596 .4388 L
.66448 .4388 L
.66448 .44498 L
.67659 .44498 L
.67659 .45116 L
.6923 .45116 L
.6923 .45735 L
.69583 .45735 L
.69583 .46353 L
Mistroke
.6981 .46353 L
.6981 .46971 L
.70475 .46971 L
.70475 .47589 L
.70589 .47589 L
.70589 .48207 L
.70647 .48207 L
.70647 .48825 L
.70714 .48825 L
.70714 .49443 L
.71258 .49443 L
.71258 .50061 L
.72778 .50061 L
.72778 .50679 L
.73773 .50679 L
.73773 .51297 L
.74229 .51297 L
.74229 .51915 L
.74661 .51915 L
.74661 .52533 L
.75113 .52533 L
.75113 .53151 L
.75859 .53151 L
.75859 .53769 L
.76754 .53769 L
.76754 .54387 L
.82832 .54387 L
.82832 .55005 L
.84032 .55005 L
.84032 .55623 L
.84328 .55623 L
.84328 .56241 L
.84409 .56241 L
.84409 .56859 L
.84467 .56859 L
.84467 .57477 L
.85034 .57477 L
.85034 .58095 L
.87188 .58095 L
.87188 .58713 L
.87828 .58713 L
.87828 .59331 L
.88223 .59331 L
.88223 .59949 L
.89199 .59949 L
.89199 .60567 L
.90038 .60567 L
.90038 .61185 L
.90349 .61185 L
.90349 .61803 L
Mistroke
.92073 .61803 L
Mfstroke
.92073 .61803 m
.92073 .61803 L
s
.02381 0 m
.03097 0 L
.03097 .00618 L
.03097 .01236 L
.03809 .01236 L
.03809 .01854 L
.04035 .01854 L
.04035 .02472 L
.04523 .02472 L
.04523 .0309 L
.05774 .0309 L
.05774 .03708 L
.07781 .03708 L
.07781 .04326 L
.09471 .04326 L
.09471 .04944 L
.09506 .04944 L
.09506 .05562 L
.09921 .05562 L
.09921 .0618 L
.1031 .0618 L
.1031 .06798 L
.10548 .06798 L
.10548 .07416 L
.10585 .07416 L
.10585 .08034 L
.11549 .08034 L
.11549 .08652 L
.11616 .08652 L
.11616 .09271 L
.11761 .09271 L
.11761 .09889 L
.15432 .09889 L
.15432 .10507 L
.1563 .10507 L
.1563 .11125 L
.1581 .11125 L
.1581 .11743 L
.16813 .11743 L
.16813 .12361 L
.17785 .12361 L
.17785 .12979 L
.18537 .12979 L
.18537 .13597 L
.1938 .13597 L
.1938 .14215 L
.19824 .14215 L
.19824 .14833 L
.21371 .14833 L
.21371 .15451 L
Mistroke
.21388 .15451 L
.21388 .16069 L
.21447 .16069 L
.21447 .16687 L
.21616 .16687 L
.21616 .17305 L
.22105 .17305 L
.22105 .17923 L
.22427 .17923 L
.22427 .18541 L
.22618 .18541 L
.22618 .19159 L
.23002 .19159 L
.23002 .19777 L
.23435 .19777 L
.23435 .20395 L
.26019 .20395 L
.26019 .21013 L
.27805 .21013 L
.27805 .21631 L
.27916 .21631 L
.27916 .22249 L
.28294 .22249 L
.28294 .22867 L
.2863 .22867 L
.2863 .23485 L
.30064 .23485 L
.30064 .24103 L
.33398 .24103 L
.33398 .24721 L
.33806 .24721 L
.33806 .25339 L
.33917 .25339 L
.33917 .25957 L
.34803 .25957 L
.34803 .26575 L
.35168 .26575 L
.35168 .27193 L
.36344 .27193 L
.36344 .27812 L
.37134 .27812 L
.37134 .2843 L
.37152 .2843 L
.37152 .29048 L
.39925 .29048 L
.39925 .29666 L
.42179 .29666 L
.42179 .30284 L
.42931 .30284 L
.42931 .30902 L
Mistroke
.45951 .30902 L
.45951 .3152 L
.47408 .3152 L
.47408 .32138 L
.48077 .32138 L
.48077 .32756 L
.48362 .32756 L
.48362 .33374 L
.49787 .33374 L
.49787 .33992 L
.5036 .33992 L
.5036 .3461 L
.50502 .3461 L
.50502 .35228 L
.50877 .35228 L
.50877 .35846 L
.53402 .35846 L
.53402 .36464 L
.53799 .36464 L
.53799 .37082 L
.5539 .37082 L
.5539 .377 L
.55418 .377 L
.55418 .38318 L
.55574 .38318 L
.55574 .38936 L
.56016 .38936 L
.56016 .39554 L
.56609 .39554 L
.56609 .40172 L
.58997 .40172 L
.58997 .4079 L
.59748 .4079 L
.59748 .41408 L
.598 .41408 L
.598 .42026 L
.61137 .42026 L
.61137 .42644 L
.61555 .42644 L
.61555 .43262 L
.62267 .43262 L
.62267 .4388 L
.62375 .4388 L
.62375 .44498 L
.64171 .44498 L
.64171 .45116 L
.65748 .45116 L
.65748 .45735 L
.66549 .45735 L
.66549 .46353 L
Mistroke
.66922 .46353 L
.66922 .46971 L
.67323 .46971 L
.67323 .47589 L
.68083 .47589 L
.68083 .48207 L
.69582 .48207 L
.69582 .48825 L
.7154 .48825 L
.7154 .49443 L
.71758 .49443 L
.71758 .50061 L
.71999 .50061 L
.71999 .50679 L
.73896 .50679 L
.73896 .51297 L
.74617 .51297 L
.74617 .51915 L
.75092 .51915 L
.75092 .52533 L
.75299 .52533 L
.75299 .53151 L
.76486 .53151 L
.76486 .53769 L
.76651 .53769 L
.76651 .54387 L
.79174 .54387 L
.79174 .55005 L
.79483 .55005 L
.79483 .55623 L
.79657 .55623 L
.79657 .56241 L
.79765 .56241 L
.79765 .56859 L
.79948 .56859 L
.79948 .57477 L
.82381 .57477 L
.82381 .58095 L
.83354 .58095 L
.83354 .58713 L
.9086 .58713 L
.9086 .59331 L
.91236 .59331 L
.91236 .59949 L
.91351 .59949 L
.91351 .60567 L
.91421 .60567 L
.91421 .61185 L
.92494 .61185 L
.92494 .61803 L
Mistroke
.96366 .61803 L
Mfstroke
.96366 .61803 m
.96366 .61803 L
s
0 1 0 r
.01 w
.02381 0 m
.06244 .02507 L
.10458 .05241 L
.14415 .07809 L
.18221 .10279 L
.22272 .12908 L
.26171 .15438 L
.30316 .18128 L
.34309 .20719 L
.3815 .23212 L
.42237 .25864 L
.46172 .28417 L
.49955 .30873 L
.53984 .33487 L
.57861 .36003 L
.61984 .38678 L
.65954 .41255 L
.69774 .43734 L
.73838 .46371 L
.77751 .4891 L
.81909 .51609 L
.85916 .54209 L
.89771 .56711 L
.93871 .59371 L
.97619 .61803 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{615.812, 380.625},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40009W0001O2000`400?l00000o`00003ooooooooo
ooooofWooooo003oooooooooooooJOooool00?oooooooooooomYooooo`00ooooooooooooofWooooo
003oooooooooooooJOooool00?oooooooooooomYooooo`00ooooooooooooofWooooo002Hooooo`So
000000WogMgMooooooooooooooooojVYZOl@413o0000oa0@4?n7QhL0GOooool2o`0000Cooooo00Go
ZJVYoa0@4?l0003o410@ohN7Q`1Jooooo`06okZj^_lQ8B7o0000o`000?mEEEGok^k^1?ooool01OnY
ZJWo410@o`000?l@413oQhN705[ooooo00KoZJVYob4Q8Ol0003o0000ob4Q8OnYZJT4ooooo`05ojVY
ZOl@413o0000oa0@4?n7QhL0EOooool6o`0000Cooooo00GoZJVYoa0@4?l0003o410@ohN7Q`05oooo
o`05ojVYZOl@413o0000oa0@4?n7QhL05_ooool009Sooooo00?oc<c<o`000?l000001Ol000002_n7
QhOooooooooooonHV9So0000ohN7Qooooooo^[Zjo`000?n7QhMLooooo`;o00000oooool01onHV9So
0000ohN7Qooooooo^[Zjo`000?n7QhL0F?ooool01OnHV9So0000ohN7QooooooogMgM00;o8B4Q0ooo
ool01onHV9So0000ohN7Qooooooo^[Zjo`000?n7QhL0F?ooool02?nHV9So0000ob4Q8OoMgMgok^k^
oeEEEOl0003oV9RH0_ooool01onHV9So0000ohN7Qooooooo^[Zjo`000?n7QhL0EOooool00onj^[[o
0000o`000005ooooo`07oiRHV?l0003oQhN7oooooonj^[[o0000ohN7Q`03ooooo`07oiRHV?l0003o
QhN7oooooonj^[[o0000ohN7Q`0Eooooo`00VOooool00oo<c<co410@olc<c003ooooo`06ohN7QolQ
8B7oooooomgMgOl0003oEEEE0oooool00omVIVKo0000onk^kP1Kooooo`;o00000_ooool00ooMgMgo
0000oeEEE@03ooooo`03ofIVI_l0003ok^k^05Kooooo00?ogMgMo`000?mEEED00oooool01onYZJWo
0000ogMgMooooooogMgMo`000?mEEED00oooool00omVIVKo0000onk^kP1Gooooo`03oa0@4?l0003o
c<c<00;ooooo00Ook^k^o`000?l@413oooooomgMgOl0003oEEEE00?ooooo00?oIVIVo`000?o^k^h0
EOooool2o`0000Cooooo00?ogMgMo`000?mEEED00oooool01omVIVKo0000onk^k_oooooogMgMo`00
0?mEEED00oooool00omVIVKo0000onk^kP0Dooooo`00V_ooool00onHV9So0000onk^kP03ooooo`05
okZj^_ooooooQhN7o`000?nYZJT00oooool00onj^[[o0000ohN7Q`1Eooooo`[o000000?oQhN7o`00
0?nYZJT00oooool00onj^[[o0000ohN7Q`1Fooooo`03oeEEEOl0003oZJVY00Cooooo00Ko0000ob4Q
8OooooooQhN7o`000?nYZJT3ooooo`03okZj^_l0003oQhN705Oooooo0_l00003ooooo`07onk^k_l0
003o0000oooooon7QhOo0000ojVYZ@03ooooo`03okZj^_l0003oQhN705Gooooo0_l00004ooooo`03
ohN7Qol0003oZJVY00?ooooo00Oo^[Zjo`000?n7QhOoooooohN7Qol0003oZJVY00?ooooo00?o^[Zj
o`000?n7QhL05?ooool009_ooooo00?oQhN7ob4Q8Oo^k^h01?ooool00olb<S;o0000omgMg@03oooo
o`03omgMgOl0003o<S8b05Gooooo00?oA4A4ojVYZOooool00oooool2o`0000;ooooo00?o<S8bo`00
0?oMgMd00oooool00ooMgMgo0000oc8b<P1Fooooo`03oa0@4?l0003ok^k^00Cooooo0_l000001?oo
oooo<S8bo`000?oMgMd3ooooo`03omgMgOl0003o<S8b05Oooooo00?o<S8bo`000?o^k^h00_ooool0
1omEEEGo0000ob4Q8Ooooooo<S8bo`000?oMgMd00oooool00ooMgMgo0000oc8b<P1Eooooo`;o0000
1?ooool00olb<S;o0000omgMg@03ooooo`07omgMgOl0003o<S8boooooolb<S;o0000omgMg@03oooo
o`03omgMgOl0003o<S8b01Cooooo002Looooo`;oEEEE1?ooool2o`0000Gooooo00?o0000oa0@4?oo
ool0E?ooool00oo^k^ko410@onk^kP03ooooo`;o00000_ooool2o`0000Gooooo00?o0000oa0@4?oo
ool0EOooool2o`0000Cooooo00CogMgMo`000?l0003ooooo0_l00005ooooo`03o`000?l@413ooooo
05Kooooo00Goc<c<o`000?n7QhOooooooeEEE@02o`000004ojVYZOoooooo0000o`0000Gooooo00?o
0000oa0@4?ooool0E?ooool2o`0000Cooooo0_l00005ooooo`03o`000?l@413ooooo00;o00001Ooo
ool00ol0003o410@ooooo`0Cooooo`00W?ooool00oo^k^ko410@ohN7Q`03ooooo`;o00001Oooool2
o`0005Kooooo00?oZJVYoc8b<_ooool00_ooool2o`0000;ooooo0_l00005ooooo`;o0000E_ooool2
o`000008onk^k_oooooooooooooooomgMgOo0000odA4A?ooool2o`0000Gooooo0_l0001Hooooo`03
omgMgOlb<S;o8B4Q00;o000000?oV9RHooooooooool00_l00005ooooo`;o0000EOooool2o`0000Co
oooo0_l00005ooooo`;o000000?oooooo`000?l000001Oooool2o`0001Cooooo002Mooooo`03oiRH
V?l0003ogMgM00;ooooo0_l00005ooooo`;o0000Eoooool01?mEEEGoQhN7ooooooooool2o`0000;o
oooo0_l00005ooooo`;o0000E_ooool01_lQ8B7o0000oeEEEOo^k^koooooojVYZ@;o000000Coc<c<
ooooool0003o00001Oooool2o`0005Sooooo00Gok^k^odA4A?l0003o0000olc<c003ooooo`;o0000
1Oooool2o`0005Gooooo0_l00004ooooo`;o00001Oooool2o`000003ooooool0003o000000Gooooo
0_l0000Dooooo`00WOooool00oo^k^ko0000oeEEE@02ooooo`;o00001Oooool2o`0005Oooooo00Co
k^k^ob4Q8OoMgMgooooo0_l00002ooooo`;o00001Oooool2o`0005Kooooo00CoIVIVo`000?n7QhOo
<S8b0_l000001?m4A4Coc<c<ooooooooool2o`0000Gooooo0_l0001Gooooo`07onk^k_lQ8B7o0000
odA4A?nYZJWo8B4QojVYZ@02ooooo`;o00001Oooool2o`0005Gooooo0_l00004ooooo`;o00001Ooo
ool2o`000003ooooool0003o000000Gooooo0_l0000Dooooo`00V?ooool00omgMgOok^k^ooooo`03
ooooo`;o00000_ooool00olb<S;o0000olc<c003ooooo`03olc<c?l0003o<S8b05Sooooo00?o^[Zj
oc8b<_ooool00_l00002ooooo`03oc8b<_l0003oc<c<00?ooooo00?oc<c<o`000?lb<S80E_ooool0
0ooMgMgo0000oeEEE@07ooooo`03oc8b<_l0003oc<c<00?ooooo00?oc<c<o`000?lb<S80Eoooool0
0omEEEGo0000oeEEE@02ooooo`07oiRHV?l0003oV9RHoooooolb<S;o0000olc<c003ooooo`03olc<
c?l0003o<S8b05Gooooo0_l00004ooooo`03oc8b<_l0003oc<c<00?ooooo00Ooc<c<o`000?lb<S;o
oooooc8b<_l0003oc<c<00?ooooo00?oc<c<o`000?lb<S805?ooool009Sooooo00?o<S8bogMgMooo
ool00_ooool00onj^[[o0000o`000002ooooo`03ohN7Qol0003oZJVY00?ooooo00?oZJVYo`000?n7
QhL0FOooool01?mVIVKoQhN7o`000?l00002ooooo`03ohN7Qol0003oZJVY00?ooooo00?oZJVYo`00
0?n7QhL0Eoooool00omgMgOo0000okZj^P06ooooo`03ohN7Qol0003oZJVY00?ooooo00?oZJVYo`00
0?n7QhL0Eoooool2o`000004omgMgOooooooooooooooo`;o000000CoooooohN7Qol0003oZJVY0ooo
ool00onYZJWo0000ohN7Q`1Eooooo`;o00001?ooool00on7QhOo0000ojVYZ@03ooooo`07ojVYZOl0
003oQhN7oooooon7QhOo0000ojVYZ@03ooooo`03ojVYZOl0003oQhN701Cooooo002Hooooo`08oiRH
V?l0003oV9RHoooooooMgMgo8B4Qo`000?l@4102ooooo`03omgMgOl0003oEEEE00?ooooo00?oEEEE
o`000?o^k^h0FOooool01?o^k^ko8B4Qo`000?l00002ooooo`03omgMgOl0003oEEEE00?ooooo00?o
EEEEo`000?o^k^h0F?ooool00omEEEGo0000olc<c005ooooo`03omgMgOl0003oEEEE00?ooooo00?o
EEEEo`000?o^k^h0Eoooool2o`000004onk^k_ooooooooooonk^kP;o000000CoooooomgMgOl0003o
EEEE0oooool00omEEEGo0000onk^kP1Eooooo`;o00001?ooool00ooMgMgo0000oeEEE@03ooooo`07
oeEEEOl0003ok^k^oooooooMgMgo0000oeEEE@03ooooo`03oeEEEOl0003ok^k^01Cooooo002Ioooo
o`03ob4Q8Ol0003o000000?o000000_oZJVYooooooooooooooooogMgMol0003oV9RHoooooonHV9So
0000oiRHV01Kooooo`03okZj^_l0003o000000?ooooo00OoMgMgo`000?nHV9SooooooiRHV?l0003o
V9RH05[ooooo00CoQhN7oa0@4?n7QhOok^k^1?ooool01omgMgOo0000oiRHV?ooooooV9RHo`000?nH
V9P0F?ooool00onHV9So0000oeEEE@02onk^kP03oeEEEOl0003oMgMg00;ooooo00OoMgMgo`000?nH
V9SooooooiRHV?l0003oV9RH05Cooooo00Co8B4QofIVI_l0003o00001Oooool01omgMgOo0000oiRH
V?ooooooV9RHo`000?nHV9P00oooool01omgMgOo0000oiRHV?ooooooV9RHo`000?nHV9P05Oooool0
09Wooooo00Kok^k^ogMgMol0003o0000ob4Q8OnYZJT5ooooo`05ohN7Qol@413o0000oa0@4?nHV9P0
GOooool00omVIVKo0000ooooo`03ooooo`05ohN7Qol@413o0000oa0@4?nHV9P0G?ooool01Oo^k^ko
QhN7oc8b<_lb<S;o^[Zj00?ooooo00GoQhN7oa0@4?l0003o410@oiRHV01Jooooo`06okZj^_m4A4Co
0000o`000?l@413oV9RH1?ooool01On7QhOo410@o`000?l@413oV9RH05Gooooo00CogMgMoiRHV?mE
EEGo00001_ooool01On7QhOo410@o`000?l@413oV9RH00Gooooo00GoQhN7oa0@4?l0003o410@oiRH
V00Fooooo`00ooooooooooooofWooooo003oooooooooooooJOooool00?oooooooooooomYooooo`00
ooooooooooooofWooooo003oooooooooooooJOooool00?oooooooooooomYooooo`00oooooooooooo
ofWooooo003oooooooooooooJOooool002cooooo2ol00009o`3o0?oo0000ool0000Eo`0001Cooooo
000gooooo`[o0?l01_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo01Oooooo00?o
0000ooooooooool06?ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01Oooooo00?o
0000ooooooooool05oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01Oooooo00?o
0000ooooooooool06?ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01Oooooo00?o
0000ooooooooool05oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01Sooooo00?o
0000ooooooooool05oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01Oooooo00?o
0000ooooooooool05oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01Sooooo00?o
0000ooooooooool07oooool003Oooooo3?l0o`04ooooo`03o`000?oooooooooo00Wooooo00?o0000
ooooooooool05oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo01Oooooo00?o0000
ooooooooool05oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01Oooooo00?o0000
ooooooooool05oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo01Oooooo00?o0000
ooooooooool05oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01Oooooo00?o0000
ooooooooool06?ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01Oooooo00?o0000
ooooooooool05oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01Oooooo00?o0000
ooooooooool06?ooool00ol0003oooooooooo`0Oooooo`00>Oooool;o`3o00?ooooo00?o0000oooo
ooooool0F?ooool00ol0003oooooooooo`1Uooooo`03o`000?oooooooooo06Kooooo00?o0000oooo
ooooool0I_ooool00ol0003oooooooooo`1Vooooo`03o`000?oooooooooo01oooooo000iooooo`03
o`000?l0o`3o0?l000[o0?l000?oooooo`000?ooool0ooooooooooooob3ooooo000iooooo`03o`00
0?oooooooooo00_o0?l000?o0000ooooooooool0oooooooooooooaoooooo000iooooo`04o`000?oo
ooooooooo`0000co0?l0ooooooooooooob3ooooo000iooooo`03o`000?oooooooooo00?o00002ol0
o`05o`000?oooooooooooolJooooo`00>Oooool01?l0003oooooooooool00003ooooo`co0?l00_oo
ool00ol0003oooooooooo`3ooooooooooooo6?ooool003Wooooo00Co0000oooooooooooo00001?oo
ool00ol0003o0?l0o`3o0009o`3o0003ooooool0003ooooo0?oooooooooooolIooooo`00>Oooool0
0ol0003oooooooooo`07o`0000co0?l01?l0003ooooooooooooo5_ooool003Wooooo00?o0000oooo
ooooool01_ooool00ol0003oooooo`00000;o`3o00;ooooo00?o0000ooooooooool0oooooooooooo
oaCooooo000iooooo`03o`000?oooooooooo00Kooooo00Co0000ooooool0003ooooo3?l0o`000ol0
003oooooooooo`3ooooooooooooo5?ooool003Wooooo00?o0000ooooooooool01_ooool4o`0000;o
oooo2ol0o`07o`000?ooooooooooool?ooooo`00>Oooool00ol0003oooooooooo`09ooooo`04o`00
0?ooooooooooooooo`co0?l01?ooool00ol0003oooooooooo`3ooooooooooooo3Oooool003Wooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`03ooooo`_o0?l00oooool00ol0003ooooo
ooooo`3ooooooooooooo3Oooool003Wooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`04ooooo`co0?l000?oooooo`000?ooool0ooooooooooooo`kooooo000iooooo`?o00002Oooool8
o`000003ooooool0o`3o0?l000Wo0?l01Ol0003ooooooooooooo2oooool003Wooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00co0?l00_ooool00ol0
003oooooooooo`3ooooooooooooo2Oooool003Wooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00;ooooo3?l0o`000ol0003oooooooooo`3ooooooooo
oooo2Oooool003Wooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`03ooooo`Ko0000
3?l0o`04o`000?ooooooooooool7ooooo`00>Oooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00_ooooo3?l0o`000ooooooo0000ooooo`3ooooooooooooo1_ooool003Wooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0<ooooo`co0?l000?o0000ooooooooool0oooooooo
ooooo`Gooooo000iooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool03_ooool<o`3o
0?ooooooooooool6ooooo`00>Oooool00ol0003oooooooooo`0:ooooo`?o00003_ooool2o`0000_o
0?l0ooooooooooooo`Gooooo000iooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0
3oooool<o`3o0?ooooooooooool3ooooo`00>Oooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo017ooooo2ol0o`3ooooooooooooo0_ooool003Wooooo00?o0000ooooooooool03?ooool;
o`0000[ooooo3?l0o`3ooooooooooooo000iooooo`03o`000?oooooooooo01Kooooo00?o0000oooo
ooooool02_ooool;o`3o0?ooooooo_ooool003Wooooo00?o0000ooooooooool05_ooool00ol0003o
ooooooooo`0;ooooo`co0?l0ooooooolooooo`00>Oooool00ol0003oooooooooo`0Fooooo`Co0000
2_ooool2o`0000co0?l0ooooooojooooo`00>Oooool00ol0003oooooooooo`0Iooooo`03o`000?oo
oooooooo00_ooooo3?l0o`3oooooooWooooo000iooooo`03o`000?oooooooooo01Wooooo00?o0000
ooooooooool02oooool00ol0003oooooo`3o000;o`3o0?oooooomoooool003Wooooo00?o0000oooo
ooooool06Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00co0?l0ooooooofoooo
o`00>Oooool3o`0001Wooooo4ol0000<o`3o0?oooooom?ooool003Wooooo00?o0000ooooooooool0
:Oooool00ol0003oooooo`000002ooooo`_o0?l0ooooooocooooo`00>Oooool00ol0003ooooooooo
o`0Yooooo`03o`000?oooooo000000;ooooo00?o0000o`3o0?l0o`002_l0o`3ooooooo7ooooo000i
ooooo`03o`000?oooooooooo02Wooooo2?l0000<o`3o0?ooooookoooool003Wooooo00?o0000oooo
ooooool0:_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo0?l000_o0?l0ooooooo^oooo
o`00>Oooool00ol0003oooooooooo`0Zooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooo
oooo00003?l0o`3ooooooncooooo000iooooo`03o`000?oooooooooo02[ooooo00?o0000oooooooo
ool00oooool01Ol0003oooooooooool0003ooooo00co0?l0ooooooo[ooooo`00>Oooool00ol0003o
ooooooooo`0Zooooo`03o`000?oooooooooo00?ooooo0_l000000ooooooo0000o`000002ooooo`co
0?l0oooooooYooooo`00>Oooool00ol0003oooooooooo`0Zooooo`03o`000?oooooooooo00Cooooo
00Co0000oooooooooooo00001?ooool;o`3o0?ooooooj?ooool003Wooooo00?o0000ooooooooool0
:_ooool00ol0003oooooooooo`04ooooo`04o`000?ooooooooooo`0000Gooooo3?l0o`3oooooonKo
oooo000iooooo`03o`000?oooooooooo02[ooooo1_l000000ooooooo0000o`000005o`0000Cooooo
3?l0o`3oooooonCooooo000iooooo`03o`000?oooooooooo02oooooo00?o0000ooooooooool00ooo
ool00ol0003oooooo`000005ooooo`co0?l0oooooooSooooo`00>Oooool00ol0003oooooooooo`0_
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooool000001oooool<o`3o0?oooooohOooool0
03Wooooo00?o0000ooooooooool0;oooool2o`0000Cooooo1ol00004ooooo`go0?l0oooooooOoooo
o`00>Oooool00ol0003oooooooooo`0`ooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`04ooooo`co0?l0oooooooNooooo`00>Oooool00ol0003ooooo
ooooo`0`ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`06ooooo`co0?l0oooooooLooooo`00>Oooool00ol0003oooooooooo`0`ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`07ooooo`co0?l0oooo
oooKooooo`00>Oooool3o`00033ooooo0_l00004ooooo`Co000000?oooooo`000?l000000ol00007
ooooo`co0?l0oooooooIooooo`00>Oooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`07ooooo`co0?l0oooooooGoooo
o`00>Oooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`08ooooo`co0?l0oooooooFooooo`00>Oooool00ol0003ooooo
ooooo`0aoooooaGo00001_ooool<o`3o0?ooooooe?ooool003Wooooo00?o0000ooooooooool0?ooo
ool00ol0003oooooo`000003ooooo`03o`000?oooooooooo00Gooooo3?l0o`3oooooom?ooooo000i
ooooo`03o`000?oooooooooo03oooooo00?o0000ooooool000000oooool00ol0003oooooooooo`07
ooooo`co0?l0oooooooAooooo`00>Oooool00ol0003oooooooooo`0oooooo`03o`000?oooooo0000
00?ooooo00?o0000ooooooooool02Oooool;o`3o0?ooooood?ooool003Wooooo00?o0000oooooooo
ool0?oooool01?l0003oooooo`000?l00002ooooo`;o00002oooool<o`3o0?ooooooc_ooool003Wo
oooo00?o0000ooooooooool0?oooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo
00_ooooo2ol0o`3oooooolgooooo000iooooo`03o`000?oooooooooo03oooooo00Co0000oooooooo
oooo00000oooool00ol0003oooooooooo`0<ooooo`co0?l0ooooooo;ooooo`00>Oooool00ol0003o
ooooooooo`0oooooo`;o000000?oooooo`000?l000001?l0000?ooooo`_o0?l0ooooooo:ooooo`00
>Oooool00ol0003oooooooooo`10ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooool00000
4?ooool;o`3o0?oooooobOooool003Wooooo00?o0000ooooooooool0@?ooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooo000001;ooooo2ol0o`3oooooolOooooo000Looooo`So000000WogMgM
ooooooooooooooooojVYZOl@413o0000oa0@4?n7QhL03?ooool00ol0003oooooooooo`10ooooo`go
00003_ooool;o`3o0?ooooooa_ooool001cooooo00?oc<c<o`000?l000001Ol000002_n7QhOooooo
oooooonHV9So0000ohN7Qooooooo^[Zjo`000?n7QhL;ooooo`03o`000?oooooooooo04Oooooo00Co
0000oooooooooooooooo0_l0000@ooooo`_o0?l0ooooooo4ooooo`007Oooool00oo<c<co410@olc<
c003ooooo`06ohN7QolQ8B7oooooomgMgOl0003oEEEE0oooool00omVIVKo0000onk^kP0:ooooo`03
o`000?oooooooooo04Oooooo00Co0000oooooooooooooooo0_l0000Aooooo`_o0?l0ooooooo3oooo
o`007_ooool00onHV9So0000onk^kP03ooooo`05okZj^_ooooooQhN7o`000?nYZJT00oooool00onj
^[[o0000ohN7Q`0:ooooo`03o`000?oooooooooo04Oooooo00Co0000oooooooooooooooo0_l0000B
ooooo`co0?l0ooooooo1ooooo`007oooool00on7QhOo8B4Qonk^kP04ooooo`03oc8b<_l0003ogMgM
00?ooooo00?ogMgMo`000?lb<S802_ooool5o`0004Gooooo00Co0000oooooooooooooooo2?l0000>
ooooo`_o0?l0ooooooo0ooooo`008?ooool2oeEEE@Cooooo0_l00005ooooo`03o`000?l@413ooooo
00Wooooo00?o0000ooooooooool0Aoooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool03Oooool<o`3o0?oooooo__ooool0023ooooo00?ok^k^oa0@4?n7
QhL00oooool2o`0000Gooooo0_l0000:ooooo`03o`000?oooooooooo04Oooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00oooooo2ol0o`3ooooookgo
oooo000Qooooo`03oiRHV?l0003ogMgM00;ooooo0_l00005ooooo`;o00002_ooool00ol0003ooooo
ooooo`17ooooo`?o00000oooool3o`0000;ooooo1Ol0000>ooooo`co0?l0oooooonkooooo`008Ooo
ool00oo^k^ko0000oeEEE@02ooooo`;o00001Oooool2o`0000[ooooo00?o0000ooooooooool0BOoo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool03_oo
ool<o`3o0?oooooo^Oooool001cooooo00?oMgMgonk^k_ooool00oooool2o`0000;ooooo00?o<S8b
o`000?o<c<`00oooool00oo<c<co0000oc8b<P0:ooooo`03o`000?oooooooooo04Wooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00oooooo3?l0o`3o
oooookSooooo000Looooo`03oc8b<_mgMgOooooo00;ooooo00?o^[Zjo`000?l000000_ooool00on7
QhOo0000ojVYZ@03ooooo`03ojVYZOl0003oQhN700[ooooo00?o0000ooooooooool0BOooool00ol0
003oooooooooo`03ooooo`oo00003?ooool<o`3o0?oooooo]_ooool001cooooo00SoV9RHo`000?nH
V9SoooooomgMgOlQ8B7o0000oa0@40;ooooo00?ogMgMo`000?mEEED00oooool00omEEEGo0000onk^
kP0:ooooo`03o`000?oooooooooo04Wooooo00?o0000ooooooooool03oooool00ol0003oooooo`00
000=ooooo`co0?l0ooooooneooooo`007Oooool00olQ8B7o0000o`000003o`00000;ojVYZOoooooo
oooooooooomgMgOo0000oiRHV?ooooooV9RHo`000?nHV9P02oooool00ol0003oooooooooo`19oooo
o`03o`000?oooooooooo00oooooo00?o0000ooooool000003oooool<o`3o0?oooooo/oooool001go
oooo00Kok^k^ogMgMol0003o0000ob4Q8OnYZJT5ooooo`05ohN7Qol@413o0000oa0@4?nHV9P03?oo
ool00ol0003oooooooooo`19ooooo`03o`000?oooooooooo00oooooo00?o0000ooooool000004Ooo
ool;o`3o0?oooooo/_ooool003Wooooo00?o0000ooooooooool0BOooool6o`0000cooooo1Ol0000@
ooooo`co0?l0oooooon`ooooo`00>Oooool00ol0003oooooooooo`1>ooooo`03o`000?oooooooooo
00cooooo00?o0000ooooool000004_ooool<o`3o0?oooooo[_ooool003Wooooo00?o0000oooooooo
ool0C_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooo000001?ooooo3?l0o`3oooooojgo
oooo000iooooo`03o`000?oooooooooo04kooooo2_l00005ooooo`Wo00003oooool<o`3o0?oooooo
Zoooool003Wooooo00?o0000ooooooooool0Eoooool00ol0003oooooooooo`06ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool03_ooool<o`3o0?ooooooZ_ooool003Wooooo00?o0000
ooooooooool0Eoooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool04?ooool<o`3o0?ooooooZ?ooool003Wooooo00?o0000ooooooooool0Eoooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool04_ooool;o`3o
0?ooooooYoooool003Wooooo0ol0001Gooooo`?o00001_ooool?o`0000cooooo3?l0o`3oooooojGo
oooo000iooooo`03o`000?oooooooooo05Wooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00cooooo3?l0o`3ooooooj?ooooo000iooooo`03o`000?oo
oooooooo05Wooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo00gooooo3?l0o`3ooooooj;ooooo000iooooo`03o`000?oooooooooo05Wooooo1?l00009
ooooo`03o`000?oooooooooo00Gooooo2ol00007ooooo`co0?l0oooooonPooooo`00>Oooool00ol0
003oooooooooo`1Looooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool03oooool00ol0
003oooooooooo`06ooooo`go0?l0oooooonNooooo`00>Oooool00ol0003oooooooooo`1Looooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`08ooooo`co
0?l0oooooonMooooo`00>Oooool00ol0003oooooooooo`1Looooo`03o`000?oooooooooo00Oooooo
0_l0000@ooooo`Go00002?ooool<o`3o0?ooooooVoooool003Wooooo00?o0000ooooooooool0G?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool01ooo
ool=o`3o0?ooooooVOooool003Wooooo00?o0000ooooooooool0G?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool02Oooool<o`3o0?ooooooV?ooool0
03Wooooo00?o0000ooooooooool0G?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
01;ooooo00?o0000ooooooooool02oooool<o`3o0?ooooooU_ooool003Wooooo00?o0000oooooooo
ool0G?ooool2o`0000Wooooo0ol0000Booooo`03o`000?oooooooooo00cooooo3Ol0o`3ooooooiCo
oooo000iooooo`03o`000?oooooooooo05gooooo00?o0000ooooooooool02Oooool00ol0003ooooo
ooooo`0@ooooo`03o`000?oooooooooo00kooooo3?l0o`3ooooooi?ooooo000iooooo`03o`000?oo
oooooooo05gooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0@ooooo`03o`000?oo
oooooooo013ooooo3?l0o`3ooooooi7ooooo000iooooo`03o`000?oooooooooo05gooooo2?l00004
ooooo`?o00004?ooool9o`0000_ooooo3?l0o`3ooooooi3ooooo000iooooo`03o`000?oooooooooo
06Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo
00_ooooo3?l0o`3oooooohkooooo000iooooo`03o`000?oooooooooo06Cooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00gooooo2ol0o`3oooooohgo
oooo000iooooo`03o`000?oooooooooo06Cooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`0Fooooo`03o`000?oooooooooo00kooooo3?l0o`3ooooooh_ooooo000iooooo`?o0000I?oo
ool;o`0001Gooooo2Ol0000:ooooo`_o0?l0oooooon:ooooo`00>Oooool00ol0003oooooooooo`1/
ooooo`03o`000?oooooo000001gooooo00?o0000ooooooooool02Oooool<o`3o0?ooooooR?ooool0
03Wooooo00?o0000ooooooooool0K?ooool00ol0003oooooo`00000Mooooo`03o`000?oooooooooo
00_ooooo2ol0o`3oooooohOooooo000iooooo`03o`000?oooooooooo06cooooo6?l00008ooooo`?o
00003?ooool;o`3o0?ooooooQ_ooool003Wooooo00?o0000ooooooooool0K_ooool00ol0003ooooo
ooooo`0Booooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool03?ooool;o`3o0?oooooo
Q?ooool003Wooooo00?o0000ooooooooool0K_ooool00ol0003oooooooooo`0Booooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool03Oooool;o`3o0?ooooooPoooool003Wooooo00?o0000
ooooooooool0K_ooool4o`00017ooooo2Ol00002ooooo`;o00004?ooool;o`3o0?ooooooPOooool0
03Wooooo00?o0000ooooooooool0LOooool00ol0003oooooooooo`0Gooooo`05o`000?oooooooooo
ooooool000004Oooool;o`3o0?ooooooP?ooool003Wooooo00?o0000ooooooooool0LOooool00ol0
003oooooooooo`0Gooooo`05o`000?ooooooooooooooool000004_ooool<o`3o0?ooooooO_ooool0
03Wooooo00?o0000ooooooooool0LOooool00ol0003oooooooooo`0Gooooo`05o`000?oooooooooo
ooooool000005?ooool;o`3o0?ooooooOOooool003Wooooo00?o0000ooooooooool0LOooool?o`00
00_ooooo0_l00002ooooo`?o00004oooool<o`3o0?ooooooNoooool003Wooooo00?o0000oooooooo
ool0Ooooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool04oooool;o`3o0?ooooooN_ooool003Wooooo00?o0000ooooooooool0Ooooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool05?ooool<o`3o0?oooooo
N?ooool003Wooooo00?o0000ooooooooool0Ooooool;o`0000;ooooo4?l0000>ooooo`co0?l0oooo
oomfooooo`00>Oooool00ol0003oooooooooo`29ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`0=ooooo`co0?l0oooooomeooooo`00>Oooool00ol0
003oooooooooo`29ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`0?ooooo`co0?l0oooooomcooooo`00>Oooool00ol0003oooooooooo`29ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0@ooooo`go
0?l0oooooomaooooo`00>Oooool3o`0008Wooooo00?o0000ooooooooool01Oooool7o`0000?ooooo
1?l0000Aooooo`co0?l0oooooom`ooooo`00>Oooool00ol0003oooooooooo`29ooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Aooooo`co0?l0oooo
oom^ooooo`00>Oooool00ol0003oooooooooo`29ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`0Booooo`co0?l0oooooom]ooooo`00>Oooool00ol0
003oooooooooo`29ooooo`Co00002_ooool6o`000003ooooool0003o000001Go00003?l0o`3ooooo
of_ooooo000iooooo`03o`000?oooooooooo08cooooo00?o0000ooooooooool03Oooool00ol0003o
ooooooooo`0Hooooo`co0?l0oooooomYooooo`00>Oooool00ol0003oooooooooo`2<ooooo`03o`00
0?oooooooooo00gooooo00?o0000ooooooooool06Oooool<o`3o0?ooooooJ?ooool003Wooooo00?o
0000ooooooooool0S?ooool2o`0000kooooo1_l0000Hooooo`co0?l01?l0003oooooof;ooooo000i
ooooo`03o`000?oooooooooo08gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0G
ooooo`co0?l00_ooool00ol0003oooooooooo`3oooooof3ooooo000iooooo`03o`000?oooooooooo
08gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Iooooo`co0?l000?o0000oooo
ooooool0oooooomPooooo`00>Oooool00ol0003oooooooooo`2=ooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool06oooool;o`3o0?ooooooH_ooool003Wooooo00?o0000ooooooooool0
SOooool9o`0000_ooooo1?l0000Kooooo`co0?l0oooooomPooooo`00>Oooool00ol0003ooooooooo
o`2Eooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool06oooool;o`3o0?ooooooGooo
ool003Wooooo00?o0000ooooooooool0UOooool00ol0003oooooooooo`0<ooooo`03o`000?oooooo
oooo01cooooo3?l0o`3ooooooegooooo000Rooooo`;o00001?ooool01OnYZJWo410@o`000?l@413o
QhN700cooooo00?o0000ooooooooool0UOoooolDo`0001cooooo2ol0o`08o`000?ooooooE?ooool0
02;ooooo0_l00003ooooo`07oiRHV?l0003oQhN7oooooonj^[[o0000ohN7Q`0;ooooo`03o`000?oo
oooooooo0:Kooooo00?o0000ooooool000007Oooool;o`3o00Kooooo00?o0000ooooooooool0oooo
oomBooooo`008_ooool2o`0000;ooooo00?ogMgMo`000?mEEED00oooool00omVIVKo0000onk^kP0:
ooooo`03o`000?oooooooooo0:Kooooo00?o0000ooooool000007oooool;o`3o00Cooooo00?o0000
ooooooooool0oooooomBooooo`007?ooool:o`000003ohN7Qol0003oZJVY00?ooooo00?o^[Zjo`00
0?n7QhL02_ooool00ol0003oooooooooo`2Vooooo`03o`000?oooooo0000023ooooo2ol0o`03oooo
o`03o`000?oooooooooo0?ooooooD_ooool001cooooo00?oA4A4ojVYZOooool00oooool2o`0000;o
oooo00?o<S8bo`000?oMgMd00oooool00ooMgMgo0000oc8b<P0:ooooo`Go0000Y?ooool;o`0001[o
oooo2ol0o`000ooooooo0000o`000006o`000?ooooooCOooool001cooooo00?ok^k^oa0@4?o^k^h0
0oooool2o`0000;ooooo0_l00005ooooo`03o`000?l@413ooooo00Wooooo00?o0000ooooooooool0
Z_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01Wooooo2ol0o`07ooooo`03o`00
0?oooooooooo0?ooooooBoooool001gooooo00?oZJVYoc8b<_ooool00_ooool2o`0000;ooooo0_l0
0005ooooo`;o00002_ooool00ol0003oooooooooo`2Zooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool06_ooool<o`3o00Gooooo00?o0000ooooooooool0oooooom;ooooo`007_ooool0
1?mEEEGoQhN7ooooooooool2o`0000;ooooo0_l00005ooooo`;o00002_ooool00ol0003ooooooooo
o`2Zooooo`03o`000?oooooooooo00?ooooo1_l0000Iooooo`_o0?l01?ooool8o`000?ooooooA_oo
ool001kooooo00Cok^k^ob4Q8OoMgMgooooo0_l00002ooooo`;o00001Oooool2o`0000[ooooo00?o
0000ooooooooool0Z_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01Sooooo3?l0
o`09ooooo`03o`000?oooooooooo0?ooooooA?ooool001oooooo00?o^[Zjoc8b<_ooool00_l00002
ooooo`03oc8b<_l0003oc<c<00?ooooo00?oc<c<o`000?lb<S802_ooool00ol0003oooooooooo`2Z
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool06_ooool;o`3o00Sooooo00?o0000
ooooooooool0oooooom4ooooo`008?ooool01?mVIVKoQhN7o`000?l00002ooooo`03ohN7Qol0003o
ZJVY00?ooooo00?oZJVYo`000?n7QhL02_ooool00ol0003oooooooooo`2Zooooo`Ko00001Oooool3
o`0001_ooooo3?l0o`06ooooo`[o0000oooooolmooooo`008?ooool01?o^k^ko8B4Qo`000?l00002
ooooo`03omgMgOl0003oEEEE00?ooooo00?oEEEEo`000?o^k^h02_ooool00ol0003oooooooooo`2_
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool06oooool<o`3o00gooooo00?o0000
ooooooooool0oooooolkooooo`008Oooool00onj^[[o0000o`000003ooooo`07ogMgMol0003oV9RH
oooooonHV9So0000oiRHV00;ooooo`03o`000?oooooooooo0:oooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`0Looooo`co0?l03?ooool00ol0003oooooooooo`3ooooooc_ooooo000R
ooooo`03ofIVI_l0003ooooo00?ooooo00GoQhN7oa0@4?l0003o410@oiRHV00<ooooo`03o`000?oo
oooooooo0:oooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Nooooo`co0?l02_oo
ool00ol0003oooooooooo`3ooooooc_ooooo000iooooo`03o`000?oooooooooo0:oooooo0ol00005
ooooo`Go00007Oooool<o`3o00Wooooo0ol0003ooooooc_ooooo000iooooo`03o`000?oooooooooo
0;7ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Mooooo`co0?l02Oooool00ol0
003oooooooooo`3oooooocWooooo000iooooo`03o`000?oooooooooo0;7ooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`0Oooooo`_o0?l02?ooool00ol0003oooooooooo`3oooooocWo
oooo000iooooo`03o`000?oooooooooo0;7ooooo2?l00002ooooo`[o00006Oooool<o`3o00Kooooo
1?l0003oooooocSooooo000iooooo`03o`000?oooooooooo0;Sooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`0Iooooo`co0?l01oooool00ol0003oooooooooo`3oooooocKooooo000i
ooooo`03o`000?oooooooooo0;Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0J
ooooo`co0?l01_ooool00ol0003oooooooooo`3oooooocKooooo000iooooo`03o`000?oooooooooo
0;Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0Looooo`co0?l01?ooool00ol0
003oooooooooo`3oooooocKooooo000iooooo`?o0000^?ooool5o`0000Oooooo0ol0000Mooooo`co
0?l00oooool3o`000?oooooo=_ooool003Wooooo00?o0000ooooooooool0_?ooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo01gooooo3?l0o`03ooooo`03o`000?oooooooooo0?oooooo
=?ooool003Wooooo00?o0000ooooooooool0_?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo01oooooo2ol0o`02ooooo`03o`000?oooooooooo0?oooooo=?ooool003Wooooo00?o0000
ooooooooool0_?ooool00ol0003oooooooooo`07ooooo`?o00008?ooool<o`3o00ko0000oooooolY
ooooo`00>Oooool00ol0003oooooooooo`2looooo`03o`000?oooooooooo00Wooooo00?o0000oooo
ooooool08?ooool<o`3o00_ooooo00?o0000ooooooooool0oooooolWooooo`00>Oooool00ol0003o
ooooooooo`2looooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool08Oooool<o`3o00[o
oooo00?o0000ooooooooool0oooooolWooooo`00>Oooool00ol0003oooooooooo`2loooooa_o0000
5oooool<o`3o00Sooooo3ol0003ooooooa_ooooo000iooooo`03o`000?oooooooooo0<_ooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`0Fooooo`go0?l05?ooool00ol0003ooooooooo
o`3ooooooaWooooo000iooooo`03o`000?oooooooooo0<_ooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`0Hooooo`co0?l04oooool00ol0003oooooooooo`3ooooooaWooooo000ioooo
o`03o`000?oooooooooo0<_ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Joooo
o`co0?l04Oooool00ol0003oooooooooo`3ooooooaWooooo000iooooo`03o`000?oooooooooo0<_o
oooo3_l0000Kooooo`co0?l04?ooool3o`000?oooooo6Oooool003Wooooo00?o0000ooooooooool0
e_ooool00ol0003oooooo`00000Mooooo`co0?l04?ooool00ol0003oooooooooo`3ooooooaOooooo
000iooooo`03o`000?oooooooooo0=Kooooo00?o0000ooooool000007oooool<o`3o00kooooo00?o
0000ooooooooool0oooooolGooooo`00>Oooool00ol0003oooooooooo`3FoooooaWo00002_ooool<
o`3o00gooooo1?l0003ooooooaKooooo000iooooo`03o`000?oooooooooo0=cooooo00?o0000oooo
ooooool03oooool00ol0003oooooooooo`0:ooooo`co0?l03_ooool00ol0003oooooooooo`3ooooo
oaCooooo000iooooo`03o`000?oooooooooo0=cooooo00?o0000ooooooooool03oooool00ol0003o
ooooooooo`0;ooooo`co0?l03Oooool00ol0003oooooooooo`3ooooooaCooooo000iooooo`03o`00
0?oooooooooo0=cooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0=ooooo`co0?l0
2oooool00ol0003oooooooooo`3ooooooaCooooo000iooooo`?o0000g?oooolNo`0000Kooooo2ol0
o`0:ooooo`03o`000?oooooooooo0?oooooo5?ooool003Wooooo00?o0000ooooooooool0kOooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Gooooo3?l0o`08ooooo`03o`000?oooooo
oooo0?oooooo5?ooool003Wooooo00?o0000ooooooooool0kOooool00ol0003oooooooooo`09oooo
o`03o`000?oooooooooo00Oooooo2ol0o`07ooooo`03o`000?oooooooooo0?oooooo5?ooool003Wo
oooo00?o0000ooooooooool0kOooool9o`0000?ooooo2ol0000<o`3o00Gooooo1?l0003ooooooa?o
oooo000iooooo`03o`000?oooooooooo0?Gooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`0;o`3o00Oooooo00?o0000ooooooooool0oooooolAooooo`00>Oooool00ol0003ooooooooo
o`3eooooo`03o`000?oooooooooo00_ooooo00Co0000oooooooooooooooo2ol0o`06ooooo`03o`00
0?oooooooooo0?oooooo4Oooool003Wooooo00?o0000ooooooooool0mOooool4o`0000[ooooo1_l0
000;o`3o00Cooooo0_l0003ooooooa;ooooo000iooooo`03o`000?oooooooooo0?Sooooo00?o0000
ooooooooool03oooool;o`3o00Cooooo00?o0000ooooooooool0ooooool@ooooo`00>Oooool00ol0
003oooooooooo`3hooooo`03o`000?oooooooooo017ooooo2ol0o`02ooooo`03o`000?oooooooooo
0?oooooo4?ooool003Wooooo00?o0000ooooooooool0n?ooool00ol0003oooooooooo`0Booooo`_o
0?l000?oooooo`000?ooool0oooooolAooooo`00>Oooool00ol0003oooooooooo`3hooooo`?o0000
4oooool<o`3o00Ko0000ooooool<ooooo`00>Oooool00ol0003oooooooooo`3jooooo`03o`000?oo
oooooooo01?ooooo2ol0o`04ooooo`03o`000?oooooooooo0?oooooo2_ooool003Wooooo00?o0000
ooooooooool0n_ooool00ol0003oooooooooo`0Cooooo`03o`000?l0o`3o0?l000[o0?l00_ooool0
0ol0003oooooooooo`3oooooo`[ooooo000iooooo`03o`000?oooooooooo0?[ooooo2Ol0000=oooo
o`03o`000?oooooooooo00_o0?l000Coooooo`000?l0003o0000ooooool:ooooo`00>Oooool00ol0
003oooooooooo`3oooooo`?ooooo00?o0000ooooooooool02oooool01?l0003oooooooooooooool<
o`3o0003ooooool0003ooooo0?oooooo2Oooool003Wooooo00?o0000ooooooooool0ooooool3oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00oooool;o`3o0003o`000?oooooooooo
0?oooooo2?ooool003Wooooo00?o0000ooooooooool0ooooool3ooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool01?ooool<o`3o0?oooooo2Oooool003Wooooo0ol0003oooooo`?ooooo
1?l0000:ooooo`Wo00002ol0o`3oooooo`Sooooo000iooooo`03o`000?oooooooooo0?oooooo1_oo
ool00ol0003oooooooooo`0Booooo`co0?l0ooooool6ooooo`00>Oooool00ol0003oooooooooo`3o
ooooo`Kooooo00?o0000ooooooooool05?ooool;o`3o0?oooooo1Oooool003Wooooo00?o0000oooo
ooooool0ooooool6ooooo`;o00005Oooool00ol0003o0?l0o`3o000:o`3o0?oooooo0oooool003Wo
oooo00?o0000ooooooooool0ooooool7ooooo`03o`000?oooooooooo01?ooooo00?o0000oooooooo
ool02ol0o`3oooooo`;ooooo000iooooo`03o`000?oooooooooo0?oooooo1oooool00ol0003ooooo
ooooo`0Cooooo`04o`000?ooooooooooooooo`co0?l0ooooool003Wooooo00?o0000ooooooooool0
ooooool7ooooo`?o00004oooool2o`0000Cooooo2ol0o`3nooooo`00>Oooool00ol0003ooooooooo
o`3oooooo`Wooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`03ooooo`co0?l0o?oo
ool003Wooooo00?o0000ooooooooool0ooooool9ooooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool01?ooool00ol0003o0?l0o`3o0009o`3o0?_ooooo000iooooo`03o`000?oooooooooo
0?oooooo2Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ool0o`002ol0o`3iooooo`00>Oooool00ol0003oooooooooo`3oooooo`Wooooo3ol00006ooooo`?o
00001?ooool4o`0000_o0?l0n?ooool003Wooooo00?o0000ooooooooool0oooooolGooooo`03o`00
0?oooooooooo00Kooooo00?o0000ooooooooool01Oooool00ol0003oooooo`3o000;o`3o0?Kooooo
000iooooo`03o`000?oooooooooo0?oooooo5oooool00ol0003oooooooooo`06ooooo`03o`000?oo
oooooooo00Gooooo00Co0000oooooooooooooooo3?l0o`3dooooo`007_ooool01_nj^[[o8B4Qo`00
0?l0003oEEEEonk^kPCooooo00GoZJVYoa0@4?l0003o410@ohN7Q`0<ooooo`03o`000?oooooooooo
0?oooooo5oooool3o`0000Kooooo0ol00005ooooo`Go00003?l0o`3cooooo`007Oooool01OnHV9So
0000ohN7QooooooogMgM00;o8B4Q0oooool01onHV9So0000ohN7Qooooooo^[Zjo`000?n7QhL02ooo
ool00ol0003oooooooooo`3ooooooaWooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`09ooooo`03o`000?l0o`3o0?l000[o0?l0lOooool001cooooo00?ogMgMo`000?mEEED00oooool0
1onYZJWo0000ogMgMooooooogMgMo`000?mEEED00oooool00omVIVKo0000onk^kP0:ooooo`03o`00
0?oooooooooo0?oooooo6Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooool0o`003?l0o`3_ooooo`007?ooool00omEEEGo0000ojVYZ@04ooooo`06o`000?lQ
8B7oooooohN7Qol0003oZJVY0oooool00onj^[[o0000ohN7Q`0:ooooo`03o`000?oooooooooo0?oo
oooo6Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Wooooo00Co0000oooooooo
oooooooo3?l0o`3^ooooo`007?ooool00ol@413o0000onk^kP04ooooo`;o000000Cooooooc8b<_l0
003ogMgM0oooool00ooMgMgo0000oc8b<P0:ooooo`Go0000oooooolGooooo`go00002?ooool00ol0
003oooooooooo`03ooooo`co0?l0k?ooool001cooooo0_l00004ooooo`04omgMgOl0003o0000oooo
o`;o00001Oooool00ol0003o410@ooooo`09ooooo`03o`000?oooooooooo0?oooooo8Oooool01Ol0
003ooooooooooooooooo000000Sooooo00?o0000ooooooooool01?ooool=o`3o0>[ooooo000Loooo
o`;o000000Sok^k^ooooooooooooooooogMgMol0003oA4A4ooooo`;o00001Oooool2o`0000[ooooo
00?o0000ooooooooool0oooooolQooooo`05o`000?ooooooooooooooool000002?ooool00ol0003o
ooooooooo`06ooooo`co0?l0jOooool001cooooo00Ko8B4Qo`000?mEEEGok^k^oooooonYZJT2o`00
0004olc<c?oooooo0000o`0000Gooooo0_l0000:ooooo`03o`000?oooooooooo0?oooooo8Oooool2
o`0000;ooooo1Ol00004ooooo`Co00001oooool<o`3o0>Oooooo000Looooo`04ofIVI_l0003oQhN7
oc8b<P;o000000CoA4A4olc<c?oooooooooo0_l00005ooooo`;o00002_ooool00ol0003ooooooooo
o`3oooooob;ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo00Kooooo3Ol0o`3Uooooo`007?ooool00ooMgMgo0000oeEEE@07ooooo`03oc8b<_l0003o
c<c<00?ooooo00?oc<c<o`000?lb<S802_ooool00ol0003oooooooooo`3oooooob;ooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Sooooo3?l0o`3T
ooooo`007Oooool00omgMgOo0000okZj^P06ooooo`03ohN7Qol0003oZJVY00?ooooo00?oZJVYo`00
0?n7QhL02_ooool00ol0003oooooooooo`3oooooob;ooooo00?o0000ooooooooool01?oooolEo`00
00co0?l0h_ooool001kooooo00?oEEEEo`000?o<c<`01Oooool00ooMgMgo0000oeEEE@03ooooo`03
oeEEEOl0003ok^k^00[ooooo00?o0000ooooooooool0oooooolRooooo`03o`000?oooooooooo00co
oooo00?o0000ooooooooool02_ooool00ol0003o0?l0o`3o000:o`3o0>7ooooo000Oooooo`04ohN7
Qol@413oQhN7onk^kPCooooo00OoMgMgo`000?nHV9SooooooiRHV?l0003oV9RH00_ooooo00?o0000
ooooooooool0oooooolRooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0<o`3o0=oooooo000Pooooo`05onk^k_n7QhOo<S8boc8b<_nj^[X00oooool0
1On7QhOo410@o`000?l@413oV9RH00cooooo00?o0000ooooooooool0oooooolRooooo`03o`000?oo
oooooooo00cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`02ooooo`_o0?l0g_oo
ool003Wooooo00?o0000ooooooooool0oooooolRooooo`Co00002oooool9o`0000Cooooo1_l0000<
o`3o0=cooooo000iooooo`03o`000?oooooooooo0?oooooo9Oooool00ol0003oooooooooo`0Aoooo
o`03o`000?oooooooooo00[ooooo2ol0o`3Kooooo`00>Oooool00ol0003oooooooooo`3oooooobGo
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0;ooooo`co0?l0fOooool003Wooooo
00?o0000ooooooooool0oooooolUooooo`Co00004?ooool4o`0000cooooo2ol0o`3Hooooo`00>Ooo
ool00ol0003oooooooooo`3oooooobSooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`0;ooooo`_o0?l0eoooool003Wooooo00?o0000ooooooooool0oooooolXooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool03Oooool;o`3o0=Gooooo000iooooo`03o`000?oooooooooo
0?oooooo:?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00kooooo2ol0o`3Doooo
o`00>Oooool3o`000?oooooo:?ooool>o`0000Kooooo1_l0000=ooooo`_o0?l000?o0000oooooooo
ool0coooool003Wooooo00?o0000ooooooooool0ooooooleooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool03?ooool;o`3o0=7ooooo000iooooo`03o`000?oooooooooo0?oooooo=Ooo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00gooooo3?l0o`3?ooooo`00>Oooool0
0ol0003oooooooooo`3oooooocGooooo1Ol00007ooooo`?o00003oooool;o`3o00;o0000c?ooool0
03Wooooo00?o0000ooooooooool0ooooooliooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool03_ooool<o`3o0<cooooo000iooooo`03o`000?oooooooooo0?oooooo>Oooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo013ooooo2ol0o`3;ooooo`00>Oooool00ol0003ooooo
ooooo`3oooooocWooooo0_l00008ooooo`Go00003oooool<o`3o0<Wooooo000iooooo`03o`000?oo
oooooooo0?oooooo>_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00oooooo3?l0
o`37ooooo`00>Oooool00ol0003oooooooooo`3ooooooc[ooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`0@ooooo`co0?l0a_ooool003Wooooo00?o0000ooooooooool0ooooooljoooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool04_ooool<o`3o0<Cooooo000iooooo`03
o`000?oooooooooo0?oooooo>_ooool8o`0000Gooooo4?l00006ooooo`go0?l00_l00030ooooo`00
>Oooool00ol0003oooooooooo`3ooooood7ooooo00?o0000ooooooooool04_ooool00ol0003ooooo
ooooo`06ooooo`co0?l000?o0000ooooooooool0__ooool003Wooooo00?o0000ooooooooool0oooo
oom1ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool02?ooool<o`3o0;oooooo000i
ooooo`03o`000?oooooooooo0?oooooo@Oooool3o`0001;ooooo0_l0000:ooooo`co0?l00_l0002l
ooooo`00>Oooool00ol0003oooooooooo`3ooooood?ooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`0:ooooo`co0?l0_?ooool003Wooooo00?o0000ooooooooool0oooooom3ooooo`03
o`000?oooooooooo017ooooo00?o0000ooooooooool03?ooool<o`3o0;[ooooo000iooooo`03o`00
0?oooooooooo0?oooooo@oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00gooooo
3?l0o`2iooooo`00>Oooool3o`000?oooooo@oooool5o`0000oooooo1?l0000>ooooo`co0?l0]ooo
ool003Wooooo00?o0000ooooooooool0oooooom7ooooo`03o`000?oooooooooo013ooooo00?o0000
ooooooooool03Oooool<o`3o0;Kooooo000iooooo`03o`000?oooooooooo0?ooooooAoooool00ol0
003oooooooooo`0@ooooo`03o`000?oooooooooo00oooooo3?l0o`2dooooo`00>Oooool00ol0003o
ooooooooo`3oooooodOooooo0_l0000Aooooo`Go00003oooool;o`3o0;?ooooo000iooooo`03o`00
0?oooooooooo0?ooooooB?ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00kooooo
3?l0o`2aooooo`00>Oooool00ol0003oooooooooo`3oooooodSooooo00?o0000ooooooooool04ooo
ool00ol0003oooooooooo`0@ooooo`_o0?l0/?ooool003Wooooo00?o0000ooooooooool0oooooom8
ooooo`_o00002oooool8o`0000cooooo3?l0o`2^ooooo`00>Oooool00ol0003oooooooooo`3ooooo
oe;ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0<ooooo`_o0?l0[Oooool003Wo
oooo00?o0000ooooooooool0oooooomBooooo`03o`000?oooooooooo013ooooo00?o0000oooooooo
ool03Oooool;o`3o0:cooooo000iooooo`03o`000?oooooooooo0?ooooooD_ooool00ol0003ooooo
ooooo`0@ooooo`03o`000?oooooooooo00oooooo2ol0o`2Zooooo`00>Oooool00ol0003ooooooooo
o`3ooooooe;ooooo2Ol0000:ooooo`[o00002Oooool;o`3o0:Wooooo000iooooo`03o`000?oooooo
oooo0?ooooooF_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Wooooo2ol0o`2W
ooooo`00>Oooool00ol0003oooooooooo`3ooooooe[ooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`0:ooooo`_o0?l0Y_ooool003Wooooo00?o0000ooooooooool0oooooomJooooo`Ko
00003_ooool2o`0000cooooo3?l0o`2Tooooo`00>Oooool00ol0003oooooooooo`3ooooooeoooooo
00?o0000ooooooooool03Oooool00ol0003oooooooooo`0<ooooo`_o0?l0Xoooool003Wooooo00?o
0000ooooooooool0oooooomOooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool03Ooo
ool<o`3o0:7ooooo000iooooo`03o`000?oooooooooo0?ooooooGoooool00ol0003oooooooooo`0=
ooooo`03o`000?oooooooooo00oooooo2ol0o`2Pooooo`00>Oooool3o`000?ooooooGoooool3o`00
00gooooo0ol0000@ooooo`co0?l0W_ooool003Wooooo00?o0000ooooooooool0oooooomQooooo`03
o`000?oooooooooo00gooooo00?o0000ooooooooool04?ooool;o`3o09gooooo000iooooo`03o`00
0?oooooooooo0?ooooooHOooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo017ooooo
3?l0o`2Kooooo`00>Oooool00ol0003oooooooooo`3oooooof7ooooo0ol0000=ooooo`Co00004_oo
ool;o`3o00So0000T_ooool003Wooooo00?o0000ooooooooool0oooooomSooooo`03o`000?oooooo
oooo00kooooo00?o0000ooooooooool04Oooool<o`3o00Gooooo00?o0000ooooooooool0T?ooool0
03Wooooo00?o0000ooooooooool0oooooomSooooo`03o`000?oooooooooo00kooooo00?o0000oooo
ooooool04oooool;o`3o00Cooooo00?o0000ooooooooool0T?ooool003Wooooo00?o0000oooooooo
ool0oooooomSooooo`Go00003?ooool2o`0001Gooooo3?l0o`02ooooo`?o0000T?ooool003Wooooo
00?o0000ooooooooool0oooooomWooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
5Oooool;o`3o00?ooooo00?o0000ooooooooool0S_ooool003Wooooo00?o0000ooooooooool0oooo
oomWooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool05_ooool<o`3o0003ooooool0
003ooooo08oooooo000iooooo`03o`000?oooooooooo0?ooooooIoooool00ol0003oooooooooo`0;
ooooo`03o`000?oooooooooo01Sooooo2ol0o`000ol0003oooooooooo`2>ooooo`00>Oooool00ol0
003oooooooooo`3oooooofOooooo2Ol00005ooooo`03o`000?oooooooooo01Wooooo3?l0o`02o`00
08gooooo000iooooo`03o`000?oooooooooo0?ooooooKoooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo01_ooooo2ol0o`000ol0003oooooooooo`2;ooooo`00>Oooool00ol0003ooooo
ooooo`3oooooofoooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Looooo`co0?l0
S?ooool001kooooo00KoZJVYob4Q8Ol0003o0000ob4Q8OnYZJT4ooooo`05ojVYZOl@413o0000oa0@
4?n7QhL03?ooool00ol0003oooooooooo`3oooooofoooooo3?l0000Kooooo`_o0?l00ol00028oooo
o`007Oooool02?nHV9So0000ob4Q8OoMgMgok^k^oeEEEOl0003oV9RH0_ooool01onHV9So0000ohN7
Qooooooo^[Zjo`000?n7QhL02oooool00ol0003oooooooooo`3oooooogKooooo00Go0000oooooooo
ooooooooo`00000Looooo`co0?l000?o0000ooooooooool0Q_ooool001gooooo00?o410@o`000?o<
c<`00_ooool01oo^k^ko0000oa0@4?oooooogMgMo`000?mEEED00oooool00omVIVKo0000onk^kP0:
ooooo`03o`000?oooooooooo0?ooooooM_ooool01Ol0003ooooooooooooooooo000001kooooo3?l0
o`27ooooo`007Oooool2o`0000?ooooo00Ook^k^o`000?l0003oooooohN7Qol0003oZJVY00?ooooo
00?o^[Zjo`000?n7QhL02_ooool00ol0003oooooooooo`3oooooogKooooo00Go0000oooooooooooo
ooooo`00000Oooooo`co0?l0Q_ooool001gooooo00?o<S8bo`000?o^k^h00_ooool01omEEEGo0000
ob4Q8Ooooooo<S8bo`000?oMgMd00oooool00ooMgMgo0000oc8b<P0:ooooo`Go0000oooooomdoooo
o`Ko00008?ooool<o`3o00Oo0000OOooool001gooooo00Goc<c<o`000?n7QhOooooooeEEE@02o`00
0004ojVYZOoooooo0000o`0000Gooooo00?o0000oa0@4?ooool02Oooool00ol0003oooooooooo`3o
ooooogWooooo00?o0000ooooool000008Oooool=o`3o00Cooooo00?o0000ooooooooool0Noooool0
01kooooo00?ogMgMoc8b<_lQ8B400_l000000onHV9Soooooooooo`02o`0000Gooooo0_l0000:oooo
o`03o`000?oooooooooo0?ooooooNOooool00ol0003oooooo`00000Sooooo`co0?l00oooool00ol0
003oooooooooo`1kooooo`007_ooool01Oo^k^koA4A4o`000?l0003oc<c<00?ooooo0_l00005oooo
o`;o00002_ooool00ol0003oooooooooo`3oooooogWooooo2Ol0000Oooooo`co0?l000?oooooo`00
0?l00000O?ooool001gooooo00Ook^k^ob4Q8Ol0003oA4A4ojVYZOlQ8B7oZJVY00;ooooo0_l00005
ooooo`;o00002_ooool00ol0003oooooooooo`3ooooooggooooo00Go0000ooooooooooooooooo`00
000Pooooo`go0?l000?o0000ooooooooool0N_ooool001gooooo00?oEEEEo`000?mEEED00_ooool0
1onHV9So0000oiRHV?oooooo<S8bo`000?o<c<`00oooool00oo<c<co0000oc8b<P0:ooooo`03o`00
0?oooooooooo0?ooooooOOooool01Ol0003ooooooooooooooooo000002;ooooo3?l0o`1looooo`00
7Oooool2o`000004omgMgOooooooooooooooo`;o000000CoooooohN7Qol0003oZJVY0oooool00onY
ZJWo0000ohN7Q`0:ooooo`03o`000?oooooooooo0?ooooooOOooool;o`0001kooooo3?l0o`1joooo
o`007Oooool2o`000004onk^k_ooooooooooonk^kP;o000000CoooooomgMgOl0003oEEEE0oooool0
0omEEEGo0000onk^kP0:ooooo`03o`000?oooooooooo0?ooooooQoooool00ol0003oooooooooo`0M
ooooo`go0?l0N?ooool001gooooo00?oV9RHo`000?mEEED00_o^k^h00omEEEGo0000ogMgM`02oooo
o`07ogMgMol0003oV9RHoooooonHV9So0000oiRHV00;ooooo`03o`000?oooooooooo0?ooooooQooo
ool00ol0003oooooooooo`0Oooooo`co0?l0Moooool001kooooo00Ko^[ZjodA4A?l0003o0000oa0@
4?nHV9P4ooooo`05ohN7Qol@413o0000oa0@4?nHV9P03?ooool00ol0003oooooooooo`3oooooohOo
oooo00?o0000ooooooooool08Oooool<o`3o07Gooooo000iooooo`03o`000?oooooooooo0?oooooo
Qoooool5o`00023ooooo3?l0o`1dooooo`00>Oooool00ol0003oooooooooo`3oooooohWooooo00?o
0000ooooool000008_ooool<o`3o07;ooooo000iooooo`03o`000?oooooooooo0?ooooooROooool0
0ol0003oooooo`00000Tooooo`_o0?l0LOooool003Wooooo00?o0000ooooooooool0oooooon9oooo
o`Ko00008_ooool<o`3o06oooooo000iooooo`03o`000?oooooooooo0?ooooooRoooool01?l0003o
ooooooooool0000Tooooo`_o0?l0K_ooool003Wooooo00?o0000ooooooooool0oooooon;ooooo`04
o`000?ooooooooooo`0002Gooooo3?l0o`1/ooooo`00>Oooool00ol0003oooooooooo`3ooooooh_o
oooo00Co0000oooooooooooo00009_ooool00ol0003o0?l0o`3o0009o`3o06_ooooo000iooooo`?o
0000oooooon;ooooo`Go00009Oooool2o`0000_o0?l0J_ooool003Wooooo00?o0000ooooooooool0
oooooon>ooooo`;o0000:Oooool;o`3o06Sooooo000iooooo`03o`000?oooooooooo0?ooooooS_oo
ool2o`0002[ooooo2ol0o`1Wooooo`00>Oooool00ol0003oooooooooo`3oooooohkooooo2?l0000V
ooooo`_o0?l0IOooool003Wooooo00?o0000ooooooooool0oooooonBooooo`04o`000?oooooooooo
o`0002Oooooo2ol0o`1Tooooo`00>Oooool00ol0003oooooooooo`3ooooooi;ooooo00Co0000oooo
oooooooo00009oooool00ol0003o0?l0o`3o000:o`3o06;ooooo000iooooo`03o`000?oooooooooo
0?ooooooT_ooool6o`0002Gooooo0ol0000;o`3o067ooooo000iooooo`03o`000?oooooooooo0?oo
ooooU_ooool2o`0002Wooooo3?l0o`1Oooooo`00>Oooool00ol0003oooooooooo`3ooooooiKooooo
0_l0000Yooooo`03o`000?oooooo0?l000[o0?l0G_ooool003Wooooo00?o0000ooooooooool0oooo
oonFooooo`;o0000:Oooool00ol0003oooooooooo`0<o`3o05cooooo000iooooo`03o`000?oooooo
oooo0?ooooooU_oooolSo`0000Sooooo1Ol0000;o`3o05_ooooo000iooooo`03o`000?oooooooooo
0?ooooooY?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00cooooo3?l0o`1Ioooo
o`00>Oooool00ol0003oooooooooo`3oooooojCooooo00?o0000ooooooooool04Oooool00ol0003o
ooooooooo`0=ooooo`03o`000?l0o`3o0?l000Wo0?l0F?ooool003Wooooo00?o0000ooooooooool0
oooooonTooooo`?o00004Oooool8o`0000Sooooo0_l0000<o`3o05Kooooo000iooooo`03o`000?oo
oooooooo0?ooooooY_ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00[ooooo2ol0
o`1Eooooo`00>Oooool00ol0003oooooooooo`3oooooojKooooo00?o0000ooooooooool05_ooool0
0ol0003oooooooooo`0;ooooo`co0?l0Doooool003Wooooo00?o0000ooooooooool0oooooonVoooo
o`03o`000?oooooooooo01Kooooo00?o0000ooooooooool03Oooool;o`3o05;ooooo000iooooo`?o
0000oooooonVooooo`;o00005oooool3o`0000kooooo3?l0o`1@ooooo`00>Oooool00ol0003ooooo
ooooo`3oooooojOooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0>ooooo`_o0?l0
Coooool003Wooooo00?o0000ooooooooool0oooooonWooooo`03o`000?oooooooooo01Oooooo00?o
0000ooooooooool03oooool<o`3o04gooooo000iooooo`03o`000?oooooooooo0?ooooooYoooool0
0ol0003oooooooooo`0Gooooo`03o`000?oooooooooo017ooooo2ol0o`1<ooooo`00>Oooool00ol0
003oooooooooo`3oooooojOooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Boooo
o`co0?l0B_ooool003Wooooo00?o0000ooooooooool0oooooonWooooo`03o`000?oooooooooo01Oo
oooo00?o0000ooooooooool05?ooool;o`3o04Wooooo000iooooo`03o`000?oooooooooo0?oooooo
Yoooool2o`0001Sooooo00?o0000ooooooooool05?ooool00ol0003o0?l0o`3o000:o`3o04Oooooo
000iooooo`03o`000?oooooooooo0?ooooooZ?ooool00ol0003oooooooooo`0Fooooo`03o`000?oo
oooooooo01Oooooo3?l0o`15ooooo`00>Oooool00ol0003oooooooooo`3oooooojSooooo00?o0000
ooooooooool05_ooool00ol0003oooooooooo`0Hooooo`co0?l0A?ooool003Wooooo00?o0000oooo
ooooool0oooooonXooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool06_ooool<o`3o
04;ooooo000iooooo`03o`000?oooooooooo0?ooooooZ?ooool?o`0000[ooooo1?l0000Jooooo`go
0?l0@?ooool003Wooooo00?o0000ooooooooool0oooooonfooooo`03o`000?oooooooooo00_ooooo
00?o0000ooooooooool06_ooool<o`3o03oooooo000iooooo`03o`000?oooooooooo0?oooooo]_oo
ool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo01cooooo3?l0o`0mooooo`00>Oooool0
0ol0003oooooooooo`3ooooookKooooo1_l00008ooooo`go00004oooool=o`3o03_ooooo000ioooo
o`03o`000?oooooooooo0?oooooo^oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
01;ooooo00?o0000o`3o0?l0o`002_l0o`0jooooo`00>Oooool00ol0003oooooooooo`3ooooook_o
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00co
0?l0>?ooool003Wooooo00?o0000ooooooooool0oooooonkooooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool04_ooool01?l0003oooooooooooooool=o`3o03Kooooo000iooooo`?o0000
oooooonkoooooc3o00003?l0o`0eooooo`00>Oooool00ol0003oooooooooo`3oooooomCooooo00?o
0000ooooooooool03Oooool00ol0003oooooooooo`06ooooo`co0?l0<oooool003Wooooo00?o0000
ooooooooool0oooooooDooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool01oooool<
o`3o03;ooooo000iooooo`03o`000?oooooooooo0?ooooooe?ooool3o`0000gooooo1?l00008oooo
o`co0?l0<?ooool003Wooooo00?o0000ooooooooool0oooooooFooooo`03o`000?oooooooooo00ko
oooo00?o0000ooooooooool01_ooool00ol0003oooooo`3o000;o`3o02kooooo000iooooo`03o`00
0?oooooooooo0?ooooooe_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00Kooooo
00?o0000ooooooooool03?l0o`0]ooooo`00>Oooool00ol0003oooooooooo`3oooooomKooooo1_l0
000;ooooo`03o`000?oooooooooo00Kooooo1Ol0000<o`3o02_ooooo000iooooo`03o`000?oooooo
oooo0?oooooofoooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00cooooo3Ol0o`0Y
ooooo`00>Oooool00ol0003oooooooooo`3oooooom_ooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`0=ooooo`03o`000?l0o`3o0?l000[o0?l0:?ooool003Wooooo00?o0000oooooooo
ool0oooooooKooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool03Oooool00ol0003o
ooooooooo`0<o`3o02Kooooo000iooooo`03o`000?oooooooooo0?oooooofoooool6o`0000Kooooo
0_l0000>ooooo`Co00003?l0o`0Uooooo`00>Oooool00ol0003oooooooooo`3oooooon3ooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`0Aooooo`03o`000?l0o`3o0?l000[o0?l08ooo
ool001Cooooo1_l00004ooooo`05ojVYZOl@413o0000oa0@4?n7QhL01Oooool01OnYZJWo410@o`00
0?l@413oQhN700cooooo00?o0000ooooooooool0oooooooPooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool04Oooool00ol0003oooooooooo`0<o`3o027ooooo000Eooooo`03okZj^_l0
003o000000Gooooo00OoV9RHo`000?n7QhOooooookZj^_l0003oQhN700?ooooo00OoV9RHo`000?n7
QhOooooookZj^_l0003oQhN700_ooooo00?o0000ooooooooool0oooooooPooooo`?o00001Oooool6
o`0000kooooo0ol000000ooooooo0?l0o`3o000:o`3o023ooooo000Fooooo`;o00001?ooool00ooM
gMgo0000oeEEE@03ooooo`07ofIVI_l0003ok^k^oooooooMgMgo0000oeEEE@03ooooo`03ofIVI_l0
003ok^k^00[ooooo00?o0000ooooooooool0oooooooRooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool03_ooool01?l0003oooooooooooooool;o`3o01oooooo000Fooooo`;o00001?oo
ool00on7QhOo0000ojVYZ@03ooooo`07okZj^_l0003oQhN7oooooon7QhOo0000ojVYZ@03ooooo`03
okZj^_l0003oQhN700[ooooo00?o0000ooooooooool0oooooooRooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`02ooooo`[o0?l07oooool001Kooooo
0_l00004ooooo`03oc8b<_l0003ogMgM00?ooooo00OogMgMo`000?lb<S;ooooooc8b<_l0003ogMgM
00?ooooo00?ogMgMo`000?lb<S802_ooool5o`000?ooooooh?ooool:o`000003ooooool0003o0000
01Go000000?oooooo`3o0?l0o`001_l0o`0Oooooo`005_ooool2o`0000Cooooo0_l00005ooooo`03
o`000?l@413ooooo00;o00001Oooool00ol0003o410@ooooo`3ooooooooooooo>Oooool001Kooooo
0_l00004ooooo`;o00001Oooool2o`000003ooooool0003o000000Gooooo0_l0003ooooooooooooo
>_ooool001Kooooo0_l00004ooooo`;o00001Oooool2o`000003ooooool0003o000000Gooooo0_l0
003ooooooooooooo>_ooool001Kooooo0_l00004ooooo`;o00001Oooool2o`000003ooooool0003o
000000Gooooo0_l0003ooooooooooooo>_ooool001Kooooo0_l00004ooooo`03oc8b<_l0003oc<c<
00?ooooo00Ooc<c<o`000?lb<S;ooooooc8b<_l0003oc<c<00?ooooo00?oc<c<o`000?lb<S80oooo
oooooooooc[ooooo000Fooooo`;o00001?ooool00on7QhOo0000ojVYZ@03ooooo`07ojVYZOl0003o
QhN7oooooon7QhOo0000ojVYZ@03ooooo`03ojVYZOl0003oQhN70?ooooooooooooljooooo`005_oo
ool2o`0000Cooooo00?ogMgMo`000?mEEED00oooool01omEEEGo0000onk^k_oooooogMgMo`000?mE
EED00oooool00omEEEGo0000onk^kP3ooooooooooooo>_ooool001Cooooo00Co8B4QofIVI_l0003o
00001Oooool01omgMgOo0000oiRHV?ooooooV9RHo`000?nHV9P00oooool01omgMgOo0000oiRHV?oo
ooooV9RHo`000?nHV9P0oooooooooooooc_ooooo000Dooooo`04omgMgOnHV9SoEEEEo`0000Kooooo
00GoQhN7oa0@4?l0003o410@oiRHV005ooooo`05ohN7Qol@413o0000oa0@4?nHV9P0oooooooooooo
occooooo003oooooooooooooJOooool00?oooooooooooomYooooo`00\
\>"],
  ImageRangeCache->{{{0, 614.812}, {379.625, 0}} -> {-10.9952, -8.49836, \
0.191003, 0.294332}}]
}, Open  ]]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1024}, {0, 689}},
WindowSize->{913, 662},
WindowMargins->{{4, Automatic}, {Automatic, 1}},
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 77, 1, 47, "Input"],

Cell[CellGroupData[{
Cell[1856, 56, 815, 17, 223, "Input"],
Cell[2674, 75, 75082, 1617, 508, 17074, 896, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],

Cell[CellGroupData[{
Cell[77793, 1697, 2181, 49, 303, "Input"],
Cell[79977, 1748, 72863, 1820, 389, 21773, 1185, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

