(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    186420,       4413]*)
(*NotebookOutlinePosition[    187145,       4437]*)
(*  CellTagsIndexPosition[    187101,       4433]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(Random\ Walk\ in\ 1  Dimension\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{\( (*_Random\ Walk*) \), "\[IndentingNewLine]", 
      RowBox[{
        StyleBox[\(p = 0.5;\),
          FontFamily->"Courier New"], 
        "\[IndentingNewLine]", \( (*_Probability\ of\ a\ forward\ step\ is\ \
p, \ and\ hence\ q = 1 - p\ for\ a\ step\ backward*) \), 
        "\[IndentingNewLine]", 
        StyleBox[\(nstep = 200;\),
          FontFamily->"Courier New"], 
        "\[IndentingNewLine]", \( (*_Number\ of\ steps\ in\ the\ random\ walk\
*) \), "\[IndentingNewLine]", 
        StyleBox[\(trial = 10;\),
          FontFamily->"Courier New"], 
        "\[IndentingNewLine]", \( (*_Number\ of\ independent\ random\ walks, \
\ i . e . \ trials*) \), "\[IndentingNewLine]", 
        StyleBox[\(monte[x_] := If[\((Random[] < p)\), x + 1, x - 1]\),
          FontFamily->"Courier New"], 
        StyleBox["\[IndentingNewLine]",
          
          FontFamily->
            "Courier New"], \( (*_Provides\ a\ function\ which\ generates\ a\ \
random\ \(walk : \ x\) \[Rule] x + 1\ with\ prob . \ p, \ 
          and\ x \[Rule] x - 1\ with\ prob . \ q = 1 - p*) \), 
        "\[IndentingNewLine]", 
        StyleBox[\(randvar = 
              Table[NestList[monte, 0, nstep], {c, 1, trial, 1}];\),
          FontFamily->"Courier New"], 
        "\[IndentingNewLine]", \( (*_Generates\ a\ table\ containing\ c = 1, 
          2,  ... , trials\ random\ walks, \ each\ of\ length\ nstep*) \), 
        "\[IndentingNewLine]", \( (*_Nestlist\ iterates\ the\ random\ process\
\ of\ choosing\ between\ going\ right\ or\ left*) \), "\n", 
        StyleBox[\(tabelle[x_] := 
              Table[{n - 1, Part[randvar, x, n]}, {n, 1, nstep, 1}];\),
          FontFamily->"Courier New"], 
        "\n", \( (*_Provides\ a\ function, \ 
          which\ extracts\ random\ walk\ #\ x\ out\ of\ the\ dataset\ randvar\
*) \), "\[IndentingNewLine]", 
        StyleBox[\(experiment[x_] := \ 
              ListPlot[tabelle[x], PlotJoined \[Rule] True, 
                DisplayFunction \[Rule] Identity, 
                TextStyle \[Rule] {FontFamily \[Rule] "\<Times\>", 
                    FontSize \[Rule] 10}];\),
          FontFamily->"Courier New"], 
        "\n", \( (*_Provides\ a\ function\ witht\ the\ task\ to\ plot\ random\
\ walk\ #\ x*) \), "\[IndentingNewLine]", 
        StyleBox[\(plotwalks = Array[experiment, trial];\),
          FontFamily->"Courier New"], 
        "\n", \( (*_Makes\ an\ array\ of\ all\ the\ random\ walks*) \), 
        "\[IndentingNewLine]", \(<< Graphics`Animation`\), 
        "\[IndentingNewLine]", 
        StyleBox[\(Show[plotwalks, 
              DisplayFunction \[Rule] $DisplayFunction];\),
          FontFamily->"Courier New"], 
        StyleBox["\n",
          FontFamily->"Courier New"], 
        StyleBox[\(Clear[plotwalks];\),
          FontFamily->"Courier New"]}]}]], "Input",
  FontFamily->"Tahoma",
  FontSize->18],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00478583 0.28872 0.0101483 [
[.2631 .27622 -7.0625 -13.5625 ]
[.2631 .27622 7.0625 0 ]
[.50239 .27622 -9.59375 -13.5625 ]
[.50239 .27622 9.59375 0 ]
[.74168 .27622 -9.59375 -13.5625 ]
[.74168 .27622 9.59375 0 ]
[.98098 .27622 -9.59375 -13.5625 ]
[.98098 .27622 9.59375 0 ]
[.01131 .08575 -21.125 -6.78125 ]
[.01131 .08575 0 6.78125 ]
[.01131 .18724 -21.125 -6.78125 ]
[.01131 .18724 0 6.78125 ]
[.01131 .3902 -14.125 -6.78125 ]
[.01131 .3902 0 6.78125 ]
[.01131 .49169 -14.125 -6.78125 ]
[.01131 .49169 0 6.78125 ]
[.01131 .59317 -14.125 -6.78125 ]
[.01131 .59317 0 6.78125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2631 .28872 m
.2631 .29497 L
s
gsave
.2631 .27622 -68.0625 -17.5625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.188 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(50) show
1.000 setlinewidth
grestore
.50239 .28872 m
.50239 .29497 L
s
gsave
.50239 .27622 -70.5938 -17.5625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.188 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(100) show
1.000 setlinewidth
grestore
.74168 .28872 m
.74168 .29497 L
s
gsave
.74168 .27622 -70.5938 -17.5625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.188 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(150) show
1.000 setlinewidth
grestore
.98098 .28872 m
.98098 .29497 L
s
gsave
.98098 .27622 -70.5938 -17.5625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.188 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(200) show
1.000 setlinewidth
grestore
.125 Mabswid
.07167 .28872 m
.07167 .29247 L
s
.11953 .28872 m
.11953 .29247 L
s
.16738 .28872 m
.16738 .29247 L
s
.21524 .28872 m
.21524 .29247 L
s
.31096 .28872 m
.31096 .29247 L
s
.35882 .28872 m
.35882 .29247 L
s
.40668 .28872 m
.40668 .29247 L
s
.45453 .28872 m
.45453 .29247 L
s
.55025 .28872 m
.55025 .29247 L
s
.59811 .28872 m
.59811 .29247 L
s
.64597 .28872 m
.64597 .29247 L
s
.69383 .28872 m
.69383 .29247 L
s
.78954 .28872 m
.78954 .29247 L
s
.8374 .28872 m
.8374 .29247 L
s
.88526 .28872 m
.88526 .29247 L
s
.93312 .28872 m
.93312 .29247 L
s
.25 Mabswid
0 .28872 m
1 .28872 L
s
.02381 .08575 m
.03006 .08575 L
s
gsave
.01131 .08575 -82.125 -10.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.188 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
70.000 14.188 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(20) show
1.000 setlinewidth
grestore
.02381 .18724 m
.03006 .18724 L
s
gsave
.01131 .18724 -82.125 -10.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.188 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
70.000 14.188 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
1.000 setlinewidth
grestore
.02381 .3902 m
.03006 .3902 L
s
gsave
.01131 .3902 -75.125 -10.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.188 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
1.000 setlinewidth
grestore
.02381 .49169 m
.03006 .49169 L
s
gsave
.01131 .49169 -75.125 -10.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.188 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(20) show
1.000 setlinewidth
grestore
.02381 .59317 m
.03006 .59317 L
s
gsave
.01131 .59317 -75.125 -10.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.188 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(30) show
1.000 setlinewidth
grestore
.125 Mabswid
.02381 .10605 m
.02756 .10605 L
s
.02381 .12635 m
.02756 .12635 L
s
.02381 .14664 m
.02756 .14664 L
s
.02381 .16694 m
.02756 .16694 L
s
.02381 .20753 m
.02756 .20753 L
s
.02381 .22783 m
.02756 .22783 L
s
.02381 .24813 m
.02756 .24813 L
s
.02381 .26842 m
.02756 .26842 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .32931 m
.02756 .32931 L
s
.02381 .34961 m
.02756 .34961 L
s
.02381 .36991 m
.02756 .36991 L
s
.02381 .4105 m
.02756 .4105 L
s
.02381 .4308 m
.02756 .4308 L
s
.02381 .45109 m
.02756 .45109 L
s
.02381 .47139 m
.02756 .47139 L
s
.02381 .51198 m
.02756 .51198 L
s
.02381 .53228 m
.02756 .53228 L
s
.02381 .55258 m
.02756 .55258 L
s
.02381 .57287 m
.02756 .57287 L
s
.02381 .06546 m
.02756 .06546 L
s
.02381 .04516 m
.02756 .04516 L
s
.02381 .02486 m
.02756 .02486 L
s
.02381 .00457 m
.02756 .00457 L
s
.02381 .61347 m
.02756 .61347 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .28872 m
.0286 .29887 L
.03338 .30902 L
.03817 .29887 L
.04295 .28872 L
.04774 .29887 L
.05252 .28872 L
.05731 .27857 L
.0621 .26842 L
.06688 .25828 L
.07167 .24813 L
.07645 .25828 L
.08124 .24813 L
.08603 .23798 L
.09081 .22783 L
.0956 .21768 L
.10038 .22783 L
.10517 .21768 L
.10995 .22783 L
.11474 .23798 L
.11953 .24813 L
.12431 .25828 L
.1291 .26842 L
.13388 .25828 L
.13867 .24813 L
.14346 .25828 L
.14824 .24813 L
.15303 .25828 L
.15781 .24813 L
.1626 .23798 L
.16738 .22783 L
.17217 .21768 L
.17696 .20753 L
.18174 .21768 L
.18653 .22783 L
.19131 .23798 L
.1961 .22783 L
.20089 .21768 L
.20567 .22783 L
.21046 .23798 L
.21524 .22783 L
.22003 .21768 L
.22481 .22783 L
.2296 .23798 L
.23439 .24813 L
.23917 .25828 L
.24396 .24813 L
.24874 .25828 L
.25353 .24813 L
.25832 .23798 L
Mistroke
.2631 .22783 L
.26789 .23798 L
.27267 .24813 L
.27746 .25828 L
.28224 .24813 L
.28703 .23798 L
.29182 .24813 L
.2966 .25828 L
.30139 .24813 L
.30617 .23798 L
.31096 .22783 L
.31575 .21768 L
.32053 .22783 L
.32532 .23798 L
.3301 .22783 L
.33489 .21768 L
.33967 .22783 L
.34446 .21768 L
.34925 .20753 L
.35403 .19739 L
.35882 .20753 L
.3636 .21768 L
.36839 .20753 L
.37318 .19739 L
.37796 .20753 L
.38275 .21768 L
.38753 .20753 L
.39232 .21768 L
.3971 .22783 L
.40189 .23798 L
.40668 .24813 L
.41146 .25828 L
.41625 .24813 L
.42103 .23798 L
.42582 .22783 L
.43061 .21768 L
.43539 .22783 L
.44018 .21768 L
.44496 .20753 L
.44975 .21768 L
.45453 .22783 L
.45932 .23798 L
.46411 .24813 L
.46889 .23798 L
.47368 .24813 L
.47846 .25828 L
.48325 .26842 L
.48804 .27857 L
.49282 .26842 L
.49761 .25828 L
Mistroke
.50239 .24813 L
.50718 .23798 L
.51196 .24813 L
.51675 .25828 L
.52154 .26842 L
.52632 .27857 L
.53111 .28872 L
.53589 .29887 L
.54068 .28872 L
.54547 .29887 L
.55025 .30902 L
.55504 .29887 L
.55982 .30902 L
.56461 .31917 L
.56939 .30902 L
.57418 .31917 L
.57897 .32931 L
.58375 .31917 L
.58854 .30902 L
.59332 .31917 L
.59811 .30902 L
.6029 .29887 L
.60768 .30902 L
.61247 .31917 L
.61725 .32931 L
.62204 .31917 L
.62682 .32931 L
.63161 .31917 L
.6364 .30902 L
.64118 .29887 L
.64597 .28872 L
.65075 .29887 L
.65554 .30902 L
.66033 .31917 L
.66511 .32931 L
.6699 .31917 L
.67468 .30902 L
.67947 .31917 L
.68425 .30902 L
.68904 .29887 L
.69383 .28872 L
.69861 .27857 L
.7034 .26842 L
.70818 .27857 L
.71297 .26842 L
.71776 .25828 L
.72254 .24813 L
.72733 .23798 L
.73211 .24813 L
.7369 .23798 L
Mistroke
.74168 .22783 L
.74647 .21768 L
.75126 .20753 L
.75604 .21768 L
.76083 .22783 L
.76561 .23798 L
.7704 .24813 L
.77519 .23798 L
.77997 .22783 L
.78476 .21768 L
.78954 .20753 L
.79433 .19739 L
.79911 .20753 L
.8039 .19739 L
.80869 .18724 L
.81347 .19739 L
.81826 .20753 L
.82304 .19739 L
.82783 .20753 L
.83262 .21768 L
.8374 .22783 L
.84219 .21768 L
.84697 .20753 L
.85176 .21768 L
.85654 .20753 L
.86133 .19739 L
.86612 .20753 L
.8709 .21768 L
.87569 .20753 L
.88047 .21768 L
.88526 .20753 L
.89005 .21768 L
.89483 .20753 L
.89962 .19739 L
.9044 .18724 L
.90919 .17709 L
.91397 .16694 L
.91876 .15679 L
.92355 .16694 L
.92833 .17709 L
.93312 .16694 L
.9379 .17709 L
.94269 .18724 L
.94748 .19739 L
.95226 .20753 L
.95705 .21768 L
.96183 .20753 L
.96662 .19739 L
.9714 .18724 L
.97619 .19739 L
Mistroke
Mfstroke
.02381 .28872 m
.0286 .27857 L
.03338 .28872 L
.03817 .29887 L
.04295 .28872 L
.04774 .29887 L
.05252 .30902 L
.05731 .31917 L
.0621 .30902 L
.06688 .29887 L
.07167 .30902 L
.07645 .31917 L
.08124 .30902 L
.08603 .29887 L
.09081 .28872 L
.0956 .29887 L
.10038 .28872 L
.10517 .29887 L
.10995 .28872 L
.11474 .27857 L
.11953 .28872 L
.12431 .27857 L
.1291 .28872 L
.13388 .27857 L
.13867 .26842 L
.14346 .27857 L
.14824 .28872 L
.15303 .27857 L
.15781 .26842 L
.1626 .25828 L
.16738 .24813 L
.17217 .25828 L
.17696 .24813 L
.18174 .23798 L
.18653 .24813 L
.19131 .25828 L
.1961 .26842 L
.20089 .27857 L
.20567 .26842 L
.21046 .25828 L
.21524 .26842 L
.22003 .25828 L
.22481 .24813 L
.2296 .23798 L
.23439 .24813 L
.23917 .25828 L
.24396 .24813 L
.24874 .25828 L
.25353 .24813 L
.25832 .25828 L
Mistroke
.2631 .24813 L
.26789 .23798 L
.27267 .22783 L
.27746 .23798 L
.28224 .22783 L
.28703 .23798 L
.29182 .22783 L
.2966 .23798 L
.30139 .24813 L
.30617 .25828 L
.31096 .24813 L
.31575 .25828 L
.32053 .24813 L
.32532 .25828 L
.3301 .26842 L
.33489 .27857 L
.33967 .26842 L
.34446 .25828 L
.34925 .26842 L
.35403 .27857 L
.35882 .28872 L
.3636 .29887 L
.36839 .28872 L
.37318 .29887 L
.37796 .30902 L
.38275 .29887 L
.38753 .28872 L
.39232 .27857 L
.3971 .26842 L
.40189 .27857 L
.40668 .28872 L
.41146 .29887 L
.41625 .30902 L
.42103 .29887 L
.42582 .30902 L
.43061 .31917 L
.43539 .32931 L
.44018 .31917 L
.44496 .30902 L
.44975 .31917 L
.45453 .30902 L
.45932 .29887 L
.46411 .28872 L
.46889 .27857 L
.47368 .28872 L
.47846 .27857 L
.48325 .26842 L
.48804 .25828 L
.49282 .26842 L
.49761 .25828 L
Mistroke
.50239 .24813 L
.50718 .25828 L
.51196 .26842 L
.51675 .25828 L
.52154 .24813 L
.52632 .23798 L
.53111 .24813 L
.53589 .23798 L
.54068 .22783 L
.54547 .23798 L
.55025 .22783 L
.55504 .23798 L
.55982 .22783 L
.56461 .23798 L
.56939 .24813 L
.57418 .25828 L
.57897 .26842 L
.58375 .27857 L
.58854 .26842 L
.59332 .25828 L
.59811 .24813 L
.6029 .25828 L
.60768 .24813 L
.61247 .23798 L
.61725 .22783 L
.62204 .23798 L
.62682 .24813 L
.63161 .25828 L
.6364 .24813 L
.64118 .23798 L
.64597 .24813 L
.65075 .23798 L
.65554 .24813 L
.66033 .25828 L
.66511 .26842 L
.6699 .27857 L
.67468 .28872 L
.67947 .27857 L
.68425 .26842 L
.68904 .27857 L
.69383 .28872 L
.69861 .29887 L
.7034 .28872 L
.70818 .29887 L
.71297 .28872 L
.71776 .27857 L
.72254 .28872 L
.72733 .27857 L
.73211 .26842 L
.7369 .27857 L
Mistroke
.74168 .26842 L
.74647 .27857 L
.75126 .28872 L
.75604 .27857 L
.76083 .26842 L
.76561 .25828 L
.7704 .24813 L
.77519 .23798 L
.77997 .22783 L
.78476 .23798 L
.78954 .24813 L
.79433 .23798 L
.79911 .22783 L
.8039 .23798 L
.80869 .24813 L
.81347 .23798 L
.81826 .22783 L
.82304 .21768 L
.82783 .20753 L
.83262 .19739 L
.8374 .18724 L
.84219 .19739 L
.84697 .18724 L
.85176 .19739 L
.85654 .18724 L
.86133 .17709 L
.86612 .16694 L
.8709 .17709 L
.87569 .18724 L
.88047 .19739 L
.88526 .18724 L
.89005 .17709 L
.89483 .16694 L
.89962 .15679 L
.9044 .16694 L
.90919 .15679 L
.91397 .14664 L
.91876 .1365 L
.92355 .14664 L
.92833 .15679 L
.93312 .16694 L
.9379 .15679 L
.94269 .16694 L
.94748 .17709 L
.95226 .18724 L
.95705 .19739 L
.96183 .20753 L
.96662 .21768 L
.9714 .22783 L
.97619 .23798 L
Mistroke
Mfstroke
.02381 .28872 m
.0286 .27857 L
.03338 .28872 L
.03817 .29887 L
.04295 .28872 L
.04774 .29887 L
.05252 .30902 L
.05731 .31917 L
.0621 .32931 L
.06688 .33946 L
.07167 .32931 L
.07645 .31917 L
.08124 .30902 L
.08603 .31917 L
.09081 .30902 L
.0956 .31917 L
.10038 .30902 L
.10517 .29887 L
.10995 .30902 L
.11474 .29887 L
.11953 .30902 L
.12431 .29887 L
.1291 .30902 L
.13388 .29887 L
.13867 .28872 L
.14346 .27857 L
.14824 .26842 L
.15303 .27857 L
.15781 .28872 L
.1626 .27857 L
.16738 .26842 L
.17217 .25828 L
.17696 .26842 L
.18174 .27857 L
.18653 .26842 L
.19131 .25828 L
.1961 .26842 L
.20089 .27857 L
.20567 .28872 L
.21046 .27857 L
.21524 .26842 L
.22003 .27857 L
.22481 .28872 L
.2296 .27857 L
.23439 .28872 L
.23917 .27857 L
.24396 .28872 L
.24874 .29887 L
.25353 .30902 L
.25832 .29887 L
Mistroke
.2631 .30902 L
.26789 .29887 L
.27267 .30902 L
.27746 .29887 L
.28224 .28872 L
.28703 .29887 L
.29182 .28872 L
.2966 .29887 L
.30139 .28872 L
.30617 .29887 L
.31096 .30902 L
.31575 .31917 L
.32053 .32931 L
.32532 .31917 L
.3301 .30902 L
.33489 .29887 L
.33967 .30902 L
.34446 .29887 L
.34925 .30902 L
.35403 .31917 L
.35882 .32931 L
.3636 .31917 L
.36839 .30902 L
.37318 .29887 L
.37796 .28872 L
.38275 .27857 L
.38753 .26842 L
.39232 .27857 L
.3971 .28872 L
.40189 .27857 L
.40668 .26842 L
.41146 .25828 L
.41625 .24813 L
.42103 .25828 L
.42582 .24813 L
.43061 .23798 L
.43539 .24813 L
.44018 .23798 L
.44496 .22783 L
.44975 .21768 L
.45453 .22783 L
.45932 .21768 L
.46411 .20753 L
.46889 .21768 L
.47368 .22783 L
.47846 .23798 L
.48325 .22783 L
.48804 .23798 L
.49282 .24813 L
.49761 .25828 L
Mistroke
.50239 .24813 L
.50718 .25828 L
.51196 .24813 L
.51675 .23798 L
.52154 .24813 L
.52632 .25828 L
.53111 .26842 L
.53589 .25828 L
.54068 .24813 L
.54547 .23798 L
.55025 .22783 L
.55504 .21768 L
.55982 .20753 L
.56461 .21768 L
.56939 .20753 L
.57418 .21768 L
.57897 .22783 L
.58375 .21768 L
.58854 .20753 L
.59332 .21768 L
.59811 .20753 L
.6029 .19739 L
.60768 .18724 L
.61247 .17709 L
.61725 .16694 L
.62204 .17709 L
.62682 .16694 L
.63161 .15679 L
.6364 .16694 L
.64118 .15679 L
.64597 .14664 L
.65075 .15679 L
.65554 .14664 L
.66033 .15679 L
.66511 .14664 L
.6699 .15679 L
.67468 .16694 L
.67947 .15679 L
.68425 .14664 L
.68904 .1365 L
.69383 .14664 L
.69861 .15679 L
.7034 .16694 L
.70818 .15679 L
.71297 .14664 L
.71776 .1365 L
.72254 .14664 L
.72733 .15679 L
.73211 .14664 L
.7369 .15679 L
Mistroke
.74168 .16694 L
.74647 .17709 L
.75126 .16694 L
.75604 .17709 L
.76083 .16694 L
.76561 .15679 L
.7704 .14664 L
.77519 .15679 L
.77997 .14664 L
.78476 .1365 L
.78954 .14664 L
.79433 .15679 L
.79911 .14664 L
.8039 .1365 L
.80869 .14664 L
.81347 .15679 L
.81826 .14664 L
.82304 .1365 L
.82783 .12635 L
.83262 .1162 L
.8374 .12635 L
.84219 .1162 L
.84697 .10605 L
.85176 .1162 L
.85654 .10605 L
.86133 .0959 L
.86612 .10605 L
.8709 .1162 L
.87569 .12635 L
.88047 .1162 L
.88526 .10605 L
.89005 .0959 L
.89483 .10605 L
.89962 .0959 L
.9044 .10605 L
.90919 .0959 L
.91397 .10605 L
.91876 .1162 L
.92355 .12635 L
.92833 .1162 L
.93312 .12635 L
.9379 .1365 L
.94269 .14664 L
.94748 .1365 L
.95226 .14664 L
.95705 .15679 L
.96183 .16694 L
.96662 .15679 L
.9714 .16694 L
.97619 .15679 L
Mistroke
Mfstroke
.02381 .28872 m
.0286 .29887 L
.03338 .28872 L
.03817 .27857 L
.04295 .28872 L
.04774 .27857 L
.05252 .26842 L
.05731 .25828 L
.0621 .24813 L
.06688 .23798 L
.07167 .24813 L
.07645 .23798 L
.08124 .22783 L
.08603 .23798 L
.09081 .24813 L
.0956 .23798 L
.10038 .22783 L
.10517 .21768 L
.10995 .20753 L
.11474 .21768 L
.11953 .22783 L
.12431 .23798 L
.1291 .22783 L
.13388 .21768 L
.13867 .22783 L
.14346 .21768 L
.14824 .20753 L
.15303 .19739 L
.15781 .20753 L
.1626 .21768 L
.16738 .22783 L
.17217 .21768 L
.17696 .20753 L
.18174 .21768 L
.18653 .20753 L
.19131 .21768 L
.1961 .20753 L
.20089 .19739 L
.20567 .18724 L
.21046 .19739 L
.21524 .20753 L
.22003 .21768 L
.22481 .20753 L
.2296 .19739 L
.23439 .20753 L
.23917 .21768 L
.24396 .20753 L
.24874 .21768 L
.25353 .20753 L
.25832 .19739 L
Mistroke
.2631 .20753 L
.26789 .21768 L
.27267 .22783 L
.27746 .21768 L
.28224 .20753 L
.28703 .21768 L
.29182 .20753 L
.2966 .21768 L
.30139 .22783 L
.30617 .23798 L
.31096 .22783 L
.31575 .21768 L
.32053 .22783 L
.32532 .23798 L
.3301 .24813 L
.33489 .23798 L
.33967 .22783 L
.34446 .23798 L
.34925 .24813 L
.35403 .25828 L
.35882 .24813 L
.3636 .23798 L
.36839 .22783 L
.37318 .21768 L
.37796 .20753 L
.38275 .19739 L
.38753 .20753 L
.39232 .21768 L
.3971 .20753 L
.40189 .21768 L
.40668 .22783 L
.41146 .21768 L
.41625 .20753 L
.42103 .19739 L
.42582 .18724 L
.43061 .19739 L
.43539 .20753 L
.44018 .19739 L
.44496 .20753 L
.44975 .19739 L
.45453 .18724 L
.45932 .17709 L
.46411 .16694 L
.46889 .17709 L
.47368 .18724 L
.47846 .17709 L
.48325 .18724 L
.48804 .19739 L
.49282 .20753 L
.49761 .19739 L
Mistroke
.50239 .20753 L
.50718 .21768 L
.51196 .20753 L
.51675 .19739 L
.52154 .18724 L
.52632 .19739 L
.53111 .18724 L
.53589 .19739 L
.54068 .20753 L
.54547 .21768 L
.55025 .22783 L
.55504 .23798 L
.55982 .22783 L
.56461 .21768 L
.56939 .20753 L
.57418 .19739 L
.57897 .18724 L
.58375 .17709 L
.58854 .16694 L
.59332 .17709 L
.59811 .16694 L
.6029 .17709 L
.60768 .18724 L
.61247 .19739 L
.61725 .20753 L
.62204 .21768 L
.62682 .20753 L
.63161 .21768 L
.6364 .20753 L
.64118 .19739 L
.64597 .18724 L
.65075 .19739 L
.65554 .18724 L
.66033 .17709 L
.66511 .18724 L
.6699 .17709 L
.67468 .16694 L
.67947 .15679 L
.68425 .14664 L
.68904 .15679 L
.69383 .16694 L
.69861 .17709 L
.7034 .18724 L
.70818 .17709 L
.71297 .16694 L
.71776 .15679 L
.72254 .14664 L
.72733 .1365 L
.73211 .14664 L
.7369 .1365 L
Mistroke
.74168 .14664 L
.74647 .15679 L
.75126 .16694 L
.75604 .15679 L
.76083 .14664 L
.76561 .15679 L
.7704 .14664 L
.77519 .15679 L
.77997 .16694 L
.78476 .17709 L
.78954 .16694 L
.79433 .17709 L
.79911 .16694 L
.8039 .15679 L
.80869 .14664 L
.81347 .15679 L
.81826 .14664 L
.82304 .15679 L
.82783 .16694 L
.83262 .17709 L
.8374 .16694 L
.84219 .17709 L
.84697 .16694 L
.85176 .17709 L
.85654 .18724 L
.86133 .17709 L
.86612 .18724 L
.8709 .17709 L
.87569 .16694 L
.88047 .15679 L
.88526 .14664 L
.89005 .15679 L
.89483 .16694 L
.89962 .15679 L
.9044 .16694 L
.90919 .15679 L
.91397 .16694 L
.91876 .15679 L
.92355 .16694 L
.92833 .15679 L
.93312 .14664 L
.9379 .1365 L
.94269 .14664 L
.94748 .15679 L
.95226 .16694 L
.95705 .17709 L
.96183 .18724 L
.96662 .19739 L
.9714 .20753 L
.97619 .19739 L
Mistroke
Mfstroke
.02381 .28872 m
.0286 .29887 L
.03338 .28872 L
.03817 .27857 L
.04295 .28872 L
.04774 .29887 L
.05252 .30902 L
.05731 .29887 L
.0621 .30902 L
.06688 .31917 L
.07167 .30902 L
.07645 .29887 L
.08124 .28872 L
.08603 .27857 L
.09081 .28872 L
.0956 .29887 L
.10038 .28872 L
.10517 .29887 L
.10995 .28872 L
.11474 .27857 L
.11953 .28872 L
.12431 .27857 L
.1291 .26842 L
.13388 .27857 L
.13867 .28872 L
.14346 .27857 L
.14824 .28872 L
.15303 .27857 L
.15781 .26842 L
.1626 .27857 L
.16738 .26842 L
.17217 .25828 L
.17696 .24813 L
.18174 .25828 L
.18653 .24813 L
.19131 .23798 L
.1961 .22783 L
.20089 .21768 L
.20567 .20753 L
.21046 .19739 L
.21524 .20753 L
.22003 .19739 L
.22481 .20753 L
.2296 .19739 L
.23439 .18724 L
.23917 .17709 L
.24396 .18724 L
.24874 .17709 L
.25353 .16694 L
.25832 .17709 L
Mistroke
.2631 .18724 L
.26789 .19739 L
.27267 .20753 L
.27746 .19739 L
.28224 .20753 L
.28703 .21768 L
.29182 .20753 L
.2966 .19739 L
.30139 .18724 L
.30617 .19739 L
.31096 .18724 L
.31575 .17709 L
.32053 .16694 L
.32532 .15679 L
.3301 .14664 L
.33489 .15679 L
.33967 .14664 L
.34446 .15679 L
.34925 .14664 L
.35403 .15679 L
.35882 .16694 L
.3636 .15679 L
.36839 .14664 L
.37318 .15679 L
.37796 .16694 L
.38275 .17709 L
.38753 .16694 L
.39232 .15679 L
.3971 .14664 L
.40189 .15679 L
.40668 .16694 L
.41146 .17709 L
.41625 .18724 L
.42103 .17709 L
.42582 .18724 L
.43061 .19739 L
.43539 .20753 L
.44018 .19739 L
.44496 .18724 L
.44975 .19739 L
.45453 .18724 L
.45932 .17709 L
.46411 .16694 L
.46889 .15679 L
.47368 .16694 L
.47846 .17709 L
.48325 .16694 L
.48804 .17709 L
.49282 .18724 L
.49761 .17709 L
Mistroke
.50239 .16694 L
.50718 .15679 L
.51196 .16694 L
.51675 .17709 L
.52154 .16694 L
.52632 .17709 L
.53111 .18724 L
.53589 .17709 L
.54068 .18724 L
.54547 .19739 L
.55025 .18724 L
.55504 .17709 L
.55982 .16694 L
.56461 .17709 L
.56939 .18724 L
.57418 .19739 L
.57897 .18724 L
.58375 .17709 L
.58854 .16694 L
.59332 .17709 L
.59811 .16694 L
.6029 .15679 L
.60768 .14664 L
.61247 .15679 L
.61725 .16694 L
.62204 .15679 L
.62682 .16694 L
.63161 .15679 L
.6364 .16694 L
.64118 .17709 L
.64597 .16694 L
.65075 .17709 L
.65554 .18724 L
.66033 .19739 L
.66511 .20753 L
.6699 .21768 L
.67468 .20753 L
.67947 .19739 L
.68425 .20753 L
.68904 .21768 L
.69383 .22783 L
.69861 .23798 L
.7034 .24813 L
.70818 .25828 L
.71297 .26842 L
.71776 .25828 L
.72254 .24813 L
.72733 .23798 L
.73211 .24813 L
.7369 .23798 L
Mistroke
.74168 .22783 L
.74647 .21768 L
.75126 .20753 L
.75604 .21768 L
.76083 .20753 L
.76561 .21768 L
.7704 .22783 L
.77519 .23798 L
.77997 .24813 L
.78476 .23798 L
.78954 .24813 L
.79433 .25828 L
.79911 .26842 L
.8039 .25828 L
.80869 .26842 L
.81347 .25828 L
.81826 .26842 L
.82304 .25828 L
.82783 .26842 L
.83262 .27857 L
.8374 .26842 L
.84219 .27857 L
.84697 .28872 L
.85176 .29887 L
.85654 .30902 L
.86133 .31917 L
.86612 .32931 L
.8709 .33946 L
.87569 .34961 L
.88047 .35976 L
.88526 .36991 L
.89005 .38006 L
.89483 .36991 L
.89962 .38006 L
.9044 .36991 L
.90919 .38006 L
.91397 .3902 L
.91876 .40035 L
.92355 .3902 L
.92833 .40035 L
.93312 .4105 L
.9379 .40035 L
.94269 .4105 L
.94748 .42065 L
.95226 .4105 L
.95705 .42065 L
.96183 .4308 L
.96662 .42065 L
.9714 .4105 L
.97619 .42065 L
Mistroke
Mfstroke
.02381 .28872 m
.0286 .27857 L
.03338 .28872 L
.03817 .29887 L
.04295 .28872 L
.04774 .29887 L
.05252 .30902 L
.05731 .31917 L
.0621 .32931 L
.06688 .33946 L
.07167 .32931 L
.07645 .31917 L
.08124 .30902 L
.08603 .31917 L
.09081 .32931 L
.0956 .33946 L
.10038 .34961 L
.10517 .33946 L
.10995 .32931 L
.11474 .31917 L
.11953 .30902 L
.12431 .29887 L
.1291 .30902 L
.13388 .29887 L
.13867 .30902 L
.14346 .31917 L
.14824 .32931 L
.15303 .31917 L
.15781 .30902 L
.1626 .29887 L
.16738 .28872 L
.17217 .27857 L
.17696 .26842 L
.18174 .27857 L
.18653 .28872 L
.19131 .27857 L
.1961 .28872 L
.20089 .29887 L
.20567 .28872 L
.21046 .27857 L
.21524 .26842 L
.22003 .25828 L
.22481 .26842 L
.2296 .25828 L
.23439 .26842 L
.23917 .25828 L
.24396 .24813 L
.24874 .25828 L
.25353 .24813 L
.25832 .25828 L
Mistroke
.2631 .24813 L
.26789 .25828 L
.27267 .26842 L
.27746 .25828 L
.28224 .24813 L
.28703 .23798 L
.29182 .22783 L
.2966 .23798 L
.30139 .22783 L
.30617 .21768 L
.31096 .20753 L
.31575 .19739 L
.32053 .18724 L
.32532 .19739 L
.3301 .18724 L
.33489 .19739 L
.33967 .18724 L
.34446 .17709 L
.34925 .18724 L
.35403 .19739 L
.35882 .18724 L
.3636 .19739 L
.36839 .20753 L
.37318 .21768 L
.37796 .22783 L
.38275 .21768 L
.38753 .22783 L
.39232 .23798 L
.3971 .24813 L
.40189 .25828 L
.40668 .26842 L
.41146 .27857 L
.41625 .26842 L
.42103 .27857 L
.42582 .26842 L
.43061 .27857 L
.43539 .26842 L
.44018 .25828 L
.44496 .24813 L
.44975 .25828 L
.45453 .26842 L
.45932 .27857 L
.46411 .28872 L
.46889 .27857 L
.47368 .28872 L
.47846 .27857 L
.48325 .26842 L
.48804 .25828 L
.49282 .26842 L
.49761 .27857 L
Mistroke
.50239 .26842 L
.50718 .27857 L
.51196 .28872 L
.51675 .27857 L
.52154 .28872 L
.52632 .29887 L
.53111 .28872 L
.53589 .27857 L
.54068 .26842 L
.54547 .25828 L
.55025 .24813 L
.55504 .23798 L
.55982 .24813 L
.56461 .23798 L
.56939 .22783 L
.57418 .21768 L
.57897 .20753 L
.58375 .21768 L
.58854 .22783 L
.59332 .21768 L
.59811 .20753 L
.6029 .19739 L
.60768 .18724 L
.61247 .17709 L
.61725 .16694 L
.62204 .17709 L
.62682 .16694 L
.63161 .15679 L
.6364 .16694 L
.64118 .17709 L
.64597 .18724 L
.65075 .19739 L
.65554 .18724 L
.66033 .19739 L
.66511 .18724 L
.6699 .19739 L
.67468 .18724 L
.67947 .19739 L
.68425 .18724 L
.68904 .17709 L
.69383 .16694 L
.69861 .17709 L
.7034 .16694 L
.70818 .15679 L
.71297 .16694 L
.71776 .17709 L
.72254 .16694 L
.72733 .17709 L
.73211 .16694 L
.7369 .17709 L
Mistroke
.74168 .16694 L
.74647 .15679 L
.75126 .16694 L
.75604 .17709 L
.76083 .16694 L
.76561 .15679 L
.7704 .14664 L
.77519 .1365 L
.77997 .12635 L
.78476 .1365 L
.78954 .12635 L
.79433 .1162 L
.79911 .10605 L
.8039 .0959 L
.80869 .10605 L
.81347 .0959 L
.81826 .10605 L
.82304 .0959 L
.82783 .08575 L
.83262 .0959 L
.8374 .08575 L
.84219 .07561 L
.84697 .08575 L
.85176 .07561 L
.85654 .06546 L
.86133 .05531 L
.86612 .06546 L
.8709 .05531 L
.87569 .06546 L
.88047 .07561 L
.88526 .08575 L
.89005 .07561 L
.89483 .08575 L
.89962 .07561 L
.9044 .08575 L
.90919 .0959 L
.91397 .10605 L
.91876 .0959 L
.92355 .10605 L
.92833 .0959 L
.93312 .08575 L
.9379 .07561 L
.94269 .06546 L
.94748 .05531 L
.95226 .06546 L
.95705 .07561 L
.96183 .06546 L
.96662 .05531 L
.9714 .04516 L
.97619 .05531 L
Mistroke
Mfstroke
.02381 .28872 m
.0286 .27857 L
.03338 .26842 L
.03817 .27857 L
.04295 .28872 L
.04774 .27857 L
.05252 .26842 L
.05731 .27857 L
.0621 .26842 L
.06688 .25828 L
.07167 .26842 L
.07645 .27857 L
.08124 .28872 L
.08603 .29887 L
.09081 .30902 L
.0956 .31917 L
.10038 .32931 L
.10517 .31917 L
.10995 .30902 L
.11474 .31917 L
.11953 .30902 L
.12431 .29887 L
.1291 .30902 L
.13388 .29887 L
.13867 .30902 L
.14346 .31917 L
.14824 .32931 L
.15303 .33946 L
.15781 .34961 L
.1626 .35976 L
.16738 .34961 L
.17217 .35976 L
.17696 .36991 L
.18174 .35976 L
.18653 .34961 L
.19131 .33946 L
.1961 .34961 L
.20089 .33946 L
.20567 .34961 L
.21046 .35976 L
.21524 .34961 L
.22003 .35976 L
.22481 .36991 L
.2296 .38006 L
.23439 .3902 L
.23917 .40035 L
.24396 .4105 L
.24874 .40035 L
.25353 .3902 L
.25832 .38006 L
Mistroke
.2631 .36991 L
.26789 .38006 L
.27267 .36991 L
.27746 .38006 L
.28224 .36991 L
.28703 .38006 L
.29182 .36991 L
.2966 .35976 L
.30139 .36991 L
.30617 .35976 L
.31096 .36991 L
.31575 .38006 L
.32053 .3902 L
.32532 .40035 L
.3301 .3902 L
.33489 .40035 L
.33967 .3902 L
.34446 .40035 L
.34925 .4105 L
.35403 .42065 L
.35882 .4308 L
.3636 .44095 L
.36839 .4308 L
.37318 .44095 L
.37796 .4308 L
.38275 .44095 L
.38753 .4308 L
.39232 .42065 L
.3971 .4105 L
.40189 .40035 L
.40668 .4105 L
.41146 .42065 L
.41625 .4308 L
.42103 .44095 L
.42582 .4308 L
.43061 .44095 L
.43539 .45109 L
.44018 .46124 L
.44496 .47139 L
.44975 .46124 L
.45453 .47139 L
.45932 .48154 L
.46411 .47139 L
.46889 .46124 L
.47368 .47139 L
.47846 .46124 L
.48325 .47139 L
.48804 .48154 L
.49282 .47139 L
.49761 .48154 L
Mistroke
.50239 .49169 L
.50718 .50184 L
.51196 .49169 L
.51675 .48154 L
.52154 .49169 L
.52632 .50184 L
.53111 .49169 L
.53589 .50184 L
.54068 .49169 L
.54547 .50184 L
.55025 .49169 L
.55504 .48154 L
.55982 .47139 L
.56461 .48154 L
.56939 .49169 L
.57418 .48154 L
.57897 .49169 L
.58375 .48154 L
.58854 .49169 L
.59332 .50184 L
.59811 .51198 L
.6029 .52213 L
.60768 .51198 L
.61247 .50184 L
.61725 .49169 L
.62204 .48154 L
.62682 .47139 L
.63161 .48154 L
.6364 .49169 L
.64118 .48154 L
.64597 .47139 L
.65075 .48154 L
.65554 .49169 L
.66033 .50184 L
.66511 .51198 L
.6699 .52213 L
.67468 .53228 L
.67947 .52213 L
.68425 .53228 L
.68904 .54243 L
.69383 .55258 L
.69861 .56273 L
.7034 .55258 L
.70818 .54243 L
.71297 .55258 L
.71776 .56273 L
.72254 .57287 L
.72733 .58302 L
.73211 .57287 L
.7369 .58302 L
Mistroke
.74168 .59317 L
.74647 .58302 L
.75126 .57287 L
.75604 .56273 L
.76083 .57287 L
.76561 .58302 L
.7704 .59317 L
.77519 .58302 L
.77997 .59317 L
.78476 .60332 L
.78954 .59317 L
.79433 .58302 L
.79911 .59317 L
.8039 .58302 L
.80869 .57287 L
.81347 .58302 L
.81826 .59317 L
.82304 .58302 L
.82783 .59317 L
.83262 .58302 L
.8374 .59317 L
.84219 .58302 L
.84697 .57287 L
.85176 .56273 L
.85654 .55258 L
.86133 .56273 L
.86612 .55258 L
.8709 .54243 L
.87569 .55258 L
.88047 .54243 L
.88526 .53228 L
.89005 .52213 L
.89483 .53228 L
.89962 .52213 L
.9044 .51198 L
.90919 .52213 L
.91397 .53228 L
.91876 .52213 L
.92355 .53228 L
.92833 .54243 L
.93312 .53228 L
.9379 .54243 L
.94269 .53228 L
.94748 .54243 L
.95226 .53228 L
.95705 .54243 L
.96183 .55258 L
.96662 .54243 L
.9714 .55258 L
.97619 .56273 L
Mistroke
Mfstroke
.02381 .28872 m
.0286 .29887 L
.03338 .28872 L
.03817 .29887 L
.04295 .28872 L
.04774 .29887 L
.05252 .28872 L
.05731 .27857 L
.0621 .26842 L
.06688 .25828 L
.07167 .26842 L
.07645 .25828 L
.08124 .24813 L
.08603 .23798 L
.09081 .24813 L
.0956 .23798 L
.10038 .22783 L
.10517 .23798 L
.10995 .22783 L
.11474 .21768 L
.11953 .20753 L
.12431 .19739 L
.1291 .18724 L
.13388 .17709 L
.13867 .18724 L
.14346 .17709 L
.14824 .16694 L
.15303 .17709 L
.15781 .16694 L
.1626 .17709 L
.16738 .18724 L
.17217 .17709 L
.17696 .16694 L
.18174 .15679 L
.18653 .14664 L
.19131 .1365 L
.1961 .14664 L
.20089 .15679 L
.20567 .16694 L
.21046 .17709 L
.21524 .18724 L
.22003 .17709 L
.22481 .16694 L
.2296 .15679 L
.23439 .16694 L
.23917 .15679 L
.24396 .16694 L
.24874 .17709 L
.25353 .16694 L
.25832 .17709 L
Mistroke
.2631 .18724 L
.26789 .17709 L
.27267 .18724 L
.27746 .17709 L
.28224 .16694 L
.28703 .17709 L
.29182 .18724 L
.2966 .19739 L
.30139 .20753 L
.30617 .21768 L
.31096 .22783 L
.31575 .23798 L
.32053 .22783 L
.32532 .23798 L
.3301 .24813 L
.33489 .25828 L
.33967 .24813 L
.34446 .25828 L
.34925 .24813 L
.35403 .23798 L
.35882 .22783 L
.3636 .21768 L
.36839 .22783 L
.37318 .23798 L
.37796 .22783 L
.38275 .23798 L
.38753 .22783 L
.39232 .23798 L
.3971 .22783 L
.40189 .21768 L
.40668 .20753 L
.41146 .21768 L
.41625 .20753 L
.42103 .21768 L
.42582 .22783 L
.43061 .23798 L
.43539 .22783 L
.44018 .23798 L
.44496 .22783 L
.44975 .21768 L
.45453 .20753 L
.45932 .21768 L
.46411 .20753 L
.46889 .21768 L
.47368 .22783 L
.47846 .23798 L
.48325 .22783 L
.48804 .21768 L
.49282 .20753 L
.49761 .21768 L
Mistroke
.50239 .22783 L
.50718 .21768 L
.51196 .22783 L
.51675 .23798 L
.52154 .22783 L
.52632 .23798 L
.53111 .24813 L
.53589 .25828 L
.54068 .26842 L
.54547 .27857 L
.55025 .26842 L
.55504 .25828 L
.55982 .24813 L
.56461 .23798 L
.56939 .22783 L
.57418 .23798 L
.57897 .22783 L
.58375 .21768 L
.58854 .22783 L
.59332 .23798 L
.59811 .22783 L
.6029 .21768 L
.60768 .20753 L
.61247 .21768 L
.61725 .20753 L
.62204 .21768 L
.62682 .20753 L
.63161 .19739 L
.6364 .18724 L
.64118 .17709 L
.64597 .18724 L
.65075 .17709 L
.65554 .16694 L
.66033 .17709 L
.66511 .16694 L
.6699 .17709 L
.67468 .16694 L
.67947 .15679 L
.68425 .16694 L
.68904 .15679 L
.69383 .16694 L
.69861 .17709 L
.7034 .16694 L
.70818 .17709 L
.71297 .16694 L
.71776 .15679 L
.72254 .14664 L
.72733 .15679 L
.73211 .16694 L
.7369 .17709 L
Mistroke
.74168 .16694 L
.74647 .17709 L
.75126 .18724 L
.75604 .17709 L
.76083 .16694 L
.76561 .15679 L
.7704 .14664 L
.77519 .15679 L
.77997 .14664 L
.78476 .1365 L
.78954 .12635 L
.79433 .1162 L
.79911 .10605 L
.8039 .1162 L
.80869 .12635 L
.81347 .1162 L
.81826 .10605 L
.82304 .0959 L
.82783 .08575 L
.83262 .0959 L
.8374 .08575 L
.84219 .07561 L
.84697 .08575 L
.85176 .07561 L
.85654 .06546 L
.86133 .07561 L
.86612 .08575 L
.8709 .07561 L
.87569 .08575 L
.88047 .07561 L
.88526 .08575 L
.89005 .0959 L
.89483 .08575 L
.89962 .07561 L
.9044 .06546 L
.90919 .05531 L
.91397 .06546 L
.91876 .05531 L
.92355 .06546 L
.92833 .05531 L
.93312 .06546 L
.9379 .07561 L
.94269 .06546 L
.94748 .05531 L
.95226 .06546 L
.95705 .07561 L
.96183 .08575 L
.96662 .0959 L
.9714 .08575 L
.97619 .0959 L
Mistroke
Mfstroke
.02381 .28872 m
.0286 .27857 L
.03338 .28872 L
.03817 .27857 L
.04295 .26842 L
.04774 .27857 L
.05252 .28872 L
.05731 .27857 L
.0621 .28872 L
.06688 .27857 L
.07167 .28872 L
.07645 .27857 L
.08124 .28872 L
.08603 .27857 L
.09081 .26842 L
.0956 .25828 L
.10038 .24813 L
.10517 .23798 L
.10995 .24813 L
.11474 .25828 L
.11953 .26842 L
.12431 .25828 L
.1291 .24813 L
.13388 .25828 L
.13867 .26842 L
.14346 .27857 L
.14824 .26842 L
.15303 .25828 L
.15781 .24813 L
.1626 .23798 L
.16738 .24813 L
.17217 .23798 L
.17696 .24813 L
.18174 .25828 L
.18653 .26842 L
.19131 .27857 L
.1961 .28872 L
.20089 .29887 L
.20567 .30902 L
.21046 .31917 L
.21524 .30902 L
.22003 .31917 L
.22481 .32931 L
.2296 .33946 L
.23439 .34961 L
.23917 .35976 L
.24396 .36991 L
.24874 .38006 L
.25353 .36991 L
.25832 .38006 L
Mistroke
.2631 .36991 L
.26789 .35976 L
.27267 .36991 L
.27746 .35976 L
.28224 .36991 L
.28703 .35976 L
.29182 .34961 L
.2966 .33946 L
.30139 .34961 L
.30617 .33946 L
.31096 .34961 L
.31575 .35976 L
.32053 .34961 L
.32532 .35976 L
.3301 .34961 L
.33489 .35976 L
.33967 .34961 L
.34446 .33946 L
.34925 .34961 L
.35403 .33946 L
.35882 .34961 L
.3636 .33946 L
.36839 .32931 L
.37318 .33946 L
.37796 .32931 L
.38275 .33946 L
.38753 .32931 L
.39232 .31917 L
.3971 .30902 L
.40189 .31917 L
.40668 .30902 L
.41146 .31917 L
.41625 .30902 L
.42103 .29887 L
.42582 .28872 L
.43061 .27857 L
.43539 .26842 L
.44018 .25828 L
.44496 .24813 L
.44975 .25828 L
.45453 .26842 L
.45932 .25828 L
.46411 .26842 L
.46889 .25828 L
.47368 .24813 L
.47846 .23798 L
.48325 .22783 L
.48804 .23798 L
.49282 .22783 L
.49761 .21768 L
Mistroke
.50239 .22783 L
.50718 .23798 L
.51196 .24813 L
.51675 .25828 L
.52154 .24813 L
.52632 .25828 L
.53111 .24813 L
.53589 .23798 L
.54068 .22783 L
.54547 .21768 L
.55025 .20753 L
.55504 .21768 L
.55982 .22783 L
.56461 .23798 L
.56939 .22783 L
.57418 .23798 L
.57897 .22783 L
.58375 .21768 L
.58854 .22783 L
.59332 .23798 L
.59811 .22783 L
.6029 .23798 L
.60768 .24813 L
.61247 .23798 L
.61725 .24813 L
.62204 .25828 L
.62682 .26842 L
.63161 .27857 L
.6364 .26842 L
.64118 .25828 L
.64597 .26842 L
.65075 .27857 L
.65554 .26842 L
.66033 .27857 L
.66511 .28872 L
.6699 .29887 L
.67468 .28872 L
.67947 .29887 L
.68425 .30902 L
.68904 .31917 L
.69383 .32931 L
.69861 .33946 L
.7034 .34961 L
.70818 .33946 L
.71297 .34961 L
.71776 .33946 L
.72254 .32931 L
.72733 .33946 L
.73211 .34961 L
.7369 .33946 L
Mistroke
.74168 .32931 L
.74647 .31917 L
.75126 .32931 L
.75604 .33946 L
.76083 .34961 L
.76561 .35976 L
.7704 .36991 L
.77519 .35976 L
.77997 .36991 L
.78476 .38006 L
.78954 .3902 L
.79433 .38006 L
.79911 .36991 L
.8039 .35976 L
.80869 .36991 L
.81347 .38006 L
.81826 .36991 L
.82304 .38006 L
.82783 .36991 L
.83262 .35976 L
.8374 .34961 L
.84219 .35976 L
.84697 .34961 L
.85176 .33946 L
.85654 .32931 L
.86133 .33946 L
.86612 .32931 L
.8709 .31917 L
.87569 .32931 L
.88047 .31917 L
.88526 .32931 L
.89005 .31917 L
.89483 .32931 L
.89962 .31917 L
.9044 .32931 L
.90919 .31917 L
.91397 .30902 L
.91876 .29887 L
.92355 .28872 L
.92833 .29887 L
.93312 .28872 L
.9379 .29887 L
.94269 .30902 L
.94748 .29887 L
.95226 .30902 L
.95705 .31917 L
.96183 .32931 L
.96662 .33946 L
.9714 .34961 L
.97619 .35976 L
Mistroke
Mfstroke
.02381 .28872 m
.0286 .27857 L
.03338 .26842 L
.03817 .25828 L
.04295 .26842 L
.04774 .25828 L
.05252 .24813 L
.05731 .25828 L
.0621 .26842 L
.06688 .27857 L
.07167 .28872 L
.07645 .27857 L
.08124 .26842 L
.08603 .27857 L
.09081 .28872 L
.0956 .29887 L
.10038 .30902 L
.10517 .31917 L
.10995 .30902 L
.11474 .29887 L
.11953 .30902 L
.12431 .31917 L
.1291 .30902 L
.13388 .31917 L
.13867 .32931 L
.14346 .31917 L
.14824 .30902 L
.15303 .29887 L
.15781 .28872 L
.1626 .27857 L
.16738 .28872 L
.17217 .29887 L
.17696 .30902 L
.18174 .29887 L
.18653 .28872 L
.19131 .27857 L
.1961 .26842 L
.20089 .27857 L
.20567 .26842 L
.21046 .25828 L
.21524 .24813 L
.22003 .25828 L
.22481 .24813 L
.2296 .23798 L
.23439 .22783 L
.23917 .21768 L
.24396 .22783 L
.24874 .21768 L
.25353 .22783 L
.25832 .23798 L
Mistroke
.2631 .22783 L
.26789 .23798 L
.27267 .24813 L
.27746 .25828 L
.28224 .26842 L
.28703 .25828 L
.29182 .24813 L
.2966 .23798 L
.30139 .22783 L
.30617 .23798 L
.31096 .24813 L
.31575 .25828 L
.32053 .24813 L
.32532 .23798 L
.3301 .24813 L
.33489 .25828 L
.33967 .24813 L
.34446 .23798 L
.34925 .22783 L
.35403 .23798 L
.35882 .22783 L
.3636 .23798 L
.36839 .22783 L
.37318 .23798 L
.37796 .24813 L
.38275 .25828 L
.38753 .26842 L
.39232 .25828 L
.3971 .24813 L
.40189 .25828 L
.40668 .26842 L
.41146 .27857 L
.41625 .28872 L
.42103 .29887 L
.42582 .30902 L
.43061 .29887 L
.43539 .28872 L
.44018 .27857 L
.44496 .26842 L
.44975 .25828 L
.45453 .24813 L
.45932 .23798 L
.46411 .22783 L
.46889 .23798 L
.47368 .22783 L
.47846 .21768 L
.48325 .22783 L
.48804 .21768 L
.49282 .22783 L
.49761 .21768 L
Mistroke
.50239 .20753 L
.50718 .19739 L
.51196 .18724 L
.51675 .19739 L
.52154 .18724 L
.52632 .17709 L
.53111 .18724 L
.53589 .19739 L
.54068 .20753 L
.54547 .19739 L
.55025 .18724 L
.55504 .17709 L
.55982 .16694 L
.56461 .17709 L
.56939 .18724 L
.57418 .19739 L
.57897 .18724 L
.58375 .19739 L
.58854 .18724 L
.59332 .19739 L
.59811 .18724 L
.6029 .19739 L
.60768 .20753 L
.61247 .19739 L
.61725 .18724 L
.62204 .17709 L
.62682 .18724 L
.63161 .19739 L
.6364 .20753 L
.64118 .19739 L
.64597 .20753 L
.65075 .19739 L
.65554 .18724 L
.66033 .17709 L
.66511 .18724 L
.6699 .17709 L
.67468 .18724 L
.67947 .17709 L
.68425 .18724 L
.68904 .17709 L
.69383 .18724 L
.69861 .19739 L
.7034 .18724 L
.70818 .17709 L
.71297 .16694 L
.71776 .15679 L
.72254 .16694 L
.72733 .15679 L
.73211 .14664 L
.7369 .15679 L
Mistroke
.74168 .14664 L
.74647 .1365 L
.75126 .12635 L
.75604 .1162 L
.76083 .10605 L
.76561 .0959 L
.7704 .08575 L
.77519 .07561 L
.77997 .08575 L
.78476 .0959 L
.78954 .08575 L
.79433 .07561 L
.79911 .08575 L
.8039 .0959 L
.80869 .10605 L
.81347 .0959 L
.81826 .08575 L
.82304 .07561 L
.82783 .06546 L
.83262 .05531 L
.8374 .06546 L
.84219 .05531 L
.84697 .04516 L
.85176 .05531 L
.85654 .06546 L
.86133 .05531 L
.86612 .06546 L
.8709 .05531 L
.87569 .04516 L
.88047 .03501 L
.88526 .02486 L
.89005 .03501 L
.89483 .04516 L
.89962 .03501 L
.9044 .04516 L
.90919 .05531 L
.91397 .04516 L
.91876 .03501 L
.92355 .02486 L
.92833 .01472 L
.93312 .02486 L
.9379 .03501 L
.94269 .04516 L
.94748 .05531 L
.95226 .04516 L
.95705 .05531 L
.96183 .06546 L
.96662 .07561 L
.9714 .06546 L
.97619 .05531 L
Mistroke
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{700.063, 432.688},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000:l0001/1000`40O003h00Oog^hog^h_W^h003o
NkSoNkRnNkP00?mk^?mk^;ik^000og^hog^h_W^h000MNkP00`00NkQk^03oNkSoNkRNNkP001ek^003
001k^7^h0?mk^?mk^9ik^0007G^h00<007^hNkP0og^hog^hWW^h000MNkP4003oNkSoNkRMNkP001ek
^003001k^7^h0?mk^?mk^9ik^0007G^h00<007^hNkP0og^hog^hWW^h000MNkP00`00NkQk^03oNkSo
NkRNNkP001ek^003001k^7^h0?mk^?mk^9ik^0007G^h00<007^hNkP0og^hog^hWW^h000MNkP00`00
NkQk^03oNkSoNkRNNkP001ek^003001k^7^h0?mk^?mk^6]k^003001k^7^h031k^0007G^h00<007^h
NkP0og^hog^hJg^h0P00<G^h000MNkP00`00NkQk^03oNkSoNkQZNkP00`00NkP0000aNkP001ek^003
001k^7^h0?mk^?mk^6Yk^004001k^7^h000`NkP001ek^003001k^7^h0?mk^?mk^6Uk^005001k^7^h
NkP0000`NkP001ek^003001k^7^h0?mk^?mk^6Uk^003001k^7^h009k^003001k^7^h02ek^0007G^h
00<007^hNkP0og^hog^hJ7^h00<007^hNkP00g^h00<007^hNkP0;G^h000MNkP4003oNkSoNkQ=NkP0
0`00NkQk^00GNkP00`00NkQk^004NkP00`00NkQk^00/NkP001ek^003001k^7^h0?mk^?mk^4ik^003
001k^7^h01Mk^003001k^7^h00Ak^003001k^7^h02ak^0007G^h00<007^hNkP0og^hog^hCG^h00<0
07^h00005g^h00<007^hNkP01W^h00<007^hNkP0:g^h000MNkP00`00NkQk^03oNkSoNkQ=NkP00`00
NkP0000GNkP00`00NkQk^006NkP00`00NkQk^00[NkP001ek^003001k^7^h0?mk^?mk^4ak^005001k
^7^hNkP0000ENkP00`00NkQk^008NkP00`00NkQk^00ZNkP001ek^003001k^7^h0?mk^?mk^4ak^005
001k^7^hNkP0000ENkP00`00NkQk^008NkP00`00NkQk^00ZNkP001ek^003001k^7^h0?mk^?mk^4]k
^003001k^7^h00=k^003001k^7^h015k^003001k^7^h00Yk^003001k^7^h02Uk^0007G^h00<007^h
NkP0og^hog^hBg^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP02W^h00<007^hNkP02W^h
00<007^hNkP0:G^h000MNkP00`00NkQk^03oNkSoNkQ:NkP00`00NkQk^004NkP00`00NkQk^003NkP2
000<NkP00`00NkQk^00:NkP00`00NkQk^00YNkP001ek^003001k^7^h0?mk^?mk^4Yk^003001k^7^h
00Ek^003001k^7^h009k^003001k^00000Yk^003001k^7^h00ak^003001k^7^h02Qk^0007G^h00<0
07^hNkP0og^hog^hBG^h00<007^hNkP01W^h00D007^hNkQk^000009k^003001k^7^h00Qk^003001k
^7^h00ak^003001k^7^h02Qk^0007G^h00<007^hNkP0og^hog^hBG^h00<007^hNkP01g^h00@007^h
NkP000=k^003001k^7^h00Ik^003001k^7^h00ik^003001k^7^h02Mk^0007G^h00<007^hNkP0og^h
og^hB7^h00<007^hNkP027^h00<007^h000017^h00<007^hNkP01W^h00<007^hNkP03W^h00<007^h
NkP09g^h000MNkP00`00NkQk^03oNkSoNkQ8NkP00`00NkQk^009NkP20005NkP00`00NkQk^004NkP0
0`00NkQk^00@NkP00`00NkQk^00VNkP001ek^0@00?mk^?mk^3=k^003001k^7^h011k^003001k^7^h
00Yk^003001k^7^h00Ak^003001k^7^h00Ak^003001k^7^h011k^003001k^7^h00Ak^003001k^7^h
00Yk^003001k^7^h019k^0007G^h00<007^hNkP0og^hog^h<g^h0P004W^h00<007^hNkP04G^h00<0
07^hNkP00g^h00<007^hNkP04W^h00<007^hNkP00g^h00<007^hNkP02W^h00<007^hNkP04W^h000M
NkP00`00NkQk^03oNkSoNkPcNkP00`00NkP0000@NkP00`00NkQk^00CNkP00`00NkQk^002NkP00`00
NkQk^00BNkP00`00NkQk^002NkP00`00NkP0000:NkP00`00NkP0000CNkP001ek^003001k^7^h0?mk
^?mk^39k^004001k^7^h000@NkP00`00NkQk^00CNkP01@00NkQk^7^h00005W^h00L007^hNkQk^000
NkP0000:NkP00`00NkP0000CNkP001ek^003001k^7^h0?mk^?mk^39k^005001k^7^hNkP0000>NkP0
0`00NkQk^00ENkP01000NkQk^0005W^h00@007^hNkP000=k^003001k^7^h00Ik^005001k^7^hNkP0
000BNkP001ek^003001k^7^h0?mk^?mk^35k^003001k^7^h009k^003001k^7^h00ak^003001k^7^h
01Ek^003001k^00001Qk^003001k^00000=k^003001k^7^h00Ik^005001k^7^hNkP0000BNkP001ek
^003001k^7^h0?mk^?mk^35k^003001k^7^h00=k^003001k^7^h00Yk^003001k^7^h01Mk^08001Qk
^08000Ek^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00mk^0007G^h00<007^hNkP0og^h
og^h:W^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^h
NkP05g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP02g^h00<007^hNkP00g^h00<007^h
NkP017^h00<007^hNkP00g^h00<007^hNkP03g^h000MNkP00`00NkQk^03oNkSoNkPZNkP00`00NkQk
^003NkP00`00NkQk^004NkP00`00NkQk^003NkP20005NkP00`00NkQk^00GNkP20005NkP00`00NkQk
^003NkP2000;NkP20005NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00?NkP001ek^003
001k^7^h0?mk^?mk^2Uk^003001k^00000=k^003001k^7^h00Ik^007001k^7^hNkP007^h000017^h
00<007^h00005g^h00<007^h000017^h00<007^h00000g^h00<007^h00002g^h00<007^h00001G^h
00<007^hNkP00W^h00<007^hNkP00g^h00<007^hNkP047^h000MNkP00`00NkQk^03oNkSoNkPYNkP0
0`00NkP00003NkP00`00NkQk^006NkP01@00NkQk^7^h00000W^h00L007^hNkQk^000NkP0000GNkP0
1000NkQk^0000g^h00<007^h00000g^h00@007^hNkP000Uk^004001k^7^h0005NkP01@00NkQk^7^h
00001W^h00<007^hNkP047^h000MNkP00`00NkQk^03oNkSoNkPXNkP01`00NkQk^7^h001k^00000Yk
^003001k^00000=k^004001k^7^h0003NkP00`00NkQk^00CNkP01@00NkQk^7^h00000W^h00L007^h
NkQk^000NkP00003NkP00`00NkQk^007NkP01@00NkQk^7^h00001G^h00@007^hNkP000Ek^003001k
^7^h015k^0007G^h00<007^hNkP0og^hog^h:7^h00L007^hNkQk^000NkP0000:NkP00`00NkP00004
NkP00`00NkP00003NkP00`00NkQk^00CNkP00`00NkQk^002NkP00`00NkP00003NkP00`00NkP00004
NkP00`00NkQk^005NkP00`00NkQk^002NkP00`00NkQk^003NkP00`00NkP00006NkP00`00NkQk^00A
NkP001ek^003001k^7^h0?mk^?mk^2Mk^003001k^7^h00=k^003001k^7^h00Yk^003001k^7^h00=k
^08000Ek^003001k^7^h015k^003001k^7^h00=k^08000Ek^003001k^7^h00=k^003001k^7^h00Ek
^003001k^7^h00=k^003001k^7^h00=k^08000Ek^003001k^7^h019k^0007G^h1000og^hog^h9W^h
00<007^hNkP00g^h00<007^hNkP02W^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP04G^h
00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h
00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP04W^h000MNkP00`00NkQk^03oNkSoNkPVNkP0
0`00NkQk^00ANkP00`00NkQk^00;NkP00`00NkQk^00@NkP00`00NkQk^00ANkP00`00NkQk^003NkP0
0`00NkQk^004NkP00`00NkQk^003NkP20005NkP00`00NkQk^00BNkP001ek^003001k^7^h0?mk^?mk
^2Ik^003001k^7^h011k^003001k^00000ak^003001k^7^h00mk^003001k^7^h01=k^005001k^7^h
NkP00008NkP01`00NkQk^7^h001k^00000Ak^003001k^7^h01=k^0007G^h00<007^hNkP0og^hog^h
9G^h00<007^hNkP04G^h00<007^h00003G^h00<007^hNkP03W^h00<007^hNkP04g^h00D007^hNkQk
^00000Qk^005001k^7^hNkP00002NkP01@00NkQk^7^h00005G^h000MNkP00`00NkQk^03oNkSoNkPU
NkP00`00NkQk^00@NkP01@00NkQk^7^h000037^h00<007^hNkP03G^h00<007^hNkP05G^h00<007^h
00002W^h00<007^h00000g^h00@007^hNkP001Ik^0007G^h00<007^hNkP0og^hog^h97^h00<007^h
NkP04G^h00D007^hNkQk^00000ek^003001k^7^h00ak^003001k^7^h01Ek^003001k^00000Yk^003
001k^00000Ak^003001k^00001Ik^0007G^h00<007^hNkP0og^hog^h97^h00<007^hNkP047^h00<0
07^hNkP00g^h00<007^hNkP02W^h00<007^hNkP02g^h00<007^hNkP05g^h00<007^hNkP02W^h00<0
07^hNkP00g^h0P005g^h000MNkP00`00NkQk^03oNkSoNkP2NkP00`00NkQk^00;NkP00`00NkQk^00@
NkP00`00NkQk^00:NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^004
NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00GNkP00`00NkQk^00:NkP00`00NkQk^004
NkP00`00NkQk^00ENkP001ek^003001k^7^h0?mk^?mk^09k^08000]k^080019k^003001k^7^h00Yk
^08000Ek^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00=k^08000Ek^003001k^7^h00=k
^08001Uk^003001k^7^h00Yk^003001k^7^h01ak^0007G^h00<007^hNkP0og^hog^h0G^h00<007^h
00002g^h00<007^h000047^h00<007^hNkP02W^h00<007^h000017^h00<007^hNkP01G^h00<007^h
NkP00W^h00<007^h000017^h00<007^h00000g^h00<007^h000017^h00<007^h00005g^h00<007^h
NkP037^h00<007^hNkP06g^h000MNkP00`00NkQk^03oNkSoNkP1NkP01000NkQk^0002G^h00@007^h
NkP0011k^003001k^7^h00Yk^004001k^7^h0003NkP00`00NkQk^006NkP01`00NkQk^7^h001k^000
00=k^004001k^7^h0003NkP00`00NkP00003NkP01000NkQk^0005g^h00<007^hNkP037^h00<007^h
NkP06g^h0009NkP40002NkP2000<NkP00`00NkQk^03oNkSoNkP01@00NkQk^7^h00002G^h00D007^h
NkQk^00000ik^003001k^7^h00Yk^005001k^7^hNkP00002NkP00`00NkQk^007NkP01000NkQk^000
0g^h00@007^hNkP000=k^003001k^00000=k^004001k^7^h0003NkP00`00NkQk^00CNkP00`00NkQk
^00>NkP00`00NkQk^00JNkP000Yk^005001k^000NkP00002NkP00`00NkQk^009NkP00`00NkQk^03o
NkSoNkP00`00NkQk^002NkP00`00NkQk^005NkP00`00NkQk^002NkP00`00NkQk^00<NkP00`00NkQk
^00:NkP00`00NkQk^002NkP00`00NkP0000:NkP00`00NkP00003NkP00`00NkP00004NkP00`00NkP0
0003NkP00`00NkP00004NkP00`00NkQk^00CNkP00`00NkQk^00>NkP00`00NkQk^00JNkP000=k^0@0
00Ak^004001k^7^h0002NkP00`00NkQk^009NkP00`00NkQk^03oNkSnNkP00`00NkQk^003NkP00`00
NkQk^005NkP00`00NkQk^003NkP00`00NkQk^00:NkP00`00NkQk^00:NkP00`00NkQk^003NkP2000;
NkP20005NkP20005NkP00`00NkQk^003NkP20005NkP00`00NkQk^00ANkP00`00NkQk^00@NkP00`00
NkQk^00INkP000ak^003001k^000009k^003001k^7^h00Uk^0D00?mk^?ak^003001k^7^h00Ak^003
001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Yk^003001k^7^h00Ak^003001k^7^h00=k^003
001k^7^h00Ak^003001k^7^h00Yk^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003
001k^7^h00Ak^003001k^7^h015k^003001k^7^h011k^003001k^7^h00Ak^003001k^7^h019k^000
37^h00<007^h00000W^h00<007^hNkP02G^h00<007^hNkP0og^hoW^h00<007^hNkP017^h00<007^h
NkP00g^h00<007^hNkP017^h00<007^hNkP02W^h00<007^hNkP00g^h0P001G^h00<007^hNkP07W^h
00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP047^h00<007^hNkP04W^h00<007^hNkP00g^h
00<007^hNkP04W^h0009NkP01P00NkQk^000NkP0009k^003001k^7^h00Uk^003001k^7^h0?mk^?ek
^003001k^7^h00Ik^005001k^7^hNkP00008NkP00`00NkQk^008NkP00`00NkQk^004NkP00`00NkP0
0003NkP00`00NkQk^00PNkP01@00NkQk^7^h000027^h00<007^hNkP03g^h00<007^hNkP04W^h00<0
07^hNkP00W^h00<007^h00004g^h000:NkP20003NkP2000<NkP00`00NkQk^03oNkSmNkP00`00NkQk
^006NkP01@00NkQk^7^h000027^h00<007^hNkP027^h00<007^hNkP00g^h00@007^hNkP000=k^003
001k^7^h021k^005001k^7^hNkP00008NkP00`00NkQk^00>NkP00`00NkQk^00DNkP01`00NkQk^7^h
001k^00001=k^0007G^h00<007^hNkP0og^ho7^h00<007^hNkP027^h00<007^h00002W^h00<007^h
NkP01W^h00<007^hNkP017^h00L007^hNkQk^000NkP0000TNkP00`00NkP0000:NkP00`00NkQk^00=
NkP00`00NkQk^00DNkP01000NkQk^0000g^h00<007^hNkP047^h000MNkP00`00NkQk^03oNkSlNkP0
0`00NkQk^008NkP00`00NkP0000:NkP00`00NkQk^006NkP00`00NkQk^003NkP00`00NkQk^002NkP0
0`00NkP0000TNkP00`00NkP0000:NkP00`00NkQk^00<NkP00`00NkQk^00FNkP00`00NkP00003NkP0
0`00NkQk^00@NkP001ek^003001k^7^h0?mk^?]k^003001k^7^h00Yk^003001k^7^h00Yk^003001k
^7^h00Ak^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h02Ak^003001k^7^h00Yk^003001k
^7^h00]k^003001k^7^h01Ik^08000Ek^003001k^7^h00mk^0007G^h00<007^hNkP0og^hng^h00<0
07^hNkP02W^h00<007^hNkP02W^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<0
07^hNkP047^h00<007^hNkP04G^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<0
07^hNkP00g^h00<007^hNkP067^h00<007^hNkP00g^h00<007^hNkP03g^h000MNkP00`00NkQk^03o
NkSjNkP00`00NkQk^00GNkP20005NkP20004NkP00`00NkQk^00GNkP00`00NkP0000ANkP20005NkP2
0004NkP00`00NkP00004NkP20004NkP00`00NkQk^00aNkP001ek^003001k^7^h0?mk^?Yk^003001k
^7^h01Mk^003001k^00000Ak^003001k^00000=k^003001k^7^h01Mk^003001k^000015k^003001k
^00000Ak^003001k^00000=k^003001k^00000Ak^003001k^00000=k^003001k^7^h035k^0007G^h
00<007^hNkP0og^hnG^h00<007^hNkP05g^h00@007^hNkP000=k^004001k^7^h0002NkP00`00NkQk
^00GNkP01@00NkQk^7^h00003g^h00@007^hNkP000=k^004001k^7^h0002NkP01@00NkQk^7^h0000
0W^h00@007^hNkP0009k^003001k^7^h039k^0007G^h00<007^hNkP0og^hnG^h00<007^hNkP05g^h
00L007^hNkQk^000NkP00004NkP00`00NkP0000INkP00`00NkQk^002NkP00`00NkQk^00<NkP01`00
NkQk^7^h001k^00000Ak^003001k^00000Ak^003001k^00000=k^003001k^00003Ak^0007G^h00<0
07^hNkP0og^hn7^h00<007^hNkP05g^h00<007^hNkP00W^h00<007^h000017^h0P006G^h00<007^h
NkP00g^h00<007^hNkP02g^h00<007^hNkP00W^h00<007^h000017^h0P001G^h0P0017^h0P00=G^h
000MNkP4003oNkSgNkP00`00NkQk^00GNkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00A
NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00:NkP00`00NkQk^003NkP00`00NkQk^004
NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^00cNkP001ek^003001k^7^h0?mk^?Mk^003
001k^7^h01Qk^003001k^7^h00Yk^003001k^7^h011k^08000Ek^003001k^7^h00Ak^003001k^7^h
00Yk^003001k^7^h015k^003001k^7^h03Uk^0007G^h00<007^hNkP0og^hmg^h00<007^hNkP05g^h
00<007^h00002W^h00<007^hNkP04G^h00<007^h00000g^h00<007^hNkP01W^h00<007^hNkP027^h
00<007^hNkP04g^h00<007^hNkP0>7^h000MNkP00`00NkQk^03oNkSfNkP00`00NkQk^00HNkP00`00
NkP0000:NkP00`00NkQk^00@NkP01000NkQk^0000g^h00<007^hNkP01W^h00<007^hNkP027^h00<0
07^hNkP04g^h00<007^hNkP0>7^h000MNkP00`00NkQk^03oNkSfNkP00`00NkQk^00GNkP01@00NkQk
^7^h000027^h00<007^hNkP04G^h00L007^hNkQk^000NkP0000:NkP00`00NkQk^006NkP00`00NkQk
^00ENkP00`00NkQk^00gNkP001ek^003001k^7^h0?mk^?Ek^003001k^7^h01Qk^005001k^7^hNkP0
0008NkP00`00NkQk^00@NkP00`00NkQk^002NkP00`00NkP0000:NkP00`00NkQk^006NkP00`00NkQk
^00ENkP00`00NkQk^00gNkP001ek^003001k^7^h0?mk^?Ek^003001k^7^h01Mk^003001k^7^h00=k
^003001k^7^h00Ak^003001k^7^h015k^003001k^7^h00=k^003001k^7^h00Yk^003001k^7^h00Ak
^003001k^7^h01Mk^003001k^7^h03Ik^0007G^h00<007^hNkP0og^hm7^h00<007^hNkP067^h00<0
07^hNkP00g^h00<007^hNkP017^h00<007^hNkP02W^h00<007^hNkP00g^h00<007^hNkP017^h00<0
07^hNkP02W^h00<007^hNkP017^h00<007^hNkP05g^h00<007^hNkP00g^h00<007^hNkP0<7^h000M
NkP00`00NkQk^03oNkSdNkP00`00NkQk^00GNkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk
^00;NkP00`00NkQk^003NkP00`00NkQk^00ANkP00`00NkQk^003NkP00`00NkQk^00HNkP00`00NkQk
^003NkP2000aNkP001ek^003001k^7^h0?mk^?=k^003001k^7^h01Qk^003001k^7^h00Ek^003001k
^7^h009k^003001k^7^h00Yk^003001k^00000=k^003001k^7^h01=k^003001k^7^h009k^003001k
^7^h01Uk^007001k^7^hNkP007^h0000<G^h000MNkP00`00NkQk^03oNkScNkP00`00NkQk^00GNkP0
0`00NkQk^006NkP01@00NkQk^7^h00003G^h00<007^h00000g^h00<007^hNkP04g^h00D007^hNkQk
^00001ak^005001k^7^hNkP00002NkP00`00NkQk^00^NkP001ek^003001k^7^h0?mk^?9k^003001k
^7^h01Qk^003001k^7^h00Mk^004001k^7^h000<NkP01`00NkQk^7^h001k^00001Mk^004001k^7^h
000MNkP00`00NkP00003NkP00`00NkQk^00^NkP001ek^003001k^7^h0?mk^?9k^003001k^7^h01Mk
^003001k^7^h00Qk^003001k^00000ek^007001k^7^hNkP007^h00005g^h00<007^h00007W^h00<0
07^h000017^h00<007^hNkP0;G^h000MNkP00`00NkQk^03oNkSaNkP00`00NkQk^00HNkP00`00NkQk
^009NkP2000<NkP00`00NkQk^003NkP00`00NkQk^00GNkP2000ONkP00`00NkQk^003NkP00`00NkQk
^00]NkP001ek^0@00?mk^?1k^003001k^7^h015k^003001k^7^h00=k^003001k^7^h00Yk^003001k
^7^h00]k^003001k^7^h00=k^003001k^7^h01Mk^003001k^7^h01ik^003001k^7^h00Ak^003001k
^7^h02ak^0007G^h00<007^hNkP0og^hlG^h00<007^hNkP047^h0P001G^h00<007^hNkP05g^h00<0
07^hNkP0AW^h00<007^hNkP0;7^h000MNkP00`00NkQk^03oNkS`NkP00`00NkQk^00ANkP00`00NkP0
0003NkP00`00NkQk^00HNkP00`00NkQk^017NkP00`00NkQk^00[NkP001ek^003001k^7^h0?mk^?1k
^003001k^7^h011k^004001k^7^h0003NkP00`00NkQk^00GNkP00`00NkQk^018NkP00`00NkQk^00[
NkP001ek^003001k^7^h0?mk^>mk^003001k^7^h015k^007001k^7^hNkP007^h00006W^h00<007^h
NkP0BG^h00<007^hNkP0:W^h000MNkP00`00NkQk^03oNkS_NkP00`00NkQk^00@NkP00`00NkQk^002
NkP00`00NkP0000INkP00`00NkQk^01:NkP00`00NkQk^00ZNkP001ek^003001k^7^h0?mk^>ik^003
001k^7^h015k^003001k^7^h00=k^003001k^7^h01Qk^003001k^7^h04]k^003001k^7^h02Uk^000
7G^h00<007^hNkP0L7^h00<007^hNkP0og^hDg^h00<007^hNkP04G^h00<007^hNkP017^h00<007^h
NkP00g^h00<007^hNkP017^h00<007^hNkP047^h00<007^hNkP017^h00<007^hNkP02W^h00<007^h
NkP02W^h00<007^hNkP0?g^h00<007^hNkP02W^h00<007^hNkP017^h00<007^hNkP08W^h000MNkP0
0`00NkQk^01`NkP00`00NkQk^03oNkQCNkP2000BNkP00`00NkQk^003NkP20005NkP00`00NkQk^003
NkP00`00NkQk^00ANkP00`00NkQk^004NkP00`00NkQk^00:NkP00`00NkQk^00:NkP00`00NkQk^00o
NkP00`00NkQk^00:NkP00`00NkQk^003NkP2000TNkP001ek^003001k^7^h06mk^003001k^0000?mk
^5=k^003001k^000015k^003001k^00000Ak^003001k^00000=k^003001k^00000Ak^003001k^7^h
011k^003001k^7^h00Ak^003001k^00000Yk^003001k^00000Yk^003001k^7^h03mk^003001k^000
00Yk^003001k^00000Ak^003001k^00002=k^0007G^h00<007^hNkP0Kg^h00<007^h0000og^hDg^h
00@007^hNkP0011k^003001k^00000=k^004001k^7^h0003NkP00`00NkP00003NkP00`00NkQk^00A
NkP00`00NkQk^004NkP00`00NkP0000:NkP00`00NkP0000:NkP00`00NkQk^00oNkP00`00NkP0000:
NkP00`00NkP00003NkP01000NkQk^0008g^h000MNkP00`00NkQk^01^NkP01@00NkQk^7^h0000og^h
DG^h00D007^hNkQk^00000mk^005001k^7^hNkP00002NkP01`00NkQk^7^h001k^00000=k^004001k
^7^h000BNkP00`00NkQk^004NkP01@00NkQk^7^h000027^h00D007^hNkQk^00000Qk^003001k^7^h
03mk^005001k^7^hNkP00008NkP01@00NkQk^7^h00000W^h00D007^hNkQk^000029k^0007G^h00<0
07^hNkP0KW^h00D007^hNkQk^0000?mk^55k^003001k^7^h009k^003001k^7^h00ak^007001k^7^h
NkP007^h000017^h00<007^h00000g^h00<007^h00004g^h00<007^hNkP017^h00D007^hNkQk^000
00Qk^005001k^7^hNkP00008NkP00`00NkQk^00oNkP01@00NkQk^7^h000027^h00L007^hNkQk^000
NkP00004NkP00`00NkQk^00PNkP001ek^003001k^7^h06ek^003001k^7^h00=k^003001k^7^h0?mk
^4ek^003001k^7^h00=k^003001k^7^h00]k^003001k^7^h00=k^08000Ek^003001k^7^h00=k^080
019k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h
00Ak^003001k^7^h03mk^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^08000Ek^003
001k^7^h01mk^0007G^h1000K7^h00<007^hNkP00g^h00<007^hNkP0FG^h00<007^hNkP017^h00<0
07^hNkP00g^h00<007^hNkP02W^h00<007^hNkP04G^h00<007^hNkP0SW^h00<007^hNkP05g^h00<0
07^hNkP00g^h00<007^hNkP017^h00<007^hNkP02W^h00<007^hNkP017^h00<007^hNkP02W^h00<0
07^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP02g^h00<007^hNkP00g^h00<0
07^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<0
07^hNkP0:g^h00<007^hNkP04G^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<0
07^hNkP017^h00<007^hNkP07g^h000MNkP00`00NkQk^01/NkP00`00NkQk^005NkP00`00NkQk^01H
NkP20005NkP00`00NkQk^003NkP2000;NkP2000BNkP00`00NkQk^02=NkP2000INkP00`00NkQk^003
NkP20005NkP00`00NkQk^00:NkP00`00NkQk^004NkP00`00NkQk^009NkP00`00NkQk^004NkP20005
NkP00`00NkQk^003NkP2000;NkP20005NkP00`00NkQk^003NkP00`00NkQk^005NkP00`00NkQk^003
NkP00`00NkQk^003NkP20005NkP00`00NkQk^00[NkP00`00NkQk^00@NkP00`00NkQk^004NkP00`00
NkQk^003NkP00`00NkQk^005NkP00`00NkQk^003NkP00`00NkQk^00ONkP001ek^003001k^7^h06ak
^003001k^7^h00Ek^003001k^7^h05Mk^003001k^00000Ak^003001k^00000=k^003001k^00000Yk
^003001k^000015k^003001k^00008ik^003001k^00001Mk^003001k^00000=k^003001k^00000Ak
^003001k^00000Yk^003001k^00000Ik^003001k^7^h00Qk^003001k^7^h00=k^003001k^00000Ak
^003001k^00000=k^003001k^00000]k^003001k^00000=k^003001k^00000Ak^003001k^7^h00Ek
^003001k^7^h009k^003001k^7^h00=k^003001k^00000Ak^003001k^00002]k^003001k^000015k
^003001k^7^h00Ek^003001k^7^h009k^003001k^7^h00Ek^003001k^7^h00Ak^003001k^7^h01ik
^0007G^h00<007^hNkP0Jg^h00<007^hNkP01g^h00<007^hNkP0EW^h00@007^hNkP000=k^003001k
^00000=k^004001k^7^h0009NkP01000NkQk^00047^h00<007^h0000SG^h00@007^hNkP001Mk^003
001k^00000=k^004001k^7^h0003NkP00`00NkP0000:NkP00`00NkP00006NkP00`00NkQk^007NkP0
0`00NkQk^004NkP01000NkQk^0000g^h00<007^h00000g^h00@007^hNkP000Uk^004001k^7^h0003
NkP00`00NkP00003NkP00`00NkQk^007NkP01@00NkQk^7^h00001G^h00@007^hNkP000=k^003001k
^00002]k^003001k^000011k^003001k^7^h00Ik^005001k^7^hNkP00009NkP00`00NkQk^003NkP0
0`00NkQk^00NNkP001ek^003001k^7^h06]k^003001k^7^h00Mk^003001k^7^h05Ek^005001k^7^h
NkP00002NkP01`00NkQk^7^h001k^00000=k^003001k^7^h00Ik^005001k^7^hNkP0000?NkP01@00
NkQk^7^h0000S7^h00D007^hNkQk^00001Ek^007001k^7^hNkP007^h00000g^h00@007^hNkP000=k
^003001k^7^h00Ik^005001k^7^hNkP00006NkP00`00NkQk^006NkP00`00NkQk^003NkP01@00NkQk
^7^h00000W^h00L007^hNkQk^000NkP00003NkP00`00NkQk^007NkP01`00NkQk^7^h001k^00000=k
^004001k^7^h0009NkP01000NkQk^0001G^h00D007^hNkQk^000009k^005001k^7^hNkP0000YNkP0
1@00NkQk^7^h00003g^h00<007^hNkP01g^h00@007^hNkP000Uk^003001k^7^h00Ak^003001k^7^h
01ek^0007G^h00<007^hNkP0JW^h00<007^hNkP02G^h00<007^hNkP0E7^h00<007^hNkP00W^h00<0
07^h00000g^h00<007^h000017^h00<007^hNkP01G^h00<007^hNkP00W^h00<007^hNkP037^h00D0
07^hNkQk^00008]k^003001k^7^h009k^003001k^7^h01=k^007001k^7^hNkP007^h000017^h00<0
07^h00000g^h00<007^hNkP01W^h00D007^hNkQk^00000Ik^003001k^7^h00Ek^003001k^7^h00Ak
^003001k^7^h009k^003001k^00000=k^003001k^00000Ak^003001k^7^h00Ek^003001k^7^h009k
^003001k^00000=k^003001k^00000]k^003001k^00000Ek^003001k^7^h009k^003001k^00000=k
^003001k^7^h02Mk^005001k^7^hNkP0000>NkP00`00NkQk^008NkP00`00NkP0000;NkP00`00NkQk
^003NkP00`00NkQk^00MNkP001ek^003001k^7^h06Yk^003001k^7^h00Uk^003001k^7^h05=k^003
001k^7^h00=k^08000Ek^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h
00]k^003001k^7^h00=k^003001k^7^h08Qk^003001k^7^h00=k^003001k^7^h015k^003001k^7^h
00=k^003001k^7^h00=k^08000Ek^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003
001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00=k^08000Ek^003001k^7^h00=k^003001k^7^h
00Ek^003001k^7^h00=k^003001k^7^h00=k^08000]k^08000Ek^003001k^7^h00=k^08000Ek^003
001k^7^h02Ek^003001k^7^h00=k^003001k^7^h00]k^003001k^7^h00Uk^08000]k^003001k^7^h
00Ak^003001k^7^h01ak^0007G^h00<007^hNkP0JG^h00<007^hNkP02g^h00<007^hNkP047^h00<0
07^hNkP017^h00<007^hNkP0>7^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<0
07^hNkP00g^h00<007^hNkP017^h00<007^hNkP02W^h00<007^hNkP00g^h00<007^hNkP0:g^h00<0
07^hNkP067^h00<007^hNkP0?W^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<0
07^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<0
07^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP017^h00<0
07^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<0
07^hNkP02g^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP09G^h00<0
07^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<0
07^hNkP017^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<0
07^hNkP03g^h000MNkP00`00NkQk^01YNkP00`00NkQk^00;NkP00`00NkQk^00@NkP20005NkP00`00
NkQk^00hNkP00`00NkQk^00ANkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00:NkP00`00
NkQk^004NkP00`00NkQk^00ZNkP2000HNkP20010NkP00`00NkQk^004NkP00`00NkQk^003NkP20005
NkP00`00NkQk^003NkP00`00NkQk^00ANkP00`00NkQk^003NkP20005NkP20005NkP00`00NkQk^003
NkP20005NkP00`00NkQk^003NkP20005NkP00`00NkQk^003NkP20005NkP00`00NkQk^004NkP00`00
NkQk^004NkP00`00NkQk^00@NkP00`00NkQk^00;NkP00`00NkQk^00SNkP00`00NkQk^004NkP00`00
NkQk^003NkP20005NkP20005NkP00`00NkQk^003NkP20005NkP00`00NkQk^004NkP00`00NkQk^003
NkP00`00NkQk^003NkP20005NkP00`00NkQk^00?NkP001ek^003001k^7^h06Qk^003001k^7^h00ek
^003001k^7^h00ik^003001k^00000Ak^003001k^00003Qk^003001k^7^h01=k^005001k^7^hNkP0
0008NkP00`00NkQk^008NkP00`00NkQk^005NkP00`00NkQk^00YNkP00`00NkP0000HNkP00`00NkP0
000nNkP00`00NkQk^006NkP01`00NkQk^7^h001k^00000Ak^003001k^00000Ak^003001k^7^h019k
^003001k^7^h009k^003001k^00000=k^003001k^00000Ik^007001k^7^hNkP007^h000017^h00<0
07^h000017^h00<007^h00001G^h00<007^hNkP00W^h00<007^h00000g^h00<007^hNkP017^h00<0
07^hNkP01G^h00<007^hNkP03g^h00<007^hNkP037^h00<007^hNkP08g^h00<007^hNkP01G^h00<0
07^hNkP00W^h00<007^h00000g^h00<007^h000017^h00<007^h00000g^h00<007^h000017^h00<0
07^h00001W^h00<007^hNkP00g^h00<007^hNkP00W^h00<007^h00000g^h00<007^hNkP047^h000M
NkP00`00NkQk^01XNkP00`00NkQk^00=NkP00`00NkQk^00>NkP01000NkQk^0000g^h00<007^h0000
>7^h00<007^hNkP04g^h00D007^hNkQk^00000Qk^003001k^7^h00Qk^003001k^7^h00Ik^003001k
^7^h02Qk^004001k^7^h000FNkP01000NkQk^000?W^h00<007^hNkP01W^h00D007^hNkQk^000009k
^007001k^7^hNkP007^h00000g^h00<007^hNkP04g^h00D007^hNkQk^000009k^005001k^7^hNkP0
0002NkP00`00NkQk^003NkP01@00NkQk^7^h00000W^h00L007^hNkQk^000NkP00003NkP01000NkQk
^0001G^h00D007^hNkQk^000009k^005001k^7^hNkP00006NkP00`00NkQk^006NkP00`00NkQk^00>
NkP00`00NkQk^00=NkP00`00NkQk^00QNkP00`00NkQk^006NkP01@00NkQk^7^h00000W^h00D007^h
NkQk^000009k^007001k^7^hNkP007^h00000g^h00@007^hNkP000=k^003001k^00000Ik^003001k
^7^h00=k^005001k^7^hNkP00002NkP01@00NkQk^7^h00004W^h000MNkP00`00NkQk^01WNkP00`00
NkQk^00?NkP00`00NkQk^00<NkP01@00NkQk^7^h00000W^h00D007^hNkQk^00003Ik^003001k^7^h
01Ek^003001k^00000Yk^003001k^7^h00Ik^003001k^7^h00Mk^003001k^7^h02Mk^005001k^7^h
NkP0000FNkP01@00NkQk^7^h0000?7^h00<007^hNkP027^h00<007^h00000g^h00@007^hNkP000=k
^004001k^7^h000FNkP01000NkQk^0000g^h00<007^h00000g^h00<007^hNkP017^h00<007^h0000
0g^h00@007^hNkP000=k^004001k^7^h0003NkP00`00NkQk^003NkP01000NkQk^0000g^h00<007^h
00001W^h00<007^hNkP01g^h00<007^hNkP03G^h00<007^hNkP03W^h00<007^hNkP08G^h00<007^h
NkP01g^h00@007^hNkP000=k^003001k^00000=k^004001k^7^h0003NkP00`00NkP00003NkP01000
NkQk^0000g^h00<007^hNkP017^h00<007^hNkP00g^h00@007^hNkP000=k^003001k^00001=k^000
7G^h00<007^hNkP0Ig^h00<007^hNkP03g^h00<007^hNkP037^h00<007^hNkP00W^h00<007^h0000
0g^h00<007^hNkP0=7^h00<007^hNkP05G^h00<007^h00002W^h00<007^hNkP01W^h00<007^hNkP0
27^h00<007^hNkP09W^h00<007^hNkP00W^h00<007^hNkP04W^h00<007^hNkP00W^h00<007^hNkP0
>W^h00<007^hNkP027^h00<007^h000017^h00<007^h00000g^h00<007^h00005g^h00<007^h0000
17^h00<007^h000017^h00<007^hNkP00g^h00<007^h000017^h00<007^h00000g^h00<007^h0000
17^h00<007^hNkP00g^h00<007^h000017^h00<007^h00001W^h00<007^hNkP027^h00<007^hNkP0
37^h00<007^hNkP03g^h00<007^hNkP07g^h00<007^hNkP027^h00<007^h000017^h00<007^h0000
17^h00<007^h00000g^h00<007^h000017^h00<007^h00000g^h00<007^hNkP017^h00<007^hNkP0
0g^h00<007^h000017^h00<007^h00004g^h000MNkP00`00NkQk^01VNkP00`00NkQk^00ANkP00`00
NkQk^00:NkP00`00NkQk^003NkP20005NkP00`00NkQk^00bNkP00`00NkQk^00GNkP00`00NkQk^00:
NkP00`00NkQk^004NkP00`00NkQk^009NkP00`00NkQk^00UNkP00`00NkQk^003NkP00`00NkQk^00B
NkP00`00NkQk^003NkP00`00NkQk^00hNkP00`00NkQk^00:NkP00`00NkQk^003NkP20005NkP2000H
NkP20005NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP20005NkP20005NkP00`00
NkQk^003NkP20005NkP00`00NkQk^004NkP00`00NkQk^009NkP00`00NkQk^00;NkP00`00NkQk^00@
NkP00`00NkQk^00ONkP00`00NkQk^009NkP20005NkP00`00NkQk^003NkP20005NkP00`00NkQk^003
NkP20005NkP00`00NkQk^004NkP00`00NkQk^003NkP20005NkP00`00NkQk^00BNkP001ek^0@0059k
^003001k^7^h00=k^003001k^7^h00Yk^003001k^7^h015k^003001k^7^h00Yk^003001k^7^h00Ak
^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h011k^003001k^7^h01Qk^003001k^7^h01Mk
^003001k^7^h00Yk^003001k^7^h00Ak^003001k^7^h00Yk^003001k^7^h02Ak^003001k^7^h00Ak
^003001k^7^h00=k^003001k^7^h00Yk^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h01Qk
^003001k^7^h011k^003001k^7^h00Ak^003001k^7^h00Yk^003001k^7^h00Ak^003001k^7^h00=k
^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak
^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak
^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Ak^003001k^7^h00Yk^003001k^7^h00=k
^003001k^7^h00Ak^003001k^7^h015k^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Yk
^003001k^7^h00=k^003001k^7^h00Yk^003001k^7^h00Ak^003001k^7^h00Ak^003001k^7^h00=k
^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak
^003001k^7^h019k^0007G^h00<007^hNkP0DW^h0P001G^h00<007^hNkP02W^h00<007^hNkP04G^h
00<007^hNkP02W^h00<007^hNkP02W^h00<007^hNkP00g^h0P004W^h0P0067^h00<007^hNkP09G^h
00<007^hNkP00g^h00<007^hNkP02g^h00<007^hNkP097^h00<007^hNkP017^h00<007^hNkP00g^h
0P002g^h00<007^hNkP017^h00<007^hNkP00g^h0P0067^h0P004W^h0P001G^h00<007^hNkP02W^h
00<007^hNkP00g^h00<007^hNkP01G^h00<007^hNkP00g^h00<007^hNkP00g^h0P001G^h00<007^h
NkP00g^h00<007^hNkP02W^h0P001G^h00<007^hNkP00g^h0P001G^h0P001G^h00<007^hNkP00g^h
0P001G^h00<007^hNkP00g^h00<007^hNkP02g^h00<007^hNkP00g^h0P001G^h00<007^hNkP04G^h
00<007^hNkP00g^h00<007^hNkP00g^h0P002g^h0P001G^h00<007^hNkP02W^h00<007^hNkP02W^h
00<007^hNkP017^h00<007^hNkP00g^h0P001W^h00<007^hNkP00g^h00<007^hNkP07g^h000MNkP0
0`00NkQk^01BNkP00`00NkP00003NkP00`00NkP0000:NkP00`00NkQk^00CNkP00`00NkQk^008NkP0
0`00NkQk^00<NkP00`00NkQk^002NkP00`00NkP0000@NkP00`00NkP0000HNkP00`00NkQk^00VNkP0
0`00NkQk^002NkP00`00NkQk^00<NkP00`00NkQk^00RNkP00`00NkP00006NkP01`00NkQk^7^h001k
^00000Yk^003001k^7^h00Ik^007001k^7^hNkP007^h000067^h00<007^h000047^h00<007^h0000
17^h00<007^h00002W^h00<007^h000017^h00<007^hNkP01G^h00<007^hNkP00W^h00<007^h0000
0g^h00<007^h000017^h00<007^h00000g^h00<007^hNkP02g^h00<007^h00000g^h00<007^h0000
17^h00<007^h00000g^h00<007^h000017^h00<007^h00000g^h00<007^h000017^h00<007^h0000
17^h00<007^hNkP037^h00L007^hNkQk^000NkP00004NkP00`00NkQk^00CNkP01`00NkQk^7^h001k
^00000Ak^003001k^00000Yk^003001k^00000=k^003001k^7^h00Yk^003001k^7^h00]k^003001k
^7^h00Ek^003001k^7^h009k^003001k^00000Ek^003001k^7^h00Ak^003001k^7^h01ik^0007G^h
00<007^hNkP0DG^h00@007^hNkP000=k^003001k^00000Yk^003001k^7^h01=k^003001k^7^h00Qk
^003001k^7^h00ak^005001k^7^hNkP00002NkP00`00NkQk^00>NkP01000NkQk^0005W^h00<007^h
NkP09g^h00D007^hNkQk^00000mk^003001k^7^h029k^003001k^00000Ik^005001k^7^hNkP00002
NkP00`00NkQk^007NkP00`00NkQk^006NkP01@00NkQk^7^h00000W^h00<007^hNkP057^h00@007^h
NkP0011k^004001k^7^h0003NkP00`00NkP0000:NkP00`00NkP00003NkP00`00NkQk^007NkP01`00
NkQk^7^h001k^00000=k^004001k^7^h0003NkP00`00NkP00003NkP00`00NkQk^00:NkP01000NkQk
^0000g^h00<007^h00000g^h00@007^hNkP000=k^004001k^7^h0003NkP00`00NkP00003NkP01000
NkQk^0000g^h00<007^h00000g^h00<007^hNkP03G^h00D007^hNkQk^000009k^005001k^7^hNkP0
000ENkP01`00NkQk^7^h001k^00000=k^004001k^7^h0009NkP01000NkQk^0000g^h00<007^hNkP0
2W^h00<007^hNkP02W^h00<007^hNkP01W^h00D007^hNkQk^000009k^003001k^7^h00Ak^003001k
^7^h00=k^003001k^7^h01ik^0007G^h00<007^hNkP0DG^h00L007^hNkQk^000NkP00003NkP00`00
NkQk^006NkP00`00NkQk^00ENkP00`00NkQk^006NkP00`00NkQk^00>NkP01000NkQk^0000g^h00<0
07^hNkP037^h00D007^hNkQk^00001Ik^003001k^7^h02Qk^004001k^7^h000@NkP00`00NkQk^00P
NkP01@00NkQk^7^h00001W^h00<007^h00000g^h00<007^hNkP01W^h00<007^hNkP027^h00<007^h
00000g^h00<007^hNkP057^h00D007^hNkQk^00000ik^005001k^7^hNkP00002NkP01@00NkQk^7^h
000027^h00D007^hNkQk^000009k^003001k^7^h00Mk^004001k^7^h0003NkP00`00NkP00003NkP0
1000NkQk^0000g^h00<007^h00003G^h00L007^hNkQk^000NkP00003NkP01000NkQk^0000g^h00<0
07^h00000g^h00@007^hNkP000=k^003001k^00000=k^004001k^7^h0003NkP01000NkQk^00047^h
00<007^h00000g^h00@007^hNkP001Mk^003001k^00000=k^004001k^7^h0003NkP00`00NkQk^006
NkP01`00NkQk^7^h001k^00000ak^003001k^7^h00]k^003001k^7^h00Mk^004001k^7^h0003NkP0
0`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00MNkP001ek^003001k^7^h051k^003001k^7^h
009k^003001k^00000=k^003001k^7^h00Ik^003001k^7^h01Ek^003001k^7^h00Ik^003001k^7^h
00ik^003001k^00000Ak^003001k^7^h00ak^003001k^7^h009k^003001k^7^h019k^003001k^7^h
02Uk^003001k^000015k^003001k^7^h021k^005001k^7^hNkP00006NkP00`00NkP00004NkP00`00
NkQk^005NkP00`00NkQk^008NkP00`00NkP00004NkP00`00NkQk^00BNkP00`00NkQk^002NkP00`00
NkQk^00<NkP00`00NkQk^002NkP00`00NkP00003NkP00`00NkQk^006NkP01`00NkQk^7^h001k^000
00]k^003001k^00000=k^003001k^00000Ak^003001k^00000=k^003001k^00000ak^003001k^7^h
009k^003001k^00000=k^003001k^00000Ak^003001k^00000Ak^003001k^00000=k^003001k^000
00Ak^003001k^00000=k^003001k^000015k^003001k^00000Ak^003001k^00001Mk^003001k^000
00=k^003001k^00000Ak^003001k^7^h00Ek^003001k^7^h009k^003001k^00000ak^003001k^7^h
00Yk^003001k^7^h00Qk^003001k^00000Ak^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h
01ek^0007G^h00<007^hNkP0D7^h00<007^hNkP00g^h00<007^hNkP00g^h00<007^hNkP017^h00<0
07^hNkP05g^h00<007^hNkP017^h00<007^hNkP047^h0P001G^h00<007^hNkP02W^h00<007^hNkP0
0g^h00<007^hNkP04W^h00<007^hNkP0:W^h0P004W^h00<007^hNkP07W^h00<007^hNkP00g^h00<0
07^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP02W^h00<007^hNkP00g^h00<0
07^hNkP04W^h00<007^hNkP00g^h00<007^hNkP02W^h00<007^hNkP00g^h0P001G^h00<007^hNkP0
17^h00<007^hNkP00g^h0P002g^h0P001G^h00<007^hNkP00g^h0P001G^h00<007^hNkP02g^h00<0
07^hNkP00g^h00<007^hNkP00g^h0P001G^h00<007^hNkP00g^h0P001G^h00<007^hNkP00g^h0P00
1G^h0P004W^h00<007^hNkP00g^h0P006G^h00<007^hNkP00g^h0P001G^h00<007^hNkP017^h00<0
07^hNkP00g^h00<007^hNkP02W^h00<007^hNkP02g^h00<007^hNkP02G^h0P001G^h00<007^hNkP0
0g^h00<007^hNkP017^h00<007^hNkP077^h000MNkP00`00NkQk^019NkP00`00NkQk^003NkP00`00
NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00GNkP00`00NkQk^004NkP00`00
NkQk^00:NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00
NkQk^004NkP00`00NkQk^00@NkP00`00NkQk^00ANkP00`00NkQk^00GNkP00`00NkQk^00ANkP00`00
NkQk^004NkP00`00NkQk^00GNkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^004NkP00`00
NkQk^003NkP00`00NkQk^00:NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^00:NkP00`00
NkQk^004NkP00`00NkQk^00:NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00
NkQk^003NkP00`00NkQk^00;NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00
NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00
NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^00ANkP00`00
NkQk^004NkP00`00NkQk^00GNkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00
NkQk^004NkP00`00NkQk^00:NkP00`00NkQk^00:NkP00`00NkQk^00:NkP00`00NkQk^004NkP00`00
NkQk^004NkP00`00NkQk^003NkP00`00NkQk^00LNkP001ek^003001k^7^h04Qk^08000Ek^003001k
^7^h00]k^003001k^7^h00=k^003001k^7^h01Mk^003001k^7^h00=k^003001k^7^h00]k^003001k
^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^08000Ek^003001k^7^h00Ak^003001k^7^h011k
^003001k^7^h015k^003001k^7^h02]k^003001k^7^h00=k^08001Uk^003001k^7^h00Ak^003001k
^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h011k^08000Ek^08000]k^003001k
^7^h00Ak^003001k^7^h00Yk^003001k^7^h00]k^003001k^7^h00=k^003001k^7^h00=k^08000]k
^08000Ek^003001k^7^h00=k^08000Ek^003001k^7^h00=k^08000Ek^08000Ek^003001k^7^h00=k
^003001k^7^h01Qk^003001k^7^h00=k^003001k^7^h03mk^003001k^7^h00=k^08000Ek^003001k
^7^h00Yk^003001k^7^h00Yk^003001k^7^h015k^003001k^7^h00Ak^003001k^7^h00=k^003001k
^7^h01ak^0007G^h00<007^hNkP0B7^h00<007^h00000g^h00<007^hNkP037^h00<007^hNkP00W^h
00<007^hNkP06G^h00<007^hNkP00W^h00<007^hNkP02W^h00<007^h00000g^h00<007^hNkP01W^h
00<007^hNkP00W^h00<007^h00000g^h00<007^hNkP01W^h00<007^hNkP03W^h00<007^hNkP04G^h
00<007^h0000;G^h00<007^hNkP00W^h00<007^h00005g^h00<007^hNkP01G^h00<007^hNkP00W^h
00<007^h00001W^h00D007^hNkQk^00001=k^003001k^00000=k^003001k^00000Yk^003001k^7^h
00Ik^003001k^7^h00Qk^003001k^7^h00ak^003001k^7^h009k^003001k^7^h00=k^003001k^000
00]k^003001k^00000=k^003001k^00000Ak^003001k^00000=k^003001k^00000Ak^003001k^000
00=k^003001k^00000Ik^005001k^7^hNkP0000LNkP01@00NkQk^7^h0000@g^h00L007^hNkQk^000
NkP00004NkP00`00NkP0000:NkP00`00NkQk^00:NkP00`00NkQk^00CNkP00`00NkQk^004NkP00`00
NkQk^003NkP00`00NkQk^00KNkP001ek^003001k^7^h04Mk^004001k^7^h0003NkP00`00NkQk^00=
NkP01@00NkQk^7^h00006g^h00D007^hNkQk^00000ek^003001k^00000=k^003001k^7^h00Ik^005
001k^7^hNkP00002NkP01@00NkQk^7^h000027^h00<007^hNkP03W^h00<007^hNkP04G^h00<007^h
0000;G^h00D007^hNkQk^000009k^003001k^7^h01Ek^003001k^7^h00Ik^007001k^7^hNkP007^h
00001W^h00D007^hNkQk^000019k^004001k^7^h0003NkP01000NkQk^0002G^h00<007^hNkP01W^h
00<007^hNkP027^h00<007^hNkP03G^h00D007^hNkQk^00000Ek^004001k^7^h0009NkP01000NkQk
^0000g^h00<007^h00000g^h00@007^hNkP000=k^003001k^00000=k^004001k^7^h0003NkP01000
NkQk^0001G^h00D007^hNkQk^00001ak^005001k^7^hNkP00013NkP01@00NkQk^7^h00000W^h00L0
07^hNkQk^000NkP0000:NkP00`00NkQk^00:NkP00`00NkQk^00CNkP00`00NkQk^004NkP00`00NkQk
^003NkP00`00NkQk^00KNkP001ek^003001k^7^h04Mk^007001k^7^hNkP007^h000047^h00@007^h
NkP001ek^004001k^7^h000<NkP01`00NkQk^7^h001k^00000Yk^004001k^7^h0003NkP00`00NkP0
000:NkP00`00NkQk^00<NkP00`00NkQk^00ANkP01@00NkQk^7^h0000;G^h00@007^hNkP000=k^003
001k^7^h01=k^003001k^7^h00Mk^004001k^7^h0003NkP00`00NkQk^004NkP00`00NkP0000CNkP0
1`00NkQk^7^h001k^00000=k^003001k^7^h00Ik^003001k^7^h00Qk^003001k^7^h00Ik^003001k
^7^h00ik^004001k^7^h0005NkP01@00NkQk^7^h00002G^h00L007^hNkQk^000NkP00003NkP01000
NkQk^0000g^h00<007^h00000g^h00@007^hNkP000=k^003001k^00000=k^003001k^7^h00Ak^003
001k^00001ik^003001k^00004Ek^003001k^00000=k^004001k^7^h0003NkP00`00NkQk^006NkP0
0`00NkQk^00:NkP00`00NkQk^00ENkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^00JNkP0
00Yk^0<0009k^08000ak^003001k^7^h04Ik^003001k^7^h009k^003001k^000015k^003001k^000
01ek^003001k^00000ek^007001k^7^hNkP007^h00002W^h00<007^h000017^h00<007^h00002W^h
00<007^hNkP037^h00<007^hNkP04G^h00D007^hNkQk^00002ek^003001k^00000Ak^003001k^7^h
01=k^003001k^7^h00Qk^003001k^00000=k^003001k^7^h00Ak^003001k^000019k^003001k^7^h
009k^003001k^00000Ak^003001k^7^h00Ek^003001k^7^h00Qk^003001k^7^h00Ik^003001k^7^h
00mk^003001k^00000Ek^003001k^7^h009k^003001k^7^h00Ek^003001k^7^h009k^003001k^000
00=k^003001k^00000Ak^003001k^00000=k^003001k^00000Ak^003001k^00000Ak^003001k^7^h
00=k^003001k^00001ik^003001k^00004Ek^003001k^00000Ak^003001k^00000=k^003001k^7^h
00Ik^003001k^7^h00Yk^003001k^7^h01Ek^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h
01Yk^0002g^h00@007^hNkP0009k^003001k^7^h00Uk^003001k^7^h04Ik^003001k^7^h00=k^003
001k^7^h011k^08001mk^08000ak^003001k^7^h00=k^003001k^7^h00Yk^08000Ek^003001k^7^h
00Yk^003001k^7^h00Yk^003001k^7^h015k^003001k^7^h00=k^003001k^7^h02]k^08000Ek^003
001k^7^h015k^003001k^7^h00Uk^08000Ek^003001k^7^h00Ak^003001k^7^h015k^003001k^7^h
00=k^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Yk^003001k^7^h00Ak^003001k^7^h
011k^08000Ek^003001k^7^h00=k^003001k^7^h00Ek^003001k^7^h00=k^003001k^7^h00=k^080
00Ek^003001k^7^h00=k^08000Ek^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h01ik^003
001k^7^h04Ek^003001k^7^h00=k^08000Ek^003001k^7^h00Ak^003001k^7^h00Yk^003001k^7^h
01Mk^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h01Uk^0000g^h100017^h00@007^hNkP0
009k^003001k^7^h00Uk^0D004=k^003001k^7^h00Ak^003001k^7^h015k^003001k^7^h01Mk^003
001k^7^h00=k^003001k^7^h00]k^003001k^7^h00=k^003001k^7^h00Yk^003001k^7^h00Ak^003
001k^7^h00Yk^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003
001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h02Ak^003001k^7^h00Ak^003
001k^7^h00Yk^003001k^7^h00Ak^003001k^7^h00Yk^003001k^7^h00=k^003001k^7^h00Ak^003
001k^7^h00Yk^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Ak^003001k^7^h00=k^003
001k^7^h00Yk^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Ak^003
001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003
001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Ak^003001k^7^h00=k^003
001k^7^h01ik^003001k^7^h02Ak^003001k^7^h015k^003001k^7^h00Ak^003001k^7^h00=k^003
001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Yk^003001k^7^h01Mk^003
001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h019k^0002g^h00@007^hNkP0
009k^003001k^7^h00Uk^003001k^7^h04Ek^003001k^7^h039k^003001k^7^h011k^003001k^7^h
019k^003001k^7^h011k^003001k^7^h00=k^08000Ek^003001k^7^h00=k^08000Ek^08000Ek^003
001k^7^h00Ak^003001k^7^h00=k^003001k^7^h02]k^003001k^7^h00Yk^003001k^7^h00=k^003
001k^7^h019k^003001k^7^h011k^003001k^7^h00=k^08000Ek^003001k^7^h00Ak^003001k^7^h
00=k^003001k^7^h00]k^003001k^7^h00=k^003001k^7^h00=k^08000Ek^003001k^7^h00=k^080
00Ek^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^08000Ek^003
001k^7^h00=k^08000Ek^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h04Ek^080019k^003
001k^7^h00=k^08000Ek^003001k^7^h00]k^003001k^7^h00=k^003001k^7^h00Yk^003001k^7^h
01Qk^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h019k^0002g^h00@0
07^hNkP0009k^003001k^7^h00Uk^003001k^7^h04Ak^003001k^7^h039k^003001k^000015k^003
001k^7^h019k^003001k^7^h015k^003001k^7^h009k^003001k^00000=k^003001k^7^h00Ak^003
001k^00000=k^003001k^00000Ak^003001k^7^h00Ek^003001k^7^h009k^003001k^00002]k^003
001k^00000Yk^003001k^00000Ak^003001k^7^h019k^003001k^7^h00mk^003001k^00000=k^003
001k^00000Ak^003001k^00000Ik^005001k^7^hNkP0000>NkP00`00NkQk^002NkP00`00NkP00003
NkP00`00NkP00004NkP00`00NkP00004NkP00`00NkP00003NkP00`00NkQk^006NkP01@00NkQk^7^h
00001W^h00<007^h00000g^h00<007^h000017^h00<007^h00000g^h00<007^h000017^h00<007^h
NkP01W^h00D007^hNkQk^00004Mk^003001k^000015k^003001k^00000Ak^003001k^00000=k^003
001k^7^h00ak^003001k^7^h009k^003001k^7^h00Yk^003001k^7^h01Uk^003001k^7^h00Ak^003
001k^7^h00=k^003001k^7^h009k^003001k^00001=k^0002g^h00@007^hNkP0009k^003001k^7^h
00Uk^003001k^7^h04Ak^003001k^7^h039k^003001k^000011k^003001k^7^h01Ak^003001k^7^h
011k^005001k^7^hNkP00002NkP01@00NkQk^7^h00001G^h00@007^hNkP000=k^004001k^7^h0003
NkP00`00NkQk^006NkP01`00NkQk^7^h001k^00002]k^003001k^00000Yk^003001k^00000=k^003
001k^7^h01Ak^003001k^7^h00ik^003001k^00000=k^004001k^7^h0003NkP00`00NkP00006NkP0
1@00NkQk^7^h00003g^h00L007^hNkQk^000NkP00003NkP01000NkQk^0000g^h00<007^h00000g^h
00@007^hNkP000=k^003001k^7^h00Ik^005001k^7^hNkP00006NkP00`00NkP00003NkP01000NkQk
^0000g^h00<007^h00000g^h00@007^hNkP000=k^003001k^7^h00Ik^005001k^7^hNkP00017NkP0
1000NkQk^00047^h00<007^h00000g^h00@007^hNkP000=k^003001k^7^h00ek^005001k^7^hNkP0
000<NkP00`00NkQk^00JNkP00`00NkQk^003NkP00`00NkQk^004NkP01`00NkQk^7^h001k^00001=k
^0002W^h0P000g^h0P0037^h00<007^hNkP0@g^h00<007^hNkP0<W^h00D007^hNkQk^00000mk^003
001k^7^h01Ak^003001k^7^h015k^004001k^7^h0003NkP00`00NkP00006NkP01`00NkQk^7^h001k
^00000=k^004001k^7^h0009NkP01000NkQk^0000g^h00<007^hNkP09g^h00D007^hNkQk^00000Qk
^005001k^7^hNkP00002NkP00`00NkQk^00DNkP00`00NkQk^00=NkP01`00NkQk^7^h001k^00000=k
^004001k^7^h0003NkP00`00NkQk^004NkP00`00NkP0000@NkP01000NkQk^0000g^h00<007^h0000
0g^h00@007^hNkP000=k^004001k^7^h0003NkP00`00NkP0000:NkP00`00NkP00006NkP01`00NkQk
^7^h001k^00000=k^004001k^7^h0003NkP00`00NkP00003NkP01000NkQk^0002W^h00<007^h0000
Ag^h00D007^hNkQk^00000mk^005001k^7^hNkP00002NkP01`00NkQk^7^h001k^000011k^004001k
^7^h000<NkP00`00NkQk^00KNkP00`00NkQk^004NkP00`00NkQk^003NkP01000NkQk^0000g^h00<0
07^hNkP047^h000MNkP00`00NkQk^013NkP00`00NkQk^00bNkP01@00NkQk^7^h00003W^h00<007^h
NkP05W^h00<007^hNkP047^h00<007^h000017^h00<007^h00001G^h00<007^hNkP00W^h00<007^h
000017^h00<007^h00002W^h00<007^h00000g^h00<007^hNkP09g^h00D007^hNkQk^00000Qk^007
001k^7^hNkP007^h000067^h00<007^hNkP037^h00L007^hNkQk^000NkP00004NkP00`00NkP00003
NkP00`00NkQk^004NkP00`00NkP0000ANkP00`00NkP00003NkP00`00NkP00004NkP00`00NkP00003
NkP00`00NkP00004NkP00`00NkP0000:NkP00`00NkP00006NkP01`00NkQk^7^h001k^00000Ak^003
001k^00000=k^003001k^00000Ak^003001k^00000Yk^003001k^00004Mk^003001k^7^h009k^003
001k^7^h00ak^007001k^7^hNkP007^h000017^h00<007^h00004G^h00<007^h000037^h00<007^h
NkP077^h00<007^hNkP00g^h00<007^hNkP017^h00<007^h00000g^h00<007^hNkP047^h000MNkP0
0`00NkQk^012NkP00`00NkQk^00bNkP00`00NkQk^003NkP00`00NkQk^00;NkP00`00NkQk^00FNkP0
0`00NkQk^00ANkP20005NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^003NkP2000;NkP2
0005NkP00`00NkQk^00UNkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP2000HNkP0
0`00NkQk^00;NkP00`00NkQk^003NkP00`00NkQk^003NkP20005NkP00`00NkQk^004NkP00`00NkQk
^00@NkP20005NkP00`00NkQk^003NkP20005NkP20005NkP00`00NkQk^00:NkP00`00NkQk^004NkP0
0`00NkQk^003NkP00`00NkQk^003NkP20005NkP00`00NkQk^003NkP2000<NkP00`00NkQk^015NkP0
0`00NkQk^003NkP00`00NkQk^00;NkP00`00NkQk^003NkP20005NkP00`00NkQk^00@NkP2000<NkP0
0`00NkQk^00MNkP00`00NkQk^004NkP00`00NkQk^003NkP20005NkP00`00NkQk^00?NkP001ek^003
001k^7^h049k^003001k^7^h015k^003001k^7^h01ik^003001k^7^h00=k^003001k^7^h00Ak^003
001k^7^h00=k^003001k^7^h015k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Yk^003
001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Ak^003001k^7^h00Yk^003
001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h01Qk^003001k^7^h00=k^003
001k^7^h00Ak^003001k^7^h00=k^003001k^7^h01Qk^003001k^7^h00=k^003001k^7^h00Ak^003
001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h015k^003
001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Yk^003
001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003
001k^7^h00Yk^003001k^7^h03mk^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003
001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00]k^003
001k^7^h00Yk^003001k^7^h01ik^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003
001k^7^h00mk^0007G^h00<007^hNkP0@W^h00<007^hNkP04G^h00<007^hNkP07G^h00<007^hNkP0
17^h00<007^hNkP00g^h0P001G^h0P004W^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP0
2W^h0P002g^h00<007^hNkP05g^h0P001G^h00<007^hNkP00g^h0P001G^h0P0067^h00<007^hNkP0
17^h00<007^hNkP00g^h0P001G^h00<007^hNkP067^h00<007^hNkP00g^h00<007^hNkP00g^h00<0
07^hNkP017^h00<007^hNkP02g^h00<007^hNkP00g^h00<007^hNkP047^h00<007^hNkP04G^h0P00
1G^h00<007^hNkP02W^h00<007^hNkP00g^h0P001G^h00<007^hNkP017^h00<007^hNkP02G^h0P00
CG^h0P001G^h00<007^hNkP017^h00<007^hNkP00g^h0P001G^h00<007^hNkP047^h0P0067^h00<0
07^hNkP07g^h00<007^hNkP00g^h00<007^hNkP00g^h0P001G^h00<007^hNkP03g^h000MNkP00`00
NkQk^011NkP00`00NkQk^00ANkP00`00NkP0000NNkP00`00NkQk^003NkP00`00NkP00004NkP00`00
NkP00003NkP00`00NkP0000ANkP00`00NkP00006NkP01`00NkQk^7^h001k^00000Yk^003001k^000
00Yk^003001k^7^h01Qk^003001k^00000Ek^003001k^7^h009k^003001k^00000=k^003001k^000
01Qk^003001k^7^h00Ek^003001k^7^h009k^003001k^00000=k^003001k^7^h01Yk^007001k^7^h
NkP007^h000017^h00<007^hNkP00g^h00<007^hNkP037^h00<007^hNkP00W^h00<007^hNkP04G^h
00<007^hNkP047^h00<007^h000017^h00<007^h00002W^h00<007^h000017^h00<007^h00000g^h
00<007^hNkP01W^h00<007^hNkP027^h00<007^h0000C7^h00<007^h00000g^h00<007^hNkP01W^h
00L007^hNkQk^000NkP00004NkP00`00NkQk^00@NkP00`00NkP0000HNkP00`00NkQk^00PNkP00`00
NkQk^003NkP00`00NkQk^002NkP00`00NkP00003NkP00`00NkQk^00@NkP001ek^003001k^7^h045k
^003001k^7^h015k^003001k^00001ek^003001k^7^h00Ak^003001k^00000=k^004001k^7^h0003
NkP01000NkQk^00047^h00<007^h00001W^h00L007^hNkQk^000NkP0000:NkP01000NkQk^0002G^h
00<007^hNkP05g^h00@007^hNkP000Ek^005001k^7^hNkP00002NkP01@00NkQk^7^h00000W^h00<0
07^hNkP057^h00<007^hNkP01W^h00D007^hNkQk^000009k^005001k^7^hNkP0000LNkP01`00NkQk
^7^h001k^00000=k^003001k^7^h00Ak^003001k^7^h00ek^005001k^7^hNkP0000BNkP00`00NkQk
^00ANkP01000NkQk^0000g^h00<007^h00002W^h00<007^h00000g^h00@007^hNkP000=k^003001k
^7^h00Ik^003001k^7^h00Mk^004001k^7^h001;NkP01000NkQk^0000g^h00<007^hNkP01W^h00D0
07^hNkQk^000009k^005001k^7^hNkP0000BNkP01000NkQk^0005W^h00<007^hNkP08G^h00<007^h
NkP00g^h00D007^hNkQk^000009k^005001k^7^hNkP0000BNkP001ek^003001k^7^h041k^003001k
^7^h015k^005001k^7^hNkP0000LNkP00`00NkQk^003NkP01@00NkQk^7^h00000W^h00L007^hNkQk
^000NkP00003NkP00`00NkQk^00=NkP01@00NkQk^7^h00001W^h00<007^h00000g^h00<007^hNkP0
1W^h00D007^hNkQk^00000Qk^003001k^7^h01Qk^005001k^7^hNkP00005NkP01000NkQk^0000g^h
00<007^h00000g^h00<007^hNkP057^h00<007^hNkP01g^h00@007^hNkP000=k^003001k^00001ik
^003001k^00000=k^004001k^7^h0005NkP00`00NkQk^00>NkP01000NkQk^0004g^h00<007^hNkP0
47^h00D007^hNkQk^000009k^005001k^7^hNkP00008NkP01@00NkQk^7^h00000W^h00L007^hNkQk
^000NkP0000:NkP00`00NkQk^006NkP01@00NkQk^7^h0000BW^h00L007^hNkQk^000NkP0000:NkP0
0`00NkP00003NkP01000NkQk^0004W^h00D007^hNkQk^00001Ik^003001k^7^h029k^003001k^7^h
00=k^004001k^7^h0003NkP00`00NkP0000CNkP001ek^003001k^7^h041k^003001k^7^h015k^005
001k^7^hNkP0000KNkP00`00NkQk^004NkP01`00NkQk^7^h001k^00000Ak^003001k^00000Ak^003
001k^7^h00ak^005001k^7^hNkP00006NkP00`00NkP00003NkP00`00NkQk^006NkP00`00NkQk^002
NkP00`00NkQk^005NkP00`00NkQk^00GNkP00`00NkQk^002NkP00`00NkQk^003NkP00`00NkP00004
NkP00`00NkP00004NkP00`00NkQk^00BNkP00`00NkQk^008NkP00`00NkP00004NkP00`00NkP0000N
NkP00`00NkP00003NkP00`00NkP00006NkP00`00NkQk^00?NkP00`00NkP0000BNkP00`00NkQk^00A
NkP00`00NkQk^002NkP00`00NkP00003NkP00`00NkQk^006NkP01`00NkQk^7^h001k^00000Ak^003
001k^00000Yk^003001k^7^h00Ek^003001k^7^h009k^003001k^7^h04Mk^003001k^7^h009k^003
001k^00000Yk^003001k^00000Ak^003001k^000019k^003001k^7^h009k^003001k^7^h019k^003
001k^7^h02=k^003001k^7^h00=k^003001k^00000Ak^003001k^00001=k^0007G^h00<007^hNkP0
?g^h00<007^hNkP04G^h00<007^hNkP00g^h00<007^hNkP067^h00<007^hNkP00g^h00<007^hNkP0
0g^h0P001G^h00<007^hNkP00g^h00<007^hNkP02g^h00<007^hNkP00g^h00<007^hNkP017^h00<0
07^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP067^h00<0
07^hNkP00g^h00<007^hNkP00g^h0P001G^h00<007^hNkP00g^h00<007^hNkP04W^h00<007^hNkP0
2G^h0P001G^h00<007^hNkP07W^h00<007^hNkP00g^h0P001G^h00<007^hNkP047^h0P004g^h00<0
07^hNkP047^h00<007^hNkP00g^h0P001G^h00<007^hNkP017^h00<007^hNkP00g^h0P001G^h00<0
07^hNkP02W^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP0AW^h00<007^hNkP00g^h00<0
07^hNkP02W^h00<007^hNkP00g^h0P004W^h00<007^hNkP00g^h00<007^hNkP04W^h00<007^hNkP0
97^h00<007^hNkP00g^h0P001G^h00<007^hNkP04W^h000MNkP4000gNkP00`00NkQk^004NkP00`00
NkQk^00ANkP00`00NkQk^003NkP00`00NkQk^00:NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00
NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00
NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00
NkQk^004NkP00`00NkQk^003NkP00`00NkQk^00GNkP00`00NkQk^004NkP00`00NkQk^003NkP00`00
NkQk^004NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00
NkQk^00:NkP00`00NkQk^004NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^00ANkP00`00
NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00ANkP00`00NkQk^003NkP00`00NkQk^004NkP00`00
NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^004NkP00`00
NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00:NkP00`00
NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00[NkP00`00NkQk^004NkP00`00NkQk^00@NkP00`00
NkQk^004NkP00`00NkQk^00:NkP00`00NkQk^004NkP00`00NkQk^00:NkP00`00NkQk^003NkP00`00
NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^00UNkP00`00
NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00BNkP001ek^003001k^7^h03Qk^08000Ek^003001k
^7^h011k^003001k^7^h00Ak^003001k^7^h00Yk^003001k^7^h00=k^08000Ek^003001k^7^h00Ak
^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00=k
^003001k^7^h00Ek^003001k^7^h00Uk^08000Ek^003001k^7^h00Ak^003001k^7^h00=k^003001k
^7^h01Mk^003001k^7^h00Ak^003001k^7^h00=k^08000Ek^003001k^7^h00=k^08000Ek^003001k
^7^h00=k^08000Ek^080019k^003001k^7^h00=k^08000Ek^003001k^7^h015k^003001k^7^h00=k
^08000Ek^003001k^7^h015k^003001k^7^h00=k^003001k^7^h00=k^08000Ek^08000Ek^003001k
^7^h00=k^08000Ek^003001k^7^h00=k^08000Ek^003001k^7^h00=k^08000Ek^003001k^7^h015k
^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h02]k^003001k^7^h00=k^080019k^003001k
^7^h01Mk^08000]k^08000Ek^003001k^7^h00Ak^003001k^7^h00=k^08000Ek^003001k^7^h00=k
^003001k^7^h02Ek^003001k^7^h00=k^08001Yk^0007G^h00<007^hNkP0=g^h00<007^h000017^h
00<007^hNkP04G^h00<007^hNkP01G^h00<007^hNkP027^h00<007^h000017^h00<007^h00000g^h
00<007^hNkP017^h00<007^hNkP01G^h00<007^hNkP00W^h00<007^hNkP01W^h00L007^hNkQk^000
NkP00004NkP00`00NkQk^005NkP00`00NkQk^008NkP00`00NkP00004NkP00`00NkP00006NkP01@00
NkQk^7^h00006G^h00<007^hNkP01W^h00L007^hNkQk^000NkP00004NkP00`00NkP00004NkP00`00
NkP00003NkP00`00NkP00004NkP00`00NkP00003NkP00`00NkP0000ANkP00`00NkP00004NkP00`00
NkP00003NkP00`00NkP0000ANkP00`00NkP00003NkP00`00NkP00004NkP00`00NkQk^00CNkP01`00
NkQk^7^h001k^00000Ak^003001k^00000=k^003001k^00000Ak^003001k^00000=k^003001k^000
00Ak^003001k^7^h00Ak^003001k^00000=k^003001k^00000Ak^003001k^00000=k^003001k^7^h
01=k^005001k^7^hNkP00008NkP00`00NkQk^00YNkP00`00NkP00004NkP00`00NkP0000@NkP00`00
NkQk^00HNkP00`00NkP0000:NkP00`00NkP00003NkP00`00NkQk^006NkP01`00NkQk^7^h001k^000
00Ak^003001k^00000=k^003001k^7^h02Mk^007001k^7^hNkP007^h00006W^h000MNkP00`00NkQk
^00gNkP01000NkQk^0000g^h00<007^hNkP047^h00<007^hNkP01W^h00<007^hNkP027^h00<007^h
00000g^h00@007^hNkP000=k^003001k^7^h00Ak^003001k^7^h00Ik^005001k^7^hNkP00008NkP0
1`00NkQk^7^h001k^00000=k^003001k^7^h00Mk^003001k^7^h00Mk^004001k^7^h0003NkP00`00
NkP00006NkP01@00NkQk^7^h00006G^h00<007^hNkP01W^h00D007^hNkQk^000009k^007001k^7^h
NkP007^h00000g^h00@007^hNkP000=k^003001k^00000=k^004001k^7^h0003NkP01000NkQk^000
47^h00<007^h00000g^h00@007^hNkP000=k^003001k^000015k^003001k^00000=k^004001k^7^h
0003NkP00`00NkQk^00CNkP01`00NkQk^7^h001k^00000=k^004001k^7^h0003NkP01000NkQk^000
0g^h00<007^h00000g^h00@007^hNkP000=k^003001k^7^h00=k^004001k^7^h0003NkP00`00NkP0
0003NkP01000NkQk^0000g^h00<007^hNkP04g^h00D007^hNkQk^00000Qk^003001k^7^h02Uk^003
001k^00000=k^004001k^7^h000@NkP00`00NkQk^00GNkP01000NkQk^0002G^h00@007^hNkP000=k
^003001k^7^h00Ik^005001k^7^hNkP00002NkP01`00NkQk^7^h001k^00000=k^003001k^7^h02Mk
^005001k^7^hNkP00002NkP00`00NkQk^00GNkP001ek^003001k^7^h03Ik^005001k^7^hNkP00002
NkP00`00NkQk^00ANkP00`00NkQk^007NkP00`00NkQk^006NkP01@00NkQk^7^h00000W^h00L007^h
NkQk^000NkP00006NkP00`00NkQk^007NkP01000NkQk^0002W^h00<007^h00000g^h00@007^hNkP0
00Uk^003001k^7^h00Ik^005001k^7^hNkP00002NkP01@00NkQk^7^h00001W^h00<007^h00006G^h
00<007^hNkP027^h00<007^h00000g^h00@007^hNkP000=k^004001k^7^h0003NkP00`00NkP00003
NkP01000NkQk^0000g^h00<007^h00000g^h00<007^hNkP03G^h00D007^hNkQk^000009k^007001k
^7^hNkP007^h00000g^h00<007^hNkP03G^h00L007^hNkQk^000NkP00003NkP01000NkQk^0005g^h
00<007^h00000g^h00@007^hNkP000=k^003001k^00000=k^004001k^7^h0003NkP00`00NkP00003
NkP01000NkQk^0001W^h00L007^hNkQk^000NkP00003NkP01000NkQk^0000g^h00<007^h00005g^h
00<007^h00002W^h00<007^hNkP09g^h00D007^hNkQk^000009k^005001k^7^hNkP0000>NkP00`00
NkQk^00HNkP01@00NkQk^7^h000027^h00L007^hNkQk^000NkP0000:NkP00`00NkP00003NkP01000
NkQk^0000g^h00<007^h0000:g^h00<007^h00000g^h00<007^hNkP05g^h000MNkP00`00NkQk^00f
NkP00`00NkQk^002NkP00`00NkP0000BNkP00`00NkQk^008NkP00`00NkQk^006NkP01`00NkQk^7^h
001k^00000Ak^003001k^00000Ik^003001k^7^h00Qk^003001k^00000Yk^003001k^00000=k^003
001k^00000]k^003001k^7^h00Ek^003001k^7^h009k^003001k^00000=k^003001k^7^h00Ak^003
001k^00001Uk^003001k^7^h00Qk^003001k^00000Ak^003001k^00000=k^003001k^00000Ak^003
001k^00000=k^003001k^00000Ak^003001k^00000Ak^003001k^7^h00ak^007001k^7^hNkP007^h
000017^h00<007^h00000g^h00<007^hNkP03G^h00L007^hNkQk^000NkP00004NkP00`00NkP0000G
NkP00`00NkP00003NkP00`00NkP00004NkP00`00NkP00004NkP00`00NkP00003NkP00`00NkP00004
NkP00`00NkP00005NkP00`00NkQk^002NkP00`00NkP00003NkP00`00NkP00004NkP00`00NkP0000G
NkP00`00NkP0000:NkP00`00NkQk^00WNkP01`00NkQk^7^h001k^00000Ak^003001k^7^h00ak^003
001k^7^h01Mk^003001k^7^h009k^003001k^7^h00Ek^003001k^7^h009k^003001k^00000Yk^003
001k^00000Ak^003001k^00000=k^003001k^00002]k^003001k^00000Ak^003001k^7^h01Ik^000
7G^h00<007^hNkP0=G^h00<007^hNkP00g^h0P004g^h00<007^hNkP02G^h00<007^hNkP017^h00<0
07^hNkP00g^h0P001G^h00<007^hNkP017^h00<007^hNkP02G^h0P0037^h00<007^hNkP00g^h0P00
2g^h00<007^hNkP017^h00<007^hNkP00g^h0P001G^h00<007^hNkP017^h00<007^hNkP05g^h00<0
07^hNkP02W^h00<007^hNkP00g^h0P001G^h0P001G^h00<007^hNkP00g^h0P001G^h00<007^hNkP0
0g^h00<007^hNkP02g^h00<007^hNkP00g^h0P001G^h00<007^hNkP00g^h00<007^hNkP02g^h00<0
07^hNkP00g^h00<007^hNkP00g^h0P006G^h00<007^hNkP00g^h0P001G^h00<007^hNkP00g^h0P00
1G^h00<007^hNkP00g^h0P001W^h00<007^hNkP00g^h00<007^hNkP00g^h0P001G^h00<007^hNkP0
5g^h00<007^hNkP02W^h00<007^hNkP09G^h00<007^hNkP00g^h0P001G^h00<007^hNkP02W^h00<0
07^hNkP067^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP02W^h00<0
07^hNkP00g^h0P001G^h00<007^hNkP0:g^h00<007^hNkP00g^h00<007^hNkP05W^h000MNkP00`00
NkQk^00^NkP00`00NkQk^004NkP00`00NkQk^004NkP00`00NkQk^00:NkP00`00NkQk^003NkP00`00
NkQk^00:NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^004NkP00`00
NkQk^00:NkP00`00NkQk^00:NkP00`00NkQk^003NkP00`00NkQk^00;NkP00`00NkQk^003NkP00`00
NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^00;NkP00`00
NkQk^003NkP00`00NkQk^00:NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00
NkQk^003NkP00`00NkQk^004NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00
NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^004NkP00`00
NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00GNkP00`00NkQk^003NkP00`00NkQk^004NkP00`00
NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00
NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00GNkP00`00NkQk^00:NkP00`00NkQk^00UNkP00`00
NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00:NkP00`00NkQk^00GNkP00`00NkQk^004NkP00`00
NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00:NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00
NkQk^00[NkP00`00NkQk^004NkP00`00NkQk^00ENkP001ek^003001k^7^h02ik^08000Ek^003001k
^7^h00=k^08000]k^08000Ek^003001k^7^h00]k^003001k^7^h00=k^003001k^7^h00Ak^003001k
^7^h00Uk^08000]k^08000ak^003001k^7^h00=k^08000ak^003001k^7^h00=k^003001k^7^h00]k
^003001k^7^h00=k^003001k^7^h00=k^08000]k^08000Ek^003001k^7^h00Yk^003001k^7^h00=k
^08000Ek^08000Ek^003001k^7^h00=k^08000Ek^003001k^7^h00Ak^003001k^7^h00=k^003001k
^7^h00=k^003001k^7^h00Ak^08000Ek^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00=k
^08000Ek^003001k^7^h00=k^08001Uk^003001k^7^h00=k^08000Ek^003001k^7^h00=k^08000Ek
^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h03Uk^003001k^7^h02=k^003001k^7^h00Ek
^003001k^7^h00=k^003001k^7^h00Yk^003001k^7^h01Mk^003001k^7^h00Ak^003001k^7^h00=k
^003001k^7^h05=k^003001k^7^h01Ek^0007G^h00<007^hNkP0;G^h00<007^h000017^h00<007^h
000017^h00<007^h00002W^h00<007^h00000g^h00<007^hNkP037^h00<007^hNkP00W^h00<007^h
NkP01G^h00<007^hNkP02G^h00<007^h00002W^h00<007^h00002W^h00<007^h00000g^h00<007^h
00003G^h00D007^hNkQk^00000ik^003001k^7^h009k^003001k^00000=k^003001k^00000]k^003
001k^00000=k^003001k^7^h00Yk^003001k^00000Ak^003001k^00000=k^003001k^00000Ik^007
001k^7^hNkP007^h000017^h00<007^hNkP01W^h00L007^hNkQk^000NkP00004NkP00`00NkQk^003
NkP00`00NkP00004NkP00`00NkQk^005NkP00`00NkQk^002NkP00`00NkP00004NkP00`00NkP00003
NkP00`00NkP00004NkP00`00NkP0000GNkP00`00NkP00003NkP00`00NkP00004NkP00`00NkQk^004
NkP00`00NkP00003NkP00`00NkP00004NkP00`00NkQk^003NkP00`00NkQk^00jNkP00`00NkQk^00S
NkP00`00NkQk^005NkP00`00NkQk^004NkP00`00NkQk^008NkP00`00NkQk^00GNkP00`00NkQk^006
NkP01@00NkQk^7^h0000Eg^h00<007^hNkP057^h000MNkP00`00NkQk^00]NkP01000NkQk^0000g^h
00<007^h00000g^h00@007^hNkP000Uk^004001k^7^h0003NkP00`00NkQk^00=NkP01@00NkQk^7^h
000027^h00<007^hNkP01g^h00@007^hNkP000Uk^004001k^7^h000:NkP00`00NkP00003NkP01000
NkQk^00037^h00D007^hNkQk^00000mk^007001k^7^hNkP007^h00000g^h00@007^hNkP000Uk^004
001k^7^h0003NkP00`00NkQk^00:NkP00`00NkP00003NkP01000NkQk^0000g^h00@007^hNkP000Ek
^005001k^7^hNkP00002NkP01@00NkQk^7^h000027^h00L007^hNkQk^000NkP00003NkP00`00NkQk
^004NkP01000NkQk^0000g^h00<007^hNkP01W^h00L007^hNkQk^000NkP00003NkP01000NkQk^000
0g^h00<007^h00000g^h00@007^hNkP001Mk^003001k^00000=k^004001k^7^h0003NkP00`00NkQk
^003NkP01000NkQk^0000g^h00<007^h00000g^h00<007^hNkP017^h00<007^hNkP0>g^h00<007^h
NkP08G^h00<007^hNkP01g^h00<007^hNkP00g^h00<007^hNkP027^h00<007^hNkP05g^h00<007^h
NkP01W^h00D007^hNkQk^00005Mk^003001k^7^h01Ak^0007G^h00<007^hNkP0;7^h00D007^hNkQk
^000009k^005001k^7^hNkP00002NkP01@00NkQk^7^h000027^h00L007^hNkQk^000NkP0000@NkP0
1000NkQk^0002G^h00<007^hNkP01g^h00D007^hNkQk^00000Qk^005001k^7^hNkP00008NkP01`00
NkQk^7^h001k^00000=k^003001k^7^h00]k^003001k^000011k^004001k^7^h0003NkP00`00NkP0
0003NkP00`00NkQk^007NkP01`00NkQk^7^h001k^00000ak^005001k^7^hNkP00002NkP01`00NkQk
^7^h001k^00000=k^003001k^7^h00Ak^003001k^00000=k^004001k^7^h000:NkP00`00NkP00003
NkP01000NkQk^0001G^h00D007^hNkQk^000009k^003001k^7^h00Mk^004001k^7^h0003NkP01000
NkQk^0000g^h00<007^h00000g^h00@007^hNkP000=k^003001k^7^h01=k^007001k^7^hNkP007^h
00000g^h00@007^hNkP000Ik^007001k^7^hNkP007^h00000g^h00@007^hNkP000Ek^003001k^7^h
03ak^003001k^7^h025k^003001k^7^h00Mk^003001k^7^h00Ak^003001k^7^h00Ik^003001k^7^h
01Mk^003001k^7^h00Qk^003001k^00005Uk^003001k^7^h01=k^0007G^h00<007^hNkP0;7^h00<0
07^hNkP00W^h00<007^h00000g^h00<007^h000017^h00<007^hNkP01G^h00<007^hNkP00W^h00<0
07^h00004G^h00<007^h00002W^h00<007^hNkP01G^h00<007^hNkP00W^h00<007^hNkP01G^h00<0
07^hNkP00W^h00<007^hNkP01W^h00L007^hNkQk^000NkP00004NkP00`00NkQk^00:NkP00`00NkP0
000ANkP00`00NkP00003NkP00`00NkP00004NkP00`00NkQk^005NkP00`00NkQk^002NkP00`00NkP0
000<NkP01`00NkQk^7^h001k^00000Ak^003001k^00000Ak^003001k^7^h00=k^003001k^00000Ak
^003001k^00000Yk^003001k^00000=k^003001k^00000Ik^003001k^7^h009k^003001k^00000Yk
^003001k^00000=k^003001k^00000Ak^003001k^00000=k^003001k^00000Ak^003001k^7^h01=k
^007001k^7^hNkP007^h000017^h00<007^h00001G^h00<007^hNkP00W^h00<007^h00000g^h00<0
07^h00001W^h00<007^hNkP0?G^h00<007^hNkP07g^h00<007^hNkP02G^h00<007^hNkP00g^h00<0
07^hNkP01W^h00<007^hNkP05g^h00<007^hNkP027^h00<007^h0000FG^h00<007^hNkP04g^h000M
NkP00`00NkQk^00[NkP00`00NkQk^003NkP20005NkP20005NkP00`00NkQk^004NkP00`00NkQk^003
NkP00`00NkQk^00@NkP2000;NkP00`00NkQk^005NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00
NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^003NkP00`00NkQk^00;NkP00`00
NkQk^00@NkP20005NkP00`00NkQk^003NkP00`00NkQk^005NkP00`00NkQk^003NkP00`00NkQk^00:
NkP00`00NkQk^003NkP20005NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP2000<
NkP00`00NkQk^003NkP20005NkP00`00NkQk^003NkP2000;NkP20005NkP20005NkP00`00NkQk^003
NkP20005NkP00`00NkQk^00ANkP00`00NkQk^003NkP00`00NkQk^003NkP20006NkP00`00NkQk^003
NkP00`00NkQk^003NkP20005NkP00`00NkQk^00nNkP00`00NkQk^00ONkP00`00NkQk^009NkP00`00
NkQk^004NkP00`00NkQk^004NkP00`00NkQk^00GNkP00`00NkQk^00:NkP00`00NkQk^01INkP00`00
NkQk^00BNkP001ek^0@002Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k
^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h015k^003001k^7^h00Yk^003001k
^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Ak^003001k
^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k
^7^h00Ak^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k
^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k
^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Yk^003001k^7^h00=k^003001k
^7^h00Ak^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k
^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00]k^003001k
^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k
^7^h00Ak^003001k^7^h00Yk^003001k^7^h039k^003001k^7^h01ek^003001k^7^h00]k^003001k
^7^h00=k^003001k^7^h00Ak^003001k^7^h00Yk^003001k^7^h00Yk^003001k^7^h00Yk^003001k
^7^h05Uk^003001k^7^h019k^0007G^h00<007^hNkP097^h0P001G^h00<007^hNkP00g^h0P001G^h
0P001G^h00<007^hNkP00g^h00<007^hNkP05g^h00<007^hNkP02g^h00<007^hNkP00g^h00<007^h
NkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP02g^h00<007^h
NkP00g^h0P001G^h00<007^hNkP00g^h0P001G^h00<007^hNkP00g^h0P001G^h00<007^hNkP00g^h
0P001G^h00<007^hNkP017^h00<007^hNkP00g^h0P001G^h00<007^hNkP00g^h0P001G^h00<007^h
NkP00g^h0P001G^h00<007^hNkP04G^h00<007^hNkP00g^h0P001G^h00<007^hNkP017^h00<007^h
NkP00g^h00<007^hNkP00g^h0P001G^h0P001G^h00<007^hNkP017^h00<007^hNkP00g^h00<007^h
NkP00g^h0P002g^h0P001G^h00<007^hNkP00g^h0P001G^h0P001G^h00<007^hNkP017^h00<007^h
NkP00g^h00<007^hNkP02W^h00<007^hNkP0<W^h00<007^hNkP07G^h00<007^hNkP02g^h00<007^h
NkP00g^h00<007^hNkP00g^h0P0037^h00<007^hNkP02W^h00<007^hNkP0IW^h00<007^hNkP04W^h
000MNkP00`00NkQk^00TNkP00`00NkP00003NkP00`00NkQk^004NkP00`00NkP00003NkP00`00NkP0
0006NkP01@00NkQk^7^h00006W^h00<007^hNkP037^h00D007^hNkQk^00000Qk^005001k^7^hNkP0
0008NkP00`00NkQk^002NkP00`00NkQk^00<NkP01`00NkQk^7^h001k^00000Ak^003001k^00000=k
^003001k^00000Ak^003001k^00000Ak^003001k^00000=k^003001k^00000Ak^003001k^00000=k
^003001k^7^h00Ak^003001k^00000=k^003001k^00000Ak^003001k^00000=k^003001k^00000Ak
^003001k^00000Ak^003001k^00000=k^003001k^000015k^003001k^00000=k^003001k^00000Ak
^003001k^7^h00Ik^007001k^7^hNkP007^h000017^h00<007^h00000g^h00<007^h000017^h00<0
07^hNkP01G^h00<007^hNkP017^h00L007^hNkQk^000NkP0000;NkP00`00NkP00003NkP00`00NkP0
0004NkP00`00NkP00003NkP00`00NkP00004NkP00`00NkQk^005NkP00`00NkQk^002NkP00`00NkP0
000:NkP00`00NkP0000dNkP00`00NkQk^00KNkP00`00NkQk^00=NkP00`00NkQk^003NkP00`00NkQk
^002NkP00`00NkP0000:NkP00`00NkP0000:NkP00`00NkQk^01XNkP00`00NkQk^00ANkP001ek^003
001k^7^h02=k^004001k^7^h0003NkP00`00NkQk^003NkP01000NkQk^0000g^h00@007^hNkP000Ek
^005001k^7^hNkP0000INkP00`00NkQk^00=NkP01@00NkQk^7^h000027^h00D007^hNkQk^00000Qk
^005001k^7^hNkP0000?NkP01@00NkQk^7^h00000W^h00L007^hNkQk^000NkP00003NkP01000NkQk
^0000g^h00<007^h00000g^h00@007^hNkP000=k^003001k^00000=k^004001k^7^h0003NkP00`00
NkQk^004NkP00`00NkP00003NkP01000NkQk^0000g^h00<007^h00000g^h00@007^hNkP000=k^003
001k^00000=k^004001k^7^h0003NkP00`00NkP0000ANkP00`00NkP00003NkP01000NkQk^0000g^h
00<007^hNkP01W^h00L007^hNkQk^000NkP00003NkP01000NkQk^0000g^h00@007^hNkP000=k^003
001k^7^h00Ik^003001k^7^h00=k^005001k^7^hNkP00002NkP00`00NkQk^007NkP01000NkQk^000
0g^h00<007^h00000g^h00@007^hNkP000=k^004001k^7^h0003NkP00`00NkQk^006NkP01`00NkQk
^7^h001k^00000Yk^003001k^00003Ak^003001k^7^h01]k^003001k^7^h00ek^003001k^7^h00=k
^005001k^7^hNkP00002NkP00`00NkQk^008NkP00`00NkP0000:NkP00`00NkQk^01XNkP00`00NkQk
^00ANkP001ek^003001k^7^h02=k^007001k^7^hNkP007^h00001W^h00L007^hNkQk^000NkP00003
NkP00`00NkQk^004NkP00`00NkP0000JNkP00`00NkQk^00>NkP00`00NkP0000:NkP00`00NkP0000:
NkP01000NkQk^00047^h00<007^h00000g^h00@007^hNkP000=k^003001k^00000=k^004001k^7^h
0003NkP01000NkQk^0000g^h00<007^h00000g^h00@007^hNkP000=k^003001k^00000Ik^007001k
^7^hNkP007^h00000g^h00@007^hNkP000=k^003001k^00000=k^004001k^7^h0003NkP01000NkQk
^0000g^h00<007^h00000g^h00<007^hNkP03G^h00L007^hNkQk^000NkP00003NkP01000NkQk^000
2W^h00<007^h00000g^h00@007^hNkP000=k^003001k^00000=k^004001k^7^h0009NkP00`00NkQk
^004NkP00`00NkP00003NkP00`00NkQk^007NkP01`00NkQk^7^h001k^00000=k^004001k^7^h0003
NkP00`00NkP00003NkP01000NkQk^0002G^h00@007^hNkP000=k^003001k^7^h00Ik^005001k^7^h
NkP0000dNkP00`00NkQk^00INkP00`00NkQk^00?NkP00`00NkQk^003NkP01000NkQk^0000g^h00<0
07^hNkP01W^h00D007^hNkQk^00000Qk^003001k^7^h06Yk^003001k^7^h011k^0007G^h00<007^h
NkP08W^h00<007^hNkP00W^h00<007^h00001G^h00<007^hNkP00W^h00<007^h000017^h00<007^h
NkP00g^h00<007^h00006G^h00<007^hNkP03g^h00<007^h00002W^h00<007^h00002W^h00<007^h
00004G^h00<007^h000017^h00<007^h00000g^h00<007^h000017^h00<007^h00000g^h00<007^h
000017^h00<007^h00000g^h00<007^h000017^h00<007^h00001W^h00L007^hNkQk^000NkP00004
NkP00`00NkP00003NkP00`00NkP00004NkP00`00NkP00003NkP00`00NkP00004NkP00`00NkP00003
NkP00`00NkQk^00=NkP01`00NkQk^7^h001k^00000Ak^003001k^00000Yk^003001k^00000=k^003
001k^00000Ak^003001k^00000Ak^003001k^00000Yk^003001k^7^h00=k^003001k^00000Ak^003
001k^7^h00Ek^003001k^7^h009k^003001k^00000=k^003001k^00000Ak^003001k^00000Ak^003
001k^00000Yk^003001k^00000=k^003001k^7^h00Ik^005001k^7^hNkP0000dNkP00`00NkQk^00I
NkP00`00NkQk^00?NkP00`00NkQk^003NkP00`00NkP00004NkP00`00NkQk^006NkP01@00NkQk^7^h
000027^h00<007^hNkP0JW^h00<007^hNkP047^h000MNkP00`00NkQk^00RNkP00`00NkQk^003NkP0
0`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00HNkP0
0`00NkQk^00@NkP00`00NkQk^00:NkP00`00NkQk^00:NkP2000BNkP00`00NkQk^003NkP20005NkP0
0`00NkQk^003NkP20005NkP20005NkP00`00NkQk^003NkP20005NkP00`00NkQk^004NkP00`00NkQk
^003NkP00`00NkQk^003NkP20005NkP00`00NkQk^003NkP20005NkP20005NkP00`00NkQk^003NkP0
0`00NkQk^00;NkP00`00NkQk^003NkP00`00NkQk^003NkP2000<NkP00`00NkQk^003NkP20005NkP0
0`00NkQk^003NkP2000;NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^005NkP00`00NkQk
^003NkP00`00NkQk^003NkP20005NkP00`00NkQk^003NkP2000;NkP20005NkP00`00NkQk^004NkP0
0`00NkQk^003NkP00`00NkQk^00bNkP00`00NkQk^00GNkP00`00NkQk^00ANkP00`00NkQk^003NkP2
0005NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^01/NkP00`00NkQk
^00?NkP001ek^003001k^7^h01]k^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003
001k^7^h00Ak^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h01Mk^003001k^7^h00Ak^003
001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Yk^003001k^7^h00Yk^003001k^7^h015k^003
001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003
001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003
001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003
001k^7^h00]k^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Yk^003001k^7^h00=k^003
001k^7^h00Ak^003001k^7^h00Ak^003001k^7^h00Yk^003001k^7^h00=k^003001k^7^h00Ak^003
001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Ak^003
001k^7^h00Yk^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00]k^003
001k^7^h00=k^003001k^7^h01ik^003001k^7^h015k^003001k^7^h00=k^003001k^7^h015k^003
001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003
001k^7^h06ak^003001k^7^h00mk^0007G^h00<007^hNkP06W^h0P001G^h00<007^hNkP017^h00<0
07^hNkP00g^h00<007^hNkP017^h00<007^hNkP017^h00<007^hNkP07G^h0P001G^h00<007^hNkP0
0g^h0P001G^h00<007^hNkP05g^h0P004W^h00<007^hNkP00g^h0P002g^h0P001G^h0P001G^h00<0
07^hNkP02W^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<0
07^hNkP017^h00<007^hNkP02W^h00<007^hNkP017^h00<007^hNkP02G^h00<007^hNkP017^h00<0
07^hNkP00g^h00<007^hNkP02g^h00<007^hNkP00g^h0P001G^h00<007^hNkP017^h00<007^hNkP0
2G^h0P001G^h00<007^hNkP00g^h0P001G^h00<007^hNkP017^h00<007^hNkP00g^h0P001G^h00<0
07^hNkP067^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP02G^h0P001G^h00<007^hNkP0
7W^h00<007^hNkP047^h0P001G^h00<007^hNkP04G^h00<007^hNkP00g^h0P001G^h00<007^hNkP0
0g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP0Og^h000MNkP00`00NkQk^00JNkP00`00
NkP00003NkP00`00NkQk^004NkP00`00NkP00003NkP00`00NkQk^004NkP00`00NkP00006NkP00`00
NkQk^00KNkP00`00NkP00004NkP00`00NkP00003NkP00`00NkP00004NkP00`00NkQk^00GNkP00`00
NkP0000ANkP00`00NkQk^004NkP00`00NkP0000:NkP00`00NkP00003NkP00`00NkP00004NkP00`00
NkP0000:NkP00`00NkP00004NkP00`00NkQk^003NkP00`00NkP00004NkP00`00NkQk^003NkP00`00
NkQk^006NkP00`00NkQk^00:NkP00`00NkQk^003NkP00`00NkQk^009NkP00`00NkQk^003NkP00`00
NkP00004NkP00`00NkQk^00:NkP00`00NkP00003NkP00`00NkP00004NkP00`00NkQk^006NkP00`00
NkQk^008NkP00`00NkP00003NkP00`00NkP00004NkP00`00NkP00003NkP00`00NkQk^004NkP00`00
NkQk^003NkP00`00NkP00004NkP00`00NkP0000INkP00`00NkQk^002NkP00`00NkP00005NkP00`00
NkQk^009NkP00`00NkP00003NkP00`00NkP0000PNkP00`00NkQk^00?NkP00`00NkP00003NkP00`00
NkQk^00CNkP01`00NkQk^7^h001k^00000Ak^003001k^00000Ak^003001k^7^h00Ek^003001k^7^h
009k^003001k^7^h07mk^0007G^h00<007^hNkP06G^h00@007^hNkP000=k^003001k^7^h00Ak^003
001k^00000=k^003001k^7^h00Ak^003001k^00000Ik^003001k^7^h01]k^004001k^7^h0003NkP0
0`00NkP00003NkP01000NkQk^0000g^h00<007^hNkP05g^h00@007^hNkP0011k^003001k^7^h00=k
^004001k^7^h0009NkP01000NkQk^0000g^h00@007^hNkP000=k^003001k^00000Yk^003001k^000
00=k^003001k^7^h00Ak^003001k^00000=k^003001k^7^h00Ak^003001k^7^h00Ik^003001k^7^h
00Yk^003001k^7^h00Ak^003001k^7^h00Mk^003001k^7^h00Ak^003001k^00000=k^003001k^7^h
00]k^003001k^00000=k^004001k^7^h0003NkP00`00NkQk^006NkP00`00NkQk^007NkP01000NkQk
^0000g^h00<007^h00000g^h00@007^hNkP000=k^003001k^7^h00Ak^003001k^7^h00=k^004001k
^7^h0003NkP00`00NkP0000JNkP01`00NkQk^7^h001k^00000Ik^003001k^7^h00Mk^004001k^7^h
0003NkP00`00NkP0000PNkP00`00NkQk^00>NkP01000NkQk^0000g^h00<007^hNkP04g^h00D007^h
NkQk^000009k^007001k^7^hNkP007^h00000g^h00<007^hNkP01W^h00D007^hNkQk^000089k^000
7G^h00<007^hNkP06G^h00L007^hNkQk^000NkP00006NkP01`00NkQk^7^h001k^00000Ik^005001k
^7^hNkP00006NkP00`00NkQk^00INkP01@00NkQk^7^h00000W^h00L007^hNkQk^000NkP00003NkP0
1000NkQk^0006G^h00D007^hNkQk^00000mk^003001k^7^h00Ak^005001k^7^hNkP00008NkP01`00
NkQk^7^h001k^00000=k^004001k^7^h0003NkP00`00NkQk^006NkP01@00NkQk^7^h00000W^h00<0
07^hNkP00g^h00D007^hNkQk^000009k^003001k^7^h00=k^003001k^7^h00Qk^003001k^7^h00Yk
^003001k^7^h00=k^003001k^7^h00Mk^003001k^7^h00=k^005001k^7^hNkP00002NkP00`00NkQk
^00:NkP01`00NkQk^7^h001k^00000=k^004001k^7^h000:NkP00`00NkQk^006NkP01`00NkQk^7^h
001k^00000=k^004001k^7^h0003NkP00`00NkP00006NkP00`00NkQk^003NkP01@00NkQk^7^h0000
0W^h00D007^hNkQk^00001Uk^004001k^7^h0003NkP00`00NkQk^003NkP00`00NkQk^007NkP01`00
NkQk^7^h001k^00000=k^003001k^7^h01ik^003001k^7^h00ek^007001k^7^hNkP007^h00005g^h
00<007^h00000g^h00@007^hNkP000=k^004001k^7^h0009NkP01000NkQk^000PW^h000MNkP00`00
NkQk^00HNkP00`00NkQk^002NkP00`00NkP00006NkP01`00NkQk^7^h001k^00000Ik^005001k^7^h
NkP00006NkP00`00NkQk^00INkP00`00NkQk^002NkP00`00NkP00003NkP00`00NkP00004NkP00`00
NkP0000INkP00`00NkQk^002NkP00`00NkQk^00<NkP00`00NkQk^003NkP00`00NkQk^002NkP00`00
NkQk^005NkP00`00NkQk^002NkP00`00NkP00004NkP00`00NkP00003NkP00`00NkQk^006NkP01`00
NkQk^7^h001k^00000Ik^007001k^7^hNkP007^h00001W^h00<007^hNkP027^h00<007^hNkP02W^h
00<007^hNkP017^h00<007^hNkP01G^h00<007^hNkP017^h00L007^hNkQk^000NkP0000=NkP01`00
NkQk^7^h001k^00000Ak^003001k^00000Yk^003001k^7^h00Ek^003001k^7^h009k^003001k^000
00=k^003001k^00000Ak^003001k^00000Ik^003001k^7^h00=k^003001k^7^h009k^003001k^000
00=k^003001k^7^h01Qk^003001k^00000=k^003001k^7^h00Ak^003001k^7^h00Ek^003001k^7^h
009k^003001k^00000=k^003001k^7^h01ik^003001k^7^h00ak^003001k^7^h009k^003001k^000
01Mk^003001k^00000Ak^003001k^00000=k^003001k^00000Yk^003001k^00008=k^0007G^h00<0
07^hNkP067^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<0
07^hNkP00g^h00<007^hNkP017^h00<007^hNkP05g^h00<007^hNkP00g^h0P001G^h00<007^hNkP0
0g^h0P006G^h00<007^hNkP00g^h00<007^hNkP02g^h00<007^hNkP017^h00<007^hNkP00g^h00<0
07^hNkP017^h00<007^hNkP00g^h00<007^hNkP00g^h0P001G^h00<007^hNkP017^h00<007^hNkP0
0g^h0P001G^h00<007^hNkP00g^h0P001G^h00<007^hNkP02W^h00<007^hNkP02W^h00<007^hNkP0
0g^h00<007^hNkP01G^h00<007^hNkP00g^h00<007^hNkP00g^h0P0037^h00<007^hNkP00g^h00<0
07^hNkP00g^h0P0037^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP00g^h0P001G^h00<0
07^hNkP017^h00<007^hNkP00g^h00<007^hNkP00g^h0P001G^h00<007^hNkP05g^h0P001G^h00<0
07^hNkP00g^h00<007^hNkP01G^h00<007^hNkP00g^h00<007^hNkP00g^h00<007^hNkP07W^h00<0
07^hNkP02g^h00<007^hNkP00g^h00<007^hNkP05g^h00<007^hNkP00g^h0P001G^h0P002g^h0P00
Pg^h000MNkP4000@NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^004NkP00`00NkQk^003
NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004
NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004
NkP00`00NkQk^00@NkP00`00NkQk^004NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004
NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^004
NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003
NkP00`00NkQk^004NkP00`00NkQk^00:NkP00`00NkQk^00:NkP00`00NkQk^004NkP00`00NkQk^003
NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^004NkP00`00NkQk^003
NkP00`00NkQk^004NkP00`00NkQk^00:NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003
NkP00`00NkQk^004NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003
NkP00`00NkQk^00ANkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003
NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^00NNkP00`00NkQk^00:NkP00`00NkQk^004
NkP00`00NkQk^00GNkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^00:NkP00`00NkQk^022
NkP001ek^003001k^7^h015k^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k
^7^h00Yk^003001k^7^h00Ek^003001k^7^h00=k^003001k^7^h00=k^08000Ek^003001k^7^h00=k
^08000Ek^003001k^7^h00=k^08000Ek^003001k^7^h00=k^080019k^08000Ek^003001k^7^h00Ak
^003001k^7^h00=k^003001k^7^h00=k^08000Ek^08000Ek^003001k^7^h00=k^003001k^7^h00Ak
^003001k^7^h00=k^08000Ek^003001k^7^h00=k^08000Ik^003001k^7^h00=k^003001k^7^h00=k
^08000Ek^003001k^7^h00Yk^003001k^7^h00Yk^003001k^7^h00Ak^003001k^7^h00=k^08000Ek
^003001k^7^h00Yk^003001k^7^h00=k^003001k^7^h00Yk^08000ak^003001k^7^h00=k^08000Ek
^003001k^7^h00=k^08000Ek^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k
^7^h00Ek^003001k^7^h011k^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Ak^003001k
^7^h00=k^003001k^7^h00]k^003001k^7^h01ek^003001k^7^h00Yk^003001k^7^h01ik^003001k
^7^h00]k^003001k^7^h08ik^0007G^h00<007^hNkP047^h00<007^h00000g^h00<007^hNkP017^h
00<007^h000017^h00<007^hNkP02W^h00<007^hNkP01G^h00<007^hNkP017^h00L007^hNkQk^000
NkP00004NkP00`00NkP00004NkP00`00NkP00003NkP00`00NkQk^004NkP00`00NkP00003NkP00`00
NkP00004NkP00`00NkP0000@NkP00`00NkP00004NkP00`00NkQk^006NkP01`00NkQk^7^h001k^000
00Ak^003001k^00000=k^003001k^00000Ik^005001k^7^hNkP00006NkP00`00NkP00004NkP00`00
NkP00003NkP00`00NkP00004NkP00`00NkP00005NkP00`00NkQk^002NkP00`00NkP00003NkP00`00
NkP00004NkP00`00NkQk^00<NkP00`00NkQk^008NkP00`00NkP00006NkP01`00NkQk^7^h001k^000
00Ak^003001k^7^h00Yk^003001k^00000Ak^003001k^7^h00Yk^003001k^00000ak^007001k^7^h
NkP007^h000017^h00<007^h00000g^h00<007^h000017^h00<007^h000017^h00<007^hNkP00g^h
00<007^hNkP017^h00<007^hNkP01G^h00<007^hNkP03g^h00<007^h000017^h00<007^hNkP01G^h
00<007^hNkP017^h00D007^hNkQk^00000ik^003001k^7^h01ik^003001k^7^h00Qk^003001k^7^h
01ik^003001k^7^h00ak^003001k^7^h08ik^0007G^h00<007^hNkP047^h00<007^h00000g^h00<0
07^hNkP017^h00<007^h00000g^h00<007^hNkP02W^h00<007^hNkP01g^h00<007^hNkP00g^h00D0
07^hNkQk^000009k^007001k^7^hNkP007^h00000g^h00@007^hNkP000=k^003001k^7^h00=k^004
001k^7^h0003NkP00`00NkP00003NkP01000NkQk^00047^h00@007^hNkP000=k^003001k^7^h00Ik
^007001k^7^hNkP007^h00000g^h00@007^hNkP000=k^004001k^7^h0005NkP01@00NkQk^7^h0000
1W^h00<007^h00000g^h00@007^hNkP000=k^003001k^00000=k^004001k^7^h0006NkP01`00NkQk
^7^h001k^00000=k^004001k^7^h0003NkP00`00NkQk^00<NkP00`00NkQk^008NkP00`00NkP00006
NkP01@00NkQk^7^h00000W^h00D007^hNkQk^00000ak^003001k^00000=k^003001k^7^h00Yk^004
001k^7^h000<NkP01@00NkQk^7^h00000W^h00L007^hNkQk^000NkP00003NkP01000NkQk^0000g^h
00<007^h00000g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP01g^h00<007^hNkP03W^h
00<007^h00000g^h00<007^hNkP01W^h00<007^hNkP017^h00D007^hNkQk^00000mk^003001k^7^h
01ek^003001k^7^h00Qk^003001k^7^h01ik^003001k^7^h00ek^003001k^7^h08ek^0007G^h00<0
07^hNkP03g^h00L007^hNkQk^000NkP00006NkP01@00NkQk^7^h00000W^h00<007^hNkP02W^h00<0
07^hNkP01g^h00<007^hNkP017^h00<007^h00000g^h00@007^hNkP000=k^004001k^7^h0003NkP0
0`00NkP00006NkP01`00NkQk^7^h001k^00000=k^004001k^7^h0003NkP00`00NkQk^00<NkP01@00
NkQk^7^h00000W^h00<007^hNkP027^h00<007^h00000g^h00@007^hNkP000=k^003001k^00000=k
^003001k^7^h00Ak^003001k^00000Ik^005001k^7^hNkP00002NkP01`00NkQk^7^h001k^00000=k
^004001k^7^h0003NkP00`00NkQk^003NkP01000NkQk^0000g^h00<007^h00000g^h00@007^hNkP0
011k^003001k^7^h00Ik^005001k^7^hNkP00006NkP00`00NkP00003NkP01000NkQk^00037^h00D0
07^hNkQk^000009k^003001k^7^h00Yk^005001k^7^hNkP0000<NkP00`00NkP00003NkP01000NkQk
^0000g^h00<007^h00000g^h00@007^hNkP000=k^004001k^7^h0005NkP00`00NkQk^004NkP00`00
NkQk^007NkP00`00NkQk^00=NkP01@00NkQk^7^h00000W^h00<007^hNkP01g^h00<007^hNkP017^h
00<007^h000047^h00<007^hNkP07W^h00<007^hNkP01W^h00<007^hNkP07W^h00<007^hNkP03W^h
00<007^hNkP0SG^h000MNkP00`00NkQk^00?NkP01`00NkQk^7^h001k^00000Ik^007001k^7^hNkP0
07^h000037^h00<007^hNkP02G^h00<007^hNkP00g^h00<007^h000017^h00<007^h00000g^h00<0
07^h000017^h00<007^h00001G^h00<007^hNkP00W^h00<007^h00000g^h00<007^h000017^h00<0
07^hNkP037^h00<007^hNkP00W^h00<007^h00002W^h00<007^h00000g^h00<007^h000017^h00<0
07^h000017^h00<007^hNkP00g^h00<007^h00001W^h00L007^hNkQk^000NkP00004NkP00`00NkP0
0003NkP00`00NkP00004NkP00`00NkQk^004NkP00`00NkP00003NkP00`00NkP00004NkP00`00NkP0
000@NkP00`00NkQk^006NkP01@00NkQk^7^h00001W^h00<007^h000017^h00<007^h000037^h00L0
07^hNkQk^000NkP0000<NkP00`00NkQk^002NkP00`00NkQk^00:NkP00`00NkP00004NkP00`00NkP0
0003NkP00`00NkP00004NkP00`00NkP00003NkP00`00NkP00006NkP00`00NkQk^003NkP00`00NkQk
^009NkP00`00NkQk^00<NkP01`00NkQk^7^h001k^00000Yk^003001k^7^h00Ak^003001k^000015k
^003001k^7^h01ek^003001k^7^h00Ik^003001k^7^h01ik^003001k^7^h00mk^003001k^7^h08ak
^0007G^h00<007^hNkP03W^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h0P0037^h
00<007^hNkP02G^h00<007^hNkP017^h00<007^hNkP00g^h0P001G^h0P001G^h00<007^hNkP017^h
00<007^hNkP00g^h00<007^hNkP00g^h0P001G^h00<007^hNkP02W^h00<007^hNkP00g^h0P0037^h
00<007^hNkP00g^h0P001G^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP017^h00<007^h
NkP00g^h0P001G^h00<007^hNkP00g^h0P001G^h00<007^hNkP00g^h0P001G^h00<007^hNkP00g^h
0P004W^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h0P0037^h
00<007^hNkP00g^h0P0037^h00<007^hNkP00g^h00<007^hNkP02W^h00<007^hNkP00g^h0P001G^h
00<007^hNkP00g^h0P001G^h0P001G^h00<007^hNkP017^h00<007^hNkP02G^h00<007^hNkP02g^h
00<007^hNkP00g^h0P002g^h00<007^hNkP017^h00<007^hNkP047^h00<007^hNkP07W^h00<007^h
NkP017^h00<007^hNkP07W^h00<007^hNkP047^h00<007^hNkP0S7^h000MNkP00`00NkQk^007NkP0
0`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^00:NkP0
0`00NkQk^00;NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP0
0`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00:NkP0
0`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP0
0`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP0
0`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP0
0`00NkQk^00@NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^004NkP0
0`00NkQk^00:NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP0
0`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP0
0`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^00;NkP00`00NkQk^00:NkP0
0`00NkQk^003NkP00`00NkQk^00:NkP00`00NkQk^004NkP00`00NkQk^004NkP00`00NkQk^00:NkP0
0`00NkQk^00MNkP00`00NkQk^004NkP00`00NkQk^00NNkP00`00NkQk^00ANkP00`00NkQk^003NkP0
0`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^01hNkP001ek^003001k^7^h00Mk^003001k^7^h
00=k^003001k^7^h00Ak^003001k^7^h00=k^08000Ek^003001k^7^h00Yk^003001k^7^h00]k^003
001k^7^h00=k^003001k^7^h00=k^08000ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h
00Ak^003001k^7^h00=k^003001k^7^h00Yk^003001k^7^h00=k^08000Ek^08000Ek^003001k^7^h
015k^003001k^7^h00=k^003001k^7^h00=k^003001k^7^h01Qk^003001k^7^h00Yk^003001k^7^h
01Qk^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h011k^003001k^7^h
00Ak^08000Ek^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^08000Ek^003001k^7^h
00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^08000Ek^003001k^7^h00=k^003
001k^7^h00]k^003001k^7^h00Uk^003001k^7^h019k^003001k^7^h00Uk^08000ak^003001k^7^h
01ik^003001k^7^h00=k^003001k^7^h01ik^003001k^7^h015k^003001k^7^h00=k^003001k^7^h
00=k^08000Ek^08007Uk^0007G^h00<007^hNkP01W^h00<007^h000017^h00<007^hNkP00g^h00<0
07^h000017^h00<007^h00000g^h00<007^hNkP02W^h00<007^hNkP03G^h00L007^hNkQk^000NkP0
0004NkP00`00NkP0000:NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkP00005NkP00`00NkQk
^002NkP00`00NkP0000:NkP00`00NkP00004NkP00`00NkP00003NkP00`00NkP00004NkP00`00NkQk
^00CNkP01`00NkQk^7^h001k^00000Ak^003001k^7^h01Uk^003001k^7^h00Qk^003001k^00001Uk
^003001k^7^h009k^003001k^7^h00Ek^003001k^7^h009k^003001k^7^h015k^003001k^7^h00=k
^003001k^00000Ak^003001k^00000=k^003001k^7^h00Ik^003001k^7^h009k^003001k^00000=k
^003001k^7^h00Ik^007001k^7^hNkP007^h00001W^h00L007^hNkQk^000NkP00004NkP00`00NkQk
^003NkP00`00NkQk^00=NkP00`00NkQk^008NkP00`00NkQk^00BNkP00`00NkQk^009NkP00`00NkP0
000<NkP00`00NkQk^00MNkP00`00NkQk^002NkP00`00NkQk^00NNkP00`00NkQk^00CNkP01`00NkQk
^7^h001k^00000Ak^003001k^00000=k^003001k^00007Uk^0007G^h00<007^hNkP01W^h00<007^h
00000g^h00<007^hNkP017^h00<007^h00000g^h00@007^hNkP000=k^003001k^7^h00Yk^003001k
^7^h00ek^007001k^7^hNkP007^h00000g^h00@007^hNkP000Yk^003001k^7^h00=k^003001k^7^h
00Ak^003001k^00000Ik^007001k^7^hNkP007^h00002W^h00<007^h00000g^h00@007^hNkP000=k
^004001k^7^h0003NkP00`00NkQk^009NkP30003NkP20002NkP01`00NkQk^7^h001k^00000=k^003
001k^7^h01Yk^003001k^7^h00Qk^003001k^00001Yk^005001k^7^hNkP00008NkP01@00NkQk^7^h
00004W^h00<007^hNkP017^h00@007^hNkP000=k^003001k^00000=k^003001k^7^h00Ik^005001k
^7^hNkP00002NkP00`00NkP000020002NkP20003NkP20003NkP00`00NkP00006NkP01@00NkQk^7^h
00000W^h00D007^hNkQk^00000Ek^003001k^7^h00ek^003001k^7^h00Mk^003001k^7^h01Ak^003
001k^7^h00Mk^004001k^7^h000<NkP00`00NkQk^00NNkP01@00NkQk^7^h00002W^h0`0000Ak^000
000000=k^08000Yk^003001k^7^h01=k^007001k^7^hNkP007^h00000g^h00@007^hNkP000=k^004
001k^7^h001RNkP40002NkP20003NkP20009NkP001ek^003001k^7^h00Ek^005001k^7^hNkP00002
NkP00`00NkQk^003NkP01@00NkQk^7^h00000W^h00L007^hNkQk^000NkP0000<NkP00`00NkQk^00?
NkP00`00NkP00003NkP01000NkQk^0000g^h00<007^hNkP01W^h00<007^hNkP00g^h00<007^hNkP0
17^h00D007^hNkQk^00000Ek^004001k^7^h0003NkP00`00NkQk^006NkP01@00NkQk^7^h00000W^h
00L007^hNkQk^000NkP00003NkP01000NkQk^0003g^h00<007^h00000W^h00H007^hNkP007^h0003
NkP01000NkQk^0007G^h00<007^hNkP01W^h00D007^hNkQk^00001Uk^004001k^7^h0009NkP01000
NkQk^0004g^h00<007^hNkP00g^h00D007^hNkQk^000009k^007001k^7^hNkP007^h00002W^h00@0
07^hNkP000=k^003001k^000009k^006001k^7^h001k^0000W^h00<007^h00000g^h00<007^hNkP0
17^h00<007^h00000g^h00@007^hNkP000Ek^003001k^7^h00mk^003001k^7^h00Ik^003001k^7^h
01Ak^003001k^7^h00Mk^005001k^7^hNkP0000<NkP00`00NkQk^00MNkP01000NkQk^00037^h00<0
07^hNkP00g^h00<007^h00000W^h00<007^hNkP01W^h00<007^hNkP05G^h00<007^h00000g^h00@0
07^hNkP000=k^003001k^00000=k^003001k^7^h065k^005001k^000NkP00002NkP00`00NkP00002
NkP00`00NkQk^006NkP001ek^003001k^7^h00Ek^007001k^7^hNkP007^h00001W^h00L007^hNkQk
^000NkP00004NkP00`00NkP0000<NkP00`00NkQk^00?NkP00`00NkP00003NkP00`00NkP00004NkP0
0`00NkQk^006NkP00`00NkQk^003NkP00`00NkQk^004NkP01@00NkQk^7^h00001W^h00<007^h0000
0g^h00<007^hNkP01W^h00L007^hNkQk^000NkP00004NkP00`00NkP00004NkP00`00NkP0000?NkP0
0`00NkP00002NkP01P00NkQk^000NkP000=k^003001k^00001ik^003001k^7^h00Ik^005001k^7^h
NkP0000JNkP00`00NkP0000:NkP00`00NkP0000BNkP00`00NkQk^004NkP00`00NkQk^002NkP00`00
NkP00003NkP00`00NkP0000:NkP00`00NkP00004NkP00`00NkP00002NkP01P00NkQk^000NkP0009k
^003001k^00000=k^003001k^7^h00Ak^003001k^00000Ak^003001k^00000Ek^003001k^7^h00mk
^003001k^7^h00Ek^003001k^7^h01Ik^003001k^7^h00Ek^003001k^7^h009k^003001k^7^h00Yk
^003001k^7^h01ik^003001k^00000ak^003001k^7^h00=k^003001k^000009k^003001k^7^h00Ik
^003001k^7^h01Ek^003001k^00000=k^003001k^00000Ak^003001k^00000Ak^003001k^7^h065k
^004001k^7^h0002NkP00`00NkP00002NkP00`00NkQk^006NkP001ek^003001k^7^h00Ak^003001k
^7^h00=k^08000Ek^003001k^7^h00=k^08000Ek^003001k^7^h00Yk^003001k^7^h015k^003001k
^7^h00=k^08000Ek^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k
^003001k^7^h00=k^08000Ek^003001k^7^h00Ak^003001k^7^h00=k^08000Ek^003001k^7^h00=k
^080011k^003001k^000009k^005001k^7^hNkP00005NkP2000ONkP00`00NkQk^004NkP00`00NkQk
^003NkP00`00NkQk^00GNkP2000;NkP2000CNkP00`00NkQk^003NkP00`00NkQk^003NkP20005NkP0
0`00NkQk^00:NkP20005NkP20002NkP01P00NkQk^000NkP0009k^08000Ek^003001k^7^h00Ak^003
001k^7^h00=k^08000Ek^003001k^7^h015k^003001k^7^h00Ak^003001k^7^h01Ik^003001k^7^h
00Ek^003001k^7^h00=k^003001k^7^h00Yk^003001k^7^h01ek^08000ek^003001k^7^h00=k^003
001k^000009k^003001k^7^h00Ek^003001k^7^h01Mk^003001k^7^h00=k^08000Ek^003001k^7^h
00=k^003001k^7^h069k^003001k^000009k^003001k^000009k^003001k^7^h00Ik^0007G^h1000
0g^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP0
17^h00<007^hNkP00g^h00<007^hNkP04G^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP0
17^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP0
0g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP017^h00<007^hNkP0
37^h0P000W^h00@007^hNkP000=k^003001k^7^h00=k^003001k^7^h01ik^003001k^7^h00Ak^003
001k^7^h00=k^003001k^7^h01Qk^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003
001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Ak^003001k^7^h00=k^003
001k^7^h00Yk^003001k^7^h00Ak^080009k^006001k^000001k^0000W^h0P001G^h00<007^hNkP0
17^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP04G^h00<007^hNkP00g^h00<007^hNkP0
67^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP0
2W^h00<007^hNkP02W^h00<007^hNkP017^h00<007^hNkP02W^h0P000g^h0P000W^h00@007^hNkP0
00Mk^003001k^7^h01Mk^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Ak^003001k^7^h
00=k^003001k^7^h05]k^003001k^000009k^003001k^000009k^003001k^7^h00Ik^0007G^h00<0
07^hNkP00g^h0P001G^h0P001G^h00<007^hNkP00g^h0P001G^h00<007^hNkP00g^h0P001G^h00<0
07^hNkP05g^h0P001G^h00<007^hNkP00g^h0P001G^h00<007^hNkP00g^h00<007^hNkP017^h00<0
07^hNkP00g^h0P001G^h0P001G^h00<007^hNkP00g^h0P006g^h00D007^hNkQk^000009k^003001k
^7^h02Uk^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h01Ik^08000Ek^003001k^7^h00=k
^08000Ek^08000Ek^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Ak^003001k^7^h011k
^08000Ek^080009k^006001k^000001k^0000W^h00<007^hNkP01G^h00<007^hNkP02G^h0P001G^h
00<007^hNkP04G^h00<007^hNkP00g^h00<007^hNkP067^h00<007^hNkP00g^h00<007^hNkP017^h
00<007^hNkP00g^h0P001G^h00<007^hNkP02W^h00<007^hNkP02W^h00<007^hNkP00g^h00<007^h
NkP02g^h0P000g^h0`0000Ek^000NkQk^00000Ik^003001k^7^h02ak^003001k^7^h00=k^003001k
^7^h05Qk^006001k^7^h001k^0000W^h00<007^h00000W^h00<007^hNkP01W^h000MNkP00`00NkQk
^003NkP00`00NkP00003NkP00`00NkP00004NkP00`00NkP00003NkP00`00NkP00006NkP00`00NkQk
^002NkP00`00NkP00003NkP00`00NkQk^00GNkP00`00NkP00004NkP00`00NkP00004NkP00`00NkP0
0003NkP00`00NkP00004NkP00`00NkQk^003NkP00`00NkP00004NkP00`00NkP00003NkP00`00NkP0
0004NkP00`00NkQk^003NkP00`00NkP0000LNkP20002NkP2000/NkP00`00NkQk^002NkP00`00NkQk
^005NkP00`00NkQk^00FNkP00`00NkP00003NkP00`00NkP00004NkP00`00NkP00003NkP00`00NkP0
0004NkP00`00NkP00003NkP00`00NkQk^004NkP00`00NkQk^006NkP00`00NkQk^00>NkP00`00NkP0
0004NkP30003NkP30002NkP20008NkP00`00NkQk^009NkP00`00NkP00003NkP00`00NkQk^00CNkP0
1@00NkQk^7^h000077^h00D007^hNkQk^00000Qk^007001k^7^hNkP007^h00001W^h00<007^hNkP0
27^h00<007^h00002W^h00<007^h000017^h00<007^hNkP02W^h0`000g^h0`000W^h0P001g^h00<0
07^hNkP0;G^h00L007^hNkQk^000NkP0001JNkP20003NkP20003NkP20009NkP001ek^003001k^7^h
009k^004001k^7^h0003NkP01000NkQk^0000g^h00<007^h00000g^h00@007^hNkP000Ek^005001k
^7^hNkP00002NkP01@00NkQk^7^h00006G^h00@007^hNkP000=k^003001k^00000=k^004001k^7^h
0003NkP00`00NkP00003NkP00`00NkQk^004NkP00`00NkP00003NkP01000NkQk^0000g^h00@007^h
NkP000=k^003001k^7^h00=k^004001k^7^h001>NkP01@00NkQk^7^h000027^h00<007^hNkP057^h
00@007^hNkP000=k^003001k^00000=k^004001k^7^h0003NkP01000NkQk^0000g^h00<007^h0000
0g^h00<007^hNkP017^h00<007^hNkP01W^h00<007^hNkP03W^h00@007^hNkP000=k^003001k^000
00=k^004001k^7^h000<NkP00`00NkQk^007NkP01000NkQk^0000g^h00<007^hNkP04g^h00D007^h
NkQk^00001ak^005001k^7^hNkP00008NkP01@00NkQk^7^h00000W^h00<007^hNkP00g^h00<007^h
NkP027^h00<007^h00002W^h00<007^h00000g^h00<007^hNkP02g^h00<007^h00000g^h00@007^h
NkP000Uk^003001k^7^h02ik^007001k^7^hNkP007^h0000Kg^h000MNkP00`00NkQk^002NkP01`00
NkQk^7^h001k^00000=k^004001k^7^h0003NkP00`00NkP00003NkP00`00NkQk^004NkP01000NkQk
^0000g^h00<007^h00006G^h00D007^hNkQk^000009k^005001k^7^hNkP00002NkP01`00NkQk^7^h
001k^00000=k^004001k^7^h0005NkP01@00NkQk^7^h00000W^h00L007^hNkQk^000NkP00003NkP0
1000NkQk^0001G^h00D007^hNkQk^00004ik^004001k^7^h0009NkP00`00NkQk^00DNkP01`00NkQk
^7^h001k^00000=k^004001k^7^h0003NkP00`00NkP00003NkP01000NkQk^0000g^h00<007^h0000
1W^h00<007^hNkP027^h00<007^hNkP037^h00D007^hNkQk^000009k^007001k^7^hNkP007^h0000
0g^h00<007^hNkP02W^h00<007^hNkP01g^h00L007^hNkQk^000NkP0000GNkP00`00NkP0000NNkP0
0`00NkP0000:NkP00`00NkP00003NkP00`00NkQk^004NkP00`00NkQk^006NkP01@00NkQk^7^h0000
27^h00D007^hNkQk^000009k^003001k^7^h00Yk^007001k^7^hNkP007^h00000g^h00<007^hNkP0
1g^h00<007^hNkP0;g^h00<007^h00000g^h00<007^hNkP0K7^h000MNkP01@00NkQk^7^h000017^h
00<007^h000017^h00<007^h00000g^h00<007^h000017^h00<007^hNkP00g^h00<007^h000017^h
00<007^h00006G^h00<007^hNkP00W^h00<007^h00000g^h00<007^h000017^h00<007^h00000g^h
00<007^h00001W^h00L007^hNkQk^000NkP00004NkP00`00NkP00004NkP00`00NkP00005NkP00`00
NkQk^002NkP00`00NkQk^01<NkP00`00NkP0000:NkP00`00NkQk^00BNkP00`00NkQk^002NkP00`00
NkP00003NkP00`00NkP00004NkP00`00NkP00004NkP00`00NkP00003NkP00`00NkP00006NkP00`00
NkQk^008NkP00`00NkQk^00<NkP00`00NkQk^002NkP00`00NkP00003NkP00`00NkP00004NkP00`00
NkQk^00:NkP00`00NkQk^005NkP00`00NkQk^002NkP00`00NkP0000GNkP00`00NkP0000NNkP00`00
NkP0000:NkP00`00NkP00004NkP00`00NkQk^003NkP00`00NkQk^006NkP01@00NkQk^7^h000027^h
00L007^hNkQk^000NkP0000=NkP01`00NkQk^7^h001k^00000Ak^003001k^7^h00Ek^003001k^7^h
031k^003001k^00000=k^003001k^7^h06ak^0007G^h00D007^hNkQk^00000Ek^003001k^7^h00=k
^08000Ek^003001k^7^h00=k^003001k^7^h00Ak^08000Ek^003001k^7^h01Mk^003001k^7^h00=k
^08000Ek^08000Ek^003001k^7^h00=k^08000Ek^003001k^7^h00=k^08000Ek^003001k^7^h00=k
^08000Ek^003001k^7^h00=k^003001k^7^h04ak^08000]k^003001k^7^h019k^003001k^7^h00=k
^003001k^7^h00=k^08000Ek^003001k^7^h00=k^08000Ek^003001k^7^h00Ak^003001k^7^h00Yk
^003001k^7^h00Yk^003001k^7^h00=k^08000Ek^003001k^7^h00=k^003001k^7^h00Yk^003001k
^7^h00Ek^003001k^7^h00=k^003001k^7^h01Mk^003001k^7^h01ik^003001k^7^h00Yk^003001k
^7^h00=k^003001k^7^h00Ak^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k
^7^h00=k^08000ak^003001k^7^h00=k^003001k^7^h00=k^003001k^7^h00Ek^003001k^7^h035k
^003001k^7^h00=k^003001k^7^h06]k^0007G^h00@007^hNkP000Ik^003001k^7^h00Ak^003001k
^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h015k^003001k
^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k
^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Ak^003001k^7^h00=k^003001k
^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h03mk^003001k^7^h00Yk^003001k
^7^h011k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Ak^003001k
^7^h00=k^003001k^7^h00Ak^003001k^7^h00Yk^003001k^7^h00=k^003001k^7^h00Ak^003001k
^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k
^7^h00=k^003001k^7^h00Ak^003001k^7^h01Mk^003001k^7^h01ik^003001k^7^h00Yk^003001k
^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k
^7^h00=k^003001k^7^h00Ak^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k
^7^h00=k^003001k^7^h039k^003001k^7^h00=k^003001k^7^h06]k^0007G^h00<007^hNkP00P00
1G^h00<007^hNkP00g^h0P001G^h00<007^hNkP00g^h0P001G^h0P001G^h00<007^hNkP047^h0P00
1G^h00<007^hNkP00g^h0P001G^h0P001G^h00<007^hNkP00g^h0P001G^h00<007^hNkP017^h00<0
07^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h0P00
1G^h00<007^hNkP0C7^h00<007^hNkP047^h00<007^hNkP017^h00<007^hNkP00g^h0P001G^h00<0
07^hNkP02W^h00<007^hNkP00g^h00<007^hNkP02g^h00<007^hNkP00g^h0P001G^h00<007^hNkP0
4G^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP0Dg^h00<007^hNkP0
0g^h00<007^hNkP00g^h00<007^hNkP01G^h00<007^hNkP00g^h00<007^hNkP02W^h00<007^hNkP0
0g^h00<007^hNkP02g^h00<007^hNkP00g^h00<007^hNkP0>G^h00<007^hNkP0JW^h000MNkP01@00
NkP007^h000017^h00<007^h000017^h00<007^h00000g^h00<007^h000017^h00<007^h00000g^h
00<007^h000017^h00<007^h00004G^h00<007^h00000g^h00<007^h000017^h00<007^h00000g^h
00<007^h000017^h00<007^h00000g^h00<007^h000017^h00<007^hNkP01G^h00<007^hNkP00W^h
00<007^h00001W^h00D007^hNkQk^00000Qk^007001k^7^hNkP007^h000017^h00<007^h0000CW^h
00<007^hNkP03W^h00<007^hNkP017^h00<007^h00000g^h00<007^h00001W^h00<007^hNkP027^h
00<007^hNkP017^h00<007^hNkP037^h00L007^hNkQk^000NkP00004NkP00`00NkQk^00CNkP01`00
NkQk^7^h001k^00000Ik^005001k^7^hNkP0001GNkP00`00NkQk^003NkP00`00NkQk^002NkP00`00
NkQk^005NkP00`00NkQk^002NkP00`00NkQk^00:NkP00`00NkP00004NkP00`00NkQk^00<NkP01@00
NkQk^7^h0000?7^h00<007^hNkP0JW^h000MNkP00`00NkP00002NkP01`00NkQk^7^h001k^00000=k
^004001k^7^h0003NkP00`00NkP00003NkP01000NkQk^0000g^h00@007^hNkP000=k^003001k^000
011k^004001k^7^h0003NkP00`00NkP00003NkP01000NkQk^0000g^h00@007^hNkP000=k^003001k
^00000=k^004001k^7^h0003NkP00`00NkQk^006NkP01`00NkQk^7^h001k^00000Ik^005001k^7^h
NkP00008NkP01@00NkQk^7^h00000W^h00L007^hNkQk^000NkP0001>NkP00`00NkQk^00>NkP00`00
NkQk^004NkP00`00NkP00003NkP01000NkQk^0001G^h00<007^hNkP027^h00<007^hNkP00g^h00<0
07^hNkP03G^h00D007^hNkQk^000009k^005001k^7^hNkP0000ENkP01`00NkQk^7^h001k^00000Ik
^005001k^7^hNkP0001GNkP00`00NkQk^003NkP01@00NkQk^7^h00002G^h00D007^hNkQk^00000ak
^003001k^00000=k^003001k^7^h00ek^005001k^7^hNkP0000mNkP00`00NkQk^01YNkP001ek^080
00=k^004001k^7^h0003NkP01000NkQk^0000g^h00<007^h00000g^h00@007^hNkP000=k^003001k
^00000=k^004001k^7^h0003NkP00`00NkQk^00=NkP01`00NkQk^7^h001k^00000=k^004001k^7^h
0003NkP00`00NkP00003NkP01000NkQk^0000g^h00<007^h00000g^h00@007^hNkP000Uk^004001k
^7^h0003NkP00`00NkQk^004NkP00`00NkP0000:NkP00`00NkP00003NkP01000NkQk^0000g^h00<0
07^hNkP0C7^h00<007^hNkP037^h00<007^hNkP017^h00L007^hNkQk^000NkP00003NkP00`00NkQk
^004NkP00`00NkQk^006NkP00`00NkQk^004NkP00`00NkQk^00>NkP00`00NkP00003NkP01000NkQk
^0005g^h00<007^h00000g^h00<007^hNkP017^h00<007^h0000FG^h00<007^hNkP00g^h00@007^h
NkP000Uk^004001k^7^h000<NkP01@00NkQk^7^h00000W^h00<007^hNkP03W^h00<007^h0000?W^h
00<007^hNkP0JG^h000MNkP20004NkP00`00NkP00003NkP00`00NkP00004NkP00`00NkP00003NkP0
0`00NkP00004NkP00`00NkP00004NkP00`00NkP00003NkP00`00NkQk^00<NkP00`00NkQk^002NkP0
0`00NkP00003NkP00`00NkP00004NkP00`00NkP00004NkP00`00NkP00003NkP00`00NkP00004NkP0
0`00NkP0000:NkP00`00NkP00003NkP00`00NkQk^004NkP00`00NkP0000:NkP00`00NkP00004NkP0
0`00NkP00003NkP00`00NkQk^01<NkP00`00NkQk^00<NkP00`00NkQk^004NkP01`00NkQk^7^h001k
^00000Ak^003001k^7^h00=k^003001k^7^h00Ik^003001k^7^h00=k^003001k^7^h00mk^003001k
^00000Ak^003001k^00001Mk^003001k^00000=k^003001k^7^h00Ak^003001k^00005Uk^003001k
^7^h00=k^003001k^00000]k^003001k^00000ak^007001k^7^hNkP007^h00004G^h00<007^h0000
?g^h00<007^hNkP0J7^h000MNkP00`00NkQk^003NkP20005NkP20005NkP00`00NkQk^003NkP20005
NkP00`00NkQk^003NkP20005NkP00`00NkQk^00;NkP00`00NkQk^003NkP00`00NkQk^003NkP20005
NkP00`00NkQk^003NkP20005NkP00`00NkQk^003NkP2000;NkP20005NkP00`00NkQk^004NkP00`00
NkQk^00:NkP00`00NkQk^003NkP20005NkP00`00NkQk^01<NkP00`00NkQk^00:NkP00`00NkQk^004
NkP00`00NkQk^003NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^004NkP00`00NkQk^004
NkP00`00NkQk^00@NkP00`00NkQk^003NkP2000INkP00`00NkQk^003NkP00`00NkQk^004NkP00`00
NkQk^01INkP00`00NkQk^003NkP2000;NkP2000<NkP00`00NkQk^003NkP2000BNkP00`00NkQk^00n
NkP00`00NkQk^01XNkP000ek^?l00?l00;4000007G^h00<007^hNkP00g^h0P001G^h0P001G^h00<0
07^hNkP02W^h00<007^hNkP00g^h0P001G^h00<007^hNkP00g^h0P001G^h00<007^hNkP017^h00<0
07^hNkP02W^h00<007^hNkP02W^h00<007^hNkP00g^h0P002g^h00<007^hNkP01G^h00<007^hNkP0
0g^h00<007^hNkP00g^h00<007^hNkP04G^h00<007^hNkP02W^h00<007^hNkP02W^h0P001G^h00<0
07^hNkP00g^h0P001G^h00<007^hNkP07W^h00<007^hNkP00g^h0P001G^h00<007^hNkP00g^h00<0
07^hNkP02g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP00g^h00<007^hNkP02g^h00<0
07^hNkP00g^h00<007^hNkP05g^h00<007^hNkP02g^h00<007^hNkP00g^h00<007^hNkP00g^h0P00
1G^h00<007^hNkP07W^h00<007^hNkP07W^h00<007^hNkP02W^h00<007^hNkP00g^h0P002g^h0P00
1G^h00<007^hNkP00g^h00<007^hNkP04G^h00<007^hNkP07W^h00<007^hNkP07W^h00<007^hNkP0
17^h00<007^hNkP05g^h00<007^hNkP05g^h00<007^hNkP00g^h0P0087^h00<007^hNkP02g^h000M
NkP20004NkP00`00NkP00003NkP00`00NkP00004NkP00`00NkQk^00;NkP00`00NkQk^003NkP00`00
NkP00003NkP00`00NkP00004NkP00`00NkP00003NkP00`00NkQk^005NkP00`00NkQk^009NkP00`00
NkQk^00:NkP00`00NkQk^004NkP3000:NkP00`00NkQk^005NkP00`00NkQk^002NkP00`00NkQk^004
NkP00`00NkQk^00BNkP00`00NkQk^009NkP00`00NkQk^009NkP00`00NkP00004NkP00`00NkP00004
NkP00`00NkP00004NkP00`00NkQk^00NNkP20003NkP00`00NkP00004NkP00`00NkQk^004NkP00`00
NkQk^00;NkP20005NkP00`00NkQk^002NkP00`00NkQk^003NkP00`00NkQk^00<NkP00`00NkQk^002
NkP00`00NkQk^00HNkP00`00NkQk^00;NkP00`00NkQk^002NkP00`00NkP00004NkP00`00NkP00004
NkP00`00NkQk^00NNkP00`00NkQk^00MNkP3000<NkP01`00NkQk^7^h001k^00000]k^0<000=k^003
001k^00000Ak^003001k^7^h015k^003001k^7^h01ik^003001k^7^h01ik^003001k^7^h00Ek^003
001k^7^h01Ik^003001k^7^h01Ik^003001k^00000Ak^0<001mk^003001k^7^h00]k^0007G^h0P00
0g^h00@007^hNkP000=k^004001k^7^h0003NkP00`00NkQk^00@NkP01000NkQk^0000g^h00<007^h
00000g^h00@007^hNkP000=k^003001k^7^h015k^003001k^7^h00Yk^003001k^7^h00=k^004001k
^7^h0009NkP00`00NkQk^007NkP01@00NkQk^7^h00006g^h00<007^hNkP02G^h00<007^hNkP02G^h
00@007^hNkP000=k^003001k^00000=k^004001k^7^h000VNkP01@00NkQk^7^h00000W^h00D007^h
NkQk^00000Ek^003001k^7^h00ek^003001k^7^h00Ak^005001k^7^hNkP00005NkP00`00NkQk^00A
NkP00`00NkQk^00HNkP00`00NkQk^00<NkP01`00NkQk^7^h001k^00000=k^004001k^7^h0015NkP0
0`00NkP0000<NkP01@00NkQk^7^h00000W^h00<007^hNkP01g^h00@007^hNkP000=k^003001k^000
00=k^003001k^7^h019k^003001k^7^h04Mk^003001k^7^h02mk^003001k^00000=k^004001k^7^h
000ONkP00`00NkQk^00;NkP001ek^003001k^000009k^007001k^7^hNkP007^h00000g^h00@007^h
NkP001=k^007001k^7^hNkP007^h00000g^h00@007^hNkP000=k^003001k^00001=k^003001k^7^h
00Yk^003001k^7^h00Ak^005001k^7^hNkP00008NkP00`00NkQk^007NkP01000NkQk^0007G^h00<0
07^hNkP027^h00<007^hNkP027^h00D007^hNkQk^000009k^005001k^7^hNkP00002NkP01@00NkQk
^7^h00009W^h00<007^h00000g^h00@007^hNkP000Ik^003001k^7^h00ik^003001k^7^h00=k^004
001k^7^h0005NkP00`00NkQk^00ANkP00`00NkQk^00INkP00`00NkQk^00<NkP01000NkQk^0000g^h
00@007^hNkP000=k^003001k^7^h045k^005001k^7^hNkP0000<NkP00`00NkP00003NkP00`00NkQk
^007NkP01`00NkQk^7^h001k^00000=k^004001k^7^h000DNkP00`00NkQk^018NkP00`00NkQk^00]
NkP01@00NkQk^7^h00000W^h00D007^hNkQk^00001ik^003001k^7^h00]k^0007G^h00D007^h001k
^00000Ak^003001k^00000Ak^003001k^000019k^003001k^7^h009k^003001k^00000=k^003001k
^00000Ak^003001k^00001=k^003001k^7^h00Yk^003001k^7^h00=k^003001k^7^h009k^003001k
^7^h00Ek^003001k^7^h00Uk^003001k^00001ek^003001k^7^h01=k^003001k^7^h009k^003001k
^00000=k^003001k^00000Ak^003001k^7^h02Ak^003001k^00000Ak^003001k^00000Ek^003001k
^7^h00mk^003001k^7^h00Ak^003001k^00000Ek^003001k^7^h015k^003001k^7^h02Uk^003001k
^00000=k^003001k^00000Ak^003001k^7^h045k^005001k^7^hNkP0000<NkP00`00NkP00004NkP0
0`00NkQk^005NkP00`00NkQk^002NkP00`00NkP00003NkP00`00NkP0001PNkP00`00NkQk^00]NkP0
1`00NkQk^7^h001k^00000Ak^003001k^7^h02Yk^0007G^h00<007^hNkP00P001G^h00<007^hNkP0
0g^h0P004g^h00<007^hNkP00g^h00<007^hNkP00g^h0P001G^h00<007^hNkP04G^h00<007^hNkP0
2W^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP02G^h0P007g^h00<0
07^hNkP04G^h00<007^hNkP00g^h0P001G^h0P001G^h00<007^hNkP097^h00<007^hNkP00g^h0P00
1W^h00<007^hNkP047^h00<007^hNkP00g^h0P001G^h00<007^hNkP04G^h00<007^hNkP0:W^h0P00
1G^h0P001G^h00<007^hNkP0?g^h00<007^hNkP00g^h00<007^hNkP02W^h00<007^hNkP00g^h00<0
07^hNkP01G^h00<007^hNkP00g^h00<007^hNkP00g^h0P00HG^h00<007^hNkP0:g^h00<007^hNkP0
0g^h0P001G^h00<007^hNkP0:G^h000MNkP01000NkQk^0001W^h00<007^hNkP017^h00<007^hNkP0
0g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP0
17^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP02W^h00<007^hNkP0
0g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP02g^h00<007^hNkP07G^h00<007^hNkP0
17^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP0
17^h00<007^hNkP04G^h00<007^hNkP00g^h00<007^hNkP02W^h00<007^hNkP017^h00<007^hNkP0
0g^h00<007^hNkP04G^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP04G^h00<007^hNkP0
:g^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP07W^h00<007^hNkP0
67^h00<007^hNkP00g^h00<007^hNkP02W^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP0
17^h00<007^hNkP00g^h00<007^hNkP0H7^h00<007^hNkP0:g^h00<007^hNkP00g^h00<007^hNkP0
17^h00<007^hNkP017^h00<007^hNkP08W^h000MNkP01@00NkQk^7^h00001G^h00<007^hNkP017^h
00<007^hNkP00g^h00<007^hNkP00g^h0P001G^h00<007^hNkP017^h00<007^hNkP017^h00<007^h
NkP00g^h00<007^hNkP00g^h0P001G^h00<007^hNkP00g^h0P0037^h00<007^hNkP00g^h00<007^h
NkP017^h00<007^hNkP00g^h00<007^hNkP02g^h00<007^hNkP07W^h00<007^hNkP00g^h00<007^h
NkP00g^h0P001G^h00<007^hNkP04G^h00<007^hNkP047^h0P001G^h00<007^hNkP047^h0P001G^h
00<007^hNkP04G^h00<007^hNkP00g^h0P001G^h00<007^hNkP04G^h00<007^hNkP0>7^h00<007^h
NkP00g^h0P007g^h0P0067^h00<007^hNkP017^h00<007^hNkP04G^h00<007^hNkP00g^h00<007^h
NkP0KG^h00<007^hNkP0:g^h00<007^hNkP02W^h00<007^hNkP00g^h0P0097^h000MNkP01@00NkQk
^7^h000017^h00<007^hNkP01W^h00L007^hNkQk^000NkP00004NkP00`00NkP00003NkP00`00NkQk
^004NkP00`00NkP00005NkP00`00NkQk^002NkP00`00NkP00004NkP00`00NkP00003NkP00`00NkP0
0004NkP00`00NkP0000:NkP00`00NkQk^003NkP00`00NkQk^006NkP01@00NkQk^7^h00003g^h00<0
07^hNkP07G^h00<007^hNkP00W^h00<007^h000017^h00<007^h00000g^h00<007^hNkP04g^h00<0
07^hNkP03g^h00<007^h00000g^h00<007^h00004G^h00<007^h00000g^h00<007^hNkP04g^h00<0
07^hNkP00W^h00<007^h00000g^h00<007^hNkP04G^h00<007^hNkP0>W^h00L007^hNkQk^000NkP0
000NNkP00`00NkP0000HNkP00`00NkQk^005NkP00`00NkQk^00ANkP01@00NkQk^7^h0000LG^h00<0
07^hNkP0:G^h00<007^hNkP037^h00<007^hNkP00W^h00<007^h00008g^h000MNkP00`00NkQk^002
NkP01@00NkQk^7^h000027^h00L007^hNkQk^000NkP00003NkP01000NkQk^0000g^h00<007^hNkP0
17^h00<007^h00001W^h00L007^hNkQk^000NkP00003NkP01000NkQk^0000g^h00<007^h00000g^h
00@007^hNkP000Yk^003001k^7^h00=k^003001k^7^h00Ik^005001k^7^hNkP0000?NkP00`00NkQk
^00NNkP01`00NkQk^7^h001k^00000=k^004001k^7^h0003NkP00`00NkQk^00CNkP00`00NkQk^00>
NkP01000NkQk^0000g^h00<007^h000047^h00@007^hNkP000=k^003001k^7^h01=k^005001k^7^h
NkP00002NkP01@00NkQk^7^h00004g^h00<007^hNkP0>W^h00D007^hNkQk^000009k^003001k^7^h
01]k^004001k^7^h000FNkP00`00NkQk^006NkP00`00NkQk^00ANkP01@00NkQk^7^h0000LG^h00<0
07^hNkP0:G^h00<007^hNkP037^h00D007^hNkQk^000009k^003001k^7^h025k^0007G^h00<007^h
NkP00W^h00@007^hNkP000Yk^003001k^00000=k^004001k^7^h0003NkP00`00NkP00006NkP01@00
NkQk^7^h00001G^h00@007^hNkP000=k^004001k^7^h0003NkP00`00NkP00003NkP01000NkQk^000
0g^h00<007^hNkP01W^h00<007^hNkP00g^h00<007^hNkP027^h00<007^h00004G^h00<007^hNkP0
7G^h00@007^hNkP000=k^004001k^7^h0003NkP00`00NkP0000GNkP00`00NkQk^00=NkP01`00NkQk
^7^h001k^00000=k^003001k^7^h00ek^007001k^7^hNkP007^h00005g^h00@007^hNkP000=k^003
001k^00001=k^003001k^7^h03ak^003001k^00000=k^003001k^7^h01Yk^005001k^7^hNkP0000F
NkP00`00NkQk^007NkP00`00NkQk^00ANkP00`00NkP0001cNkP00`00NkQk^00WNkP00`00NkQk^00>
NkP01000NkQk^0000g^h00<007^hNkP087^h000MNkP00`00NkQk^003NkP00`00NkP0000:NkP00`00
NkP00003NkP00`00NkP00004NkP00`00NkP00006NkP01@00NkQk^7^h00001W^h00<007^h00000g^h
00<007^h000017^h00<007^h00000g^h00<007^h000017^h00<007^hNkP01W^h00<007^hNkP00g^h
00<007^hNkP027^h00<007^h00004G^h00<007^hNkP07W^h00<007^h00000g^h00<007^h000017^h
00<007^h00005g^h00<007^hNkP037^h00<007^hNkP00W^h00<007^h00000g^h00<007^hNkP037^h
00<007^hNkP00W^h00<007^h00005g^h00<007^h000017^h00<007^h00004g^h00<007^hNkP0?7^h
00<007^h000017^h00<007^hNkP06G^h00<007^hNkP00W^h00<007^hNkP04W^h00<007^hNkP027^h
00<007^hNkP04G^h00<007^h0000Lg^h00<007^hNkP09g^h00<007^hNkP03W^h00<007^h000017^h
00<007^hNkP087^h000MNkP00`00NkQk^003NkP2000<NkP00`00NkQk^003NkP20005NkP00`00NkQk
^004NkP00`00NkQk^003NkP00`00NkQk^003NkP20005NkP20005NkP00`00NkQk^003NkP20005NkP0
0`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^00:NkP00`00NkQk^00ANkP00`00NkQk^00MNkP2
0005NkP20005NkP00`00NkQk^00GNkP00`00NkQk^00;NkP00`00NkQk^003NkP00`00NkQk^003NkP0
0`00NkQk^00;NkP00`00NkQk^003NkP00`00NkQk^00GNkP20005NkP00`00NkQk^00ANkP00`00NkQk
^00nNkP00`00NkQk^003NkP00`00NkQk^00HNkP00`00NkQk^003NkP00`00NkQk^00BNkP00`00NkQk
^009NkP00`00NkQk^00ANkP00`00NkQk^01cNkP00`00NkQk^00UNkP00`00NkQk^00@NkP20005NkP0
0`00NkQk^00ONkP001ek^0@000=k^003001k^7^h00Yk^003001k^7^h00=k^003001k^7^h00Ak^003
001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003
001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Yk^003
001k^7^h015k^003001k^7^h00=k^003001k^7^h01Qk^003001k^7^h00=k^003001k^7^h00Ak^003
001k^7^h01Mk^003001k^7^h00Yk^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Yk^003
001k^7^h00Ak^003001k^7^h00Yk^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003
001k^7^h00Yk^003001k^7^h00Ak^003001k^7^h03ik^003001k^7^h00Ak^003001k^7^h00=k^003
001k^7^h00Yk^003001k^7^h00Ak^003001k^7^h00Ak^003001k^7^h011k^003001k^7^h00Yk^003
001k^7^h00Yk^003001k^7^h00Ak^003001k^7^h07=k^003001k^7^h02Ek^003001k^7^h011k^003
001k^7^h00Ak^003001k^7^h01mk^0007G^h00<007^hNkP04G^h00<007^hNkP00g^h0P001G^h00<0
07^hNkP00g^h0P001G^h00<007^hNkP00g^h0P001G^h0P001G^h00<007^hNkP00g^h0P001G^h00<0
07^hNkP00g^h00<007^hNkP017^h00<007^hNkP07W^h00<007^hNkP00g^h0P00@7^h00<007^hNkP0
2W^h00<007^hNkP02g^h00<007^hNkP02G^h00<007^hNkP04G^h00<007^hNkP00g^h0P001G^h00<0
07^hNkP017^h00<007^hNkP02W^h00<007^hNkP00g^h00<007^hNkP0AW^h00<007^hNkP00g^h0P00
2g^h0P001G^h00<007^hNkP017^h00<007^hNkP047^h00<007^hNkP02g^h00<007^hNkP02G^h0P00
1G^h00<007^hNkP0Lg^h00<007^hNkP097^h00<007^hNkP067^h00<007^hNkP07g^h000MNkP00`00
NkQk^00BNkP01`00NkQk^7^h001k^00000Ak^003001k^00000Ak^003001k^00000=k^003001k^000
00Ak^003001k^00000=k^003001k^00000Ak^003001k^00000=k^003001k^00000Ik^003001k^7^h
009k^003001k^7^h00=k^003001k^7^h021k^007001k^7^hNkP007^h0000@G^h00<007^hNkP027^h
00<007^hNkP037^h00<007^hNkP027^h00<007^hNkP04G^h00<007^h000017^h00<007^h00000g^h
00<007^hNkP01W^h00<007^hNkP027^h00<007^h000017^h00<007^hNkP0Ag^h00L007^hNkQk^000
NkP0000:NkP00`00NkP00004NkP00`00NkQk^006NkP00`00NkQk^00>NkP00`00NkQk^00<NkP00`00
NkQk^008NkP00`00NkP00004NkP00`00NkP0001eNkP00`00NkQk^00SNkP00`00NkQk^00INkP00`00
NkQk^00NNkP001ek^003001k^7^h019k^005001k^7^hNkP00002NkP01`00NkQk^7^h001k^00000=k
^004001k^7^h0003NkP00`00NkP00003NkP01000NkQk^0000g^h00@007^hNkP000=k^003001k^000
00=k^004001k^7^h0005NkP01@00NkQk^7^h00001W^h00<007^hNkP087^h00D007^hNkQk^000009k
^003001k^7^h03ik^003001k^7^h00Qk^003001k^7^h00ek^003001k^7^h00Mk^003001k^7^h015k
^003001k^00000=k^004001k^7^h0003NkP00`00NkQk^006NkP00`00NkQk^008NkP00`00NkP00003
NkP00`00NkQk^018NkP01@00NkQk^7^h00000W^h00<007^hNkP01g^h00@007^hNkP000=k^003001k
^7^h00Ik^003001k^7^h00ik^003001k^7^h00ek^003001k^7^h00Mk^004001k^7^h0003NkP00`00
NkP0001eNkP00`00NkQk^00RNkP00`00NkQk^00JNkP00`00NkQk^00NNkP001ek^003001k^7^h01=k
^003001k^00000=k^004001k^7^h0003NkP01000NkQk^0000g^h00<007^h00000g^h00@007^hNkP0
00=k^003001k^00000=k^004001k^7^h0003NkP00`00NkP00003NkP00`00NkQk^004NkP01000NkQk
^0001G^h00<007^hNkP08W^h00<007^h00000g^h00<007^hNkP0?g^h00<007^hNkP01W^h00<007^h
NkP03W^h00<007^hNkP01W^h00<007^hNkP04G^h00D007^hNkQk^000009k^007001k^7^hNkP007^h
00002W^h00<007^hNkP01W^h00D007^hNkQk^000009k^003001k^7^h04Uk^003001k^00000=k^003
001k^7^h00Ik^005001k^7^hNkP00002NkP00`00NkQk^008NkP00`00NkQk^00<NkP00`00NkQk^00>
NkP00`00NkQk^006NkP01@00NkQk^7^h00000W^h00D007^hNkQk^00007Ek^003001k^7^h025k^003
001k^7^h01]k^003001k^7^h01ek^0007G^h00<007^hNkP04g^h00<007^h000017^h00<007^h0000
0g^h00<007^h000017^h00<007^h00000g^h00<007^h000017^h00<007^h000017^h00<007^h0000
0g^h00<007^h000017^h00<007^hNkP00g^h00<007^h00001W^h00<007^hNkP08W^h00<007^h0000
17^h00<007^hNkP0?W^h00<007^hNkP01W^h00<007^hNkP03g^h00<007^hNkP01G^h00<007^hNkP0
4G^h00L007^hNkQk^000NkP00004NkP00`00NkP0000:NkP00`00NkQk^006NkP01`00NkQk^7^h001k
^00004ak^003001k^00000Ak^003001k^7^h00Ek^003001k^7^h009k^003001k^00000Yk^003001k
^7^h00ak^003001k^7^h00mk^003001k^7^h00Ek^003001k^7^h009k^003001k^00000=k^003001k
^7^h07=k^003001k^7^h021k^003001k^7^h01ak^003001k^7^h01ek^0007G^h00<007^hNkP057^h
00<007^hNkP00g^h0P001G^h0P001G^h00<007^hNkP00g^h0P001G^h00<007^hNkP00g^h0P001G^h
00<007^hNkP00g^h00<007^hNkP017^h0P001G^h00<007^hNkP097^h00<007^hNkP00g^h00<007^h
NkP0?g^h00<007^hNkP017^h00<007^hNkP047^h00<007^hNkP017^h00<007^hNkP04G^h00<007^h
NkP00g^h0P001G^h00<007^hNkP02W^h00<007^hNkP017^h00<007^hNkP00g^h0P00CG^h00<007^h
NkP00g^h00<007^hNkP017^h00<007^hNkP00g^h0P0037^h00<007^hNkP02W^h00<007^hNkP047^h
00<007^hNkP017^h00<007^hNkP00g^h0P001G^h00<007^hNkP0Lg^h00<007^hNkP07g^h00<007^h
NkP07G^h00<007^hNkP077^h000MNkP00`00NkQk^00DNkP00`00NkQk^004NkP00`00NkQk^003NkP0
0`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^004NkP00`00NkQk^003NkP0
0`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00TNkP00`00NkQk^004NkP0
0`00NkQk^00nNkP00`00NkQk^004NkP00`00NkQk^00ANkP00`00NkQk^003NkP00`00NkQk^00ANkP0
0`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00:NkP00`00NkQk^004NkP00`00NkQk^003NkP0
0`00NkQk^01<NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00:NkP0
0`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00ANkP00`00NkQk^003NkP00`00NkQk^004NkP0
0`00NkQk^003NkP00`00NkQk^00UNkP00`00NkQk^01;NkP00`00NkQk^004NkP00`00NkQk^004NkP0
0`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^00NNkP00`00NkQk^00LNkP0
01ek^003001k^7^h01Ak^003001k^7^h00Yk^003001k^7^h00Ak^003001k^7^h00Ak^003001k^7^h
00=k^003001k^7^h00=k^003001k^7^h00]k^003001k^7^h00=k^08000Ek^003001k^7^h02]k^003
001k^7^h03mk^003001k^7^h00=k^003001k^7^h015k^003001k^7^h00=k^003001k^7^h015k^003
001k^7^h01Mk^003001k^7^h00=k^003001k^7^h05Yk^003001k^7^h00=k^003001k^7^h015k^003
001k^7^h00=k^08000Ek^003001k^7^h015k^003001k^7^h00=k^003001k^7^h00]k^003001k^7^h
02=k^08004ik^003001k^7^h00=k^003001k^7^h00=k^08000Ek^003001k^7^h00=k^08000Ek^003
001k^7^h01ik^003001k^7^h01ak^0007G^h00<007^hNkP05G^h00<007^hNkP027^h00<007^hNkP0
1W^h00<007^hNkP00g^h00<007^hNkP00W^h00<007^hNkP017^h00<007^hNkP037^h00L007^hNkQk
^000NkP00004NkP00`00NkQk^00]NkP00`00NkQk^00nNkP00`00NkQk^002NkP00`00NkQk^00CNkP0
1@00NkQk^7^h00004g^h00<007^hNkP06G^h00<007^hNkP00W^h00<007^hNkP0Fg^h00D007^hNkQk
^00001Ek^007001k^7^hNkP007^h000017^h00<007^hNkP04g^h00D007^hNkQk^00000ik^003001k
^7^h02=k^003001k^00004ek^003001k^7^h009k^003001k^00000Ak^003001k^00000=k^003001k
^00000Ak^003001k^00000=k^003001k^7^h021k^003001k^7^h01]k^0007G^h00<007^hNkP05G^h
00<007^hNkP027^h00<007^hNkP01W^h00<007^hNkP017^h00D007^hNkQk^00000Ek^003001k^7^h
00ek^005001k^7^hNkP00002NkP01@00NkQk^7^h0000;g^h00<007^hNkP0?g^h00D007^hNkQk^000
01Ek^005001k^7^hNkP0000CNkP00`00NkQk^00INkP01@00NkQk^7^h0000GW^h00D007^hNkQk^000
01Ek^005001k^7^hNkP00002NkP01@00NkQk^7^h00005G^h00D007^hNkQk^00000mk^003001k^7^h
025k^004001k^7^h001>NkP01`00NkQk^7^h001k^00000=k^004001k^7^h0003NkP00`00NkP00003
NkP01000NkQk^0000g^h00<007^hNkP087^h00<007^hNkP06g^h000MNkP00`00NkQk^00FNkP00`00
NkQk^006NkP00`00NkQk^008NkP00`00NkQk^003NkP01000NkQk^0001W^h00<007^hNkP03W^h00<0
07^h00000g^h00@007^hNkP0035k^003001k^7^h03ik^004001k^7^h000GNkP00`00NkP0000CNkP0
0`00NkQk^00KNkP01000NkQk^000Gg^h00<007^h00005g^h00<007^h00000g^h00@007^hNkP001Mk
^003001k^000011k^003001k^7^h025k^005001k^7^hNkP0001=NkP01000NkQk^0000g^h00@007^h
NkP000=k^003001k^00000=k^004001k^7^h0003NkP00`00NkP0000TNkP00`00NkQk^00JNkP001ek
^003001k^7^h01Ik^003001k^7^h00Ik^003001k^7^h00Qk^003001k^7^h00Ak^003001k^00000Ek
^003001k^7^h00mk^003001k^00000Ak^003001k^000035k^003001k^7^h03mk^003001k^00001Mk
^003001k^00001=k^003001k^7^h01]k^003001k^000061k^003001k^00001Mk^003001k^00000Ak
^003001k^00001Mk^003001k^000015k^003001k^7^h01mk^003001k^7^h009k^003001k^7^h04ak
^003001k^00000=k^003001k^00000Ak^003001k^00000=k^003001k^00000Ak^003001k^00002Ak
^003001k^7^h01Yk^0007G^h00<007^hNkP05g^h00<007^hNkP017^h00<007^hNkP02W^h00<007^h
NkP00g^h0P001W^h00<007^hNkP047^h00<007^hNkP00g^h0P00<g^h00<007^hNkP0?W^h0P006G^h
00<007^hNkP04G^h00<007^hNkP07G^h0P00HG^h00<007^hNkP05g^h00<007^hNkP00g^h0P006G^h
00<007^hNkP047^h00<007^hNkP07g^h00<007^hNkP00g^h00<007^hNkP0Bg^h0P001G^h0P001G^h
00<007^hNkP00g^h0P001G^h00<007^hNkP097^h00<007^hNkP06G^h000MNkP4000FNkP00`00NkQk
^004NkP00`00NkQk^00:NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^00ANkP00`00NkQk
^004NkP00`00NkQk^00aNkP00`00NkQk^00oNkP00`00NkQk^00GNkP00`00NkQk^003NkP00`00NkQk
^004NkP00`00NkQk^004NkP00`00NkQk^00MNkP00`00NkQk^01PNkP00`00NkQk^00GNkP00`00NkQk
^004NkP00`00NkQk^00GNkP00`00NkQk^00ANkP00`00NkQk^00@NkP00`00NkQk^00:NkP00`00NkQk
^004NkP00`00NkQk^015NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk
^003NkP00`00NkQk^004NkP00`00NkQk^00TNkP00`00NkQk^00INkP001ek^003001k^7^h01Qk^003
001k^7^h00=k^003001k^7^h00Yk^003001k^7^h00Yk^003001k^7^h01Qk^003001k^7^h035k^003
001k^7^h05mk^08000Ek^003001k^7^h00=k^003001k^7^h0=1k^003001k^7^h011k^08000]k^003
001k^7^h00Ak^003001k^7^h04Ek^003001k^7^h00=k^080045k^003001k^7^h01Qk^0007G^h00<0
07^hNkP067^h00<007^hNkP00W^h00<007^hNkP037^h00<007^hNkP027^h00<007^hNkP06W^h00<0
07^hNkP0<G^h00<007^hNkP0GG^h00<007^h000017^h00<007^h000017^h00<007^hNkP0dG^h00<0
07^hNkP03W^h00<007^h00002W^h00<007^hNkP01W^h00<007^hNkP0@g^h00<007^h000017^h00<0
07^h0000@7^h00<007^hNkP067^h000MNkP00`00NkQk^00INkP01@00NkQk^7^h00003W^h00<007^h
NkP027^h00<007^hNkP06W^h00<007^hNkP0<G^h00<007^hNkP0GG^h00@007^hNkP000=k^003001k
^00000=k^003001k^7^h0=9k^003001k^7^h00ik^004001k^7^h0009NkP00`00NkQk^006NkP00`00
NkQk^013NkP00`00NkP00003NkP01000NkQk^000@G^h00<007^hNkP05g^h000MNkP00`00NkQk^00I
NkP01000NkQk^00047^h00<007^hNkP01W^h00<007^hNkP077^h00<007^hNkP0<G^h00<007^hNkP0
Fg^h00D007^hNkQk^000009k^005001k^7^hNkP00002NkP00`00NkQk^03CNkP00`00NkQk^00<NkP0
1@00NkQk^7^h000027^h00<007^hNkP027^h00<007^hNkP0@G^h00D007^hNkQk^000009k^005001k
^7^hNkP00010NkP00`00NkQk^00GNkP001ek^003001k^7^h01Yk^003001k^000011k^003001k^7^h
00Ik^003001k^7^h01ak^003001k^7^h035k^003001k^7^h05]k^003001k^7^h009k^003001k^000
00=k^003001k^0000=Ik^003001k^7^h00ak^003001k^7^h009k^003001k^7^h00Ek^003001k^7^h
00Qk^003001k^7^h045k^007001k^7^hNkP007^h000017^h00<007^hNkP0?g^h00<007^hNkP05W^h
000MNkP00`00NkQk^00JNkP2000BNkP00`00NkQk^004NkP00`00NkQk^00NNkP00`00NkQk^00aNkP0
0`00NkQk^01INkP00`00NkQk^003NkP20005NkP2003GNkP00`00NkQk^00:NkP00`00NkQk^003NkP0
0`00NkQk^004NkP00`00NkQk^00:NkP00`00NkQk^00oNkP00`00NkQk^003NkP20005NkP00`00NkQk
^00nNkP00`00NkQk^00FNkP001ek^003001k^7^h01]k^003001k^7^h011k^003001k^7^h00Ak^003
001k^7^h01ik^003001k^7^h01Mk^003001k^7^h00Ak^003001k^7^h011k^003001k^7^h02]k^003
001k^7^h00Ak^003001k^7^h01Mk^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003
001k^7^h00=k^003001k^7^h0=Ik^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00Ak^003
001k^7^h00=k^003001k^7^h00Yk^003001k^7^h03mk^003001k^7^h00=k^003001k^7^h00Ak^003
001k^7^h03mk^003001k^7^h01Ek^0007G^h00<007^hNkP0;g^h00<007^hNkP00W^h00<007^hNkP0
7g^h00<007^hNkP05W^h0P001G^h0P004g^h00<007^hNkP0:G^h00<007^h000017^h0P0067^h0P00
1G^h0P0017^h00<007^hNkP0i7^h00<007^hNkP00W^h00<007^h000017^h00<007^hNkP01G^h00<0
07^hNkP00W^h00<007^hNkP037^h00<007^hNkP0?G^h00<007^hNkP02g^h00<007^hNkP0?g^h00<0
07^hNkP05G^h000MNkP00`00NkQk^00_NkP00`00NkQk^002NkP00`00NkQk^00PNkP00`00NkQk^00E
NkP00`00NkP00004NkP00`00NkP0000BNkP00`00NkQk^00YNkP00`00NkP00004NkP00`00NkP0000G
NkP00`00NkP00004NkP00`00NkP00003NkP00`00NkQk^03UNkP01`00NkQk^7^h001k^00000Ak^003
001k^7^h00Ik^005001k^7^hNkP0000>NkP00`00NkQk^00mNkP00`00NkQk^00<NkP00`00NkQk^00o
NkP00`00NkQk^00DNkP001ek^003001k^7^h031k^004001k^7^h000SNkP00`00NkQk^00DNkP01000
NkQk^0000g^h00@007^hNkP001=k^003001k^7^h02Mk^005001k^7^hNkP00002NkP01000NkQk^000
5W^h00@007^hNkP000=k^004001k^7^h0002NkP00`00NkQk^03VNkP01000NkQk^0000g^h00@007^h
NkP000Uk^004001k^7^h000@NkP00`00NkQk^00kNkP00`00NkQk^00=NkP00`00NkQk^00oNkP00`00
NkQk^00DNkP001ek^003001k^7^h035k^003001k^00002Ak^003001k^7^h01=k^007001k^7^hNkP0
07^h000017^h00<007^hNkP04G^h00<007^hNkP09W^h00<007^hNkP00W^h00<007^h00000g^h00<0
07^hNkP04g^h00L007^hNkQk^000NkP00004NkP00`00NkP0003YNkP00`00NkP00004NkP00`00NkP0
000:NkP00`00NkP0000ANkP00`00NkQk^00jNkP00`00NkQk^00>NkP00`00NkQk^00oNkP00`00NkQk
^00CNkP001ek^003001k^7^h035k^08002Ek^003001k^7^h019k^003001k^7^h009k^003001k^000
00Ak^003001k^7^h015k^003001k^7^h02Ek^003001k^7^h00=k^08000Ak^003001k^7^h019k^003
001k^7^h009k^003001k^00000Ak^0800>Yk^08000Ek^08000]k^080019k^003001k^7^h03Uk^003
001k^7^h00mk^003001k^7^h03mk^003001k^7^h01=k^0007G^h1000<G^h00<007^hNkP097^h00<0
07^hNkP017^h00<007^hNkP02W^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<0
07^hNkP02g^h00<007^hNkP097^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<0
07^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP0jG^h00<0
07^hNkP017^h00<007^hNkP02W^h00<007^hNkP04G^h00<007^hNkP0<G^h00<007^hNkP017^h00<0
07^hNkP047^h00<007^hNkP0?g^h00<007^hNkP04W^h000MNkP00`00NkQk^01INkP00`00NkQk^003
NkP2000;NkP00`00NkQk^00;NkP00`00NkQk^003NkP2000<NkP00`00NkQk^00TNkP00`00NkQk^00:
NkP00`00NkQk^003NkP20005NkP20005NkP00`00NkQk^03oNkPONkP00`00NkQk^00aNkP00`00NkQk
^003NkP00`00NkQk^00BNkP00`00NkQk^00nNkP00`00NkQk^00BNkP001ek^003001k^7^h05Yk^003
001k^7^h009k^003001k^00000Yk^003001k^7^h00ak^007001k^7^hNkP007^h00003G^h00<007^h
NkP08W^h00<007^hNkP037^h00<007^hNkP00W^h00<007^h00000g^h00<007^h000017^h00<007^h
NkP0og^h8G^h00<007^hNkP0;g^h00<007^h000017^h00<007^hNkP04W^h00<007^hNkP0?g^h00<0
07^hNkP04G^h000MNkP00`00NkQk^01JNkP01@00NkQk^7^h00000W^h00<007^hNkP01g^h00<007^h
NkP03G^h00D007^hNkQk^000009k^003001k^7^h00Yk^003001k^7^h029k^003001k^7^h00ak^005
001k^7^hNkP00002NkP01@00NkQk^7^h00000W^h00D007^hNkQk^0000?mk^2=k^003001k^7^h02mk
^003001k^00000=k^003001k^7^h01Ak^003001k^7^h03ik^003001k^7^h015k^0007G^h00<007^h
NkP0Fg^h00@007^hNkP000=k^003001k^7^h00Ik^003001k^7^h00ik^003001k^00000=k^003001k
^7^h00]k^003001k^7^h021k^003001k^7^h00ik^004001k^7^h0003NkP00`00NkP00003NkP01000
NkQk^000og^h9G^h00<007^hNkP0;G^h00D007^hNkQk^000009k^003001k^7^h01Ak^003001k^7^h
03mk^003001k^7^h011k^0007G^h00<007^hNkP0Fg^h00<007^h000017^h00<007^hNkP01G^h00<0
07^hNkP03g^h00<007^h000017^h00<007^hNkP02W^h00<007^hNkP087^h00<007^hNkP03W^h00<0
07^h000017^h00<007^h000017^h00<007^h0000og^h9G^h00<007^hNkP0;G^h00L007^hNkQk^000
NkP0000HNkP00`00NkQk^00nNkP00`00NkQk^00@NkP001ek^003001k^7^h05ak^08000Ek^003001k
^7^h00Ak^003001k^7^h011k^003001k^7^h00=k^003001k^7^h00]k^003001k^7^h01ik^003001k
^7^h011k^08000Ek^003001k^7^h00=k^0800?mk^2Mk^003001k^7^h02]k^003001k^7^h00=k^080
01Qk^003001k^7^h03mk^003001k^7^h00mk^0007G^h00<007^hNkP0G7^h00<007^hNkP017^h00<0
07^hNkP00g^h00<007^hNkP04G^h00<007^hNkP017^h00<007^hNkP02W^h00<007^hNkP04G^h00<0
07^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h00<0
07^hNkP017^h00<007^hNkP017^h00<007^hNkP0og^h9G^h00<007^hNkP00g^h00<007^hNkP04G^h
00<007^hNkP04G^h00<007^hNkP00g^h00<007^hNkP067^h00<007^hNkP0?W^h00<007^hNkP03g^h
000MNkP00`00NkQk^01SNkP00`00NkQk^003NkP00`00NkQk^00HNkP00`00NkQk^00:NkP00`00NkQk
^00@NkP20005NkP00`00NkQk^003NkP00`00NkQk^004NkP20005NkP00`00NkQk^03oNkPiNkP00`00
NkQk^003NkP2000BNkP00`00NkQk^00ANkP00`00NkQk^00NNkP00`00NkQk^01@NkP001ek^003001k
^7^h06Ak^005001k^7^hNkP0000LNkP00`00NkQk^00:NkP00`00NkQk^00?NkP00`00NkP00003NkP0
0`00NkP00004NkP00`00NkQk^003NkP00`00NkP00004NkP00`00NkP0003oNkPkNkP01`00NkQk^7^h
001k^000015k^003001k^000015k^003001k^7^h021k^003001k^7^h04mk^0007G^h00<007^hNkP0
I7^h00D007^hNkQk^00001ak^003001k^7^h00Yk^003001k^7^h00ik^004001k^7^h0003NkP00`00
NkP00003NkP00`00NkQk^004NkP01000NkQk^0000g^h00<007^h0000og^h>g^h00D007^hNkQk^000
009k^003001k^7^h00ik^003001k^000015k^003001k^7^h021k^003001k^7^h04mk^0007G^h00<0
07^hNkP0IG^h00<007^h00007W^h00<007^hNkP02W^h00<007^hNkP03G^h00L007^hNkQk^000NkP0
0003NkP01000NkQk^0001G^h00D007^hNkQk^000009k^005001k^7^hNkP0003oNkPkNkP00`00NkP0
0003NkP00`00NkQk^00=NkP01@00NkQk^7^h00003g^h00<007^hNkP08W^h00<007^hNkP0CW^h000M
NkP00`00NkQk^01UNkP00`00NkP0000NNkP00`00NkQk^00:NkP00`00NkQk^00<NkP00`00NkQk^002
NkP00`00NkP00003NkP00`00NkP00006NkP00`00NkQk^002NkP00`00NkP00003NkP00`00NkQk^03o
NkPiNkP00`00NkP00004NkP00`00NkQk^00<NkP01@00NkQk^7^h00003g^h00<007^hNkP08W^h00<0
07^hNkP0CW^h000MNkP00`00NkQk^01VNkP00`00NkQk^00NNkP00`00NkQk^00:NkP00`00NkQk^00;
NkP00`00NkQk^003NkP00`00NkQk^003NkP20005NkP00`00NkQk^003NkP20005NkP00`00NkQk^03o
NkPiNkP00`00NkQk^003NkP00`00NkQk^00;NkP00`00NkQk^003NkP00`00NkQk^00;NkP00`00NkQk
^00TNkP00`00NkQk^01=NkP001ek^0@006Ek^003001k^7^h01ik^003001k^7^h00Yk^003001k^7^h
00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h
00Ak^003001k^7^h00=k^003001k^7^h0?mk^3Uk^003001k^7^h00Ak^003001k^7^h00Yk^003001k
^7^h00=k^003001k^7^h00Ak^003001k^7^h00Ak^003001k^7^h02Ak^003001k^7^h00=k^003001k
^7^h00Ak^003001k^7^h041k^0007G^h00<007^hNkP0Qg^h00<007^hNkP02W^h00<007^hNkP00g^h
0P001G^h0P001G^h00<007^hNkP00g^h0P001G^h00<007^hNkP02W^h00<007^hNkP0og^h@7^h00<0
07^hNkP02W^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP00g^h00<007^hNkP09G^h00<0
07^hNkP00g^h0P001G^h00<007^hNkP0@7^h000MNkP00`00NkQk^028NkP00`00NkQk^00:NkP00`00
NkQk^002NkP00`00NkP00003NkP00`00NkP00004NkP00`00NkP00003NkP00`00NkP00004NkP00`00
NkQk^00<NkP00`00NkQk^03oNkQ0NkP00`00NkQk^008NkP00`00NkQk^005NkP00`00NkQk^002NkP0
0`00NkP00004NkP00`00NkQk^00VNkP01`00NkQk^7^h001k^00000Ak^003001k^000045k^0007G^h
00<007^hNkP0R7^h00<007^hNkP02W^h00D007^hNkQk^000009k^005001k^7^hNkP00002NkP01`00
NkQk^7^h001k^00000=k^004001k^7^h0003NkP00`00NkQk^00<NkP00`00NkQk^03oNkQ0NkP00`00
NkQk^008NkP00`00NkQk^006NkP01`00NkQk^7^h001k^00000=k^003001k^7^h02Mk^005001k^7^h
NkP00002NkP01`00NkQk^7^h001k^000045k^0007G^h00<007^hNkP0RG^h00<007^hNkP02W^h00@0
07^hNkP000=k^003001k^00000=k^004001k^7^h0003NkP00`00NkP00003NkP01000NkQk^00047^h
00<007^hNkP0og^h@7^h00<007^hNkP01W^h00<007^hNkP01g^h00@007^hNkP000=k^004001k^7^h
000ZNkP00`00NkP00003NkP01000NkQk^0000g^h00<007^hNkP0?W^h000MNkP00`00NkQk^029NkP0
0`00NkQk^00:NkP00`00NkP00004NkP00`00NkP00004NkP00`00NkP00003NkP00`00NkP00004NkP0
0`00NkP0000@NkP00`00NkQk^03oNkQ0NkP00`00NkQk^006NkP00`00NkQk^008NkP00`00NkP00003
NkP00`00NkP0000[NkP00`00NkP00004NkP00`00NkP00003NkP00`00NkQk^00nNkP001ek^003001k
^7^h08Yk^003001k^7^h00Yk^08000Ek^003001k^7^h00=k^08000Ek^003001k^7^h00=k^080019k
^003001k^7^h0?mk^41k^003001k^7^h00Ak^003001k^7^h00Uk^08000Ek^08002ak^003001k^7^h
00=k^08000Ek^003001k^7^h03ek^0007G^h00<007^hNkP0RW^h00<007^hNkP02W^h00<007^hNkP0
17^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP047^h00<007^hNkP0
og^h@7^h00<007^hNkP017^h00<007^hNkP02W^h00<007^hNkP00g^h00<007^hNkP0:g^h00<007^h
NkP017^h00<007^hNkP00g^h00<007^hNkP0?G^h000MNkP00`00NkQk^02;NkP00`00NkQk^00@NkP0
0`00NkQk^00UNkP00`00NkQk^03oNkPoNkP00`00NkQk^003NkP00`00NkQk^01=NkP00`00NkQk^00l
NkP001ek^003001k^7^h08]k^003001k^7^h00mk^003001k^7^h02Ik^003001k^7^h0?mk^41k^003
001k^7^h009k^003001k^7^h04ek^003001k^7^h03ak^0007G^h00<007^hNkP0S7^h00<007^hNkP0
3W^h00<007^hNkP09g^h00<007^hNkP0og^h?g^h00D007^hNkQk^000055k^003001k^7^h03]k^000
7G^h00<007^hNkP0S7^h00<007^hNkP03G^h00<007^hNkP0:7^h00<007^hNkP0og^h@7^h00@007^h
NkP0055k^003001k^7^h03]k^0002W^h0`000W^h0P0037^h00<007^hNkP0SG^h00<007^hNkP037^h
00<007^hNkP0:G^h00<007^hNkP0og^h?g^h00<007^h0000Dg^h00<007^hNkP0>W^h000;NkP01000
NkQk^0000W^h00<007^hNkP02G^h00<007^hNkP0SG^h00<007^hNkP02g^h00<007^hNkP0:W^h00<0
07^hNkP0og^h@7^h0P00Dg^h00<007^hNkP0>W^h000;NkP01000NkQk^0000W^h00<007^hNkP02G^h
1@00S7^h00<007^hNkP02W^h00<007^hNkP0:g^h00<007^hNkP00g^h00<007^hNkP017^h00<007^h
NkP0og^h<W^h00<007^hNkP0Dg^h00<007^hNkP00g^h00<007^hNkP0<g^h000;NkP01000NkQk^000
0W^h00<007^hNkP02G^h00<007^hNkP0SW^h00<007^hNkP02G^h00<007^hNkP0;7^h00<007^hNkP0
0g^h0P001G^h00<007^hNkP0og^hR7^h00<007^hNkP00g^h00<007^hNkP0<g^h000;NkP01000NkQk
^0000W^h00<007^hNkP02G^h00<007^hNkP0Sg^h00<007^hNkP027^h00<007^hNkP0;G^h00L007^h
NkQk^000NkP00004NkP00`00NkP0003oNkR:NkP01`00NkQk^7^h001k^00003Ak^0002g^h00@007^h
NkP0009k^003001k^7^h00Uk^003001k^7^h08mk^003001k^7^h00Mk^003001k^7^h02ik^005001k
^7^hNkP00002NkP01`00NkQk^7^h001k^0000?mk^8Yk^007001k^7^hNkP007^h0000=7^h000:NkP2
0003NkP2000<NkP00`00NkQk^02@NkP00`00NkQk^006NkP00`00NkQk^00_NkP00`00NkP00003NkP0
1000NkQk^0000g^h00<007^hNkP0og^hR7^h00<007^h00000g^h00<007^hNkP0<G^h000MNkP00`00
NkQk^02@NkP00`00NkQk^005NkP00`00NkQk^00`NkP00`00NkP00004NkP00`00NkP00003NkP00`00
NkQk^03oNkR8NkP00`00NkP00003NkP00`00NkQk^00aNkP001ek^003001k^7^h095k^003001k^7^h
00Ak^003001k^7^h035k^003001k^7^h00=k^08000Ek^003001k^7^h0?mk^8Qk^003001k^7^h00=k
^003001k^7^h031k^0007G^h00<007^hNkP0TG^h00<007^hNkP00g^h00<007^hNkP0<W^h00<007^h
NkP017^h00<007^hNkP00g^h00<007^hNkP097^h00<007^hNkP0og^hHG^h00<007^hNkP00g^h00<0
07^hNkP017^h00<007^hNkP0:G^h000MNkP00`00NkQk^02ANkP00`00NkQk^003NkP00`00NkQk^00o
NkP00`00NkQk^00TNkP2003oNkQYNkP00`00NkQk^003NkP00`00NkQk^00YNkP001ek^003001k^7^h
099k^005001k^7^hNkP00013NkP00`00NkQk^00RNkP00`00NkP0003oNkQYNkP00`00NkQk^002NkP0
0`00NkP0000ZNkP001ek^003001k^7^h099k^005001k^7^hNkP00013NkP00`00NkQk^00RNkP01000
NkQk^000og^hJG^h00L007^hNkQk^000NkP0000ZNkP001ek^003001k^7^h09=k^003001k^00004Ek
^003001k^7^h021k^005001k^7^hNkP0003oNkQYNkP01000NkQk^0000g^h00<007^hNkP09g^h000M
NkP00`00NkQk^02CNkP00`00NkP00015NkP00`00NkQk^00PNkP00`00NkQk^002NkP00`00NkQk^03o
NkQWNkP00`00NkP00003NkP00`00NkQk^00WNkP001ek^003001k^7^h09Ak^003001k^7^h04Ek^003
001k^7^h01ik^003001k^7^h00=k^003001k^7^h0?mk^6Mk^08000Ek^003001k^7^h02Ik^0007G^h
1000Tg^h00<007^hNkP0AG^h00<007^hNkP07W^h00<007^hNkP017^h00<007^hNkP0og^hIg^h00<0
07^hNkP00g^h00<007^hNkP017^h00<007^hNkP02W^h00<007^hNkP04W^h000MNkP00`00NkQk^03M
NkP00`00NkQk^00MNkP00`00NkQk^004NkP00`00NkQk^03oNkQ^NkP00`00NkQk^003NkP00`00NkQk
^00:NkP00`00NkQk^00BNkP001ek^003001k^7^h0=ek^003001k^7^h01ak^003001k^7^h00Ik^003
001k^7^h0?mk^6ek^003001k^7^h009k^003001k^00000Yk^003001k^00001=k^0007G^h00<007^h
NkP0gW^h00<007^hNkP06g^h00<007^hNkP01W^h00<007^hNkP0og^hKW^h00L007^hNkQk^000NkP0
000:NkP00`00NkP0000CNkP001ek^003001k^7^h0=ik^003001k^7^h01Yk^003001k^7^h00Qk^003
001k^7^h0?mk^6ek^004001k^7^h0003NkP00`00NkQk^006NkP01@00NkQk^7^h00004W^h000MNkP0
0`00NkQk^03ONkP00`00NkQk^00INkP00`00NkQk^008NkP00`00NkQk^03oNkQ^NkP00`00NkP00003
NkP00`00NkQk^006NkP01@00NkQk^7^h00004W^h000MNkP00`00NkQk^03ONkP00`00NkQk^00HNkP0
0`00NkQk^00:NkP00`00NkQk^03oNkQ]NkP20005NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00
NkQk^00?NkP001ek^003001k^7^h0>1k^003001k^7^h01Mk^003001k^7^h00Yk^003001k^7^h0?mk
^6ik^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h00mk^0007G^h00<0
07^hNkP0h7^h00<007^hNkP05g^h00<007^hNkP02W^h00<007^hNkP0og^hM7^h00<007^hNkP00g^h
00<007^hNkP05W^h000MNkP00`00NkQk^03QNkP00`00NkQk^00ENkP00`00NkQk^00<NkP00`00NkQk
^03oNkQdNkP00`00NkQk^002NkP00`00NkQk^00FNkP001ek^003001k^7^h0>5k^003001k^7^h01Ek
^003001k^7^h00ak^003001k^7^h0?mk^7Ak^005001k^7^hNkP0000INkP001ek^003001k^7^h0>9k
^003001k^7^h01=k^003001k^7^h00ik^003001k^7^h0?mk^7Ak^004001k^7^h000INkP001ek^003
001k^7^h0>9k^003001k^7^h01=k^003001k^7^h00ik^003001k^7^h0?mk^7Ak^003001k^00001Yk
^0007G^h00<007^hNkP0hg^h00<007^hNkP04G^h00<007^hNkP047^h00<007^hNkP0og^hM7^h0P00
6W^h000MNkP4003RNkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^004NkP00`00NkQk^00@
NkP00`00NkQk^004NkP00`00NkQk^03oNkQ]NkP00`00NkQk^00INkP001ek^003001k^7^h0>=k^003
001k^7^h00=k^08000Ek^003001k^7^h00=k^003001k^7^h019k^003001k^7^h00=k^003001k^7^h
0?mk^8Uk^0007G^h00<007^hNkP0i7^h00L007^hNkQk^000NkP00004NkP00`00NkP00004NkP00`00
NkQk^00BNkP00`00NkQk^002NkP00`00NkP0003oNkR:NkP001ek^003001k^7^h0>Ak^005001k^7^h
NkP00002NkP01`00NkQk^7^h001k^00000=k^003001k^7^h01Ak^007001k^7^hNkP007^h0000og^h
RW^h000MNkP00`00NkQk^03UNkP00`00NkP00003NkP01000NkQk^0000g^h00@007^hNkP001Ik^004
001k^7^h0003NkP00`00NkQk^03oNkR7NkP001ek^003001k^7^h0>Ek^003001k^00000Ak^003001k
^00000=k^003001k^00001Qk^003001k^00000=k^003001k^7^h0?mk^8Mk^0007G^h00<007^hNkP0
iW^h00<007^hNkP00g^h0P001G^h0P0067^h0P001G^h00<007^hNkP0og^hQW^h000MNkP00`00NkQk
^03VNkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^00HNkP00`00NkQk^003NkP00`00NkQk
^03oNkR6NkP001ek^003001k^7^h0?mk^1Ek^003001k^7^h0?mk^8Ik^0007G^h00<007^hNkP0og^h
5W^h00<007^hNkP0og^hQG^h000MNkP00`00NkQk^03oNkPFNkP00`00NkQk^03oNkR5NkP001ek^003
001k^7^h0?mk^1Mk^003001k^7^h0?mk^8Ak^0007G^h00<007^hNkP0og^h5g^h00<007^hNkP0og^h
Q7^h000MNkP00`00NkQk^03oNkPHNkP00`00NkQk^03oNkR3NkP001ek^0@00?mk^1Mk^003001k^7^h
0?mk^8=k^0007G^h00<007^hNkP0og^h6G^h00<007^hNkP0og^hPW^h000MNkP00`00NkQk^03oNkPI
NkP00`00NkQk^03oNkR2NkP001ek^003001k^7^h0?mk^1Yk^003001k^7^h0?mk^85k^0007G^h00<0
07^hNkP0og^h6W^h00<007^hNkP0og^hPG^h000MNkP00`00NkQk^03oNkPKNkP00`00NkQk^03oNkR0
NkP001ek^003001k^7^h0?mk^1]k^003001k^7^h0?mk^81k^0007G^h00<007^hNkP0og^h77^h00<0
07^hNkP00g^h00<007^hNkP02W^h00<007^hNkP017^h00<007^hNkP0og^hIG^h000MNkP00`00NkQk
^03oNkPLNkP00`00NkQk^003NkP2000;NkP20005NkP00`00NkQk^03oNkQUNkP001ek^003001k^7^h
0?mk^1ek^007001k^7^hNkP007^h00002W^h00<007^h000017^h00<007^h0000og^hIW^h000MNkP0
0`00NkQk^03oNkPMNkP01@00NkQk^7^h00000W^h00<007^hNkP01g^h00@007^hNkP000=k^003001k
^0000?mk^6Ik^0007G^h00<007^hNkP0og^h7W^h00<007^h00000g^h00<007^hNkP01W^h00D007^h
NkQk^000009k^005001k^7^hNkP0003oNkQUNkP001ek^003001k^7^h0?mk^1ik^003001k^00000Ak
^003001k^7^h00Ek^003001k^7^h009k^003001k^00000=k^003001k^7^h0?mk^6=k^0007G^h00<0
07^hNkP0og^h7g^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP00g^h0P001G^h00<007^h
NkP0og^hHW^h000MNkP4003oNkPNNkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^004NkP0
0`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00[NkP00`00NkQk^00[NkP00`00NkQk^00:NkP0
0`00NkQk^03aNkP001ek^003001k^7^h0?mk^2Ik^003001k^7^h00=k^003001k^7^h00]k^003001k
^7^h00=k^003001k^7^h02Yk^08002ak^08000ak^003001k^7^h0?5k^0007G^h00<007^hNkP0og^h
9g^h00D007^hNkQk^00000ik^003001k^7^h009k^003001k^00002]k^003001k^00002]k^003001k
^00000Yk^003001k^0000?9k^0007G^h00<007^hNkP0og^h9g^h00D007^hNkQk^00000mk^007001k
^7^hNkP007^h0000:W^h00@007^hNkP002Yk^004001k^7^h000:NkP00`00NkP0003bNkP001ek^003
001k^7^h0?mk^2Qk^003001k^000011k^004001k^7^h0003NkP00`00NkQk^00WNkP01@00NkQk^7^h
0000:G^h00D007^hNkQk^00000Qk^005001k^7^hNkP0003aNkP001ek^003001k^7^h0?mk^2Qk^003
001k^000015k^003001k^00000=k^003001k^7^h02Ik^003001k^7^h009k^003001k^7^h02Ik^003
001k^7^h009k^003001k^7^h00Ik^005001k^7^hNkP0003aNkP001ek^003001k^7^h0?mk^2Uk^003
001k^7^h011k^08000Ek^003001k^7^h02Ek^003001k^7^h00=k^003001k^7^h02Ek^003001k^7^h
00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h0>ik^0007G^h00<007^hNkP0og^h:G^h
00<007^hNkP04G^h00<007^hNkP00g^h00<007^hNkP02W^h00<007^hNkP05g^h00<007^hNkP017^h
00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP05g^h00<007^hNkP017^h00<007^hNkP017^h
00<007^hNkP00g^h00<007^hNkP0kW^h000MNkP00`00NkQk^03oNkQ3NkP00`00NkQk^00:NkP00`00
NkQk^00GNkP00`00NkQk^004NkP00`00NkQk^003NkP20005NkP00`00NkQk^00GNkP00`00NkQk^004
NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^03^NkP001ek^003001k^7^h0?mk^4Ak^003
001k^7^h00Qk^003001k^00001Mk^003001k^7^h00Ik^003001k^7^h009k^003001k^00000=k^003
001k^00001Mk^003001k^7^h00Ik^003001k^7^h009k^003001k^7^h00Ek^003001k^7^h0>ek^000
7G^h00<007^hNkP0og^hA7^h00<007^hNkP027^h00<007^h00005g^h00<007^hNkP01W^h00D007^h
NkQk^000009k^007001k^7^hNkP007^h00005g^h00<007^hNkP01W^h00D007^hNkQk^00000Qk^003
001k^7^h0>ek^0007G^h00<007^hNkP0og^hAG^h00<007^hNkP01W^h00D007^hNkQk^00001Ek^003
001k^7^h00Qk^004001k^7^h0003NkP00`00NkP00003NkP00`00NkQk^00CNkP00`00NkQk^008NkP0
1000NkQk^0002G^h00<007^hNkP0k7^h0009NkP40002NkP2000<NkP00`00NkQk^03oNkQ5NkP00`00
NkQk^006NkP01@00NkQk^7^h00005G^h00<007^hNkP027^h00<007^h000017^h00<007^h00000g^h
00<007^hNkP04g^h00<007^hNkP027^h00<007^h00002W^h00<007^hNkP0k7^h000:NkP01@00NkP0
07^h00000W^h00<007^hNkP02G^h00<007^hNkP0og^hAW^h00<007^hNkP017^h00<007^hNkP00g^h
00<007^hNkP04G^h00<007^hNkP02W^h0P001G^h00<007^hNkP00g^h00<007^hNkP04G^h00<007^h
NkP02W^h0P002g^h00<007^hNkP0jg^h000;NkP01000NkQk^0000W^h00<007^hNkP02G^h1@00og^h
A7^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP017^h00<007^hNkP017^h00<007^hNkP0
0g^h00<007^hNkP02W^h00<007^hNkP017^h00<007^hNkP00g^h00<007^hNkP04G^h00<007^hNkP0
2W^h00<007^hNkP02W^h00<007^hNkP0jg^h000<NkP00`00NkP00002NkP00`00NkQk^009NkP00`00
NkQk^03oNkQ7NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk^003NkP2
0005NkP00`00NkQk^00HNkP00`00NkQk^00@NkP00`00NkQk^00HNkP00`00NkQk^03ZNkP000ak^003
001k^000009k^003001k^7^h00Uk^003001k^7^h0?mk^4Mk^003001k^7^h009k^003001k^7^h00Ek
^003001k^7^h009k^003001k^00000Ak^003001k^00000=k^003001k^7^h01Uk^003001k^7^h00mk
^003001k^7^h01Uk^003001k^7^h0>Yk^0002G^h00H007^hNkP007^h0002NkP00`00NkQk^009NkP0
0`00NkQk^03oNkQ8NkP01@00NkQk^7^h000027^h00L007^hNkQk^000NkP00003NkP01000NkQk^000
0g^h00<007^hNkP06W^h00<007^hNkP03W^h00<007^hNkP06W^h00<007^hNkP0jG^h000:NkP20003
NkP2000<NkP00`00NkQk^03oNkQ8NkP01000NkQk^0002G^h00@007^hNkP000=k^004001k^7^h0003
NkP00`00NkP0000MNkP00`00NkQk^00=NkP00`00NkQk^00KNkP00`00NkQk^03YNkP001ek^003001k
^7^h0?mk^4Uk^003001k^00000Yk^003001k^00000=k^003001k^00000Ak^003001k^00001ik^003
001k^7^h00ak^003001k^7^h01ak^003001k^7^h0>Qk^0007G^h00<007^hNkP0og^hBG^h0P002g^h
0P001G^h0P001G^h00<007^hNkP07G^h00<007^hNkP02g^h00<007^hNkP07G^h00<007^hNkP0j7^h
000MNkP00`00NkQk^03oNkQ:NkP00`00NkQk^00:NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00
NkQk^00NNkP00`00NkQk^00:NkP00`00NkQk^00NNkP00`00NkQk^03WNkP001ek^003001k^7^h0?mk
^8Ek^003001k^7^h00Yk^003001k^7^h01ik^003001k^7^h0>Mk^0007G^h00<007^hNkP0og^hQW^h
00<007^hNkP027^h00<007^hNkP087^h00<007^hNkP0iW^h000MNkP00`00NkQk^03oNkR6NkP00`00
NkQk^008NkP00`00NkQk^00PNkP00`00NkQk^03VNkP001ek^003001k^7^h0?mk^8Mk^003001k^7^h
00Ik^003001k^7^h029k^003001k^7^h0>Ek^0007G^h00<007^hNkP0og^hQg^h00<007^hNkP01W^h
00<007^hNkP08W^h00<007^hNkP0iG^h000MNkP00`00NkQk^03oNkR8NkP00`00NkQk^004NkP00`00
NkQk^00TNkP00`00NkQk^03TNkP001ek^0@00?mk^8Mk^003001k^7^h00Ak^003001k^7^h02Ak^003
001k^7^h0:5k^003001k^7^h041k^0007G^h00<007^hNkP0og^hR7^h00<007^hNkP00g^h00<007^h
NkP09G^h00<007^hNkP0XG^h00<007^hNkP0@7^h000MNkP00`00NkQk^03oNkR9NkP00`00NkQk^002
NkP00`00NkQk^00VNkP00`00NkQk^02ONkP00`00NkP00011NkP001ek^003001k^7^h0?mk^8Uk^005
001k^7^hNkP0000YNkP00`00NkQk^02ONkP00`00NkP00011NkP001ek^003001k^7^h0?mk^8Yk^004
001k^7^h000ZNkP00`00NkQk^02MNkP01@00NkQk^7^h0000@7^h000MNkP00`00NkQk^03oNkR:NkP0
0`00NkP0000[NkP00`00NkQk^02MNkP01@00NkQk^7^h0000@7^h000MNkP00`00NkQk^03oNkR;NkP2
000/NkP00`00NkQk^02KNkP00`00NkQk^003NkP00`00NkQk^00mNkP001ek^003001k^7^h0?mk^8]k
^003001k^7^h02]k^003001k^7^h00Ak^003001k^7^h08ek^003001k^7^h00Ak^003001k^7^h00=k
^003001k^7^h00Ak^003001k^7^h03Ik^0007G^h00<007^hNkP0og^h^G^h00<007^hNkP00g^h0P00
Sg^h00<007^hNkP00g^h00<007^hNkP01G^h00<007^hNkP00g^h00<007^hNkP0=W^h000MNkP00`00
NkQk^03oNkRjNkP00`00NkQk^002NkP00`00NkP0002=NkP00`00NkP00004NkP00`00NkQk^005NkP0
0`00NkQk^002NkP00`00NkP0000gNkP001ek^003001k^7^h0?mk^;Yk^005001k^7^hNkP00002NkP0
0`00NkQk^02;NkP00`00NkP00003NkP00`00NkQk^007NkP01`00NkQk^7^h001k^00003Mk^0007G^h
00<007^hNkP0og^h^g^h00@007^hNkP000=k^003001k^7^h08Uk^005001k^7^hNkP00002NkP00`00
NkQk^007NkP01000NkQk^0000g^h00<007^hNkP0=7^h000MNkP00`00NkQk^03oNkRkNkP00`00NkP0
0004NkP00`00NkQk^029NkP01`00NkQk^7^h001k^00000]k^003001k^00000=k^003001k^7^h03Ak
^0007G^h00<007^hNkP0og^h_7^h0P001G^h00<007^hNkP0Qg^h00<007^hNkP00g^h0P002g^h0P00
1G^h00<007^hNkP0<g^h000MNkP4003oNkRkNkP00`00NkQk^004NkP00`00NkQk^027NkP00`00NkQk
^003NkP00`00NkQk^00;NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk
^004NkP00`00NkQk^00ONkP001ek^003001k^7^h0?mk^<=k^003001k^7^h08Mk^003001k^7^h01Mk
^003001k^7^h00=k^08000Ek^08000Ek^003001k^7^h01mk^0007G^h00<007^hNkP0og^ha7^h00<0
07^hNkP0QG^h00<007^hNkP06G^h00<007^hNkP00W^h00<007^h00000g^h00<007^h000017^h00<0
07^h000087^h000MNkP00`00NkQk^03oNkS4NkP00`00NkQk^025NkP00`00NkQk^00INkP01@00NkQk
^7^h00000W^h00D007^hNkQk^000009k^007001k^7^hNkP007^h000087^h000MNkP00`00NkQk^03o
NkS5NkP00`00NkQk^023NkP00`00NkQk^00KNkP01000NkQk^0000g^h00<007^h00000g^h00@007^h
NkP000=k^003001k^7^h01ek^0007G^h00<007^hNkP0og^haG^h00<007^hNkP0Pg^h00<007^hNkP0
6g^h00<007^h000017^h00<007^h000017^h00<007^h00000g^h00<007^hNkP07G^h000MNkP00`00
NkQk^03oNkS6NkP00`00NkQk^021NkP00`00NkQk^00MNkP20005NkP00`00NkQk^003NkP20005NkP0
0`00NkQk^00LNkP001ek^003001k^7^h0?mk^<Ik^003001k^7^h00Yk^003001k^7^h06ek^003001k
^7^h00Ak^003001k^7^h01ek^003001k^7^h00Ak^003001k^7^h00Ak^003001k^7^h00=k^003001k
^7^h00Ak^003001k^7^h01Ek^0007G^h00<007^hNkP0og^hag^h00<007^hNkP02G^h0P00KW^h00<0
07^hNkP00g^h00<007^hNkP0<W^h00<007^hNkP00g^h0P005g^h000MNkP00`00NkQk^03oNkS7NkP0
0`00NkQk^008NkP00`00NkP0001]NkP00`00NkP00004NkP00`00NkQk^00cNkP00`00NkQk^002NkP0
0`00NkP0000FNkP001ek^003001k^7^h0?mk^<Qk^003001k^7^h00Mk^004001k^7^h001/NkP00`00
NkP00003NkP00`00NkQk^00dNkP01@00NkQk^7^h00000W^h00<007^hNkP057^h000MNkP00`00NkQk
^03oNkS8NkP00`00NkQk^006NkP01@00NkQk^7^h0000Jg^h00D007^hNkQk^000009k^003001k^7^h
03Ek^004001k^7^h0003NkP00`00NkQk^00CNkP001ek^003001k^7^h0?mk^<Uk^003001k^7^h00Ek
^003001k^7^h009k^003001k^7^h06Qk^007001k^7^hNkP007^h0000>7^h00<007^h000017^h00<0
07^hNkP04g^h000MNkP00`00NkQk^03oNkS9NkP00`00NkQk^004NkP00`00NkQk^003NkP00`00NkQk
^01WNkP00`00NkQk^003NkP2000iNkP20005NkP00`00NkQk^00BNkP001ek^0@00?mk^<Uk^003001k
^7^h00=k^003001k^7^h00Ak^003001k^7^h05mk^003001k^7^h00Ak^003001k^7^h00=k^003001k
^7^h03Qk^003001k^7^h00Ak^003001k^7^h019k^0007G^h00<007^hNkP0og^hbW^h00<007^hNkP0
0g^h00<007^hNkP017^h00<007^hNkP0Gg^h00<007^hNkP00g^h00<007^hNkP0AW^h00<007^hNkP0
4W^h000MNkP00`00NkQk^03oNkS;NkP01@00NkQk^7^h000027^h00<007^hNkP0GG^h00<007^h0000
17^h00<007^hNkP0Ag^h00<007^hNkP04G^h000MNkP00`00NkQk^03oNkS;NkP01@00NkQk^7^h0000
27^h00<007^hNkP0GG^h00<007^h00000g^h00<007^hNkP0B7^h00<007^hNkP04G^h000MNkP00`00
NkQk^03oNkS<NkP00`00NkP0000:NkP00`00NkQk^01KNkP01@00NkQk^7^h00000W^h00<007^hNkP0
BG^h00<007^hNkP047^h000MNkP00`00NkQk^03oNkS<NkP00`00NkP0000:NkP00`00NkQk^01KNkP0
1`00NkQk^7^h001k^00004ak^003001k^7^h011k^0007G^h00<007^hNkP0og^hcG^h00<007^hNkP0
2W^h00<007^hNkP0FG^h00<007^hNkP00g^h0P00CG^h00<007^hNkP03g^h000MNkP00`00NkQk^03o
NkS=NkP00`00NkQk^00:NkP00`00NkQk^00GNkP00`00NkQk^00oNkP00`00NkQk^003NkP00`00NkQk
^01<NkP00`00NkQk^00?NkP001ek^003001k^7^h0?mk^=Yk^003001k^7^h01Mk^080041k^003001k
^7^h06Ak^0007G^h00<007^hNkP0og^hfg^h00<007^hNkP05G^h00<007^h0000?g^h00<007^hNkP0
IG^h000MNkP00`00NkQk^03oNkSKNkP00`00NkQk^00ENkP01000NkQk^000?W^h00<007^hNkP0IG^h
000MNkP00`00NkQk^03oNkSLNkP00`00NkQk^00CNkP01@00NkQk^7^h0000?G^h00<007^hNkP0IW^h
000MNkP00`00NkQk^03oNkSLNkP00`00NkQk^00CNkP00`00NkQk^002NkP00`00NkQk^00jNkP00`00
NkQk^01VNkP001ek^003001k^7^h0?mk^=ek^003001k^7^h015k^003001k^7^h00=k^003001k^7^h
03Uk^003001k^7^h06Mk^0007G^h1000og^hg7^h00<007^hNkP017^h00<007^hNkP02W^h00<007^h
NkP017^h00<007^hNkP07G^h00<007^hNkP067^h00<007^hNkP0Ig^h000MNkP00`00NkQk^03oNkSN
NkP00`00NkQk^003NkP00`00NkQk^00:NkP00`00NkQk^004NkP00`00NkQk^00MNkP2000HNkP00`00
NkQk^01XNkP001ek^003001k^7^h0?mk^=ik^003001k^7^h009k^003001k^00000Yk^003001k^7^h
00Ik^003001k^7^h01]k^003001k^00001Qk^003001k^7^h06Qk^0007G^h00<007^hNkP0og^hgg^h
00L007^hNkQk^000NkP0000:NkP00`00NkQk^006NkP00`00NkQk^00KNkP01000NkQk^0005W^h00<0
07^hNkP0JG^h000MNkP00`00NkQk^03oNkSONkP01000NkQk^0000g^h00<007^hNkP01W^h00<007^h
NkP027^h00<007^hNkP06G^h00D007^hNkQk^00001Ik^003001k^7^h06Uk^0007G^h00<007^hNkP0
og^hh7^h00<007^h00000g^h00<007^hNkP01W^h00<007^hNkP027^h00<007^hNkP06G^h00<007^h
NkP00W^h00<007^hNkP04W^h00<007^hNkP0JW^h000MNkP00`00NkQk^03oNkSPNkP20005NkP00`00
NkQk^004NkP00`00NkQk^00:NkP00`00NkQk^00GNkP00`00NkQk^003NkP00`00NkQk^00BNkP00`00
NkQk^01ZNkP001ek^003001k^7^h0?mk^>5k^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h
00Yk^003001k^7^h00=k^003001k^7^h00]k^003001k^7^h00=k^003001k^7^h00Ak^003001k^7^h
00=k^003001k^7^h00Ak^003001k^7^h00=k^003001k^7^h06]k^0007G^h00<007^hNkP0og^hig^h
00<007^hNkP00g^h00<007^hNkP02g^h00<007^hNkP00W^h00<007^h00002g^h0P0017^h00<007^h
NkP01G^h00<007^hNkP00W^h00<007^h000017^h0P0017^h00<007^hNkP0K7^h000MNkP00`00NkQk
^03oNkSXNkP00`00NkQk^002NkP00`00NkQk^00<NkP01`00NkQk^7^h001k^00000]k^003001k^000
00=k^003001k^7^h00Ik^007001k^7^hNkP007^h000017^h00<007^h00000g^h00<007^hNkP0K7^h
000MNkP00`00NkQk^03oNkSXNkP01@00NkQk^7^h00003g^h00@007^hNkP000=k^003001k^7^h00Mk
^004001k^7^h0002NkP00`00NkQk^007NkP01000NkQk^0000g^h00@007^hNkP0009k^004001k^7^h
001_NkP000Uk^0<000=k^08000ak^003001k^7^h0?mk^>Uk^003001k^000015k^003001k^00000Ak
^003001k^7^h00Ek^003001k^7^h009k^003001k^00000Yk^003001k^00000Ak^003001k^00000=k
^003001k^00006mk^00037^h00<007^h00000W^h00<007^hNkP02G^h00<007^hNkP0og^hjG^h00<0
07^h00004G^h0P001G^h00<007^hNkP01G^h00<007^hNkP00W^h0P002g^h0P001G^h0P0017^h0P00
L7^h000<NkP00`00NkP00002NkP00`00NkQk^009NkP5003oNkSXNkP00`00NkQk^00ANkP00`00NkQk
^004NkP00`00NkQk^003NkP00`00NkQk^004NkP00`00NkQk^00:NkP00`00NkQk^004NkP00`00NkQk
^003NkP00`00NkQk^01^NkP000Yk^080009k^004001k^7^h000;NkP00`00NkQk^03oNkSoNkP6NkP0
0`00NkQk^003NkP00`00NkQk^02?NkP000]k^004001k^7^h0002NkP00`00NkQk^009NkP00`00NkQk
^03oNkSoNkP7NkP01@00NkQk^7^h0000TW^h000<NkP00`00NkP00002NkP00`00NkQk^009NkP00`00
NkQk^03oNkSoNkP7NkP01@00NkQk^7^h0000TW^h0009NkP30003NkP2000<NkP00`00NkQk^03oNkSo
NkP8NkP00`00NkP0002CNkP001ek^003001k^7^h0?mk^?mk^0Qk^003001k^00009=k^0007G^h00<0
07^hNkP0og^hog^h2G^h00<007^hNkP0TW^h000MNkP00`00NkQk^03oNkSoNkP9NkP00`00NkQk^02B
NkP001ek^003001k^7^h0?mk^?mk^9ik^0007G^h00<007^hNkP0og^hog^hWW^h000MNkP00`00NkQk
^03oNkSoNkRNNkP001ek^003001k^7^h0?mk^?mk^9ik^0007G^h00<007^hNkP0og^hog^hWW^h000M
NkP00`00NkQk^03oNkSoNkRNNkP001ek^0@00?mk^?mk^9ek^0007G^h00<007^hNkP0og^hog^hWW^h
000MNkP00`00NkQk^03oNkSoNkRNNkP001ek^003001k^7^h0?mk^?mk^9ik^0007G^h00<007^hNkP0
og^hog^hWW^h003oNkSoNkRnNkP00?mk^?mk^;ik^000og^hog^h_W^h0000\
\>"],
  ImageRangeCache->{{{0, 699.063}, {431.688, 0}} -> {-9.05026, -29.0187, \
0.304732, 0.143708}}]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 1189}},
ScreenStyleEnvironment->"Presentation",
WindowSize->{1016, 1151},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "NaturalColor.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 63, 1, 59, "Input"],

Cell[CellGroupData[{
Cell[1842, 56, 2886, 59, 673, "Input"],
Cell[4731, 117, 181673, 4293, 457, 43908, 2588, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

