(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5165,        142]*)
(*NotebookOutlinePosition[      5949,        171]*)
(*  CellTagsIndexPosition[      5878,        165]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(Linear\ Birth\ Process\ \((Gillespie\ Algorithm)\)\)], "Input",
  FontSize->16],

Cell["\<\
<<Statistics`DiscreteDistributions`
Clear[a,p]
a=4;
For[k=1,k\[LessEqual]5,
{t=0.1+(k-1)0.3;
p=Exp[-t];
negdist=NegativeBinomialDistribution[a,p];
pdf=PDF[negdist,x];
plotpdf[k]=Plot[pdf,{x,0,30},TextStyle\[Rule]{FontFamily\[Rule]\"Times\",\
FontSize\[Rule]20},DisplayFunction\[Rule]Identity];};
k++]
plotall=Table[plotpdf[i],{i,1,5}];
Show[plotall,DisplayFunction\[Rule]$DisplayFunction,PlotRange->All];\
\>", \
"Input",
  FontSize->16,
  CellTags->"S6.1.1"],

Cell[BoxData[{\(Clear[a]\), "\[IndentingNewLine]", 
    RowBox[{\(a = 1;\), 
      "              ", \( (*_Initial\ population\ size_*) \)}], "\n", 
    RowBox[{\(n = 20;\), 
      "         ", \( (*_Number\ of\ steps\ in\ each\ trial_*) \)}], "\n", \
\(trial = 3; \  (*_Number\ of\ realizations\ of\ the\ random\ process_*) \n
    numbers = Table[{i}, {i, 1, n - a}];\), "\n", 
    RowBox[{"For", "[", 
      RowBox[{\(k = 1\), 
        StyleBox[",",
          "MR"], " ", 
        RowBox[{"k", " ", 
          StyleBox["<=",
            "MR"], " ", "trial"}], ",", " ", "\n", "  ", 
        RowBox[{
          RowBox[{"{", 
            
            RowBox[{\(t = 0\), ";", "\n", 
              "  ", \(data = 
                Table[{{t = t - Log[Random[]]/i, i}, {t, i + 1}}, {i, a + 1, 
                    n}]\), ";", "\n", 
              "  ", \(dataflat = FlattenAt[data, numbers]\), ";", "\n", 
              "  ", \(firsttime = Part[Part[dataflat, 1], 1]\), ";", "\n", 
              "  ", \(datafull = 
                Prepend[Prepend[dataflat, {firsttime, a}], {0, a}]\), ";", 
              "\n", "  ", 
              RowBox[{
                RowBox[{"experiment", 
                  StyleBox["[",
                    "Subsubsection"], 
                  StyleBox["k",
                    "Subsubsection"], 
                  StyleBox["]",
                    "Subsubsection"]}], 
                "=", \(ListPlot[datafull, PlotJoined \[Rule] True, 
                  PlotRange \[Rule] {0, n}, DisplayFunction \[Rule] Identity, 
                  TextStyle \[Rule] {FontFamily \[Rule] "\<Times\>", 
                      FontSize \[Rule] 20}]\)}]}], "}"}], ";", 
          "\[IndentingNewLine]", \(k++\)}]}], 
      "]"}], "\n", \(allplots = 
        Table[experiment[k], {k, 1, trial}];\), "\n", \(deterministic = 
        Plot[a\ Exp[x], {x, 0, 5}, 
          PlotStyle \[Rule] {{Thickness[0.01], RGBColor[0, 1, 0]}}, 
          DisplayFunction \[Rule] Identity];\), "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{"Show", "[", 
        RowBox[{"allplots", ",", "deterministic", ",", 
          StyleBox[\(DisplayFunction \[Rule] $DisplayFunction\),
            FontFamily->"Courier New"]}], 
        StyleBox["]",
          FontFamily->"Courier New"]}], 
      StyleBox[";",
        FontFamily->"Courier New"]}]}], "Input",
  FontSize->16],

Cell[BoxData[
    \(Mean\ first\ passage\ time\ probability\ distribution\)], "Input"],

Cell[BoxData[{
    \(\(Clear[n, t];\)\), "\[IndentingNewLine]", 
    \(\(n = 1000;\)\), "\[IndentingNewLine]", 
    \(\(w = \((n - 1)\) 
          Exp[\(-t\)] \((1 - Exp[\(-t\)])\)\^\(n - 2\);\)\), "\
\[IndentingNewLine]", 
    \(\(Plot[w, {t, 1, 15}, PlotRange \[Rule] All, 
        TextStyle \[Rule] {FontFamily \[Rule] "\<Times\>", 
            FontSize \[Rule] 20}];\)\)}], "Input"]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1024}, {0, 689}},
WindowSize->{913, 662},
WindowMargins->{{3, Automatic}, {Automatic, 1}},
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S6.1.1"->{
    Cell[1856, 55, 469, 17, 266, "Input",
      CellTags->"S6.1.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S6.1.1", 5783, 158}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 99, 2, 50, "Input"],
Cell[1856, 55, 469, 17, 266, "Input",
  CellTags->"S6.1.1"],
Cell[2328, 74, 2355, 53, 410, "Input"],
Cell[4686, 129, 86, 1, 47, "Input"],
Cell[4775, 132, 386, 8, 97, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

